/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.kyero.KyeroReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KyeroImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroImport.class);
    private static final I18n I18N = I18nFactory.getI18n(KyeroImport.class);
    private static final String NAME = "kyero";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Kyero-XML";
    }

    @Override
    public String[] getVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = KyeroVersion.values();
        ArrayUtils.reverse((Object[])objectArray);
        for (Object object : objectArray) {
            arrayList.add(object.toReadableVersion());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isSingleLanguageFormat() {
        return false;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        try {
            KyeroImportReader kyeroImportReader = new KyeroImportReader();
            return kyeroImportReader.readTransfer(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't load parser!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Can't parse document!", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't process document!", jAXBException);
        }
    }

    @Override
    public String validateFile(File file) throws IOException {
        KyeroDocument kyeroDocument = null;
        try {
            kyeroDocument = KyeroUtils.createDocument((File)file);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        if (kyeroDocument == null) {
            throw new IOException("The file does not contain a supported document.");
        }
        KyeroVersion kyeroVersion = kyeroDocument.getDocumentVersion();
        return kyeroVersion != null ? kyeroVersion.toReadableVersion() : null;
    }

    public static class KyeroImportReader
    extends KyeroReader {
        private KyeroVersion version = null;

        public KyeroImportReader() {
            KyeroImportReader.initJAXB();
        }

        protected EstateImpl convertImmobilie(PropertyType propertyType, Map<String, AgentContactImpl> map) throws OpenEstateException {
            EstateImpl estateImpl = super.convertImmobilie(propertyType, map);
            if (estateImpl == null) {
                return null;
            }
            return estateImpl;
        }

        protected KyeroDocument createXmlDocument(Document document) {
            KyeroDocument kyeroDocument = super.createXmlDocument(document);
            if (kyeroDocument != null && this.version != null) {
                LOGGER.debug("Set Kyero-XML version " + this.version + " for import.");
                kyeroDocument.setDocumentVersion(this.version);
            }
            return kyeroDocument;
        }

        public KyeroVersion getVersion() {
            return this.version;
        }

        public static void initJAXB() {
            AgencyPluginUtils.initJAXB(KyeroUtils.class);
        }

        public void setVersion(KyeroVersion kyeroVersion) {
            this.version = kyeroVersion;
        }
    }
}

