/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.GIS;
import org.openestate.is24.restapi.xml.gis.Continents;
import org.openestate.is24.restapi.xml.gis.Countries;
import org.openestate.is24.restapi.xml.gis.Regions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24GeoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24GeoBuilder.class);
    private static final String WEBSERVICE_URL = "https://rest.sandbox-immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "testzugang-openestateKey";
    private static final String CONSUMER_SECRET = "GUwRuFZq5rnvaTuFzP2m";
    private static final String ACCESS_KEY = "258c7557-aff2-4c30-bed9-bc521c620016";
    private static final String ACCESS_SECRET = "2thYbs8pF5E2/rtKkqSj+cTHsb+594G4F5XwhlFeFKOc4yd80M7Sczd58zMdjiyCG6wpAFshSRIW8ExmEQplmZUQISLDvleBqJGefFdjn7U=";
    private static final int GERMANY = 276;

    public final GeoImpl build() throws OAuthException, IOException {
        return this.build(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET, ACCESS_KEY, ACCESS_SECRET, null);
    }

    public final GeoImpl build(GeoImpl geoImpl) throws OAuthException, IOException {
        return this.build(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET, ACCESS_KEY, ACCESS_SECRET, geoImpl);
    }

    public final GeoImpl build(String string, String string2, String string3, String string4, String string5) throws OAuthException, IOException {
        return this.build(string, string2, string3, string4, string5, null);
    }

    public GeoImpl build(String string, String string2, String string3, String string4, String string5, GeoImpl geoImpl) throws OAuthException, IOException {
        Continents continents;
        GeoImpl geoImpl2 = new GeoImpl();
        geoImpl2.setBuildTime(new Date());
        geoImpl2.setName("is24");
        geoImpl2.setProvider("ImmobilienScout24.de");
        DefaultClient defaultClient = new DefaultClient(string, string2, string3);
        defaultClient.authorize(string4, string5);
        try {
            continents = GIS.ContinentService.getAll((AbstractClient)defaultClient);
        }
        catch (Exception exception) {
            throw new IOException("Can't load continents!", exception);
        }
        if (continents == null) {
            System.out.println("Can't find any continents!");
            return geoImpl2;
        }
        for (Continents.Continent continent : continents.getContinent()) {
            Countries countries;
            try {
                countries = GIS.CountryService.getAll((AbstractClient)defaultClient, (long)continent.getId());
            }
            catch (Exception exception) {
                throw new IOException("Can't load countries for '" + continent.getLabel() + "' (#" + continent.getId() + ")!", exception);
            }
            if (countries == null) {
                System.out.println("Can't find any countries for '" + continent.getLabel() + "' (#" + continent.getId() + ")!");
                return geoImpl2;
            }
            for (Countries.Country country : countries.getCountry()) {
                Regions regions;
                GeoCountryImpl geoCountryImpl;
                if (276L == country.getId()) continue;
                String string6 = this.getCountryCode(country.getLabel());
                if (string6 == null) {
                    System.out.println("WARNING: Can't find country code for '" + country.getLabel() + "'!");
                    continue;
                }
                GeoCountryImpl geoCountryImpl2 = geoCountryImpl = geoImpl != null ? this.getCountry(geoImpl, country.getLabel()) : null;
                if (geoImpl != null && geoCountryImpl == null) {
                    System.out.println("WARNING: Can't find country '" + country.getLabel() + "' in old database!");
                }
                GeoCountryImpl geoCountryImpl3 = new GeoCountryImpl();
                geoCountryImpl3.setName(country.getLabel());
                geoCountryImpl3.setProviderId(country.getId().toString());
                geoCountryImpl3.setIsoCode(string6);
                geoCountryImpl3.setId(geoCountryImpl3.getProviderId());
                geoCountryImpl3.setOldId(geoCountryImpl != null ? geoCountryImpl.getId() : null);
                geoImpl2.getCountries().add(geoCountryImpl3);
                try {
                    regions = GIS.RegionService.getAll((AbstractClient)defaultClient, (long)continent.getId(), (long)country.getId());
                }
                catch (Exception exception) {
                    throw new IOException("Can't load regions for '" + country.getLabel() + "' (#" + country.getId() + ")!", exception);
                }
                if (regions == null) {
                    System.out.println("Can't find any regions for '" + country.getLabel() + "' (#" + country.getId() + ")!");
                    return geoImpl2;
                }
                for (Regions.Region region : regions.getRegion()) {
                    GeoAreaImpl geoAreaImpl;
                    GeoAreaImpl geoAreaImpl2 = geoAreaImpl = geoCountryImpl != null ? this.getArea(geoCountryImpl, region.getLabel()) : null;
                    if (geoCountryImpl != null && geoAreaImpl == null) {
                        System.out.println("WARNING: Can't find region '" + region.getLabel() + "' of country '" + country.getLabel() + "' in old database!");
                    }
                    GeoAreaImpl geoAreaImpl3 = new GeoAreaImpl();
                    geoAreaImpl3.setName(region.getLabel());
                    geoAreaImpl3.setProviderId(region.getId().toString());
                    geoAreaImpl3.setLevel(GeoAreaImpl.LEVEL_REGION);
                    geoAreaImpl3.setId(country.getId() + "-" + geoAreaImpl3.getProviderId());
                    geoAreaImpl3.setOldId(geoAreaImpl != null ? geoAreaImpl.getId() : null);
                    geoCountryImpl3.getAreas().add(geoAreaImpl3);
                }
            }
        }
        return geoImpl2;
    }

    public GeoImpl build(File file) throws IOException {
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.setBuildTime(new Date());
        geoImpl.setName("is24");
        geoImpl.setProvider("ImmobilienScout24.de");
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("cp1252")));){
            String string = lineNumberReader.readLine();
            GeoCountryImpl geoCountryImpl = null;
            while (string != null) {
                Object object;
                if (lineNumberReader.getLineNumber() <= 1) {
                    string = lineNumberReader.readLine();
                    continue;
                }
                if (string.trim().length() <= 0) {
                    string = lineNumberReader.readLine();
                    continue;
                }
                String[] stringArray = string.split("\\|");
                if (stringArray.length != 3) {
                    string = lineNumberReader.readLine();
                    continue;
                }
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                String string4 = stringArray[2].trim();
                if (geoCountryImpl == null || !geoCountryImpl.getProviderId().equals(string3)) {
                    if (geoCountryImpl != null && geoCountryImpl.getIsoCode() != null) {
                        geoImpl.getCountries().add(geoCountryImpl);
                    }
                    geoCountryImpl = new GeoCountryImpl();
                    geoCountryImpl.setProviderId(string3);
                    geoCountryImpl.setName(string2);
                    object = OpenEstateUtils.convertToIso2Country((String)string3);
                    if (object != null) {
                        geoCountryImpl.setIsoCode((String)object);
                        geoCountryImpl.setId(DigestUtils.sha1Hex((String)geoCountryImpl.getIsoCode()));
                    } else {
                        System.out.println("Can't convert '" + string3 + "' (" + string2 + ") to an ISO-2 country code!");
                        geoCountryImpl.setId(null);
                        geoCountryImpl.setIsoCode(null);
                    }
                }
                if (geoCountryImpl.getIsoCode() != null) {
                    object = new GeoAreaImpl();
                    object.setId(DigestUtils.sha1Hex((String)(geoCountryImpl.getId() + "-" + string4)));
                    object.setName(string4);
                    object.setLevel(GeoAreaImpl.LEVEL_REGION);
                    geoCountryImpl.getAreas().add(object);
                }
                string = lineNumberReader.readLine();
            }
            if (geoCountryImpl != null && geoCountryImpl.getIsoCode() != null) {
                geoImpl.getCountries().add(geoCountryImpl);
            }
        }
        return geoImpl;
    }

    private GeoAreaImpl getArea(GeoCountryImpl geoCountryImpl, String string) {
        for (GeoAreaImpl geoAreaImpl : geoCountryImpl.getAreas()) {
            if (!geoAreaImpl.getName().equalsIgnoreCase(string)) continue;
            return geoAreaImpl;
        }
        return null;
    }

    private GeoCountryImpl getCountry(GeoImpl geoImpl, String string) {
        for (GeoCountryImpl geoCountryImpl : geoImpl.getCountries()) {
            if (!geoCountryImpl.getName().equalsIgnoreCase(string)) continue;
            return geoCountryImpl;
        }
        return null;
    }

    private String getCountryCode(String string) {
        if ("Afghanistan".equalsIgnoreCase(string = StringUtils.trimToEmpty((String)string))) {
            return "AF";
        }
        if ("\u00c4gypten".equalsIgnoreCase(string)) {
            return "EG";
        }
        if ("Albanien".equalsIgnoreCase(string)) {
            return "AL";
        }
        if ("Algerien".equalsIgnoreCase(string)) {
            return "DZ";
        }
        if ("Amerikanische Jungferninseln".equalsIgnoreCase(string)) {
            return "VI";
        }
        if ("Amerikanisch-Samoa".equalsIgnoreCase(string)) {
            return "AS";
        }
        if ("Andorra".equalsIgnoreCase(string)) {
            return "AD";
        }
        if ("Angola".equalsIgnoreCase(string)) {
            return "AO";
        }
        if ("Anguilla".equalsIgnoreCase(string)) {
            return "AI";
        }
        if ("Antarktis".equalsIgnoreCase(string)) {
            return "AQ";
        }
        if ("Antigua und Barbuda".equalsIgnoreCase(string)) {
            return "AG";
        }
        if ("\u00c4quatorialguinea".equalsIgnoreCase(string)) {
            return "GQ";
        }
        if ("Argentinien".equalsIgnoreCase(string)) {
            return "AR";
        }
        if ("Armenien".equalsIgnoreCase(string)) {
            return "AM";
        }
        if ("Aruba".equalsIgnoreCase(string)) {
            return "AW";
        }
        if ("Aserbeidschan".equalsIgnoreCase(string)) {
            return "AZ";
        }
        if ("\u00c4thiopien".equalsIgnoreCase(string)) {
            return "ET";
        }
        if ("Australien".equalsIgnoreCase(string)) {
            return "AU";
        }
        if ("Bahamas".equalsIgnoreCase(string)) {
            return "BS";
        }
        if ("Bahrain".equalsIgnoreCase(string)) {
            return "BH";
        }
        if ("Bangladesh".equalsIgnoreCase(string)) {
            return "BD";
        }
        if ("Barbados".equalsIgnoreCase(string)) {
            return "BB";
        }
        if ("Belgien".equalsIgnoreCase(string)) {
            return "BE";
        }
        if ("Belize".equalsIgnoreCase(string)) {
            return "BZ";
        }
        if ("Benin".equalsIgnoreCase(string)) {
            return "BJ";
        }
        if ("Bermuda-Inseln".equalsIgnoreCase(string)) {
            return "BM";
        }
        if ("Bhutan".equalsIgnoreCase(string)) {
            return "BT";
        }
        if ("Bolivien".equalsIgnoreCase(string)) {
            return "BO";
        }
        if ("Bosnien-Herzegowina".equalsIgnoreCase(string)) {
            return "BA";
        }
        if ("Botsuana".equalsIgnoreCase(string)) {
            return "BW";
        }
        if ("Brasilien".equalsIgnoreCase(string)) {
            return "BR";
        }
        if ("Britische Jungferninseln".equalsIgnoreCase(string)) {
            return "VG";
        }
        if ("Brunei".equalsIgnoreCase(string)) {
            return "BN";
        }
        if ("Bulgarien".equalsIgnoreCase(string)) {
            return "BG";
        }
        if ("Burkina Faso".equalsIgnoreCase(string)) {
            return "BF";
        }
        if ("Burundi".equalsIgnoreCase(string)) {
            return "BI";
        }
        if ("Chile".equalsIgnoreCase(string)) {
            return "CL";
        }
        if ("China".equalsIgnoreCase(string)) {
            return "CN";
        }
        if ("Cookinseln".equalsIgnoreCase(string)) {
            return "CK";
        }
        if ("Costa Rica".equalsIgnoreCase(string)) {
            return "CR";
        }
        if ("D\u00e4nemark".equalsIgnoreCase(string)) {
            return "DK";
        }
        if ("Dominica".equalsIgnoreCase(string)) {
            return "DM";
        }
        if ("Dominikanische Republik".equalsIgnoreCase(string)) {
            return "DO";
        }
        if ("Dschibuti".equalsIgnoreCase(string)) {
            return "DJ";
        }
        if ("Ecuador".equalsIgnoreCase(string)) {
            return "EC";
        }
        if ("El Salvador".equalsIgnoreCase(string)) {
            return "SV";
        }
        if ("Elfenbeink\u00fcste".equalsIgnoreCase(string)) {
            return "CI";
        }
        if ("Eritrea".equalsIgnoreCase(string)) {
            return "ER";
        }
        if ("Estland".equalsIgnoreCase(string)) {
            return "EE";
        }
        if ("Falklandinseln".equalsIgnoreCase(string)) {
            return "FK";
        }
        if ("F\u00e4r\u00f6er".equalsIgnoreCase(string)) {
            return "FO";
        }
        if ("Fidschi".equalsIgnoreCase(string)) {
            return "FJ";
        }
        if ("Finnland".equalsIgnoreCase(string)) {
            return "FI";
        }
        if ("Frankreich".equalsIgnoreCase(string)) {
            return "FR";
        }
        if ("Franz\u00f6sisch-Guyana".equalsIgnoreCase(string)) {
            return "GF";
        }
        if ("Franz\u00f6sisch-Polynesien".equalsIgnoreCase(string)) {
            return "PF";
        }
        if ("Gabun".equalsIgnoreCase(string)) {
            return "GA";
        }
        if ("Gambia".equalsIgnoreCase(string)) {
            return "GM";
        }
        if ("Georgien".equalsIgnoreCase(string)) {
            return "GE";
        }
        if ("Ghana".equalsIgnoreCase(string)) {
            return "GH";
        }
        if ("Gibraltar".equalsIgnoreCase(string)) {
            return "GI";
        }
        if ("Grenada".equalsIgnoreCase(string)) {
            return "GD";
        }
        if ("Griechenland".equalsIgnoreCase(string)) {
            return "GR";
        }
        if ("Gr\u00f6nland".equalsIgnoreCase(string)) {
            return "GL";
        }
        if ("Gro\u00dfbritannien und Nordirland".equalsIgnoreCase(string)) {
            return "GB";
        }
        if ("Guadeloupe".equalsIgnoreCase(string)) {
            return "GP";
        }
        if ("Guam".equalsIgnoreCase(string)) {
            return "GU";
        }
        if ("Guatemala".equalsIgnoreCase(string)) {
            return "GT";
        }
        if ("Guinea".equalsIgnoreCase(string)) {
            return "GN";
        }
        if ("Guinea-Bissau".equalsIgnoreCase(string)) {
            return "GW";
        }
        if ("Guyana".equalsIgnoreCase(string)) {
            return "GY";
        }
        if ("Haiti".equalsIgnoreCase(string)) {
            return "HT";
        }
        if ("Heard-, MacDonald-Inseln".equalsIgnoreCase(string)) {
            return "HM";
        }
        if ("Honduras".equalsIgnoreCase(string)) {
            return "HN";
        }
        if ("Hongkong".equalsIgnoreCase(string)) {
            return "HK";
        }
        if ("Indien".equalsIgnoreCase(string)) {
            return "IN";
        }
        if ("Indonesien".equalsIgnoreCase(string)) {
            return "ID";
        }
        if ("Insel Man".equalsIgnoreCase(string)) {
            return "IM";
        }
        if ("Irak".equalsIgnoreCase(string)) {
            return "IQ";
        }
        if ("Iran".equalsIgnoreCase(string)) {
            return "IR";
        }
        if ("Irland".equalsIgnoreCase(string)) {
            return "IE";
        }
        if ("Island".equalsIgnoreCase(string)) {
            return "IS";
        }
        if ("Israel".equalsIgnoreCase(string)) {
            return "IL";
        }
        if ("Italien".equalsIgnoreCase(string)) {
            return "IT";
        }
        if ("Jamaika".equalsIgnoreCase(string)) {
            return "JM";
        }
        if ("Japan".equalsIgnoreCase(string)) {
            return "JP";
        }
        if ("Jemen".equalsIgnoreCase(string)) {
            return "YE";
        }
        if ("Jordanien".equalsIgnoreCase(string)) {
            return "JO";
        }
        if ("Kaimaninseln".equalsIgnoreCase(string)) {
            return "KY";
        }
        if ("Kambodscha".equalsIgnoreCase(string)) {
            return "KH";
        }
        if ("Kamerun".equalsIgnoreCase(string)) {
            return "CM";
        }
        if ("Kanada".equalsIgnoreCase(string)) {
            return "CA";
        }
        if ("Kap Verde".equalsIgnoreCase(string)) {
            return "CV";
        }
        if ("Kasachstan".equalsIgnoreCase(string)) {
            return "KZ";
        }
        if ("Katar".equalsIgnoreCase(string)) {
            return "QA";
        }
        if ("Kenia".equalsIgnoreCase(string)) {
            return "KE";
        }
        if ("Kirgisistan".equalsIgnoreCase(string)) {
            return "KG";
        }
        if ("Kiribati".equalsIgnoreCase(string)) {
            return "KI";
        }
        if ("Kokosinseln".equalsIgnoreCase(string)) {
            return "CC";
        }
        if ("Kolumbien".equalsIgnoreCase(string)) {
            return "CO";
        }
        if ("Komoren".equalsIgnoreCase(string)) {
            return "KM";
        }
        if ("Kongo, Demokratische Republik".equalsIgnoreCase(string)) {
            return "CD";
        }
        if ("Kongo, Republik".equalsIgnoreCase(string)) {
            return "CG";
        }
        if ("Kosovo".equalsIgnoreCase(string)) {
            return "CS";
        }
        if ("Kroatien".equalsIgnoreCase(string)) {
            return "HR";
        }
        if ("Kuba".equalsIgnoreCase(string)) {
            return "CU";
        }
        if ("Kuwait".equalsIgnoreCase(string)) {
            return "KW";
        }
        if ("Laos".equalsIgnoreCase(string)) {
            return "LA";
        }
        if ("Lesotho".equalsIgnoreCase(string)) {
            return "LS";
        }
        if ("Lettland".equalsIgnoreCase(string)) {
            return "LV";
        }
        if ("Libanon".equalsIgnoreCase(string)) {
            return "LB";
        }
        if ("Liberia".equalsIgnoreCase(string)) {
            return "LR";
        }
        if ("Libyen".equalsIgnoreCase(string)) {
            return "LY";
        }
        if ("Liechtenstein".equalsIgnoreCase(string)) {
            return "LI";
        }
        if ("Litauen".equalsIgnoreCase(string)) {
            return "LT";
        }
        if ("Luxemburg".equalsIgnoreCase(string)) {
            return "LU";
        }
        if ("Macau".equalsIgnoreCase(string)) {
            return "MO";
        }
        if ("Madagaskar".equalsIgnoreCase(string)) {
            return "MG";
        }
        if ("Malawi".equalsIgnoreCase(string)) {
            return "MW";
        }
        if ("Malaysia".equalsIgnoreCase(string)) {
            return "MY";
        }
        if ("Malediven".equalsIgnoreCase(string)) {
            return "MV";
        }
        if ("Mali".equalsIgnoreCase(string)) {
            return "ML";
        }
        if ("Malta".equalsIgnoreCase(string)) {
            return "MT";
        }
        if ("Marokko".equalsIgnoreCase(string)) {
            return "MA";
        }
        if ("Marshallinseln".equalsIgnoreCase(string)) {
            return "MH";
        }
        if ("Martinique".equalsIgnoreCase(string)) {
            return "MQ";
        }
        if ("Mauretanien".equalsIgnoreCase(string)) {
            return "MR";
        }
        if ("Mauritius".equalsIgnoreCase(string)) {
            return "MU";
        }
        if ("Mayotte".equalsIgnoreCase(string)) {
            return "YT";
        }
        if ("Mazedonien".equalsIgnoreCase(string)) {
            return "MK";
        }
        if ("Mexiko".equalsIgnoreCase(string)) {
            return "MX";
        }
        if ("Mikronesien".equalsIgnoreCase(string)) {
            return "FM";
        }
        if ("Moldawien".equalsIgnoreCase(string)) {
            return "MD";
        }
        if ("Monaco".equalsIgnoreCase(string)) {
            return "MC";
        }
        if ("Mongolei".equalsIgnoreCase(string)) {
            return "MN";
        }
        if ("Montenegro".equalsIgnoreCase(string)) {
            return "ME";
        }
        if ("Montserrat".equalsIgnoreCase(string)) {
            return "MS";
        }
        if ("Mosambik".equalsIgnoreCase(string)) {
            return "MZ";
        }
        if ("Myanmar (Burma)".equalsIgnoreCase(string)) {
            return "MM";
        }
        if ("Namibia".equalsIgnoreCase(string)) {
            return "NA";
        }
        if ("Nauru".equalsIgnoreCase(string)) {
            return "NR";
        }
        if ("Nepal".equalsIgnoreCase(string)) {
            return "NP";
        }
        if ("Neukaledonien".equalsIgnoreCase(string)) {
            return "NC";
        }
        if ("Neuseeland".equalsIgnoreCase(string)) {
            return "NZ";
        }
        if ("Nicaragua".equalsIgnoreCase(string)) {
            return "NI";
        }
        if ("Niederlande".equalsIgnoreCase(string)) {
            return "NL";
        }
        if ("Niederl\u00e4ndische Antillen".equalsIgnoreCase(string)) {
            return "AN";
        }
        if ("Niger".equalsIgnoreCase(string)) {
            return "NE";
        }
        if ("Nigeria".equalsIgnoreCase(string)) {
            return "NG";
        }
        if ("Niue".equalsIgnoreCase(string)) {
            return "NU";
        }
        if ("Nordkorea".equalsIgnoreCase(string)) {
            return "KP";
        }
        if ("N\u00f6rdliche Marianen".equalsIgnoreCase(string)) {
            return "MP";
        }
        if ("Norfolkinsel".equalsIgnoreCase(string)) {
            return "NF";
        }
        if ("Norwegen".equalsIgnoreCase(string)) {
            return "NO";
        }
        if ("Oman".equalsIgnoreCase(string)) {
            return "OM";
        }
        if ("\u00d6sterreich".equalsIgnoreCase(string)) {
            return "AT";
        }
        if ("Osttimor".equalsIgnoreCase(string)) {
            return "TL";
        }
        if ("Pakistan".equalsIgnoreCase(string)) {
            return "PK";
        }
        if ("Palau".equalsIgnoreCase(string)) {
            return "PW";
        }
        if ("Panama".equalsIgnoreCase(string)) {
            return "PA";
        }
        if ("Papua-Neuguinea".equalsIgnoreCase(string)) {
            return "PG";
        }
        if ("Paraguay".equalsIgnoreCase(string)) {
            return "PY";
        }
        if ("Peru".equalsIgnoreCase(string)) {
            return "PE";
        }
        if ("Philippinen".equalsIgnoreCase(string)) {
            return "PH";
        }
        if ("Pitcairninseln".equalsIgnoreCase(string)) {
            return "PN";
        }
        if ("Polen".equalsIgnoreCase(string)) {
            return "PL";
        }
        if ("Portugal".equalsIgnoreCase(string)) {
            return "PT";
        }
        if ("Puerto Rico".equalsIgnoreCase(string)) {
            return "PR";
        }
        if ("R\u00e9union".equalsIgnoreCase(string)) {
            return "RE";
        }
        if ("Ruanda".equalsIgnoreCase(string)) {
            return "RW";
        }
        if ("Rum\u00e4nien".equalsIgnoreCase(string)) {
            return "RO";
        }
        if ("Russische F\u00f6deration".equalsIgnoreCase(string)) {
            return "RU";
        }
        if ("Saint-Pierre und Miquelon".equalsIgnoreCase(string)) {
            return "PM";
        }
        if ("Salomonen".equalsIgnoreCase(string)) {
            return "SB";
        }
        if ("Sambia".equalsIgnoreCase(string)) {
            return "ZM";
        }
        if ("Samoa".equalsIgnoreCase(string)) {
            return "WS";
        }
        if ("San Marino".equalsIgnoreCase(string)) {
            return "SM";
        }
        if ("S\u00e3o Tom\u00e9 und Pr\u00edncipe".equalsIgnoreCase(string)) {
            return "ST";
        }
        if ("Saudi-Arabien".equalsIgnoreCase(string)) {
            return "SA";
        }
        if ("Schweden".equalsIgnoreCase(string)) {
            return "SE";
        }
        if ("Schweiz".equalsIgnoreCase(string)) {
            return "CH";
        }
        if ("Senegal".equalsIgnoreCase(string)) {
            return "SN";
        }
        if ("Serbien".equalsIgnoreCase(string)) {
            return "RS";
        }
        if ("Seychellen".equalsIgnoreCase(string)) {
            return "SC";
        }
        if ("Sierra Leone".equalsIgnoreCase(string)) {
            return "SL";
        }
        if ("Simbabwe".equalsIgnoreCase(string)) {
            return "ZW";
        }
        if ("Singapur".equalsIgnoreCase(string)) {
            return "SG";
        }
        if ("Slowakei".equalsIgnoreCase(string)) {
            return "SK";
        }
        if ("Slowenien".equalsIgnoreCase(string)) {
            return "SI";
        }
        if ("Somalia".equalsIgnoreCase(string)) {
            return "SO";
        }
        if ("Spanien".equalsIgnoreCase(string)) {
            return "ES";
        }
        if ("Sri Lanka".equalsIgnoreCase(string)) {
            return "LK";
        }
        if ("St. Helena".equalsIgnoreCase(string)) {
            return "SH";
        }
        if ("St. Kitts und Nevis".equalsIgnoreCase(string)) {
            return "KN";
        }
        if ("St. Lucia".equalsIgnoreCase(string)) {
            return "LC";
        }
        if ("St. Vincent und die Grenadinen".equalsIgnoreCase(string)) {
            return "VC";
        }
        if ("S\u00fcdafrika".equalsIgnoreCase(string)) {
            return "ZA";
        }
        if ("Sudan".equalsIgnoreCase(string)) {
            return "SD";
        }
        if ("S\u00fcdkorea".equalsIgnoreCase(string)) {
            return "KR";
        }
        if ("Suriname".equalsIgnoreCase(string)) {
            return "SR";
        }
        if ("Svalbard und Jan Mayen".equalsIgnoreCase(string)) {
            return "SJ";
        }
        if ("Swasiland".equalsIgnoreCase(string)) {
            return "SZ";
        }
        if ("Syrien".equalsIgnoreCase(string)) {
            return "SY";
        }
        if ("Tadschikistan".equalsIgnoreCase(string)) {
            return "TJ";
        }
        if ("Taiwan".equalsIgnoreCase(string)) {
            return "TW";
        }
        if ("Tansania".equalsIgnoreCase(string)) {
            return "TZ";
        }
        if ("Thailand".equalsIgnoreCase(string)) {
            return "TH";
        }
        if ("Togo".equalsIgnoreCase(string)) {
            return "TG";
        }
        if ("Tokelau".equalsIgnoreCase(string)) {
            return "TK";
        }
        if ("Tonga".equalsIgnoreCase(string)) {
            return "TO";
        }
        if ("Trinidad und Tobago".equalsIgnoreCase(string)) {
            return "TT";
        }
        if ("Tschad".equalsIgnoreCase(string)) {
            return "TD";
        }
        if ("Tschechische Republik".equalsIgnoreCase(string)) {
            return "CZ";
        }
        if ("Tunesien".equalsIgnoreCase(string)) {
            return "TN";
        }
        if ("T\u00fcrkei".equalsIgnoreCase(string)) {
            return "TR";
        }
        if ("Turkmenistan".equalsIgnoreCase(string)) {
            return "TM";
        }
        if ("Turks- und Caicosinseln".equalsIgnoreCase(string)) {
            return "TC";
        }
        if ("Tuvalu".equalsIgnoreCase(string)) {
            return "TV";
        }
        if ("Uganda".equalsIgnoreCase(string)) {
            return "UG";
        }
        if ("Ukraine".equalsIgnoreCase(string)) {
            return "UA";
        }
        if ("Ungarn".equalsIgnoreCase(string)) {
            return "HU";
        }
        if ("Uruguay".equalsIgnoreCase(string)) {
            return "UY";
        }
        if ("USA".equalsIgnoreCase(string)) {
            return "US";
        }
        if ("Usbekistan".equalsIgnoreCase(string)) {
            return "UZ";
        }
        if ("Vanuatu".equalsIgnoreCase(string)) {
            return "VU";
        }
        if ("Vatikanstadt".equalsIgnoreCase(string)) {
            return "VA";
        }
        if ("Venezuela".equalsIgnoreCase(string)) {
            return "VE";
        }
        if ("Vereinigte Arabische Emirate".equalsIgnoreCase(string)) {
            return "AE";
        }
        if ("Vietnam".equalsIgnoreCase(string)) {
            return "VN";
        }
        if ("Wallis und Futuna".equalsIgnoreCase(string)) {
            return "WF";
        }
        if ("Weihnachtsinsel".equalsIgnoreCase(string)) {
            return "CX";
        }
        if ("Wei\u00dfrussland".equalsIgnoreCase(string)) {
            return "BY";
        }
        if ("Westsahara".equalsIgnoreCase(string)) {
            return "EH";
        }
        if ("Zentralafrikanische Republik".equalsIgnoreCase(string)) {
            return "CF";
        }
        if ("Zypern".equalsIgnoreCase(string)) {
            return "CY";
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        GeoImpl geoImpl = null;
        File file = new File("/home/andy/repositories/OpenEstate-Impl/OpenEstate-Impl-is24/doc/is24-geo-alt.xml");
        if (file.isFile()) {
            try {
                object2 = new FileInputStream(file);
                object = null;
                try {
                    geoImpl = new GeoImpl();
                    geoImpl.readFromXml(OpenEstateUtils.loadDocument((InputStream)object2));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object2).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        object2 = new Is24GeoBuilder();
        object = null;
        try {
            object = ((Is24GeoBuilder)object2).build(geoImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            System.exit(1);
        }
        File file2 = ArrayUtils.isNotEmpty((Object[])stringArray) ? new File(stringArray[0]) : new File(SystemUtils.getUserHome(), "is24-geo.xml");
        System.out.println("save geo data to " + file2.getAbsolutePath());
        try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file2, "UTF-8");){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)object, (Writer)fileWriterWithEncoding, (boolean)true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

