/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24Utils.class);

    private Is24Utils() {
    }

    public static LengthValue getFahrtwegDistanz(Number number) {
        if (number == null || number.doubleValue() <= 0.0) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(number.doubleValue() / 60.0 * 50.0);
        return new LengthValue(bigDecimal, LengthValue.Unit.KM);
    }

    public static Long getFahrtwegZeit(LengthValue lengthValue) {
        if (lengthValue == null) {
            return null;
        }
        BigDecimal bigDecimal = LengthValue.convert((LengthValue)lengthValue, (LengthValue.Unit)LengthValue.Unit.KM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
        return bigDecimal.divide(new BigDecimal("50"), mathContext).multiply(new BigDecimal("60", mathContext)).longValue();
    }

    public static Integer getFahrtwegZeitAsInteger(LengthValue lengthValue) {
        if (lengthValue == null) {
            return null;
        }
        BigDecimal bigDecimal = LengthValue.convert((LengthValue)lengthValue, (LengthValue.Unit)LengthValue.Unit.KM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
        return bigDecimal.divide(new BigDecimal("50"), mathContext).multiply(new BigDecimal("60"), mathContext).intValue();
    }

    public static LengthValue getFusswegDistanz(Number number) {
        if (number == null || number.doubleValue() <= 0.0) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(number.doubleValue() / 60.0 * 3.6);
        return new LengthValue(bigDecimal, LengthValue.Unit.KM);
    }

    public static Long getFusswegZeit(LengthValue lengthValue) {
        if (lengthValue == null) {
            return null;
        }
        BigDecimal bigDecimal = LengthValue.convert((LengthValue)lengthValue, (LengthValue.Unit)LengthValue.Unit.KM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
        return bigDecimal.divide(new BigDecimal("3.6"), mathContext).multiply(new BigDecimal("60"), mathContext).longValue();
    }

    public static Integer getFusswegZeitAsInteger(LengthValue lengthValue) {
        if (lengthValue == null) {
            return null;
        }
        BigDecimal bigDecimal = LengthValue.convert((LengthValue)lengthValue, (LengthValue.Unit)LengthValue.Unit.KM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
        return bigDecimal.divide(new BigDecimal("3.6"), mathContext).multiply(new BigDecimal("60"), mathContext).intValue();
    }

    public static Double toDouble(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        string = StringUtils.replace((String)string, (String)" ", (String)"");
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
            numberFormat.setGroupingUsed(false);
            return numberFormat.parse(string).doubleValue();
        }
        catch (Exception exception) {
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
                numberFormat.setGroupingUsed(false);
                return numberFormat.parse(string).doubleValue();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static Long toLong(String string) {
        if ((string = StringUtils.trimToNull((String)StringUtils.replace((String)string, (String)" ", (String)""))) == null) {
            return null;
        }
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
            numberFormat.setGroupingUsed(false);
            numberFormat.setParseIntegerOnly(true);
            return numberFormat.parse(string).longValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

