/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immobiliare_it;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.LocaleUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItVersion;
import org.openestate.io.immobiliare_it.xml.ObjectFactory;
import org.openestate.io.immobiliare_it.xml.types.Category;
import org.openestate.io.immobiliare_it.xml.types.EnergyUnit;
import org.openestate.io.immobiliare_it.xml.types.LandSizeUnit;
import org.openestate.io.immobiliare_it.xml.types.SizeUnit;
import org.openestate.io.immobiliare_it.xml.types.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImmobiliareItUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItUtils.class);
    private static JAXBContext JAXB = null;
    public static final ImmobiliareItVersion VERSION = ImmobiliareItVersion.V2_5;
    public static final String NAMESPACE = "http://feed.immobiliare.it";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String PACKAGE = "org.openestate.io.immobiliare_it.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private ImmobiliareItUtils() {
    }

    public static ImmobiliareItDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return ImmobiliareItUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static ImmobiliareItDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return ImmobiliareItUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static ImmobiliareItDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return ImmobiliareItUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static ImmobiliareItDocument createDocument(Document document) {
        if (ImmobiliareItDocument.isReadable(document)) {
            return new ImmobiliareItDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return ImmobiliareItUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = ImmobiliareItUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = ImmobiliareItUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            ImmobiliareItUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static String getCountryCode(String string) {
        return LocaleUtils.getCountryISO2((String)string);
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static boolean isValidDateUpdatedType(Calendar calendar) {
        Calendar calendar2 = DatatypeConverter.parseDateTime((String)"2000-12-31T00:00:00");
        return calendar != null && !calendar.before(calendar2);
    }

    public static boolean isValidEmailType(String string) {
        return string != null && string.matches("[^@]+@[^\\.]+\\..+");
    }

    public static boolean isValidLatitude(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal("27.2");
        BigDecimal bigDecimal3 = new BigDecimal("71.1");
        return bigDecimal != null && bigDecimal.compareTo(bigDecimal2) >= 0 && bigDecimal.compareTo(bigDecimal3) <= 0;
    }

    @Deprecated
    public static boolean isValidLatitude(Double d) {
        return ImmobiliareItUtils.isValidLatitude(BigDecimal.valueOf(d));
    }

    public static boolean isValidLongitude(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal("31.2");
        BigDecimal bigDecimal3 = new BigDecimal("38.9");
        return bigDecimal != null && bigDecimal.compareTo(bigDecimal2) >= 0 && bigDecimal.compareTo(bigDecimal3) <= 0;
    }

    @Deprecated
    public static boolean isValidLongitude(Double d) {
        return ImmobiliareItUtils.isValidLongitude(BigDecimal.valueOf(d));
    }

    public static boolean isValidRooms(Integer n) {
        return n != null && n >= 1 && n <= 100;
    }

    public static boolean isValidYear(Integer n) {
        return n != null && n >= 1000 && n <= 2020;
    }

    public static Category parseCategory(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        Category category = Category.fromXmlValue(string);
        if (category == null) {
            throw new IllegalArgumentException("Can't parse category value '" + string + "'!");
        }
        return category;
    }

    public static String parseCountry(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static Currency parseCurrency(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            if (string.trim().length() != 3) {
                throw new Exception("Currency code must contain of 3 characters.");
            }
            return Currency.getInstance(string.trim().toUpperCase());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't parse currency value '" + string + "'!", exception);
        }
    }

    public static Calendar parseDateUpdatedType(String string) {
        try {
            return XmlUtils.parseDateTime((String)string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't parse date-updated value '" + string + "'!", exception);
        }
    }

    public static String parseEmailType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static EnergyUnit parseEnergyUnit(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        EnergyUnit energyUnit = EnergyUnit.fromXmlValue(string);
        if (energyUnit == null) {
            throw new IllegalArgumentException("Can't parse energy-unit value '" + string + "'!");
        }
        return energyUnit;
    }

    public static BigInteger parseInteger(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static LandSizeUnit parseLandSizeUnit(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        LandSizeUnit landSizeUnit = LandSizeUnit.fromXmlValue(string);
        if (landSizeUnit == null) {
            throw new IllegalArgumentException("Can't parse land-size-unit value '" + string + "'!");
        }
        return landSizeUnit;
    }

    public static BigDecimal parseLatitude(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseLongitude(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static Integer parseRooms(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Integer.valueOf(DatatypeConverter.parseInt((String)string)) : null;
    }

    public static SizeUnit parseSizeUnit(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        SizeUnit sizeUnit = SizeUnit.fromXmlValue(string);
        if (sizeUnit == null) {
            throw new IllegalArgumentException("Can't parse size-unit value '" + string + "'!");
        }
        return sizeUnit;
    }

    private static String parseText(String string, int n) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseText3000(String string) {
        return ImmobiliareItUtils.parseText(string, 3000);
    }

    public static Transaction parseTransaction(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        Transaction transaction = Transaction.fromXmlValue(string);
        if (transaction == null) {
            throw new IllegalArgumentException("Can't parse transaction value '" + string + "'!");
        }
        return transaction;
    }

    public static Integer parseYear(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Integer.valueOf(DatatypeConverter.parseInt((String)string)) : null;
    }

    public static Boolean parseYesNo(String string) {
        if ("yes".equalsIgnoreCase(string = StringUtils.trimToEmpty((String)string))) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Can't parse yes-no value '" + string + "'!");
    }

    public static Boolean parseYN(String string) {
        if ("y".equalsIgnoreCase(string = StringUtils.trimToEmpty((String)string))) {
            return Boolean.TRUE;
        }
        if ("n".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Can't parse y-n value '" + string + "'!");
    }

    public static String printCategory(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Can't print category value!");
        }
        return category.getXmlValue();
    }

    public static String printCountry(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            throw new IllegalArgumentException("Can't print country value!");
        }
        String string2 = StringUtils.trimToNull((String)ImmobiliareItUtils.getCountryCode(string));
        if (string2 == null) {
            throw new IllegalArgumentException("Can't convert country '" + string + "' to its ISO2 code!");
        }
        return string2;
    }

    public static String printCurrency(Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Can't print currency value!");
        }
        return currency.getCurrencyCode();
    }

    public static String printDateUpdatedType(Calendar calendar) {
        if (calendar == null || !ImmobiliareItUtils.isValidDateUpdatedType(calendar)) {
            throw new IllegalArgumentException("Can't print date-updated value!");
        }
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static String printEmailType(String string) {
        if (!ImmobiliareItUtils.isValidEmailType(string)) {
            throw new IllegalArgumentException("Can't print email value!");
        }
        return string;
    }

    public static String printEnergyUnit(EnergyUnit energyUnit) {
        if (energyUnit == null) {
            throw new IllegalArgumentException("Can't print energy-unit value!");
        }
        return energyUnit.getXmlValue();
    }

    public static String printInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print integer value!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printLandSizeUnit(LandSizeUnit landSizeUnit) {
        if (landSizeUnit == null) {
            throw new IllegalArgumentException("Can't print land-size-unit value!");
        }
        return landSizeUnit.getXmlValue();
    }

    public static String printLatitude(BigDecimal bigDecimal) {
        if (bigDecimal == null || !ImmobiliareItUtils.isValidLatitude(bigDecimal)) {
            throw new IllegalArgumentException("Can't print latitude value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printLongitude(BigDecimal bigDecimal) {
        if (bigDecimal == null || !ImmobiliareItUtils.isValidLongitude(bigDecimal)) {
            throw new IllegalArgumentException("Can't print longitude value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printRooms(Integer n) {
        if (!ImmobiliareItUtils.isValidRooms(n)) {
            throw new IllegalArgumentException("Can't print rooms value!");
        }
        return DatatypeConverter.printInt((int)n);
    }

    public static String printSizeUnit(SizeUnit sizeUnit) {
        if (sizeUnit == null) {
            throw new IllegalArgumentException("Can't print size-unit value!");
        }
        return sizeUnit.getXmlValue();
    }

    private static String printText(String string, int n) {
        int n2 = (string = StringUtils.trimToEmpty((String)string)).length();
        if (n2 <= 0) {
            return "";
        }
        if (n2 <= n) {
            return string;
        }
        if (n > 3) {
            return StringUtils.abbreviate((String)string, (int)n);
        }
        return string.substring(0, n);
    }

    public static String printText3000(String string) {
        return ImmobiliareItUtils.printText(string, 3000);
    }

    public static String printTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Can't print transaction value!");
        }
        return transaction.getXmlValue();
    }

    public static String printYear(Integer n) {
        if (!ImmobiliareItUtils.isValidYear(n)) {
            throw new IllegalArgumentException("Can't print year value!");
        }
        return DatatypeConverter.printInt((int)n);
    }

    public static String printYesNo(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "yes";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "no";
        }
        throw new IllegalArgumentException("Can't print yes-no value!");
    }

    public static String printYN(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "Y";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "N";
        }
        throw new IllegalArgumentException("Can't print y-n value!");
    }
}

