/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringTablePanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestTablePanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsExtension;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.extensions.DbRelationExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactsUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactsUtils.class);
    private static final AgencyContactsUtils INSTANCE = new AgencyContactsUtils();
    private static DbAgencyContactsExtension contactsExtension = null;

    private AgencyContactsUtils() {
    }

    public static void checkForDuplicateInterestSearches(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException, ImmoToolException {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension((AbstractDbDriver)abstractDbDriver);
        if (dbAgencyExtension == null) {
            throw new ImmoToolException("Can't find an usable DbAgencyExtension!");
        }
        DbAgencyContactsExtension dbAgencyContactsExtension = AgencyContactsUtils.lookupDbAgencyContactsExtension(abstractDbDriver);
        if (dbAgencyContactsExtension == null) {
            throw new ImmoToolException("Can't find an usable DbAgencyContactsExtension!");
        }
        DbAgencySearchesHandler dbAgencySearchesHandler = dbAgencyExtension.getSearchesHandler();
        DbAgencyInterestsHandler dbAgencyInterestsHandler = dbAgencyContactsExtension.getInterestsHandler();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestsHandler.getInterests(connection)) {
            if (!arrayList.contains(dbAgencyInterest.agencySearchId)) {
                arrayList.add(dbAgencyInterest.agencySearchId);
                continue;
            }
            LOGGER.debug("> Found duplicate search request #" + dbAgencyInterest.agencySearchId + " for interest #" + dbAgencyInterest.id);
            DbAgencySearch dbAgencySearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, dbAgencyInterest.agencySearchId);
            dbAgencySearchesHandler.loadAttribConditions(connection, (DbSearch)dbAgencySearch);
            dbAgencySearchesHandler.loadParameters(connection, (DbSearch)dbAgencySearch);
            dbAgencySearchesHandler.loadValueConditions(connection, (DbSearch)dbAgencySearch);
            dbAgencySearch.id = 0L;
            dbAgencySearchesHandler.saveSearch(connection, (DbSearch)dbAgencySearch);
            LOGGER.debug(">> use copied search #" + dbAgencySearch.id);
            LOGGER.debug(">> for interest #" + dbAgencyInterest.id);
            dbAgencyInterest.agencySearchId = dbAgencySearch.id;
            dbAgencyInterestsHandler.saveInterest(connection, dbAgencyInterest);
            arrayList.add(dbAgencyInterest.agencySearchId);
        }
    }

    public static DbAgencyBrokeringsHandler getBrokeringsHandler() {
        return contactsExtension != null ? contactsExtension.getBrokeringsHandler() : null;
    }

    public static DbAgencyContactsExtension getContactsExtension() {
        return contactsExtension;
    }

    public static DbAgencyContactsHandler getContactsHandler() {
        return contactsExtension != null ? contactsExtension.getContactsHandler() : null;
    }

    public static AgencyContactsUtils getInstance() {
        return INSTANCE;
    }

    public static DbAgencyInterestsHandler getInterestsHandler() {
        return contactsExtension != null ? contactsExtension.getInterestsHandler() : null;
    }

    public static DbAgencyContactsExtension lookupDbAgencyContactsExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? AgencyContactsUtils.lookupDbAgencyContactsExtension(ImmoToolEnvironment.getDbRelationExtensions((ImmoToolProject)immoToolProject)) : null;
    }

    public static DbAgencyContactsExtension lookupDbAgencyContactsExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? AgencyContactsUtils.lookupDbAgencyContactsExtension(ImmoToolEnvironment.getDbRelationExtensions((AbstractDbDriver)abstractDbDriver, null)) : null;
    }

    private static DbAgencyContactsExtension lookupDbAgencyContactsExtension(Collection<DbRelationExtension> collection) {
        if (collection != null) {
            for (DbRelationExtension dbRelationExtension : collection) {
                if (!(dbRelationExtension instanceof DbAgencyContactsExtension)) continue;
                return (DbAgencyContactsExtension)dbRelationExtension;
            }
        }
        return null;
    }

    public static void setContactsExtension(DbAgencyContactsExtension dbAgencyContactsExtension) {
        contactsExtension = dbAgencyContactsExtension;
    }

    private static final class InterestTableTask
    extends ImmoToolTask<AgencyInterestTablePanel, Void> {
        private final boolean asNewTab;

        public InterestTableTask(boolean bl) {
            this.asNewTab = bl;
        }

        protected AgencyInterestTablePanel doInBackground() throws Exception {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(AgencyInterestTablePanel.class) : null;
            if (AgencyInterestTablePanel.class.isInstance(abstractMainTab)) {
                AgencyInterestTablePanel agencyInterestTablePanel = (AgencyInterestTablePanel)abstractMainTab;
                ImmoToolAppUtils.selectTab((Component)((Object)agencyInterestTablePanel));
                return null;
            }
            return AgencyInterestTablePanel.createTab();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyInterestTablePanel agencyInterestTablePanel) {
            super.succeeded((Object)agencyInterestTablePanel);
            if (agencyInterestTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyInterestTablePanel);
                agencyInterestTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class InterestTableAction
    extends AbstractI18nAction {
        private final boolean asNewTab;

        public InterestTableAction() {
            this(false);
        }

        public InterestTableAction(boolean bl) {
            this.asNewTab = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new InterestTableTask(this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show search mandates")));
            this.setShortDescription(I18N.tr("Show a table of search mandates."));
        }
    }

    public static final class InterestFormAction
    extends AbstractI18nAction {
        private final long interestId;

        public InterestFormAction() {
            this(0L);
        }

        public InterestFormAction(long l) {
            this.interestId = l;
            if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (this.interestId > 0L) {
                for (AbstractMainTab abstractMainTab : ImmoToolAppUtils.getTabs(AgencyInterestViewPanel.class)) {
                    AgencyInterestViewPanel agencyInterestViewPanel = (AgencyInterestViewPanel)abstractMainTab;
                    if (agencyInterestViewPanel.getCurrentInterestId() != this.interestId) continue;
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyInterestViewPanel));
                    return;
                }
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyInterestViewTask(immoToolProject.getDbDriver(), this.interestId));
        }

        protected final void updateLocalization() {
            if (this.interestId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new search mandate")));
                this.setShortDescription(I18N.tr("Add a new search mandate."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show search mandate")));
                this.setShortDescription(I18N.tr("Show details about the search mandate."));
            }
        }
    }

    private static final class BrokeringTableTask
    extends ImmoToolTask<AgencyBrokeringTablePanel, Void> {
        private final boolean asNewTab;

        public BrokeringTableTask(boolean bl) {
            this.asNewTab = bl;
        }

        protected AgencyBrokeringTablePanel doInBackground() throws Exception {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(AgencyBrokeringTablePanel.class) : null;
            if (AgencyBrokeringTablePanel.class.isInstance(abstractMainTab)) {
                AgencyBrokeringTablePanel agencyBrokeringTablePanel = (AgencyBrokeringTablePanel)abstractMainTab;
                ImmoToolAppUtils.selectTab((Component)((Object)agencyBrokeringTablePanel));
                return null;
            }
            return AgencyBrokeringTablePanel.createTab();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyBrokeringTablePanel agencyBrokeringTablePanel) {
            super.succeeded((Object)agencyBrokeringTablePanel);
            if (agencyBrokeringTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyBrokeringTablePanel);
                agencyBrokeringTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class BrokeringTableAction
    extends AbstractI18nAction {
        private final boolean asNewTab;

        public BrokeringTableAction() {
            this(false);
        }

        public BrokeringTableAction(boolean bl) {
            this.asNewTab = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new BrokeringTableTask(this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show brokering mandates")));
            this.setShortDescription(I18N.tr("Show a table of brokering mandates."));
        }
    }

    public static final class BrokeringFormAction
    extends AbstractI18nAction {
        private final long brokeringId;

        public BrokeringFormAction() {
            this(0L);
        }

        public BrokeringFormAction(long l) {
            this.brokeringId = l;
            if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (this.brokeringId > 0L) {
                for (AbstractMainTab abstractMainTab : ImmoToolAppUtils.getTabs(AgencyBrokeringViewPanel.class)) {
                    AgencyBrokeringViewPanel agencyBrokeringViewPanel = (AgencyBrokeringViewPanel)abstractMainTab;
                    if (agencyBrokeringViewPanel.getCurrentBrokeringId() != this.brokeringId) continue;
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyBrokeringViewPanel));
                    return;
                }
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyBrokeringViewTask(immoToolProject.getDbDriver(), this.brokeringId));
        }

        protected final void updateLocalization() {
            if (this.brokeringId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("new brokering mandate")));
                this.setShortDescription(I18N.tr("Add a new brokering mandate."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show brokering mandate")));
                this.setShortDescription(I18N.tr("Show details about the brokering mandate."));
            }
        }
    }
}

