/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyEstateViewContactTablePanel;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewContactAddPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewContactAddPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewContactAddPanel.class);
    private final WeakReference<AgencyEstateViewContactTablePanel> tablePanel;
    private ValidationHandler validationHandler;
    private JXTitledSeparator formTitle;
    private JLabel groupLabel;
    private JComboBox<DbContactsGroup> groupField;
    private ContactsEntryExtendedAddressPanel addressForm;
    private AbstractI18nAction entryAddAction;

    public AgencyEstateViewContactAddPanel(AgencyEstateViewContactTablePanel agencyEstateViewContactTablePanel) {
        this.tablePanel = new WeakReference<AgencyEstateViewContactTablePanel>(agencyEstateViewContactTablePanel);
        this.build();
    }

    private void build() {
        this.groupLabel = new JLabel();
        this.groupField = new JComboBox();
        this.groupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select address group") + " ]";
            }
        }));
        this.addressForm = new ContactsEntryExtendedAddressPanel(50);
        this.addressForm.load(new DbContactsEntry());
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.validationHandler.putRule(this.groupField, ValidationHandler.NOT_BLANK);
        this.validationHandler.init();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.entryAddAction = new EntryAddAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{this.entryAddAction});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.groupField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.addressForm).xyw(1, defaultFormBuilder.nextRow(), 3);
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.updateLocalization();
    }

    private void clearNewContact() {
        this.addressForm.load(new DbContactsEntry());
        this.groupField.setSelectedItem(null);
        this.validationHandler.init();
        this.addressForm.initInputs();
    }

    private void doEntryAdd() {
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        if (!this.submitNewContact(dbContactsEntry)) {
            return;
        }
        this.entryAddAction.setEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new EntryAddTask(dbContactsEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        defaultComboBoxModel.addElement(null);
        try {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
                defaultComboBoxModel.addElement(dbContactsGroup);
            }
        }
        finally {
            this.groupField.setModel(defaultComboBoxModel);
        }
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("new address"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbAgencyObject dbAgencyObject) {
    }

    public void save(DbAgencyObject dbAgencyObject) {
    }

    private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
        this.validationHandler.validate();
        this.addressForm.validateInputs();
        if (!this.validationHandler.isValid() || !this.addressForm.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)this.getViewPanel());
            return false;
        }
        this.addressForm.save(dbContactsEntry);
        dbContactsEntry.groupId = ((DbContactsGroup)this.groupField.getSelectedItem()).id;
        return true;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("create a new address")));
        this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
    }

    private class EntryAddTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbContactsEntry newEntry;
        private String contactGroupName = null;

        private EntryAddTask(DbContactsEntry dbContactsEntry) {
            this.newEntry = dbContactsEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            this.contactGroupName = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsHandler.saveEntry(connection, this.newEntry);
                DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.newEntry.groupId);
                if (dbContactsGroup == null) {
                    throw new Exception("Can't find group #" + this.newEntry.groupId + "!");
                }
                this.contactGroupName = dbContactsGroup.name;
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            AgencyEstateViewContactAddPanel.this.entryAddAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            AgencyEstateViewContactTablePanel agencyEstateViewContactTablePanel;
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyEstateViewContactTablePanel agencyEstateViewContactTablePanel2 = agencyEstateViewContactTablePanel = AgencyEstateViewContactAddPanel.this.tablePanel != null ? (AgencyEstateViewContactTablePanel)((Object)AgencyEstateViewContactAddPanel.this.tablePanel.get()) : null;
            if (agencyEstateViewContactTablePanel != null) {
                agencyEstateViewContactTablePanel.getRelationForm().unselectRelation();
            }
            if (agencyEstateViewContactTablePanel != null) {
                agencyEstateViewContactTablePanel.addContactsEntry(this.newEntry, this.contactGroupName, null);
                agencyEstateViewContactTablePanel.updateLocalization();
            }
            AgencyEstateViewContactAddPanel.this.clearNewContact();
            if (agencyEstateViewContactTablePanel != null) {
                JTabbedPane jTabbedPane = (JTabbedPane)AgencyEstateViewContactAddPanel.this.getParent();
                jTabbedPane.setSelectedIndex(jTabbedPane.indexOfComponent((Component)((Object)agencyEstateViewContactTablePanel)));
            }
        }
    }

    private class EntryAddAction
    extends AbstractI18nAction {
        private EntryAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewContactAddPanel.this.doEntryAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save and assign the new address."));
        }
    }
}

