/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.idx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvFormat;
import org.openestate.io.core.LocaleUtils;
import org.openestate.io.core.NumberUtils;
import org.openestate.io.idx.IdxParser;
import org.openestate.io.idx.IdxPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxFormat
extends CsvFormat<IdxParser, IdxPrinter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxFormat.class);
    public static final String VERSION = "3.01";
    public static final String ENCODING = "ISO-8859-1";
    public static final String RECORD_SEPARATOR = "\r\n";

    public IdxFormat() {
        super(CSVFormat.newFormat((char)'#').withRecordSeparator(RECORD_SEPARATOR).withNullString(""));
    }

    public static String getCountryCode(String string) {
        return LocaleUtils.getCountryISO2((String)string);
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    private static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public String getEncoding() {
        return ENCODING;
    }

    protected IdxParser newParser(CSVParser cSVParser) {
        return new IdxParser(cSVParser);
    }

    protected IdxPrinter newPrinter(CSVPrinter cSVPrinter) {
        return new IdxPrinter(cSVPrinter);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="This behaviour is intended.")
    public static Boolean parseBoolean(String string) {
        if ("1".equalsIgnoreCase(string = StringUtils.trimToNull((String)string)) || "Y".equalsIgnoreCase(string)) {
            return true;
        }
        if ("0".equalsIgnoreCase(string) || "N".equalsIgnoreCase(string)) {
            return false;
        }
        return null;
    }

    public static Date parseDate(String string) throws ParseException {
        return (string = StringUtils.trimToNull((String)string)) != null ? IdxFormat.getDateFormat().parse(string) : null;
    }

    public static Calendar parseDateAsCalendar(String string) throws ParseException {
        Date date = IdxFormat.parseDate(string);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date parseDateTime(String string) throws ParseException {
        return (string = StringUtils.trimToNull((String)string)) != null ? IdxFormat.getDateTimeFormat().parse(string) : null;
    }

    public static Calendar parseDateTimeAsCalendar(String string) throws ParseException {
        Date date = IdxFormat.parseDateTime(string);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static BigDecimal parseDecimal(String string) throws NumberFormatException {
        Number number = IdxFormat.parseNumber(string, false);
        return number != null ? BigDecimal.valueOf(number.doubleValue()) : null;
    }

    public static Integer parseInteger(String string) throws NumberFormatException {
        Number number = IdxFormat.parseNumber(string, false);
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static Long parseLong(String string) throws NumberFormatException {
        Number number = IdxFormat.parseNumber(string, false);
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public static Number parseNumber(String string) throws NumberFormatException {
        return IdxFormat.parseNumber(string, false);
    }

    public static Number parseNumber(String string, boolean bl) throws NumberFormatException {
        return NumberUtils.parseNumber((String)string, (boolean)bl, (Locale[])new Locale[]{Locale.ENGLISH, Locale.GERMANY});
    }

    public static String printBoolean(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "1";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "0";
        }
        return "";
    }

    public static String printDate(Calendar calendar) {
        return IdxFormat.printDate(calendar != null ? calendar.getTime() : null);
    }

    public static String printDate(Date date) {
        return date != null ? IdxFormat.getDateFormat().format(date) : null;
    }

    public static String printDateTime(Calendar calendar) {
        return IdxFormat.printDateTime(calendar != null ? calendar.getTime() : null);
    }

    public static String printDateTime(Date date) {
        return date != null ? IdxFormat.getDateTimeFormat().format(date) : null;
    }

    public static String printNumber(Number number, int n) {
        return IdxFormat.printNumber(number, n, 0);
    }

    public static String printNumber(Number number, int n, int n2) {
        return NumberUtils.printNumber((Number)number, (int)n, (int)n2, (Locale)Locale.ENGLISH);
    }

    public static String printString(String string) {
        return IdxFormat.printString(string, 0);
    }

    public static String printString(String string, int n) {
        string = StringUtils.trimToNull((String)string);
        if (n < 1) {
            return string;
        }
        if (n < 4) {
            return StringUtils.left((String)string, (int)n);
        }
        return StringUtils.abbreviate((String)string, (int)n);
    }
}

