/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.daft_ie;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConvertableDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.DaftIeVersion;
import org.openestate.io.daft_ie.xml.Daft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DaftIeDocument
extends XmlConvertableDocument<Daft, DaftIeVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeDocument.class);

    public DaftIeDocument(Document document) {
        super(document);
        if (!DaftIeDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public DaftIeVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            string = StringUtils.trimToNull((String)XmlUtils.newXPath((String)"/io:daft/@version", (Document)object).stringValueOf(object));
            if (string == null) {
                LOGGER.warn("Can't find version information in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = DaftIeVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public DaftIeVersion getLatestVersion() {
        return DaftIeUtils.VERSION;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "daft".equals(element.getLocalName());
    }

    public static DaftIeDocument newDocument() throws ParserConfigurationException, JAXBException {
        return DaftIeDocument.newDocument(DaftIeUtils.getFactory().createDaft());
    }

    public static DaftIeDocument newDocument(Daft daft) throws ParserConfigurationException, JAXBException {
        if (StringUtils.isBlank((CharSequence)daft.getVersion())) {
            daft.setVersion(DaftIeUtils.VERSION.toReadableVersion());
        }
        Document document = XmlUtils.newDocument();
        DaftIeUtils.createMarshaller("UTF-8", true).marshal((Object)daft, (Node)document);
        return new DaftIeDocument(document);
    }

    public void setDocumentVersion(DaftIeVersion daftIeVersion) {
        try {
            Document document = this.getDocument();
            Element element = (Element)XmlUtils.newXPath((String)"/io:daft", (Document)document).selectSingleNode((Object)document);
            if (element == null) {
                LOGGER.warn("Can't find an <daft> element in the document!");
                return;
            }
            element.setAttribute("version", daftIeVersion.toReadableVersion());
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public Daft toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (Daft)DaftIeUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

