/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.trovit;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.features.BalconyTerraceDirection;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.AdType;
import org.openestate.io.trovit.xml.ObjectFactory;
import org.openestate.io.trovit.xml.PictureType;
import org.openestate.io.trovit.xml.Trovit;
import org.openestate.io.trovit.xml.types.AreaUnitValue;
import org.openestate.io.trovit.xml.types.OrientationValue;
import org.openestate.io.trovit.xml.types.PricePeriodValue;
import org.openestate.io.trovit.xml.types.TypeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrovitWriter
extends AbstractXmlWriter<TrovitDocument, Trovit> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitWriter.class);
    private static final ObjectFactory FACTORY = TrovitUtils.getFactory();
    private Date now = new Date();
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;

    public TrovitWriter() {
    }

    public TrovitWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AdType convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        List list2;
        BigDecimal bigDecimal;
        BigInteger bigInteger;
        Furnished.Option option;
        AdType adType = FACTORY.createAdType();
        adType.setAddress(estateImpl.getAddress().writeStreet());
        adType.setAgency(agentImpl != null ? agentImpl.getCompany().getCompanyName() : null);
        adType.setBathrooms(CountBathrooms.getAsBigDecimal((EstateImpl)estateImpl));
        adType.setByOwner(null);
        adType.setCity(StringUtils.trimToNull((String)estateImpl.getAddress().getCity()));
        adType.setCityArea(StringUtils.trimToNull((String)estateImpl.getAddress().getDistrict()));
        adType.setCountry(estateImpl.getAddress().getCountry());
        adType.setDate(TrovitWriter.toCalendar(estateImpl.getPublishBegin(), this.now));
        adType.setEcoScore(EfficiencyCategory.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        adType.setExpirationDate(TrovitWriter.toCalendar(estateImpl.getPublishEnd()));
        adType.setFloorNumber(StringUtils.trimToNull((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        adType.setForeclosure(Boolean.valueOf(OpenEstateAction.AUCTION.equals((Object)estateImpl.getAction())));
        adType.setForeclosureType(null);
        adType.setId(StringUtils.trimToNull((String)estateImpl.getId()));
        adType.setIsRentToOwn(null);
        adType.setLatitude(estateImpl.getAddress().getLatitude());
        adType.setLongitude(estateImpl.getAddress().getLongitude());
        adType.setMlsDatabase(null);
        adType.setMobileUrl(null);
        adType.setNeighborhood(StringUtils.trimToNull((String)LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        adType.setPostcode(estateImpl.getAddress().getCountry());
        adType.setPropertyType(estateImpl.getType().name());
        adType.setRegion(StringUtils.trimToNull((String)estateImpl.getAddress().getRegion()));
        adType.setRooms(CountBedrooms.getAsBigDecimal((EstateImpl)estateImpl));
        adType.setTitle(StringUtils.trimToNull((String)estateImpl.getTitle()));
        adType.setUrl(null);
        adType.setVirtualTour(null);
        adType.setYear(BuildYear.getAsBigInteger((EstateImpl)estateImpl));
        ConditionType.Option option2 = ConditionType.get((EstateImpl)estateImpl);
        if (option2 != null) {
            adType.setCondition(StringUtils.trimToNull((String)option2.getTranslation(this.getOpenEstateLanguage())));
        }
        adType.setContactEmail((String)StringUtils.defaultIfBlank((CharSequence)(agentContactImpl != null ? agentContactImpl.getPersonMail() : null), agentImpl != null ? StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMail()) : null));
        adType.setContactName((String)StringUtils.defaultIfBlank((CharSequence)(agentContactImpl != null ? agentContactImpl.writePersonFullName() : null), agentImpl != null ? StringUtils.trimToNull((String)agentImpl.getCompany().writePersonFullName()) : null));
        adType.setContactTelephone((String)StringUtils.defaultIfBlank((CharSequence)(agentContactImpl != null ? agentContactImpl.getPersonPhone() : null), agentImpl != null ? StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyPhone()) : null));
        String string = estateImpl.getTitle(this.getOpenEstateLanguage());
        String string2 = "";
        if (!StringUtils.isBlank((CharSequence)string)) {
            string2 = string2 + string + "<hr/>";
        }
        string2 = string2 + estateImpl.getType().getTranslation(this.getOpenEstateLanguage());
        string2 = string2 + " / " + estateImpl.getAction().getTranslation(this.getOpenEstateLanguage());
        string2 = string2 + "<hr/>" + estateImpl.getAddress().writeFullAddress(", ", this.getOpenEstateLanguage());
        String string3 = StringUtils.trimToNull((String)DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string3 != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION.getTranslation(this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string3;
        }
        if ((string3 = StringUtils.trimToNull((String)FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateAttrib.DESCRIPTIONS_FEATURE_DESCRIPTION.getTranslation(this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string3;
        }
        if ((string3 = StringUtils.trimToNull((String)PriceDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION.getTranslation(this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string3;
        }
        if ((string3 = StringUtils.trimToNull((String)AgentFeeInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateAttrib.DESCRIPTIONS_AGENT_FEE_INFORMATION.getTranslation(this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string3;
        }
        if (this.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((CharSequence)(option = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)"<br/>")))) {
            string2 = string2 + "<hr/>" + (String)option;
        }
        adType.setContent(StringUtils.trimToNull((String)string2));
        Furnished.Option option3 = option = new Furnished.Option[]{TotalArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), ResidentialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), CommercialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), UsableArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)};
        int n = ((BigInteger[])option3).length;
        for (int i = 0; i < n; ++i) {
            bigInteger = option3[i];
            if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 1) continue;
            adType.setFloorArea(FACTORY.createFloorAreaType());
            adType.getFloorArea().setUnit(AreaUnitValue.METERS);
            adType.getFloorArea().setValue(bigInteger);
            break;
        }
        if (Furnished.Option.YES.equals((Object)(option3 = Furnished.get((EstateImpl)estateImpl))) || Furnished.Option.PARTIAL.equals((Object)option3)) {
            adType.setIsFurnished(Boolean.valueOf(true));
        } else if (Furnished.Option.NO.equals((Object)option3)) {
            adType.setIsFurnished(Boolean.valueOf(false));
        } else {
            adType.setIsFurnished(null);
        }
        Integer n2 = CountParkingSpaces.getAsInteger((EstateImpl)estateImpl);
        List list3 = CarParkingType.getAsList((EstateImpl)estateImpl);
        if (n2 != null && n2 > 0 || list3 != null && !list3.isEmpty()) {
            adType.setParking(Boolean.valueOf(true));
        }
        if ((bigInteger = PlotArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) != null) {
            adType.setPlotArea(FACTORY.createPlotAreaType());
            adType.getPlotArea().setValue(bigInteger);
            adType.getPlotArea().setUnit(AreaUnitValue.METERS);
        }
        if (estateImpl.isHiddenPrices()) {
            adType.setPrice(FACTORY.createPriceType());
            adType.getPrice().setPeriod(PricePeriodValue.MONTHLY);
            adType.getPrice().setValue(BigDecimal.ZERO);
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction()) || OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            bigDecimal = Lease.getAsBigDecimal((EstateImpl)estateImpl);
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                adType.setPrice(FACTORY.createPriceType());
                adType.getPrice().setPeriod(PricePeriodValue.MONTHLY);
                adType.getPrice().setValue(bigDecimal);
            }
        } else if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            bigDecimal = PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl);
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                adType.setPrice(FACTORY.createPriceType());
                adType.getPrice().setValue(bigDecimal);
            }
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            bigDecimal = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            }
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                adType.setPrice(FACTORY.createPriceType());
                adType.getPrice().setPeriod(PricePeriodValue.MONTHLY);
                adType.getPrice().setValue(bigDecimal);
            }
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction()) && (bigDecimal = RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            adType.setPrice(FACTORY.createPriceType());
            adType.getPrice().setValue(bigDecimal);
            list2 = RentFlatRatePer.get((EstateImpl)estateImpl);
            if (RentFlatRatePer.Option.MONTH.equals((Object)list2)) {
                adType.getPrice().setPeriod(PricePeriodValue.MONTHLY);
            } else if (RentFlatRatePer.Option.WEEK.equals((Object)list2)) {
                adType.getPrice().setPeriod(PricePeriodValue.WEEKLY);
            } else if (RentFlatRatePer.Option.DAY.equals((Object)list2)) {
                adType.getPrice().setPeriod(PricePeriodValue.DAILY);
            }
        }
        bigDecimal = Age.get((EstateImpl)estateImpl);
        if (Age.Option.NEW_BUILDING.equals((Object)bigDecimal)) {
            adType.setIsNew(Boolean.valueOf(true));
        } else if (Age.Option.OLD_BUILDING.equals((Object)bigDecimal)) {
            adType.setIsNew(Boolean.valueOf(false));
        }
        list2 = BalconyTerraceDirection.getAsList((EstateImpl)estateImpl);
        if (list2.contains(BalconyTerraceDirection.Option.E)) {
            adType.setOrientation(OrientationValue.EAST);
        } else if (list2.contains(BalconyTerraceDirection.Option.N)) {
            adType.setOrientation(OrientationValue.NORTH);
        } else if (list2.contains(BalconyTerraceDirection.Option.S)) {
            adType.setOrientation(OrientationValue.SOUTH);
        } else if (list2.contains(BalconyTerraceDirection.Option.W)) {
            adType.setOrientation(OrientationValue.WEST);
        }
        OpenEstateAction openEstateAction = estateImpl.getAction();
        boolean bl = OpenEstateAction.PURCHASE.equals((Object)openEstateAction) || OpenEstateAction.AUCTION.equals((Object)openEstateAction);
        boolean bl2 = OpenEstateAction.LEASE.equals((Object)openEstateAction) || OpenEstateAction.RENT.equals((Object)openEstateAction) || OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction);
        List<OpenEstateType> list4 = Arrays.asList(estateImpl.getType().getParentPath());
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            adType.setType(TypeValue.SHORT_TERM_RENTALS);
        } else if (list4.contains(OpenEstateType.APARTMENT_SHARE)) {
            adType.setType(TypeValue.ROOMMATE);
        } else if (list4.contains(OpenEstateType.GENERAL_PIECE_OF_LAND) && bl) {
            adType.setType(TypeValue.LAND_FOR_SALE);
        } else if (list4.contains(OpenEstateType.RETAIL) && bl) {
            adType.setType(TypeValue.LOCAL_FOR_SALE);
        } else if (list4.contains(OpenEstateType.RETAIL) && bl2) {
            adType.setType(TypeValue.LOCAL_FOR_RENT);
        } else if (list4.contains(OpenEstateType.OFFICE_SURGERY) && bl) {
            adType.setType(TypeValue.OFFICE_FOR_SALE);
        } else if (list4.contains(OpenEstateType.OFFICE_SURGERY) && bl2) {
            adType.setType(TypeValue.OFFICE_FOR_RENT);
        } else if (list4.contains(OpenEstateType.HALL_WAREHOUSE) && bl) {
            adType.setType(TypeValue.WAREHOUSE_FOR_RENT);
        } else if (list4.contains(OpenEstateType.HALL_WAREHOUSE) && bl2) {
            adType.setType(TypeValue.WAREHOUSE_FOR_SALE);
        } else if (list4.contains(OpenEstateType.GENERAL_PARKING) && bl) {
            adType.setType(TypeValue.PARKING_FOR_SALE);
        } else if (list4.contains(OpenEstateType.GENERAL_PARKING) && bl2) {
            adType.setType(TypeValue.PARKING_FOR_RENT);
        } else if (bl2) {
            adType.setType(TypeValue.FOR_RENT);
        } else if (bl) {
            adType.setType(TypeValue.FOR_SALE);
        } else {
            list.add("Die Kombination aus Immobilienart (" + estateImpl.getType() + ") und Vermarktungsart (" + estateImpl.getAction() + ") wird nicht unterst\u00fctzt!");
            return null;
        }
        String string4 = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string4 != null) {
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                URI uRI;
                if (estateAttachmentImpl == null || !estateAttachmentImpl.isImageType() || (uRI = estateAttachmentImpl.getAbsoluteUrl(string4)) == null) continue;
                if (adType.getPictures() == null) {
                    adType.setPictures(FACTORY.createAdTypePictures());
                }
                PictureType pictureType = FACTORY.createPictureType();
                pictureType.setPictureTitle(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
                pictureType.setPictureUrl(uRI);
                pictureType.setFeatured(Boolean.valueOf(adType.getPictures().getPicture().isEmpty()));
                adType.getPictures().getPicture().add(pictureType);
            }
        }
        return adType;
    }

    protected Trovit convertToXmlObject(AgencyImpl agencyImpl) {
        Trovit trovit = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("no agency was provided!");
        } else {
            for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
                try {
                    String string = estateImpl.getContactId();
                    AgentContactImpl agentContactImpl = string != null && agencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)agencyImpl.getContacts().get(string) : null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AdType adType = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    trovit.getAd().add(adType);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return trovit;
    }

    protected Trovit convertToXmlObject(TransferImpl transferImpl) {
        Trovit trovit = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn("no transferable agent found!");
        } else {
            TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                try {
                    String string = estateImpl.getContactId();
                    AgentContactImpl agentContactImpl = string != null && transferAgencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)transferAgencyImpl.getContacts().get(string) : null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AdType adType = this.convertEstate(estateImpl, transferAgencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    trovit.getAd().add(adType);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return trovit;
    }

    protected Trovit createRoot() {
        return FACTORY.createTrovit();
    }

    protected TrovitDocument createXmlDocument(Trovit trovit) throws ParserConfigurationException, JAXBException {
        return TrovitDocument.newDocument((Trovit)trovit);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    private static Calendar toCalendar(Date date) {
        return TrovitWriter.toCalendar(date, null);
    }

    private static Calendar toCalendar(Date date, Date date2) {
        if (date == null) {
            date = date2;
        }
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        return calendar;
    }
}

