/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateField;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AgencyEstateRelationPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateRelationPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateRelationPanel.class);
    private long currentObjectId = 0L;
    private JXTitledSeparator formTitle;
    private AgencyEstateField agencyObjectField;
    private JLabel agencyObjectLabel;
    private JPanel agencyObjectPanel;
    private JLabel notesLabel;
    private DefaultTextArea notesField;

    public AgencyEstateRelationPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        this.agencyObjectLabel = new JLabel();
        this.agencyObjectField = new AgencyEstateField();
        this.agencyObjectPanel = new JPanel(new BorderLayout());
        this.agencyObjectPanel.add((Component)((Object)this.agencyObjectField), "Center");
        this.notesLabel = null;
        this.notesField = null;
        JScrollPane jScrollPane = null;
        if (bl) {
            this.notesLabel = new JLabel();
            this.notesField = new DefaultTextArea();
            jScrollPane = this.notesField.createScrollPane();
            jScrollPane.setPreferredSize(new Dimension(100, 100));
        }
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.agencyObjectLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agencyObjectPanel).xy(3, defaultFormBuilder.row());
        if (jScrollPane != null) {
            defaultFormBuilder.add((Component)this.notesLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
            defaultFormBuilder.addRaw((Component)jScrollPane).xy(3, defaultFormBuilder.row());
        }
        this.updateLocalization();
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        String string;
        DbAgencyObject dbAgencyObject = this.agencyObjectField.getAgencyObject();
        String string2 = string = this.notesField != null ? this.notesField.getText().trim() : null;
        if (dbAgencyObject == null) {
            return;
        }
        if (this.submit(dbAgencyObject, string)) {
            this.unselectRelation();
        }
    }

    public long getCurrentAgencyObjectId() {
        return this.currentObjectId;
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbAgencyObject(), null);
    }

    public void selectRelation(DbAgencyObject dbAgencyObject, String string) {
        if (dbAgencyObject == null) {
            this.setVisible(false);
            return;
        }
        this.currentObjectId = dbAgencyObject.id;
        if (this.notesField != null) {
            this.notesField.setText(StringUtils.trimToEmpty((String)string));
            this.notesField.setCaretPosition(0);
        }
        this.agencyObjectField.setEnabled(false);
        this.agencyObjectField.setAgencyObject(this.currentObjectId > 0L ? dbAgencyObject : null);
        this.agencyObjectField.setCaretPosition(0);
        this.agencyObjectField.setEnabled(true);
        this.updateLocalization();
        this.setVisible(true);
    }

    public abstract boolean submit(DbAgencyObject var1, String var2);

    public void unselectRelation() {
        this.selectRelation(null, null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentObjectId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.agencyObjectLabel.setText(StringUtils.capitalize((String)I18N.tr("property")) + ":");
        if (this.notesLabel != null) {
            this.notesLabel.setText(StringUtils.capitalize((String)I18N.tr("notes")) + ":");
        }
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        public RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateRelationPanel.this.doRelationSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit current assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        public RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateRelationPanel.this.doRelationClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("close")));
            this.setShortDescription(I18N.tr("Close current assignment."));
        }
    }
}

