/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLog;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateStatusTask
extends ImmoToolTask<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateStatusTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateStatusTask.class);
    private final long[] estateIds;
    private final DbAgencyObject[] estates;
    private final AbstractDbDriver dbDriver;
    private final Connection dbConnection;
    private final DbUser dbUser;
    private final DbAgencyObjectsHandler dbObjectsHandler;
    private final DbAgencyObjectLogsHandler dbLogHandler;
    private DbAgencyObject.Status status;

    public AgencyEstateStatusTask(long[] lArray, DbAgencyObject.Status status, AbstractDbDriver abstractDbDriver, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = abstractDbDriver;
        this.dbConnection = null;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.status = status;
        this.estates = null;
        this.estateIds = ArrayUtils.clone((long[])lArray);
    }

    public AgencyEstateStatusTask(long[] lArray, DbAgencyObject.Status status, Connection connection, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = null;
        this.dbConnection = connection;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.status = status;
        this.estates = null;
        this.estateIds = ArrayUtils.clone((long[])lArray);
    }

    public AgencyEstateStatusTask(DbAgencyObject[] dbAgencyObjectArray, DbAgencyObject.Status status, AbstractDbDriver abstractDbDriver, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = abstractDbDriver;
        this.dbConnection = null;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.status = status;
        this.estates = (DbAgencyObject[])ArrayUtils.clone((Object[])dbAgencyObjectArray);
        this.estateIds = null;
    }

    public AgencyEstateStatusTask(DbAgencyObject[] dbAgencyObjectArray, DbAgencyObject.Status status, Connection connection, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = null;
        this.dbConnection = connection;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.status = status;
        this.estates = (DbAgencyObject[])ArrayUtils.clone((Object[])dbAgencyObjectArray);
        this.estateIds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        Connection connection = this.dbConnection;
        try {
            if (connection == null) {
                connection = this.dbDriver.getConnection();
            }
            for (DbAgencyObject dbAgencyObject : this.loadEstates(connection)) {
                DbAgencyObject.Status status = dbAgencyObject.status;
                if (this.status.equals((Object)status)) continue;
                if (DbAgencyObject.Status.PUBLISHED.equals((Object)status)) {
                    if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_UNPUBLISHING)) {
                        LOGGER.warn("User is not allowed to unpublish property #" + dbAgencyObject.id + "!");
                        continue;
                    }
                } else if (DbAgencyObject.Status.PUBLISHED.equals((Object)this.status) && !AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING)) {
                    LOGGER.warn("User is not allowed to publish property #" + dbAgencyObject.id + "!");
                    continue;
                }
                this.setMessage("Update object #" + dbAgencyObject.id);
                this.dbObjectsHandler.setObjectStatus(connection, dbAgencyObject.id, this.status);
                dbAgencyObject.status = this.status;
                DbAgencyObjectLog dbAgencyObjectLog = DbAgencyObjectLog.create(dbAgencyObject.id, "EDIT", this.dbUser);
                dbAgencyObjectLog.putChangedStatus(status, dbAgencyObject.status);
                this.dbLogHandler.saveLog(connection, dbAgencyObjectLog);
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            if (this.dbConnection == null) {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private DbAgencyObject[] loadEstates(Connection connection) throws SQLException {
        if (this.estates != null) {
            return this.estates;
        }
        if (this.estateIds == null || this.estateIds.length < 1) {
            return new DbAgencyObject[0];
        }
        ArrayList<DbAgencyObject> arrayList = new ArrayList<DbAgencyObject>();
        for (DbObject dbObject : this.dbObjectsHandler.getObjects(connection, this.estateIds)) {
            arrayList.add((DbAgencyObject)dbObject);
        }
        return arrayList.toArray(new DbAgencyObject[0]);
    }

    protected void setStatus(DbAgencyObject.Status status) {
        this.status = status;
    }
}

