/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportPool;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.gui.ExportTransferModeRenderer;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.StringRenderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.AlphanumComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportDialogPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportDialogPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportDialogPanel.class);
    private static final String TABLE_ID = "AgencyExportDialogPanel.Table";
    private final AgencyExportPool pool;
    private final DbAgencyExport export;
    private AbstractDbDriver dbDriver = null;
    private DbAgencyExtension dbExtension = null;
    private AbstractFormat.TransferMode transferMode;
    private View view = View.SHORT;
    private Map<Long, String> estateHashes = new HashMap<Long, String>();
    private JXTitledSeparator title;
    private JComboBox<AbstractFormat.TransferMode> transferModeField;
    private JPanel mainPanel;
    private JLabel infoLabel;
    private JXBusyLabel busyLabel;
    private Table table;
    private JScrollPane tableScroller;
    private ToggleViewAction detailsAction;
    private RemoveAction removeAction;

    public AgencyExportDialogPanel(DbAgencyExport dbAgencyExport, AgencyExportPool agencyExportPool) {
        this.export = dbAgencyExport;
        this.pool = agencyExportPool;
        this.transferMode = dbAgencyExport.transferMode;
        this.build();
    }

    private void build() {
        this.title = ImmoToolUtils.createHead2Separator((String)"");
        this.title.setIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
        this.removeAction = new RemoveAction();
        this.detailsAction = new ToggleViewAction();
        this.transferModeField = new JComboBox();
        this.transferModeField.setRenderer((ListCellRenderer<AbstractFormat.TransferMode>)new DefaultListCellRenderer((Renderer)new ExportTransferModeRenderer(false)));
        for (AbstractFormat.TransferMode transferMode : this.export.getFormat().getSupportedTransferModes()) {
            this.transferModeField.addItem(transferMode);
        }
        this.transferModeField.setSelectedItem((Object)this.transferMode);
        this.transferModeField.setEnabled(this.transferModeField.getItemCount() > 1);
        this.transferModeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AgencyExportDialogPanel.this.transferModeField.isEnabled()) {
                    AgencyExportDialogPanel.this.updateTransferMode();
                }
            }
        });
        this.infoLabel = new JLabel();
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(this.infoLabel.getFont().getSize2D() * 0.95f));
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setBusy(false);
        this.busyLabel.setVisible(false);
        this.table = new Table();
        this.tableScroller = this.table.createScrollPane();
        this.tableScroller.setPreferredSize(new Dimension(this.tableScroller.getPreferredSize().width, 250));
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{this.transferModeField, new JButton((Action)((Object)this.detailsAction)), new JButton((Action)((Object)this.removeAction))});
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.setBorder(Paddings.EMPTY);
        this.mainPanel.add((Component)this.busyLabel, "North");
        this.mainPanel.add((Component)this.tableScroller, "Center");
        this.mainPanel.add((Component)this.infoLabel, "South");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.mainPanel, "Center");
        this.updateLocalization();
    }

    protected void doRemove() {
    }

    public void doToggleView() {
        this.setView(View.DETAIL.equals((Object)this.view) ? View.SHORT : View.DETAIL);
    }

    public long getExportId() {
        return this.export.id;
    }

    private int getPublishCount() {
        AbstractFormat.TransferMode transferMode = (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
        boolean bl = AbstractFormat.TransferMode.FULL.equals((Object)transferMode);
        boolean bl2 = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)transferMode);
        int n = bl2 && this.export.publishings != null ? this.export.publishings.size() : 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            ExportAction exportAction = this.table.getActionAt(i);
            if (ExportAction.INSERT.equals((Object)exportAction)) {
                ++n;
                continue;
            }
            if (ExportAction.UPDATE.equals((Object)exportAction) && bl) {
                ++n;
                continue;
            }
            if (!ExportAction.DELETE.equals((Object)exportAction) || !bl2) continue;
            --n;
        }
        return n;
    }

    public AbstractFormat.TransferMode getTransferMode() {
        return (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
    }

    public void load(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        this.dbDriver = abstractDbDriver;
        this.dbExtension = dbAgencyExtension;
        this.estateHashes.clear();
        this.setBusy(true);
        this.busyLabel.setText(I18N.tr("Loading exportable properties."));
        this.table.clearRows();
        ImmoToolUtils.executeTask((ImmoToolTask)new LoadInBackgroundTask());
    }

    protected void loadingFinished(boolean bl) {
    }

    public void save(ExportContext exportContext) throws IOException {
        exportContext.transferMode = this.transferMode;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            ExportEntry exportEntry;
            long l = this.table.getObjectIdAt(i);
            String string = this.table.getPublicIdAt(i);
            ExportAction exportAction = this.table.getActionAt(i);
            if (ExportAction.INSERT.equals((Object)exportAction) || ExportAction.UPDATE.equals((Object)exportAction)) {
                exportEntry = new ExportEntry(ExportAction.INSERT.equals((Object)exportAction) ? DbAgencyExportAction.INSERT : DbAgencyExportAction.UPDATE);
                exportEntry.objectId = l;
                exportEntry.objectNr = string;
                exportEntry.objectKey = exportContext.export.getFormat().getObjectKey(l, string);
                exportEntry.hash = this.estateHashes.get(l);
                exportContext.addEntry(exportEntry, this.pool.getObjectFile(exportEntry.objectId));
                continue;
            }
            if (ExportAction.DELETE.equals((Object)exportAction)) {
                exportEntry = new ExportEntry(DbAgencyExportAction.DELETE);
                exportEntry.objectId = l;
                exportEntry.objectNr = string;
                exportEntry.objectKey = exportContext.export.getFormat().getObjectKey(l, string);
                exportContext.addEntry(exportEntry, null);
                continue;
            }
            if (!ExportAction.IGNORE_CHANGES.equals((Object)exportAction)) continue;
            exportContext.addIgnoredEntry(l, this.estateHashes.get(l));
        }
    }

    private void setBusy(boolean bl) {
        this.transferModeField.setEnabled(!bl);
        this.detailsAction.setEnabled(!bl);
        this.removeAction.setEnabled(!bl);
        this.transferModeField.setEnabled(!bl && this.transferModeField.getItemCount() > 1);
        if (bl) {
            this.tableScroller.setVisible(false);
            this.infoLabel.setVisible(false);
            this.busyLabel.setVisible(true);
            this.busyLabel.setBusy(true);
            this.revalidate();
            this.repaint();
        } else {
            this.setView(this.view);
        }
    }

    private void setError(String string) {
        this.transferModeField.setEnabled(false);
        this.detailsAction.setEnabled(false);
        this.removeAction.setEnabled(true);
        this.transferModeField.setEnabled(false);
        this.tableScroller.setVisible(false);
        this.infoLabel.setVisible(false);
        this.busyLabel.setVisible(true);
        this.busyLabel.setBusy(false);
        this.busyLabel.setText(StringUtils.trimToEmpty((String)string));
        this.revalidate();
        this.repaint();
    }

    private void setView(View view) {
        if (view == null) {
            return;
        }
        this.view = view;
        this.busyLabel.setBusy(false);
        this.busyLabel.setVisible(false);
        this.infoLabel.setVisible(true);
        this.tableScroller.setVisible(View.DETAIL.equals((Object)view));
        this.revalidate();
        this.repaint();
    }

    private void updateInfo() {
        int n;
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.table.getRowCount(); ++n) {
            ExportAction exportAction = this.table.getActionAt(n);
            if (ExportAction.DELETE.equals((Object)exportAction)) {
                ++n4;
                continue;
            }
            if (ExportAction.INSERT.equals((Object)exportAction)) {
                ++n2;
                continue;
            }
            if (!ExportAction.UPDATE.equals((Object)exportAction)) continue;
            ++n3;
        }
        n = this.export.publishings != null ? this.export.publishings.size() : 0;
        int n5 = n + n2 - n4;
        String string = "<html><div style=\"text-align:center;\">";
        string = string + I18N.trn("{0} new entry", "{0} new entries", (long)n2, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(n2) + "</b>"));
        string = string + ", ";
        string = string + I18N.trn("{0} update", "{0} updates", (long)n3, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(n3) + "</b>"));
        string = string + ", ";
        string = string + I18N.trn("{0} deletion", "{0} deletions", (long)n4, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(n4) + "</b>"));
        string = string + ", ";
        string = this.export.limit < 1 ? string + I18N.tr("unlimited") : string + "<span style=\"color:red;\">" + I18N.trn("limited to {0} property", "limited to {0} properties", (long)this.export.limit, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(this.export.limit) + "</b>")) + "</span>";
        string = string + "<br>";
        string = string + I18N.trn("{0} publication before export", "{0} publications before export", (long)n, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(n) + "</b>"));
        string = string + ", ";
        string = string + I18N.trn("{0} publication after export", "{0} publications after export", (long)n5, (Object)("<b style=\"font-size:1.1em;\">" + numberFormat.format(n5) + "</b>"));
        string = string + "</div></html>";
        this.infoLabel.setText(string);
    }

    private void updateLimit() {
        if (this.export.limit < 1) {
            return;
        }
        AbstractFormat.TransferMode transferMode = (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
        boolean bl = AbstractFormat.TransferMode.FULL.equals((Object)transferMode);
        boolean bl2 = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)transferMode);
        int n = this.getPublishCount();
        block0: while (n > this.export.limit) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                ExportAction exportAction = this.table.getActionAt(i);
                if (ExportAction.INSERT.equals((Object)exportAction)) {
                    this.table.setActionAt(i, ExportAction.DONT_PUBLISH);
                    --n;
                    continue block0;
                }
                if (ExportAction.UPDATE.equals((Object)exportAction) && bl) {
                    this.table.setActionAt(i, ExportAction.DELETE);
                    --n;
                    continue block0;
                }
                if (!ExportAction.KEEP_PUBLISHED.equals((Object)exportAction) || !bl2) continue;
                this.table.setActionAt(i, ExportAction.DELETE);
                --n;
                continue block0;
            }
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateInfo();
        String string = StringUtils.trimToNull((String)this.export.name);
        this.title.setTitle(string != null ? StringUtils.abbreviate((String)string, (int)25) : "#" + this.export.id);
    }

    protected void updateTransferMode() {
        AbstractFormat.TransferMode transferMode = (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
        if (transferMode == null || transferMode.equals((Object)this.transferMode)) {
            return;
        }
        this.transferMode = transferMode;
        boolean bl = AbstractFormat.TransferMode.FULL.equals((Object)this.transferMode);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            long l = this.table.getObjectIdAt(i);
            String string = this.estateHashes.get(l);
            ExportStatus exportStatus = this.table.getStatusAt(i);
            ExportAction exportAction = this.table.getActionAt(i);
            ExportAction exportAction2 = null;
            ExportStatus exportStatus2 = null;
            if (ExportStatus.CANT_UPDATE.equals((Object)exportStatus) || ExportStatus.REMOVED_LOCALLY.equals((Object)exportStatus) || ExportStatus.UNMATCHED.equals((Object)exportStatus)) {
                exportAction2 = ExportAction.DELETE;
            } else {
                if (!ExportStatus.CAN_UPDATE.equals((Object)exportStatus) && !ExportStatus.UNCHANGED.equals((Object)exportStatus)) continue;
                if (bl) {
                    exportStatus2 = ExportStatus.CAN_UPDATE;
                    if (!exportAction.isSupported(this.transferMode)) {
                        exportAction2 = ExportAction.UPDATE;
                    }
                } else {
                    DbAgencyExportPublishing dbAgencyExportPublishing = this.export.publishings.get(l);
                    boolean bl2 = dbAgencyExportPublishing == null || string == null || !string.equalsIgnoreCase(dbAgencyExportPublishing.hash);
                    ExportStatus exportStatus3 = exportStatus2 = bl2 ? ExportStatus.CAN_UPDATE : ExportStatus.UNCHANGED;
                    if (!ExportAction.DELETE.equals((Object)exportAction)) {
                        ExportAction exportAction3 = exportAction2 = bl2 ? ExportAction.UPDATE : ExportAction.KEEP_PUBLISHED;
                    }
                }
            }
            if (exportStatus2 != null) {
                this.table.setStatusAt(i, exportStatus2);
            }
            if (exportAction2 == null) continue;
            this.table.setActionAt(i, exportAction2);
        }
        this.updateInfo();
    }

    public static enum View {
        SHORT,
        DETAIL;

    }

    private static enum ExportStatus implements Translatable
    {
        CAN_INSERT(I18n.marktr((String)"new entry"), ExportAction.INSERT, ExportAction.DONT_PUBLISH),
        CAN_UPDATE(I18n.marktr((String)"already published"), ExportAction.UPDATE, ExportAction.DELETE, ExportAction.KEEP_PUBLISHED, ExportAction.IGNORE_CHANGES),
        CANT_INSERT(I18n.marktr((String)"insert not possible"), ExportAction.DONT_PUBLISH),
        CANT_UPDATE(I18n.marktr((String)"update not possible"), ExportAction.DELETE, ExportAction.KEEP_PUBLISHED),
        UNCHANGED(I18n.marktr((String)"unchanged since last export"), ExportAction.UPDATE, ExportAction.DELETE, ExportAction.KEEP_PUBLISHED, ExportAction.IGNORE_CHANGES),
        UNMATCHED(I18n.marktr((String)"not matching with search criteria"), ExportAction.DELETE, ExportAction.KEEP_PUBLISHED),
        REMOVED_LOCALLY(I18n.marktr((String)"removed from project"), ExportAction.DELETE, ExportAction.KEEP_PUBLISHED);

        private final String i18nKey;
        private final ExportAction[] actions;

        private ExportStatus(String string2, ExportAction ... exportActionArray) {
            this.i18nKey = string2;
            this.actions = exportActionArray;
        }

        public ExportAction[] getActions() {
            return (ExportAction[])ArrayUtils.clone((Object[])this.actions);
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ExportStatus.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ExportStatus.class, (String)this.i18nKey, (Locale)locale);
        }

        public boolean isActionSupported(ExportAction exportAction) {
            return ArrayUtils.contains((Object[])this.actions, (Object)((Object)exportAction));
        }
    }

    private class ExportActionTableEditor
    extends JComboBox<ExportAction>
    implements TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

        private ExportActionTableEditor() {
            this.setRenderer(new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExportActionTableEditor.this.isEnabled()) {
                        ExportActionTableEditor.this.stopCellEditing();
                    }
                }
            });
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
            AgencyExportDialogPanel.this.updateInfo();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (!(jTable instanceof Table)) {
                return null;
            }
            boolean bl2 = ((AgencyExportDialogPanel)AgencyExportDialogPanel.this).export.limit > 0 && ((AgencyExportDialogPanel)AgencyExportDialogPanel.this).export.limit <= AgencyExportDialogPanel.this.getPublishCount();
            Table table = (Table)((Object)jTable);
            int n3 = table.convertRowIndexToModel(n);
            ExportStatus exportStatus = table.getStatusAt(n3);
            ExportAction exportAction = table.getActionAt(n3);
            DefaultComboBoxModel<ExportAction> defaultComboBoxModel = new DefaultComboBoxModel<ExportAction>();
            for (ExportAction exportAction2 : exportStatus.getActions()) {
                if (bl2 && !exportAction2.equals((Object)exportAction) && (ExportAction.INSERT.equals((Object)exportAction2) || ExportAction.KEEP_PUBLISHED.equals((Object)exportAction2) && !ExportAction.UPDATE.equals((Object)exportAction) || ExportAction.UPDATE.equals((Object)exportAction2) && !ExportAction.KEEP_PUBLISHED.equals((Object)exportAction)) || !exportAction2.isSupported(AgencyExportDialogPanel.this.transferMode)) continue;
                defaultComboBoxModel.addElement(exportAction2);
            }
            this.setEnabled(false);
            this.setSelectedIndex(-1);
            this.setModel(defaultComboBoxModel);
            this.setSelectedItem((Object)exportAction);
            this.setEnabled(true);
            return this;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
            AgencyExportDialogPanel.this.updateInfo();
            return true;
        }
    }

    private static enum ExportAction implements Translatable
    {
        INSERT(I18n.marktr((String)"insert"), I18n.marktr((String)"Send as new property to the recipient.")),
        UPDATE(I18n.marktr((String)"update"), I18n.marktr((String)"Send as modified property to the recipient.")),
        DELETE(I18n.marktr((String)"delete"), I18n.marktr((String)"Remove property from the recipient.")),
        IGNORE_CHANGES(I18n.marktr((String)"ignore changes"), I18n.marktr((String)"Ignore modified property until new changes are made.")),
        DONT_PUBLISH(I18n.marktr((String)"don't publish"), I18n.marktr((String)"Don't send the property to the recipient.")),
        KEEP_PUBLISHED(I18n.marktr((String)"keep published"), I18n.marktr((String)"Don't send the modified property to the recipient."));

        private final String i18nKey;
        private final String i18nDescriptionKey;

        private ExportAction(String string2, String string3) {
            this.i18nKey = string2;
            this.i18nDescriptionKey = string3;
        }

        public String getDescription() {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nDescriptionKey);
        }

        public String getDescription(Locale locale) {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nDescriptionKey, (Locale)locale);
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ExportAction.class, (String)this.i18nKey, (Locale)locale);
        }

        public boolean isSupported(AbstractFormat.TransferMode transferMode) {
            if (KEEP_PUBLISHED.equals((Object)this) && AbstractFormat.TransferMode.FULL.equals((Object)transferMode)) {
                return false;
            }
            return !IGNORE_CHANGES.equals((Object)this) || !AbstractFormat.TransferMode.FULL.equals((Object)transferMode);
        }
    }

    private class ToggleViewAction
    extends AbstractI18nAction {
        private ToggleViewAction() {
            this.updateIcon();
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportDialogPanel.this.doToggleView();
            this.updateIcon();
            this.updateLocalization();
        }

        private void updateIcon() {
            if (View.DETAIL.equals((Object)AgencyExportDialogPanel.this.view)) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16));
            }
        }

        protected void updateLocalization() {
        }
    }

    private class SetExportAction
    extends AbstractI18nAction {
        private final ExportAction action;
        private final Table table;

        private SetExportAction(ExportAction exportAction, Table table) {
            this.action = exportAction;
            this.table = table;
            this.updateLocalization();
            this.setEnabled(false);
            for (int n : this.table.getSelectedRows()) {
                int n2 = this.table.convertRowIndexToModel(n);
                ExportStatus exportStatus = this.table.getStatusAt(n2);
                if (exportStatus == null || !exportStatus.isActionSupported(exportAction)) continue;
                this.setEnabled(true);
                break;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int n : this.table.getSelectedRows()) {
                int n2 = this.table.convertRowIndexToModel(n);
                ExportStatus exportStatus = this.table.getStatusAt(n2);
                if (exportStatus == null || !exportStatus.isActionSupported(this.action)) continue;
                this.table.setActionAt(n2, this.action);
            }
            AgencyExportDialogPanel.this.updateLimit();
            AgencyExportDialogPanel.this.updateInfo();
        }

        protected void updateLocalization() {
            this.setName(this.action.getTranslation());
            this.setShortDescription(this.action.getDescription());
        }
    }

    private class RemoveAction
    extends AbstractI18nAction {
        private RemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportDialogPanel.this.doRemove();
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Remove interface from the export process."));
        }
    }

    private static class TableRow
    extends AbstractTable.Row {
        private final long objectId;
        private final String publicId;
        private final EstateImpl object;
        private final String notice;
        private ExportAction action;
        private ExportStatus status;

        private TableRow(long l, EstateImpl estateImpl, ExportAction exportAction, ExportStatus exportStatus, String string) {
            this.objectId = l;
            this.publicId = estateImpl != null ? StringUtils.trimToNull((String)estateImpl.getPublicId()) : null;
            this.object = estateImpl;
            this.status = exportStatus;
            this.notice = string;
            this.action = exportAction;
        }

        private TableRow(long l, String string, ExportAction exportAction, ExportStatus exportStatus, String string2) {
            this.objectId = l;
            this.publicId = string;
            this.object = null;
            this.status = exportStatus;
            this.notice = string2;
            this.action = exportAction;
        }

        public ExportAction getAction() {
            return this.action;
        }

        public String getNotice() {
            return this.notice;
        }

        public EstateImpl getObject() {
            return this.object;
        }

        public long getObjectId() {
            return this.objectId;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public ExportStatus getStatus() {
            return this.status;
        }

        public String getToolTipText(AbstractTable.Column column) {
            String string;
            Object object;
            OpenEstateAction openEstateAction = this.object != null ? this.object.getAction() : null;
            OpenEstateType openEstateType = this.object != null ? this.object.getType() : null;
            EstateAddressImpl estateAddressImpl = this.object != null ? this.object.getAddress() : null;
            String string2 = "<html><div style=\"padding:3px;\">";
            string2 = string2 + "<b style=\"font-size:1.1em;\">";
            string2 = string2 + StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.objectId;
            if (StringUtils.isNotBlank((CharSequence)this.publicId)) {
                string2 = string2 + " / " + StringEscapeUtils.escapeXml11((String)this.publicId);
            }
            string2 = string2 + "</b>";
            if (openEstateType != null || openEstateAction != null) {
                string2 = string2 + "<br>";
                if (openEstateType != null) {
                    string2 = string2 + openEstateType.getTranslation();
                }
                if (openEstateType != null && openEstateAction != null) {
                    string2 = string2 + " / ";
                }
                if (openEstateAction != null) {
                    string2 = string2 + openEstateAction.getTranslation();
                }
            }
            if (estateAddressImpl != null) {
                object = estateAddressImpl.writePostal();
                if (StringUtils.isNotBlank((CharSequence)object)) {
                    string2 = string2 + "<br>" + StringEscapeUtils.escapeXml11((String)object);
                }
                if (StringUtils.isNotBlank((CharSequence)(string = estateAddressImpl.writeStreet(true)))) {
                    string2 = string2 + "<br>" + StringEscapeUtils.escapeXml11((String)string);
                }
            }
            if (openEstateType != null && openEstateAction != null) {
                object = new ArrayList();
                string = this.object.getTypeSpec();
                for (OpenEstateAttrib openEstateAttrib : string.getAttribs()) {
                    String string3;
                    AbstractAttribImpl abstractAttribImpl;
                    if (!string.isAttribRequired(openEstateAttrib) || (abstractAttribImpl = this.object.getAttribute(openEstateAttrib)) == null || (string3 = StringUtils.trimToNull((String)abstractAttribImpl.getFormattedValue())) == null) continue;
                    object.add(StringEscapeUtils.escapeXml11((String)openEstateAttrib.getTranslation()) + ": " + StringEscapeUtils.escapeXml11((String)string3));
                }
                if (!object.isEmpty()) {
                    string2 = string2 + "<hr>" + StringUtils.join((Iterable)object, (String)"<br>");
                }
            }
            string2 = string2 + "<hr>";
            string2 = string2 + "<b>" + (this.status != null ? StringEscapeUtils.escapeXml11((String)this.status.getTranslation()) : "???") + "</b>";
            if (this.action != null) {
                string2 = string2 + "<br>";
                string2 = string2 + "<i>" + StringEscapeUtils.escapeXml11((String)this.action.getDescription()) + "</i>";
            }
            if (StringUtils.isNotBlank((CharSequence)this.notice)) {
                string2 = string2 + "<hr>";
                string2 = string2 + StringEscapeUtils.escapeXml11((String)this.notice);
            }
            string2 = string2 + "</div></html>";
            return string2;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForExport((TableColumn)column);
            }
            return null;
        }

        private Object getValueForExport(TableColumn tableColumn) {
            OpenEstateAction openEstateAction = this.object != null ? this.object.getAction() : null;
            OpenEstateType openEstateType = this.object != null ? this.object.getType() : null;
            EstateAddressImpl estateAddressImpl = this.object != null ? this.object.getAddress() : null;
            switch (tableColumn) {
                case ID: {
                    return "<html><div>#" + this.objectId + (StringUtils.isNotBlank((CharSequence)this.publicId) ? "<br>" + this.publicId : "") + "</div></html>";
                }
                case TYPE: {
                    if (openEstateType == null && openEstateAction == null) {
                        return "";
                    }
                    return "<html><div>" + (openEstateType != null ? openEstateType.getTranslation() : "???") + "<br>" + (openEstateAction != null ? openEstateAction.getTranslation() : "???") + "</div></html>";
                }
                case ADDRESS: {
                    if (estateAddressImpl == null) {
                        return "";
                    }
                    return "<html><div>" + estateAddressImpl.writeStreet(true) + "<br>" + estateAddressImpl.writePostal() + "</div></html>";
                }
                case NOTICE: {
                    return "<html><div>" + (this.status != null ? this.status.getTranslation() : "") + (this.status != null && StringUtils.isNotBlank((CharSequence)this.notice) ? "<br>" : "") + (StringUtils.isNotBlank((CharSequence)this.notice) ? this.notice : "") + "</div></html>";
                }
                case ACTION: {
                    return this.action;
                }
            }
            return null;
        }

        public boolean isEditable(AbstractTable.Column column) {
            return super.isEditable(column) && TableColumn.ACTION.equals(column) && this.status != null && ArrayUtils.isNotEmpty((Object[])this.status.getActions());
        }

        public void setAction(ExportAction exportAction) {
            this.action = exportAction;
        }

        public void setStatus(ExportStatus exportStatus) {
            this.status = exportStatus;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (TableColumn.ACTION.equals(column)) {
                this.action = (ExportAction)((Object)object);
            }
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        ID,
        TYPE,
        ADDRESS,
        NOTICE,
        ACTION;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case ACTION: {
                    return new DefaultTableCellRenderer((Renderer)new AbstractRenderer<ExportAction>(){

                        public void render(ExportAction exportAction, JLabel jLabel) {
                            jLabel.setVerticalAlignment(1);
                            if (exportAction != null) {
                                if (ExportAction.INSERT.equals((Object)exportAction) || ExportAction.UPDATE.equals((Object)exportAction)) {
                                    jLabel.setText("<html><a href=\"#\" style=\"font-weight:bold; color:#008000;\">" + exportAction.getTranslation() + "</a></html>");
                                } else if (ExportAction.DELETE.equals((Object)exportAction)) {
                                    jLabel.setText("<html><a href=\"#\" style=\"font-weight:bold; color:#FF0000;\">" + exportAction.getTranslation() + "</a></html>");
                                } else if (ExportAction.IGNORE_CHANGES.equals((Object)exportAction)) {
                                    jLabel.setText("<html><a href=\"#\" style=\"font-weight:bold; color:#E16222;\">" + exportAction.getTranslation() + "</a></html>");
                                } else {
                                    jLabel.setText("<html><a href=\"#\">" + exportAction.getTranslation() + "</a></html>");
                                }
                            } else {
                                jLabel.setText("");
                            }
                        }
                    });
                }
                case NOTICE: {
                    return new DefaultTableCellRenderer<String>((Renderer)new StringRenderer()){
                        private final Icon okIcon;
                        private final Icon warningIcon;
                        {
                            this.okIcon = ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16);
                            this.warningIcon = ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)16);
                        }

                        protected void init() {
                            super.init();
                            this.setVerticalAlignment(1);
                            this.setVerticalTextPosition(1);
                        }

                        public Component getRenderedComponent(JTable jTable, String string, boolean bl, boolean bl2, int n, int n2) {
                            JLabel jLabel = (JLabel)super.getRenderedComponent(jTable, (Object)string, bl, bl2, n, n2);
                            if (string != null) {
                                ExportStatus exportStatus = ((Table)((Object)jTable)).getStatusAt(n);
                                if (ExportStatus.CANT_INSERT.equals((Object)exportStatus) || ExportStatus.CANT_UPDATE.equals((Object)exportStatus)) {
                                    jLabel.setIcon(this.warningIcon);
                                } else {
                                    jLabel.setIcon(this.okIcon);
                                }
                            } else {
                                jLabel.setIcon(null);
                            }
                            return jLabel;
                        }
                    };
                }
            }
            return new DefaultTableCellRenderer<String>((Renderer)new StringRenderer()){

                protected void init() {
                    super.init();
                    this.setVerticalAlignment(1);
                    this.setVerticalTextPosition(1);
                }
            };
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return String.class;
                }
                case TYPE: {
                    return String.class;
                }
                case ADDRESS: {
                    return String.class;
                }
                case NOTICE: {
                    return String.class;
                }
                case ACTION: {
                    return ExportAction.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case ADDRESS: {
                    return StringUtils.capitalize((String)I18N.tr("address"));
                }
                case NOTICE: {
                    return StringUtils.capitalize((String)I18N.tr("notice"));
                }
                case ACTION: {
                    return StringUtils.capitalize((String)I18N.tr("action"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                case NOTICE: 
                case ID: 
                case TYPE: 
                case ADDRESS: {
                    return new AlphanumComparator();
                }
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case ACTION: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(AgencyExportDialogPanel.TABLE_ID);
        }

        protected void doShowActions(int n, int n2) {
            if (this.getSelectedRowCount() < 1) {
                return;
            }
            AbstractFormat.TransferMode transferMode = AgencyExportDialogPanel.this.getTransferMode();
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.capitalize((String)I18N.tr("select action")), (int)5));
            for (ExportAction exportAction : ExportAction.values()) {
                if (!exportAction.isSupported(transferMode)) continue;
                jPopupMenu.add((Action)((Object)new SetExportAction(exportAction, this)));
            }
            jPopupMenu.show((Component)((Object)this), n, n2);
        }

        private ExportAction getActionAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getAction() : null;
        }

        public EstateImpl getObjectAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getObject() : null;
        }

        private long getObjectIdAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getObjectId() : 0L;
        }

        private String getPublicIdAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getPublicId() : null;
        }

        private ExportStatus getStatusAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getStatus() : null;
        }

        protected void init() {
            this.setMultipleIntervalSelection();
            this.setSortable(true);
            this.setColumnControlVisible(false);
            this.setRowHeight(this.getRowHeight() * 2 - 2);
            super.init();
            this.getColumnById(TableColumn.ACTION.getColumnId()).setCellEditor((TableCellEditor)new ExportActionTableEditor());
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(TableColumn.values()));
        }

        private void setActionAt(int n, ExportAction exportAction) {
            TableRow tableRow = (TableRow)this.getRow(n);
            if (tableRow != null) {
                tableRow.setAction(exportAction);
            }
        }

        private void setStatusAt(int n, ExportStatus exportStatus) {
            TableRow tableRow = (TableRow)this.getRow(n);
            if (tableRow != null) {
                tableRow.setStatus(exportStatus);
            }
        }
    }

    private class LoadInBackgroundTask
    extends ImmoToolTask<Boolean, Void> {
        private LoadInBackgroundTask() {
            super(I18N.tr("Loading exportable properties."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            boolean bl = AbstractFormat.TransferMode.FULL.equals((Object)AgencyExportDialogPanel.this.transferMode);
            DbAgencyExport dbAgencyExport = AgencyExportDialogPanel.this.export;
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyExportDialogPanel.this.dbExtension.getExportsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyExportDialogPanel.this.dbExtension.getObjectsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyExportDialogPanel.this.dbExtension.getSearchesHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyExportDialogPanel.this.dbExtension.getLanguagesHandler();
            DbGeoHandler dbGeoHandler = AgencyExportDialogPanel.this.dbExtension.getGeoHandler();
            Connection connection = null;
            try {
                DbAgencySearch dbAgencySearch;
                connection = AgencyExportDialogPanel.this.dbDriver.getConnection();
                dbAgencyExportsHandler.loadExportSettings(connection, dbAgencyExport);
                dbAgencyExportsHandler.loadExportPublishings(connection, dbAgencyExport);
                if (dbAgencyExport.searchId < 1L) {
                    dbAgencySearch = new DbAgencySearch();
                    dbAgencySearch.item = new SearchImpl();
                    dbAgencySearch.status.add(DbAgencyObject.Status.PUBLISHED);
                } else {
                    dbAgencySearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, dbAgencyExport.searchId);
                    dbAgencySearchesHandler.loadAttribConditions(connection, dbAgencySearch);
                    dbAgencySearchesHandler.loadParameters(connection, dbAgencySearch);
                    dbAgencySearchesHandler.loadValueConditions(connection, dbAgencySearch);
                }
                Map map = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
                HashMap<Long, DbGeo> hashMap = new HashMap<Long, DbGeo>();
                for (DbGeo dbGeo : dbGeoHandler.getGeoDbs(connection)) {
                    hashMap.put(dbGeo.id, dbGeo);
                }
                long[] lArray = dbAgencyObjectsHandler.getObjectIdsForExport(connection, dbAgencyExport.id, dbAgencySearch);
                ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
                for (long dbAgencyExportPublishing : lArray) {
                    ExportStatus exportStatus;
                    ExportAction exportAction;
                    EstateImpl estateImpl = AgencyExportDialogPanel.this.pool.lookupObject(dbAgencyExportPublishing, connection, map, hashMap);
                    if (estateImpl == null) {
                        LOGGER.warn("Can't load property #" + dbAgencyExportPublishing + "!");
                        continue;
                    }
                    boolean bl2 = dbAgencyExport.publishings.containsKey(dbAgencyExportPublishing);
                    String string = null;
                    String string2 = null;
                    try {
                        Object notExportableException;
                        if (bl2 && !AgencyExportDialogPanel.this.pool.isObjectModifiedSinceLastExport(dbAgencyExportPublishing, dbAgencyExport.lastExecution)) {
                            string = dbAgencyExport.publishings.get((Object)Long.valueOf((long)dbAgencyExportPublishing)).hash;
                        }
                        if (string == null) {
                            notExportableException = estateImpl.getId();
                            String bl3 = estateImpl.getPublicId();
                            string = dbAgencyExport.format.calculateHashForObject(dbAgencyExportPublishing, estateImpl);
                            estateImpl.setId((String)notExportableException);
                            estateImpl.setPublicId(bl3);
                        }
                        if (string == null) {
                            throw new AbstractFormat.HashCalculationException("Hash value is empty for object #" + dbAgencyExportPublishing + "!");
                        }
                        AgencyExportDialogPanel.this.estateHashes.put(dbAgencyExportPublishing, string);
                        if (bl) {
                            exportAction = bl2 ? ExportAction.UPDATE : ExportAction.INSERT;
                            exportStatus = bl2 ? ExportStatus.CAN_UPDATE : ExportStatus.CAN_INSERT;
                        } else if (!bl2) {
                            exportAction = ExportAction.INSERT;
                            exportStatus = ExportStatus.CAN_INSERT;
                        } else {
                            notExportableException = dbAgencyExport.publishings.get(dbAgencyExportPublishing);
                            boolean bl3 = !string.equalsIgnoreCase(((DbAgencyExportPublishing)notExportableException).hash);
                            exportAction = bl3 ? ExportAction.UPDATE : ExportAction.KEEP_PUBLISHED;
                            exportStatus = bl3 ? ExportStatus.CAN_UPDATE : ExportStatus.UNCHANGED;
                        }
                    }
                    catch (AbstractFormat.NotExportableException hashCalculationException) {
                        LOGGER.warn("Can't export property #" + dbAgencyExportPublishing + " into format '" + dbAgencyExport.getFormatName() + "'!");
                        LOGGER.warn("> " + hashCalculationException.getLocalizedMessage(), (Throwable)hashCalculationException);
                        exportAction = !bl2 ? ExportAction.DONT_PUBLISH : ExportAction.DELETE;
                        exportStatus = bl2 ? ExportStatus.CANT_UPDATE : ExportStatus.CANT_INSERT;
                        string2 = StringUtils.trimToNull((String)hashCalculationException.getLocalizedMessage());
                    }
                    catch (AbstractFormat.HashCalculationException hashCalculationException) {
                        LOGGER.warn("Can't calculate hash value for property #" + dbAgencyExportPublishing + " in format '" + dbAgencyExport.getFormatName() + "'!");
                        LOGGER.warn("> " + hashCalculationException.getLocalizedMessage(), (Throwable)hashCalculationException);
                        exportAction = !bl2 ? ExportAction.DONT_PUBLISH : ExportAction.DELETE;
                        exportStatus = bl2 ? ExportStatus.CANT_UPDATE : ExportStatus.CANT_INSERT;
                        string2 = I18N.tr("Can't generate hash value!");
                    }
                    arrayList.add(dbAgencyExportPublishing);
                    AgencyExportDialogPanel.this.table.addRow(new TableRow(dbAgencyExportPublishing, estateImpl, exportAction, exportStatus, string2));
                }
                Object object = dbAgencyExport.publishings.keySet().iterator();
                while (object.hasNext()) {
                    Long l = (Long)object.next();
                    if (arrayList.contains(l)) continue;
                    EstateImpl estateImpl = AgencyExportDialogPanel.this.pool.lookupObject(l, connection, map, hashMap);
                    if (estateImpl != null) {
                        AgencyExportDialogPanel.this.table.addRow(new TableRow((long)l, estateImpl, ExportAction.DELETE, ExportStatus.UNMATCHED, null));
                        continue;
                    }
                    DbAgencyExportPublishing dbAgencyExportPublishing = dbAgencyExport.publishings.get(l);
                    AgencyExportDialogPanel.this.table.addRow(new TableRow(dbAgencyExportPublishing.objectId, dbAgencyExportPublishing.objectNr, ExportAction.DELETE, ExportStatus.REMOVED_LOCALLY, null));
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportDialogPanel.this.setError(I18N.tr("Can't load exportable properties!"));
            AgencyExportDialogPanel.this.loadingFinished(false);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            AgencyExportDialogPanel.this.setBusy(false);
            AgencyExportDialogPanel.this.updateLimit();
            AgencyExportDialogPanel.this.updateInfo();
            AgencyExportDialogPanel.this.table.packAll();
            AgencyExportDialogPanel.this.loadingFinished(Boolean.TRUE.equals(bl));
        }
    }
}

