/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyExportViewHistoryPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewMediaPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewPropertiesPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewSearchPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewSetupPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.extensions.ExportViewExtension;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewPanel.class);
    private DbAgencyExport currentExport = null;
    private long nextExportId = 0L;
    private long prevExportId = 0L;
    private boolean mayEditExport = false;
    private boolean mayRemoveExport = false;
    private List<ExportViewExtension> addons;
    private AgencyExportViewSetupPanel setupPanel;
    private AgencyExportViewMediaPanel mediaPanel;
    private AgencyExportViewSearchPanel searchPanel;
    private AgencyExportViewPropertiesPanel propertiesPanel;
    private AgencyExportViewHistoryPanel historyPanel;
    private NotesPanel notesPanel;
    private PermissionsTab permissionPanel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private AgencyExportViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.setupPanel = (AgencyExportViewSetupPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyExportViewSetupPanel(), (JTabbedPane)jTabbedPane);
        this.mediaPanel = (AgencyExportViewMediaPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyExportViewMediaPanel(), (JTabbedPane)jTabbedPane);
        this.searchPanel = (AgencyExportViewSearchPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyExportViewSearchPanel(), (JTabbedPane)jTabbedPane);
        this.propertiesPanel = (AgencyExportViewPropertiesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyExportViewPropertiesPanel(this.addons), (JTabbedPane)jTabbedPane);
        this.historyPanel = (AgencyExportViewHistoryPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyExportViewHistoryPanel(), (JTabbedPane)jTabbedPane);
        try {
            for (ExportViewExtension exportViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = exportViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.notesPanel = (NotesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesPanel(), (JTabbedPane)jTabbedPane);
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionPanel = (PermissionsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new PermissionsTab(), (JTabbedPane)jTabbedPane);
        }
    }

    public static AgencyExportViewPanel createTab() {
        return AgencyExportViewPanel.createTab(null);
    }

    public static AgencyExportViewPanel createTab(DbAgencyExport dbAgencyExport) {
        AgencyExportViewPanel agencyExportViewPanel = new AgencyExportViewPanel();
        agencyExportViewPanel.setExport(dbAgencyExport);
        return agencyExportViewPanel;
    }

    protected void doCopy() {
        if (this.currentExport == null || this.currentExport.id < 1L) {
            return;
        }
        if (!this.mayEditExport) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doLoadInBackground(Connection connection) {
        try {
            long[] lArray = AgencyPlugin.getDbAgencyExtension().getExportsHandler().getExportIds(connection);
            int n = ArrayUtils.indexOf((long[])lArray, (long)this.currentExport.id);
            this.prevExportId = n > 0 ? lArray[n - 1] : 0L;
            this.nextExportId = n + 1 < lArray.length ? lArray[n + 1] : 0L;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void doRefresh() {
        if (this.currentExport != null && this.currentExport.id > 0L) {
            this.setExport(this.currentExport);
            this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentExport == null || this.currentExport.id < 1L) {
            return;
        }
        if (!this.mayRemoveExport) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (AgencyExportHandler.isJobRunning(this.currentExport.id)) {
            String string = "<html>" + I18N.tr("You are currently exporting properties through this interface!") + "</html>";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove property export {0}?", (Object)("#" + this.currentExport.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        if (AgencyExportHandler.hasExportJob(this.currentExport.id)) {
            AgencyExportHandler.removeExportJob(this.currentExport.id);
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask());
    }

    protected void doHelp() {
        super.doHelp();
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentExport != null && this.currentExport.id > 0L && AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentExport != null && this.currentExport.id > 0L && this.mayRemoveExport));
        boolean bl = false;
        for (ExportViewExtension exportViewExtension : this.addons) {
            Object[] objectArray = exportViewExtension.createActionMenuItems(this.currentExport);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!bl) {
                    bl = true;
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.addSeparator();
        if (this.currentExport != null && this.currentExport.id > 0L) {
            jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportObjectsAction(this.currentExport.id)));
        }
        jPopupMenu.add((Action)this.notesPanel.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        long l;
        if (!this.mayEditExport) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        long l2 = l = this.currentExport != null ? this.currentExport.id : 0L;
        if (l > 0L && AgencyExportHandler.isJobRunning(l)) {
            String string = "<html><b>" + I18N.tr("You are currently exporting properties through this interface!") + "</b><br>" + I18N.tr("Do you want cancel the running export process in order to save the interface?") + "</html>";
            if (!ImmoToolUtils.showQuestionDialog((String)string, (Component)((Object)this))) {
                return;
            }
            AgencyExportHandler.removeExportJob(l);
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextExportId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyExportViewTask(ImmoToolProject.getAppDbDriver(), this.nextExportId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevExportId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyExportViewTask(ImmoToolProject.getAppDbDriver(), this.prevExportId, this));
        }
    }

    public long getCurrentExportId() {
        return this.currentExport != null ? this.currentExport.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32);
    }

    protected String getHeaderTitle() {
        if (this.currentExport == null || this.currentExport.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("property export")) + " (" + I18N.tr("new") + ")";
        }
        return StringUtils.capitalize((String)I18N.tr("property export")) + " #" + this.currentExport.id;
    }

    public String getTabTitle() {
        if (this.currentExport == null || this.currentExport.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("property export")) + " (" + I18N.tr("new") + ")";
        }
        return StringUtils.capitalize((String)I18N.tr("property export")) + " #" + this.currentExport.id;
    }

    public String getTabToolTipText() {
        if (this.currentExport == null || this.currentExport.id < 1L) {
            return I18N.tr("Create a new property export.");
        }
        return I18N.tr("Edit property export {0}.", (Object)('\"' + StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)this.currentExport.name), (int)50) + '\"'));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<ExportViewExtension>();
        try {
            this.addons.addAll(AgencyPluginUtils.getExportViewExtensions());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return this.currentExport != null && this.currentExport.id > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        boolean bl2 = this.currentExport == null || this.currentExport.id < 1L;
        this.submitAction.setEnabled(bl && this.mayEditExport);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && !bl2 && this.nextExportId > 0L);
        this.viewPrevAction.setEnabled(bl && !bl2 && this.prevExportId > 0L);
    }

    public void setExport(DbAgencyExport dbAgencyExport) {
        this.currentExport = dbAgencyExport != null ? dbAgencyExport : new DbAgencyExport();
        this.nextExportId = 0L;
        this.prevExportId = 0L;
        this.mayEditExport = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT);
        this.mayRemoveExport = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_REMOVE);
        if (this.currentExport.permission != null) {
            AbstractMainViewTab[] abstractMainViewTabArray = ImmoToolProject.getAppUser();
            this.mayEditExport = this.mayEditExport && this.currentExport.permission.canWrite((DbUser)abstractMainViewTabArray, this.currentExport.ownerUserId, this.currentExport.ownerGroupId);
            this.mayRemoveExport = this.mayRemoveExport && this.currentExport.permission.canDelete((DbUser)abstractMainViewTabArray, this.currentExport.ownerUserId, this.currentExport.ownerGroupId);
        }
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentExport);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    protected void updateFormat(AbstractFormat abstractFormat) {
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            if (!(abstractMainViewTab instanceof AbstractTab) || abstractMainViewTab == this.setupPanel) continue;
            ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
            ((AbstractTab)abstractMainViewTab).updateFormat(abstractFormat);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbAgencyExport, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyExport doInBackground() throws Exception {
            DbAgencyExport dbAgencyExport;
            DbAgencyExport dbAgencyExport2;
            Connection connection;
            DbAgencyExportsHandler dbAgencyExportsHandler;
            ImmoToolProject immoToolProject;
            block9: {
                String object;
                immoToolProject = ImmoToolProject.getAppInstance();
                if (immoToolProject == null) {
                    throw new Exception("No project loaded!");
                }
                dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
                this.warnings.clear();
                connection = null;
                if (this.saveAsCopy) {
                    ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id = 0L;
                }
                connection = immoToolProject.getDbConnection();
                if (AgencyExportViewPanel.this.currentExport == null || ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id < 1L) {
                    dbAgencyExport2 = new DbAgencyExport();
                } else {
                    dbAgencyExport2 = dbAgencyExportsHandler.getExport(connection, ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id);
                    dbAgencyExportsHandler.loadExportSettings(connection, dbAgencyExport2);
                }
                if (dbAgencyExport2.id <= 0L || !dbAgencyExport2.isLockedByAnotherProcess() || ImmoToolUtils.showQuestionDialog((String)(object = "<html><b>" + I18N.tr("An export was started through this interface!") + "</b><br>" + I18N.tr("Maybe the last export did not finish successfully or another user started the export process.") + "<br>" + I18N.tr("Do you want to continue to save the interface nevertheless?") + "</html>"), (Component)((Object)AgencyExportViewPanel.this))) break block9;
                DbAgencyExport dbAgencyExport3 = null;
                JdbcUtils.closeQuietly((Connection)connection);
                return dbAgencyExport3;
            }
            try {
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbAgencyExport2);
                }
                dbAgencyExport2.lockTime = null;
                dbAgencyExportsHandler.saveExport(connection, dbAgencyExport2, true, false);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, immoToolProject, dbAgencyExport2);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                dbAgencyExport = dbAgencyExport2;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return dbAgencyExport;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save property export!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyExportViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbAgencyExport dbAgencyExport) {
            super.succeeded((Object)dbAgencyExport);
            if (dbAgencyExport == null) {
                return;
            }
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            AgencyExportViewPanel.this.setExport(dbAgencyExport);
            AgencyExportViewPanel.this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                Object object;
                connection = ImmoToolProject.getAppDbConnection();
                DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id);
                if (dbAgencyExport == null) {
                    throw new Exception("Can't find interface #" + ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id + "!");
                }
                if (dbAgencyExport.isLocked() && !ImmoToolUtils.showQuestionDialog((String)(object = "<html><b>" + I18N.tr("An export was started through this interface!") + "</b><br>" + I18N.tr("Maybe the last export did not finish successfully or another user started the export process.") + "<br>" + I18N.tr("Do you want to continue to remove the interface nevertheless?") + "</html>"), (Component)((Object)AgencyExportViewPanel.this))) {
                    Boolean bl = false;
                    return bl;
                }
                dbAgencyExportsHandler.removeExport(connection, ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id);
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete property export!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyExportViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)AgencyExportViewPanel.this), (boolean)true);
        }
    }

    private final class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;
        private boolean loaded = false;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            DbExtension dbExtension = immoToolProject.getDbExtension();
            DbUser dbUser = immoToolProject.getUser();
            this.loaded = false;
            try {
                if (AgencyExportViewPanel.this.currentExport != null && ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.id > 0L) {
                    this.form.setPermission(((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.ownerUserId, ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.ownerGroupId, ((AgencyExportViewPanel)AgencyExportViewPanel.this).currentExport.permission);
                } else {
                    this.form.setPermission(dbUser.id, 0L, null);
                }
                this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
                this.loaded = true;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load permissions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbAgencyExport dbAgencyExport) {
            this.loaded = false;
            this.form.setPermission(0L, 0L, null);
        }

        @Override
        public void save(DbAgencyExport dbAgencyExport) {
            DbGroup dbGroup;
            dbAgencyExport.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbAgencyExport.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbAgencyExport.ownerGroupId = dbGroup.id;
            }
        }
    }

    private final class NotesPanel
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbAgencyExport dbAgencyExport) {
            this.notesField.setText(dbAgencyExport != null ? StringUtils.trimToEmpty((String)dbAgencyExport.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbAgencyExport dbAgencyExport) {
            dbAgencyExport.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the property export")));
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<AgencyExportViewPanel> viewPanel = null;
        private List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public AgencyExportViewPanel getViewPanel() {
            return this.viewPanel != null ? (AgencyExportViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbAgencyExport var1) throws Exception;

        public abstract void save(DbAgencyExport var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyExport dbAgencyExport) throws SQLException, IOException {
        }

        public void setViewPanel(AgencyExportViewPanel agencyExportViewPanel) {
            this.viewPanel = agencyExportViewPanel != null ? new WeakReference<AgencyExportViewPanel>(agencyExportViewPanel) : null;
        }

        protected void updateFormat(AbstractFormat abstractFormat) {
        }
    }
}

