/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.extensions.ExportViewExtension;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.utils.AlphanumComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportViewPropertiesPanel
extends AgencyExportViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewPropertiesPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewPropertiesPanel.class);
    private static final String PROPERTIES_TABLE_ID = "AgencyExportViewPropertiesPanel.PublishingsTable";
    private DbAgencyExport currentExport = null;
    private boolean mayEditExport = false;
    private JXTitledSeparator title;
    private JTabbedPane tabPanel;
    private PublishingsTab publishingsTab;

    public AgencyExportViewPropertiesPanel(List<ExportViewExtension> list) {
        this.build(list);
    }

    private void build(List<ExportViewExtension> list) {
        this.title = ImmoToolUtils.createHead2Separator((String)"");
        this.tabPanel = new JTabbedPane();
        this.tabPanel.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component instanceof AgencyExportViewPanel.AbstractTab) {
                    ((AgencyExportViewPanel.AbstractTab)((Object)component)).setViewPanel(AgencyExportViewPropertiesPanel.this.getViewPanel());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component instanceof AgencyExportViewPanel.AbstractTab) {
                    ((AgencyExportViewPanel.AbstractTab)((Object)component)).setViewPanel(null);
                }
            }
        });
        this.publishingsTab = (PublishingsTab)ImmoToolUtils.addTab((AbstractTab)new PublishingsTab(), (JTabbedPane)this.tabPanel);
        for (ExportViewExtension exportViewExtension : list) {
            try {
                AgencyExportViewPanel.AbstractTab[] abstractTabArray = exportViewExtension.createPropertyTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AgencyExportViewPanel.AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((AbstractTab)abstractTab, (JTabbedPane)this.tabPanel);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load addon-tabs");
                LOGGER.warn("> for " + exportViewExtension.getClass().getName());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.title, "North");
        this.add(this.tabPanel, "Center");
        this.updateLocalization();
    }

    public void doLoadInBackground(Connection connection) throws Exception {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null || !abstractTab.isLoadedInBackground()) continue;
            abstractTab.doLoadInBackground(connection);
        }
    }

    private void doPublishingRemove() {
        if (!this.mayEditExport) {
            return;
        }
        if (this.publishingsTab.table.getSelectedRowCount() < 1) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected publications?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.publishingsTab.table.getSelectedRows()) {
            int n2 = this.publishingsTab.table.convertRowIndexToModel(n);
            Long l = this.publishingsTab.table.getObjectIdAt(n2);
            this.publishingsTab.removedPublishings.add(l);
            arrayList.add(l);
        }
        for (int i = this.publishingsTab.table.getRowCount() - 1; i >= 0; --i) {
            int n = this.publishingsTab.table.convertRowIndexToModel(i);
            Long l = this.publishingsTab.table.getObjectIdAt(n);
            if (!arrayList.contains(l)) continue;
            this.publishingsTab.table.removeRow(n);
        }
        this.publishingsTab.updateLocalization();
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("properties"));
    }

    public boolean isLoadedInBackground() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null || !abstractTab.isLoadedInBackground()) continue;
            return true;
        }
        return false;
    }

    public boolean isTabEnabled() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null || abstractTab.isTabEnabled()) continue;
            return false;
        }
        return true;
    }

    public boolean isTabValid() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null || abstractTab.isTabValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport) throws Exception {
        this.currentExport = dbAgencyExport;
        this.mayEditExport = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT);
        if (this.currentExport.permission != null) {
            DbUser dbUser = ImmoToolProject.getAppUser();
            this.mayEditExport = this.mayEditExport && this.currentExport.permission.canWrite(dbUser, this.currentExport.ownerUserId, this.currentExport.ownerGroupId);
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null) continue;
            abstractTab.load(dbAgencyExport);
        }
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport) throws Exception {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null) continue;
            abstractTab.save(dbAgencyExport);
        }
    }

    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyExport dbAgencyExport) throws SQLException, IOException {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null) continue;
            abstractTab.saveFinished(connection, immoToolProject, dbAgencyExport);
        }
    }

    @Override
    public void setViewPanel(AgencyExportViewPanel agencyExportViewPanel) {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyExportViewPanel.AbstractTab abstractTab = (AgencyExportViewPanel.AbstractTab)((Object)this.tabPanel.getComponentAt(i));
            if (abstractTab == null) continue;
            abstractTab.setViewPanel(agencyExportViewPanel);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.title.setTitle(StringUtils.capitalize((String)I18N.tr("exported properties")));
    }

    private class PublishingRemoveAction
    extends AbstractI18nAction {
        private PublishingRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyExportViewPropertiesPanel.this.mayEditExport);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportViewPropertiesPanel.this.doPublishingRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected publications."));
        }
    }

    private static class PublishingsTableRow
    extends AbstractTable.Row {
        private final long objectId;
        private final String publicId;
        private final String title;

        private PublishingsTableRow(DbObject dbObject) {
            this(dbObject.id, dbObject.item.getPublicId(), (String)StringUtils.defaultIfBlank((CharSequence)dbObject.item.getTitle(Locale.getDefault()), (CharSequence)dbObject.item.getFallbackTitle(Locale.getDefault())));
        }

        private PublishingsTableRow(long l, String string, String string2) {
            this.objectId = l;
            this.publicId = string;
            this.title = string2;
        }

        public long getObjectId() {
            return this.objectId;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getTitle() {
            return this.title;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof PublishingsTableColumn) {
                return this.getValueForPublishing((PublishingsTableColumn)column);
            }
            return null;
        }

        private Object getValueForPublishing(PublishingsTableColumn publishingsTableColumn) {
            switch (publishingsTableColumn) {
                case ID: {
                    return this.objectId;
                }
                case NR: {
                    return StringUtils.trimToEmpty((String)this.publicId);
                }
                case TITLE: {
                    return this.title;
                }
            }
            return null;
        }
    }

    private static enum PublishingsTableColumn implements AbstractTable.Column
    {
        ID,
        NR,
        TITLE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                default: 
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case NR: 
                case TITLE: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case NR: {
                    return StringUtils.capitalize((String)I18N.tr("nr"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("title"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                case NR: {
                    return new AlphanumComparator();
                }
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }

    private final class PublishingsTable
    extends AbstractTable<PublishingsTableRow, AbstractTable.Model<PublishingsTableRow>> {
        private PublishingsTable() {
            super(AgencyExportViewPropertiesPanel.PROPERTIES_TABLE_ID);
        }

        protected void doRemove() {
            AgencyExportViewPropertiesPanel.this.doPublishingRemove();
        }

        protected void doSelect() {
            AgencyExportViewPropertiesPanel.this.publishingsTab.removeAction.setEnabled(AgencyExportViewPropertiesPanel.this.mayEditExport && this.getSelectedRowCount() > 0);
        }

        protected void doView() {
            if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
                return;
            }
            int n = this.getSelectedRow();
            if (n < 0) {
                return;
            }
            long l = this.getObjectIdAt(n = this.convertRowIndexToModel(n));
            if (l < 1L) {
                return;
            }
            new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
        }

        private long getObjectIdAt(int n) {
            PublishingsTableRow publishingsTableRow = (PublishingsTableRow)this.getRow(n);
            return publishingsTableRow != null ? publishingsTableRow.getObjectId() : 0L;
        }

        public String getPublicIdAt(int n) {
            PublishingsTableRow publishingsTableRow = (PublishingsTableRow)this.getRow(n);
            return publishingsTableRow != null ? publishingsTableRow.getPublicId() : null;
        }

        public String getTitleAt(int n) {
            PublishingsTableRow publishingsTableRow = (PublishingsTableRow)this.getRow(n);
            return publishingsTableRow != null ? publishingsTableRow.getTitle() : null;
        }

        protected void init() {
            this.setSortable(true);
            this.setColumnControlVisible(true);
            super.init();
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(PublishingsTableColumn.values()));
        }
    }

    private final class PublishingsTab
    extends AgencyExportViewPanel.AbstractTab {
        private List<Long> removedPublishings = new ArrayList<Long>();
        private JXTitledSeparator title;
        private PublishingsTable table;
        private PublishingRemoveAction removeAction;

        private PublishingsTab() {
            this.build();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.removeAction = new PublishingRemoveAction();
            this.removeAction.setEnabled(false);
            this.table = new PublishingsTable();
            ImmoToolUtils.configureTable((JXTable)this.table);
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(5, 5));
            this.add(ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (Action[])new Action[]{this.removeAction}), "North");
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) throws Exception {
            AbstractTable.Model model = this.table.newModel();
            try {
                DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
                DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
                DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
                dbAgencyExportsHandler.loadExportPublishings(connection, AgencyExportViewPropertiesPanel.this.currentExport);
                Set<Long> set = ((AgencyExportViewPropertiesPanel)AgencyExportViewPropertiesPanel.this).currentExport.publishings.keySet();
                long[] lArray = ArrayUtils.toPrimitive((Long[])set.toArray(new Long[0]));
                DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, lArray);
                dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, dbLanguagesHandler);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (DbObject dbObject : dbObjectArray) {
                    model.addRow((AbstractTable.Row)new PublishingsTableRow(dbObject));
                    arrayList.add(dbObject.id);
                }
                for (Long l : set) {
                    DbAgencyExportPublishing dbAgencyExportPublishing;
                    if (arrayList.contains(l) || (dbAgencyExportPublishing = ((AgencyExportViewPropertiesPanel)AgencyExportViewPropertiesPanel.this).currentExport.publishings.get(l)) == null) continue;
                    model.addRow((AbstractTable.Row)new PublishingsTableRow(dbAgencyExportPublishing.objectId, dbAgencyExportPublishing.objectNr, null));
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(model){
                    final /* synthetic */ AbstractTable.Model val$publishingsModel;
                    {
                        this.val$publishingsModel = model;
                    }

                    @Override
                    public void run() {
                        try {
                            PublishingsTab.this.table.setAutoCreateColumnsFromModel(false);
                            PublishingsTab.this.table.setModel((TableModel)this.val$publishingsModel);
                        }
                        finally {
                            PublishingsTab.this.table.setEnabled(true);
                            PublishingsTab.this.updateLocalization();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("publications"));
        }

        public boolean isLoadedInBackground() {
            return AgencyExportViewPropertiesPanel.this.currentExport != null && ((AgencyExportViewPropertiesPanel)AgencyExportViewPropertiesPanel.this).currentExport.id > 0L;
        }

        @Override
        public void load(DbAgencyExport dbAgencyExport) {
            this.removedPublishings.clear();
            this.table.clearRows();
            this.table.setEnabled(false);
            this.removeAction.setEnabled(false);
        }

        @Override
        public void save(DbAgencyExport dbAgencyExport) {
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyExport dbAgencyExport) throws SQLException {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            if (this.removedPublishings != null && !this.removedPublishings.isEmpty()) {
                Long[] longArray = this.removedPublishings.toArray(new Long[0]);
                dbAgencyExportsHandler.removeExportPublishings(connection, dbAgencyExport.id, ArrayUtils.toPrimitive((Long[])longArray));
                dbAgencyExportsHandler.loadExportPublishings(connection, dbAgencyExport);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            String string = StringUtils.capitalize((String)I18N.tr("currently published properties"));
            int n = this.table.getRowCount();
            if (n > 0) {
                string = string + " / " + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)NumberFormat.getIntegerInstance().format(n));
            }
            this.title.setTitle(string);
        }
    }
}

