/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.MultiVersionSupport;
import com.openindex.openestate.tool.agency.gui.ExportFormatRenderer;
import com.openindex.openestate.tool.agency.gui.ExportTransferModeRenderer;
import com.openindex.openestate.tool.agency.gui.ExportTransportRenderer;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.StringRenderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.FormatterRule;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportViewSetupPanel
extends AgencyExportViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewSetupPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewSetupPanel.class);
    private final Map<String, FormatTab> formatTabs = new HashMap<String, FormatTab>();
    private final Map<String, TransportTab> transportTabs = new HashMap<String, TransportTab>();
    private ValidationHandler validationHandler;
    private ModificationHandler modifications;
    private JXTitledSeparator generalTitle;
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel formatLabel;
    private JComboBox<AbstractFormat> formatField;
    private JComboBox<String> formatVersionField;
    private JLabel transportLabel;
    private JComboBox<AbstractTransport> transportField;
    private JLabel transferModeLabel;
    private JComboBox<AbstractFormat.TransferMode> transferModeField;
    private JLabel publishAddressLabel;
    private JComboBox<PublishingMode> publishAddressField;
    private JLabel publishPricesLabel;
    private JComboBox<PublishingMode> publishPricesField;
    private JLabel limitLabel;
    private JFormattedTextField limitField;
    private JCheckBox limitBox;
    private JCheckBox enabledBox;
    private JTabbedPane tabbedPane;
    private FormatTab currentFormatTab;
    private TransportTab currentTransportTab;

    public AgencyExportViewSetupPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.generalTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.titleLabel = new JLabel();
        this.titleField = new JTextField();
        this.formatLabel = new JLabel();
        this.formatField = new JComboBox();
        this.formatField.setRenderer((ListCellRenderer<AbstractFormat>)new DefaultListCellRenderer((Renderer)new ExportFormatRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select format") + " ]";
            }
        }));
        this.formatField.setPrototypeDisplayValue(null);
        this.formatField.addItem(null);
        TreeMap<String, AbstractFormat> treeMap = new TreeMap<String, AbstractFormat>();
        for (AbstractFormat abstractFormat : AbstractFormat.getFormats().values()) {
            String string = StringUtils.trimToNull((String)abstractFormat.getTitle());
            if (string == null || treeMap.containsKey(string)) continue;
            treeMap.put(string, abstractFormat);
        }
        for (AbstractFormat abstractFormat : treeMap.values()) {
            abstractFormat.initDefaults();
            this.formatField.addItem(abstractFormat);
        }
        this.formatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExportViewSetupPanel.this.formatField.isEnabled()) {
                    return;
                }
                AgencyExportViewSetupPanel.this.updateFormatVersionField();
                AgencyExportViewSetupPanel.this.updateTransportField(true);
                AgencyExportViewSetupPanel.this.updateTransferModeField(true);
                AgencyExportViewSetupPanel.this.updateTabs();
                AgencyExportViewSetupPanel.this.getViewPanel().updateFormat(AgencyExportViewSetupPanel.this.getSelectedFormat());
            }
        });
        this.formatVersionField = new JComboBox();
        this.formatVersionField.setRenderer((ListCellRenderer<String>)new DefaultListCellRenderer((Renderer)new StringRenderer(){

            public String getEmptyText() {
                return I18N.tr("latest version");
            }
        }));
        this.formatVersionField.setPrototypeDisplayValue(null);
        this.transportLabel = new JLabel();
        this.transportField = new JComboBox();
        this.transportField.setEnabled(false);
        this.transportField.setRenderer((ListCellRenderer<AbstractTransport>)new DefaultListCellRenderer((Renderer)new ExportTransportRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select transport") + " ]";
            }
        }));
        this.transportField.setPrototypeDisplayValue(null);
        this.transportField.addItem(null);
        this.transportField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExportViewSetupPanel.this.transportField.isEnabled()) {
                    return;
                }
                AgencyExportViewSetupPanel.this.updateTabs();
            }
        });
        this.transferModeLabel = new JLabel();
        this.transferModeField = new JComboBox();
        this.transferModeField.setEnabled(false);
        this.transferModeField.setRenderer((ListCellRenderer<AbstractFormat.TransferMode>)new DefaultListCellRenderer((Renderer)new ExportTransferModeRenderer(true){

            public String getEmptyText() {
                return "[ " + I18N.tr("select mode") + " ]";
            }
        }));
        this.transferModeField.setPrototypeDisplayValue(null);
        this.transferModeField.addItem(null);
        for (Iterator<AbstractFormat> iterator : AbstractFormat.TransferMode.values()) {
            this.transferModeField.addItem((AbstractFormat.TransferMode)((Object)iterator));
        }
        this.limitLabel = new JLabel();
        this.limitField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.limitField.setEnabled(false);
        this.limitBox = new JCheckBox();
        this.limitBox.setSelected(true);
        this.limitBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExportViewSetupPanel.this.limitBox.isEnabled()) {
                    return;
                }
                AgencyExportViewSetupPanel.this.limitField.setEnabled(!AgencyExportViewSetupPanel.this.limitBox.isSelected());
                AgencyExportViewSetupPanel.this.validationHandler.validate((JComponent)AgencyExportViewSetupPanel.this.limitField);
            }
        });
        this.enabledBox = new JCheckBox();
        this.enabledBox.setSelected(true);
        this.publishAddressLabel = new JLabel();
        this.publishAddressField = new JComboBox();
        this.publishAddressField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.publishAddressField.addItem(PublishingMode.DEFAULT);
        this.publishAddressField.addItem(PublishingMode.NEVER);
        this.publishAddressField.addItem(PublishingMode.ALWAYS);
        this.publishAddressField.setPrototypeDisplayValue(PublishingMode.DEFAULT);
        this.publishPricesLabel = new JLabel();
        this.publishPricesField = new JComboBox();
        this.publishPricesField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.publishPricesField.addItem(PublishingMode.DEFAULT);
        this.publishPricesField.addItem(PublishingMode.NEVER);
        this.publishPricesField.addItem(PublishingMode.ALWAYS);
        this.publishPricesField.setPrototypeDisplayValue(PublishingMode.DEFAULT);
        this.tabbedPane = new JTabbedPane();
        this.currentFormatTab = null;
        this.currentTransportTab = null;
        this.validationHandler.putRule((JComponent)this.titleField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.limitField, (ValidationRule)new FormatterRule(this.limitField));
        this.validationHandler.putRule(this.transportField, (ValidationRule)new NonEmptyComboBoxRule(this.transportField));
        this.validationHandler.putRule(this.formatField, (ValidationRule)new NonEmptyComboBoxRule(this.formatField));
        this.validationHandler.putRule(this.transferModeField, (ValidationRule)new NonEmptyComboBoxRule(this.transferModeField));
        Iterator<AbstractFormat> iterator = DefaultFormBuilder.create((String)"right:pref, 3dlu, 20dlu:grow, 3dlu, pref, 6dlu, right:pref, 3dlu, pref");
        iterator.border(Paddings.EMPTY);
        iterator.add((Component)this.generalTitle).xyw(1, iterator.nextRow(), 9);
        iterator.add(this.titleLabel).xy(1, iterator.nextRow());
        iterator.add(this.titleField).xyw(3, iterator.row(), 7);
        iterator.add(this.formatLabel).xy(1, iterator.nextRow());
        iterator.add(this.formatField).xy(3, iterator.row());
        iterator.add(this.formatVersionField).xy(5, iterator.row());
        iterator.add(this.publishAddressLabel).xy(7, iterator.row());
        iterator.add(this.publishAddressField).xy(9, iterator.row());
        iterator.add(this.transportLabel).xy(1, iterator.nextRow());
        iterator.add(this.transportField).xyw(3, iterator.row(), 3);
        iterator.add(this.publishPricesLabel).xy(7, iterator.row());
        iterator.add(this.publishPricesField).xy(9, iterator.row());
        iterator.add(this.transferModeLabel).xy(1, iterator.nextRow());
        iterator.add(this.transferModeField).xyw(3, iterator.row(), 3);
        iterator.add(this.limitLabel).xy(7, iterator.row());
        iterator.add(this.limitField).xy(9, iterator.row());
        iterator.add(this.enabledBox).xyw(3, iterator.nextRow(), 3);
        iterator.add(this.limitBox).xy(9, iterator.row());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder((Border)Paddings.DIALOG);
        jPanel.add((Component)iterator.getPanel(), "North");
        jPanel.add((Component)this.tabbedPane, "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(Paddings.EMPTY);
        this.add(jPanel, "Center");
        this.updateLocalization();
        this.updateTabs();
    }

    private AbstractFormat getSelectedFormat() {
        return (AbstractFormat)this.formatField.getSelectedItem();
    }

    private AbstractFormat.TransferMode getSelectedTransferMode() {
        return (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
    }

    private AbstractTransport getSelectedTransport() {
        return (AbstractTransport)this.transportField.getSelectedItem();
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("general"));
    }

    public boolean isTabModified() {
        return this.modifications.isModified();
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid() && this.currentFormatTab != null && this.currentFormatTab.isTabValid() && this.currentTransportTab != null && this.currentTransportTab.isTabValid();
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DbAgencyExport dbAgencyExport) {
        Object object;
        int n;
        AbstractTransport abstractTransport;
        AbstractFormat abstractFormat;
        block25: {
            block24: {
                abstractFormat = dbAgencyExport.getFormat();
                abstractTransport = dbAgencyExport.getTransport();
                this.formatTabs.clear();
                this.transportTabs.clear();
                this.titleField.setText(StringUtils.trimToEmpty((String)dbAgencyExport.name));
                this.enabledBox.setSelected(dbAgencyExport.enabled);
                this.limitBox.setSelected(dbAgencyExport.limit < 1);
                this.limitField.setEnabled(!this.limitBox.isSelected());
                this.limitField.setValue(this.limitField.isEnabled() ? Integer.valueOf(dbAgencyExport.limit) : null);
                this.publishAddressField.setSelectedItem((Object)(abstractFormat != null ? abstractFormat.getPropertyAddressPublication() : PublishingMode.DEFAULT));
                this.publishPricesField.setSelectedItem((Object)(abstractFormat != null ? abstractFormat.getPropertyPricePublication() : PublishingMode.DEFAULT));
                this.formatField.setEnabled(false);
                try {
                    if (abstractFormat == null) {
                        this.formatField.setSelectedItem(null);
                        break block24;
                    }
                    for (n = 0; n < this.formatField.getItemCount(); ++n) {
                        object = this.formatField.getItemAt(n);
                        if (object == null || !((AbstractFormat)object).getName().equals(abstractFormat.getName())) continue;
                        this.formatField.setSelectedIndex(n);
                        break;
                    }
                }
                finally {
                    this.updateFormatVersionField();
                    this.updateTransportField(false);
                    this.updateTransferModeField(false);
                    this.formatField.setEnabled(true);
                }
            }
            if (abstractFormat instanceof MultiVersionSupport) {
                MultiVersionSupport multiVersionSupport = (MultiVersionSupport)((Object)abstractFormat);
                object = StringUtils.trimToNull((String)multiVersionSupport.getVersion());
                this.formatVersionField.setEnabled(false);
                this.formatVersionField.setSelectedIndex(0);
                try {
                    if (multiVersionSupport.isLatestVersion() || object == null) break block25;
                    for (int i = 0; i < this.formatVersionField.getItemCount(); ++i) {
                        String string = this.formatVersionField.getItemAt(i);
                        if (string == null || !string.equals(object)) continue;
                        this.formatVersionField.setSelectedIndex(i);
                        break;
                    }
                }
                finally {
                    this.formatVersionField.setEnabled(true);
                }
            }
        }
        this.transportField.setEnabled(false);
        try {
            if (abstractTransport == null) {
                this.transportField.setSelectedItem(null);
            } else {
                for (n = 0; n < this.transportField.getItemCount(); ++n) {
                    object = this.transportField.getItemAt(n);
                    if (object == null || !((AbstractTransport)object).getName().equals(abstractTransport.getName())) continue;
                    this.transportField.setSelectedIndex(n);
                    break;
                }
            }
            this.transportField.setEnabled(this.transportField.getItemCount() > 1);
        }
        catch (Throwable throwable) {
            this.transportField.setEnabled(this.transportField.getItemCount() > 1);
            throw throwable;
        }
        this.transferModeField.setEnabled(false);
        try {
            if (dbAgencyExport.transferMode == null) {
                this.transferModeField.setSelectedItem(null);
            } else {
                for (n = 0; n < this.transferModeField.getItemCount(); ++n) {
                    object = this.transferModeField.getItemAt(n);
                    if (!dbAgencyExport.transferMode.equals(object)) continue;
                    this.transferModeField.setSelectedIndex(n);
                    break;
                }
            }
            this.transferModeField.setEnabled(this.transferModeField.getItemCount() > 1);
        }
        catch (Throwable throwable) {
            this.transferModeField.setEnabled(this.transferModeField.getItemCount() > 1);
            throw throwable;
        }
        this.updateTabs();
        if (abstractFormat != null && this.currentFormatTab != null) {
            this.currentFormatTab.format.clear();
            this.currentFormatTab.format.putAll(abstractFormat);
            this.currentFormatTab.form.load(dbAgencyExport, this.currentFormatTab.format);
        }
        if (abstractTransport != null && this.currentTransportTab != null) {
            this.currentTransportTab.transport.clear();
            this.currentTransportTab.transport.putAll(abstractTransport);
            this.currentTransportTab.form.load(dbAgencyExport, this.currentTransportTab.transport);
        }
        if (dbAgencyExport.id > 0L) {
            this.validationHandler.validate();
        } else {
            this.validationHandler.init();
        }
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport) {
        AbstractFormat abstractFormat;
        AbstractTransport abstractTransport;
        dbAgencyExport.name = this.titleField.getText().trim();
        dbAgencyExport.enabled = this.enabledBox.isSelected();
        dbAgencyExport.limit = !this.limitBox.isSelected() ? ((Number)this.limitField.getValue()).intValue() : 0;
        dbAgencyExport.transferMode = (AbstractFormat.TransferMode)((Object)this.transferModeField.getSelectedItem());
        AbstractTransport abstractTransport2 = abstractTransport = this.currentTransportTab != null ? this.currentTransportTab.transport : null;
        if (abstractTransport != null) {
            this.currentTransportTab.form.save(dbAgencyExport, abstractTransport);
            dbAgencyExport.setTransport(abstractTransport.getName());
            dbAgencyExport.getTransport().putAll(abstractTransport);
        }
        AbstractFormat abstractFormat2 = abstractFormat = this.currentFormatTab != null ? this.currentFormatTab.format : null;
        if (abstractFormat != null) {
            this.currentFormatTab.form.save(dbAgencyExport, abstractFormat);
            abstractFormat.setPropertyAddressPublication((PublishingMode)((Object)this.publishAddressField.getSelectedItem()));
            abstractFormat.setPropertyPricePublication((PublishingMode)((Object)this.publishPricesField.getSelectedItem()));
            if (abstractFormat instanceof MultiVersionSupport) {
                MultiVersionSupport multiVersionSupport = (MultiVersionSupport)((Object)abstractFormat);
                if (this.formatVersionField.getSelectedIndex() < 1) {
                    multiVersionSupport.setLatestVersion();
                } else {
                    multiVersionSupport.setVersion((String)this.formatVersionField.getSelectedItem());
                }
            }
            dbAgencyExport.setFormat(abstractFormat.getName());
            dbAgencyExport.getFormat().putAll(abstractFormat);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.generalTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general settings")));
        this.titleLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.titleField.setToolTipText(I18N.tr("Please enter a name for the interface, that you can easily remember at a later stage."));
        this.transportLabel.setText(StringUtils.capitalize((String)I18N.tr("transport")) + ":");
        this.transportField.setToolTipText(I18N.tr("Please select a method, how the generated files should be transported."));
        this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
        this.formatField.setToolTipText(I18N.tr("Please select a format, that should be send to the recipient."));
        this.formatVersionField.setToolTipText(I18N.tr("Select the version of the exported file."));
        this.transferModeLabel.setText(StringUtils.capitalize((String)I18N.tr("mode")) + ":");
        this.transferModeField.setToolTipText(I18N.tr("You can select between a full transfer and an incremental transfer of your properties."));
        this.publishAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("addresses")) + ":");
        this.publishAddressField.setToolTipText(I18N.tr("Please select, if property addresses should be sent to the recipient."));
        this.publishPricesLabel.setText(StringUtils.capitalize((String)I18N.tr("prices")) + ":");
        this.publishPricesField.setToolTipText(I18N.tr("Please select, if property prices should be sent to the recipient."));
        this.limitLabel.setText(StringUtils.capitalize((String)I18N.tr("limit")) + ":");
        this.limitField.setToolTipText(I18N.tr("Please select, how many properties should be published at maximum through this interface."));
        this.limitBox.setText(I18N.tr("Export without limitation."));
        this.limitBox.setToolTipText(I18N.tr("Enable this option to export an unlimited number of properties through this interface."));
        this.enabledBox.setText(I18N.tr("Enable interface."));
        this.enabledBox.setToolTipText(I18N.tr("Enable this this interface by default for further exports."));
    }

    private void updateFormatVersionField() {
        String string;
        this.formatVersionField.setEnabled(false);
        this.formatVersionField.removeAllItems();
        AbstractFormat abstractFormat = this.getSelectedFormat();
        if (abstractFormat instanceof MultiVersionSupport) {
            String[] stringArray;
            MultiVersionSupport multiVersionSupport = (MultiVersionSupport)((Object)abstractFormat);
            this.formatVersionField.addItem(null);
            for (String string2 : stringArray = multiVersionSupport.getVersions()) {
                this.formatVersionField.addItem(string2);
            }
            this.formatVersionField.setSelectedIndex(0);
            this.formatVersionField.setEnabled(true);
        } else if (abstractFormat != null && (string = StringUtils.trimToNull((String)abstractFormat.getVersion())) != null) {
            this.formatVersionField.addItem(string);
            this.formatVersionField.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTabs() {
        try {
            Object object;
            int n = this.tabbedPane.getSelectedIndex();
            this.tabbedPane.removeAll();
            this.currentFormatTab = null;
            this.currentTransportTab = null;
            AbstractFormat abstractFormat = this.getSelectedFormat();
            if (abstractFormat != null) {
                object = abstractFormat.getName();
                if (this.formatTabs.containsKey(object)) {
                    this.currentFormatTab = this.formatTabs.get(object);
                } else {
                    this.currentFormatTab = new FormatTab(abstractFormat);
                    this.formatTabs.put((String)object, this.currentFormatTab);
                }
                this.currentFormatTab = (FormatTab)ImmoToolUtils.addTab((AbstractTab)this.currentFormatTab, (JTabbedPane)this.tabbedPane);
            }
            if ((object = this.getSelectedTransport()) != null) {
                String string = ((AbstractTransport)object).getName();
                if (this.transportTabs.containsKey(string)) {
                    this.currentTransportTab = this.transportTabs.get(string);
                } else {
                    this.currentTransportTab = new TransportTab((AbstractTransport)object);
                    this.transportTabs.put(string, this.currentTransportTab);
                }
                this.currentTransportTab = (TransportTab)ImmoToolUtils.addTab((AbstractTab)this.currentTransportTab, (JTabbedPane)this.tabbedPane);
            }
            this.tabbedPane.setVisible(abstractFormat != null || object != null);
            if (n > -1 && this.tabbedPane.getTabCount() > n) {
                this.tabbedPane.setSelectedIndex(n);
            }
        }
        finally {
            this.tabbedPane.revalidate();
            this.tabbedPane.repaint();
        }
    }

    private void updateTransferModeField(boolean bl) {
        AbstractFormat.TransferMode transferMode = bl ? this.getSelectedTransferMode() : null;
        this.transferModeField.setEnabled(false);
        this.transferModeField.removeAllItems();
        this.transferModeField.addItem(null);
        AbstractFormat abstractFormat = this.getSelectedFormat();
        if (abstractFormat != null) {
            for (AbstractFormat.TransferMode transferMode2 : abstractFormat.getSupportedTransferModes()) {
                this.transferModeField.addItem(transferMode2);
            }
            this.transferModeField.setSelectedItem((Object)transferMode);
        }
        this.transferModeField.setEnabled(this.transferModeField.getItemCount() > 1);
        this.validationHandler.validate(this.transferModeField);
    }

    private void updateTransportField(boolean bl) {
        AbstractTransport abstractTransport = bl ? this.getSelectedTransport() : null;
        this.transportField.setEnabled(false);
        this.transportField.removeAllItems();
        this.transportField.addItem(null);
        AbstractFormat abstractFormat = this.getSelectedFormat();
        if (abstractFormat != null) {
            for (AbstractTransport abstractTransport2 : abstractFormat.getSupportedTransports()) {
                abstractTransport2.initDefaults();
                this.transportField.addItem(abstractTransport2);
            }
            if (abstractTransport != null) {
                for (int i = 0; i < this.transportField.getItemCount(); ++i) {
                    AbstractTransport abstractTransport3 = this.transportField.getItemAt(i);
                    if (abstractTransport3 == null || !abstractTransport3.getName().equals(abstractTransport.getName())) continue;
                    this.transportField.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.transportField.setEnabled(this.transportField.getItemCount() > 1);
        this.validationHandler.validate(this.transportField);
    }

    private static class TransportTab
    extends AbstractTab {
        private AbstractTransport transport;
        private JXTitledSeparator formTitle;
        private AbstractTransportPanel form;

        private TransportTab(AbstractTransport abstractTransport) {
            this.transport = abstractTransport;
            this.form = abstractTransport.createSetupPanel();
            this.build();
            this.form.load(new DbAgencyExport(), abstractTransport);
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)this.formTitle, "North");
            jPanel.add((Component)((Object)this.form), "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("transport"));
        }

        public boolean isTabValid() {
            return this.form.isValidInput();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(this.transport.getTitle());
        }
    }

    private static class FormatTab
    extends AbstractTab {
        private AbstractFormat format;
        private JXTitledSeparator formTitle;
        private AbstractFormatPanel form;

        private FormatTab(AbstractFormat abstractFormat) {
            this.format = abstractFormat;
            this.form = abstractFormat.createSetupPanel();
            this.build();
            this.form.load(new DbAgencyExport(), abstractFormat);
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)this.formTitle, "North");
            jPanel.add((Component)((Object)this.form), "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("format"));
        }

        public boolean isTabValid() {
            return this.form.isValidInput();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(this.format.getTitle());
        }
    }
}

