/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExposeTask;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.gui.AgencyExposeRenderer;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExposeDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExposeDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExposeDialog.class);
    private static File lastSaveLocation = null;
    private static long lastSelectedExposeId = 0L;
    private final Map<DbAgencyExpose, AbstractExposePanel> exposeForms = new HashMap<DbAgencyExpose, AbstractExposePanel>();
    private final List<Long> removedSetupIds = new ArrayList<Long>();
    private ImmoToolProject project = null;
    private DbAgencyObject[] agencyObjects = null;
    private AbstractSubmitTask submitTask = null;
    private boolean submitted = false;
    private JLabel setupLabel;
    private JComboBox<DbAgencyExpose> setupBox;
    private JCheckBox saveChangesBox;
    private JXTitledSeparator setupTitleLabel;
    private JPanel setupPanel;
    private JPopupMenu setupAddMenu;
    private SetupAddAction setupAddAction;
    private SetupRemoveAction setupRemoveAction;
    private SubmitAndOpenAction submitAndOpenAction;
    private SubmitAndSaveAction submitAndSaveAction;

    private AgencyExposeDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(500, 500));
        this.setLocationRelativeTo(frame);
    }

    private AgencyExposeDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(500, 500));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAndSaveAction = new SubmitAndSaveAction();
        this.submitAndOpenAction = new SubmitAndOpenAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAndSaveAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.submitAndOpenAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.setupLabel = new JLabel();
        this.setupBox = new JComboBox();
        this.setupBox.setEditable(true);
        this.setupBox.setRenderer((ListCellRenderer<DbAgencyExpose>)new DefaultListCellRenderer((Renderer)new AgencyExposeRenderer()));
        this.setupBox.setEditor(new PdfSetupEditor());
        this.setupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExposeDialog.this.setupBox.isEnabled()) {
                    return;
                }
                AgencyExposeDialog.this.showSetupForm((DbAgencyExpose)AgencyExposeDialog.this.setupBox.getSelectedItem());
            }
        });
        this.setupAddMenu = new JPopupMenu();
        this.setupAddAction = new SetupAddAction();
        this.setupRemoveAction = new SetupRemoveAction();
        this.saveChangesBox = new JCheckBox();
        this.saveChangesBox.setOpaque(false);
        this.setupTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.setupPanel = new JPanel(new BorderLayout(5, 5));
        this.setupPanel.setOpaque(false);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, pref, 3dlu, pref");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.setupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.setupBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.setupAddAction))).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.setupRemoveAction))).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.saveChangesBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.setupTitleLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.setupPanel, "Center");
        return jPanel;
    }

    private void doSetupAdd(JComponent jComponent, int n, int n2) {
        this.setupAddMenu.show(jComponent, n, n2);
    }

    private void doSetupAdd(AbstractExpose abstractExpose) {
        int n = 0;
        for (int i = 0; i < this.setupBox.getItemCount(); ++i) {
            DbAgencyExpose dbAgencyExpose = this.setupBox.getItemAt(i);
            if (dbAgencyExpose.type == null || !dbAgencyExpose.type.equalsIgnoreCase(abstractExpose.getName())) continue;
            ++n;
        }
        DbAgencyExpose dbAgencyExpose = new DbAgencyExpose();
        dbAgencyExpose.name = abstractExpose.getTitle();
        if (n > 0) {
            dbAgencyExpose.name = dbAgencyExpose.name + " (" + (n + 1) + ")";
        }
        dbAgencyExpose.setExposeBuilder(abstractExpose);
        this.setupBox.addItem(dbAgencyExpose);
        this.setupBox.setEnabled(true);
        this.setupBox.setSelectedIndex(this.setupBox.getItemCount() - 1);
        this.updateButtons(true);
        this.showSetupForm(dbAgencyExpose);
        this.setupBox.requestFocus();
        this.setupBox.getEditor().selectAll();
    }

    private void doSetupRemove() {
        if (this.setupBox.getSelectedIndex() < 0) {
            return;
        }
        int n = this.setupBox.getSelectedIndex();
        DbAgencyExpose dbAgencyExpose = this.setupBox.getItemAt(n);
        if (dbAgencyExpose != null && dbAgencyExpose.id > 0L) {
            this.removedSetupIds.add(dbAgencyExpose.id);
        }
        this.setupBox.setEnabled(false);
        this.setupBox.removeItemAt(n);
        this.setupBox.setEnabled(true);
        while (n > 0 && n >= this.setupBox.getItemCount()) {
            --n;
        }
        this.setupBox.setSelectedIndex(n < this.setupBox.getItemCount() ? n : -1);
        this.updateButtons(true);
    }

    private void doSubmitAndOpen() {
        File file;
        if (ArrayUtils.getLength((Object)this.agencyObjects) < 1) {
            return;
        }
        ArrayList<DbAgencyExpose> arrayList = new ArrayList<DbAgencyExpose>();
        DbAgencyExpose dbAgencyExpose = this.getExposes(arrayList);
        if (dbAgencyExpose == null) {
            LOGGER.warn("No expos\u00e9 was selected!");
            return;
        }
        if (ArrayUtils.getLength((Object)this.agencyObjects) > 1) {
            file = new File(this.project.getTempDirectory().getAbsolutePath() + File.separator + "exposes" + File.separator + System.currentTimeMillis());
            if (!file.exists() && !file.mkdirs()) {
                ImmoToolUtils.showMessageErrorDialog((String)"Can't create temp directory!", (Component)((Object)this));
                return;
            }
        } else {
            file = new File(this.project.getTempDirectory().getAbsolutePath() + File.separator + "exposes" + File.separator + System.currentTimeMillis() + ".pdf");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                ImmoToolUtils.showMessageErrorDialog((String)"Can't create temp directory!", (Component)((Object)this));
                return;
            }
        }
        this.submitted = true;
        this.submitTask = new SubmitAndOpenTask(this.project, dbAgencyExpose, this.agencyObjects, file);
        if (this.isChangesAreSaved()) {
            for (Long serializable : this.removedSetupIds) {
                this.submitTask.addExposeToRemove(serializable);
            }
            for (DbAgencyExpose dbAgencyExpose2 : arrayList) {
                this.submitTask.addExposeToSave(dbAgencyExpose2);
            }
        }
        this.setVisible(false);
    }

    /*
     * WARNING - void declaration
     */
    private void doSubmitAndSave() {
        int n;
        if (ArrayUtils.getLength((Object)this.agencyObjects) < 1) {
            return;
        }
        ArrayList<DbAgencyExpose> arrayList = new ArrayList<DbAgencyExpose>();
        DbAgencyExpose dbAgencyExpose = this.getExposes(arrayList);
        if (dbAgencyExpose == null) {
            LOGGER.warn("No expos\u00e9 was selected!");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (ArrayUtils.getLength((Object)this.agencyObjects) > 1) {
            jFileChooser.setFileSelectionMode(1);
            if (lastSaveLocation != null) {
                jFileChooser.setSelectedFile(lastSaveLocation);
            }
        } else {
            void var6_9;
            DbAgencyObject dbAgencyObject = this.agencyObjects[0];
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return I18N.tr("PDF files") + " (*.pdf)";
                }
            });
            Iterator iterator = dbAgencyObject.item.getPublicId();
            if (StringUtils.isBlank((CharSequence)((Object)iterator))) {
                iterator = "ID_" + dbAgencyObject.id;
            }
            String string = dbAgencyExpose.name + "_" + (String)((Object)iterator);
            string = string.replaceAll("[^\\w\\-\\.]", "_");
            while (var6_9.contains("__")) {
                String string2 = var6_9.replace("__", "_");
            }
            if (lastSaveLocation != null) {
                jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + (String)var6_9 + ".pdf"));
            } else {
                jFileChooser.setSelectedFile(new File((String)var6_9 + ".pdf"));
            }
        }
        if ((n = jFileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        if (ArrayUtils.getLength((Object)this.agencyObjects) > 1) {
            AgencyExposeDialog.setLastSaveLocation(jFileChooser.getSelectedFile());
        } else {
            AgencyExposeDialog.setLastSaveLocation(jFileChooser.getSelectedFile().getParentFile());
        }
        this.submitted = true;
        this.submitTask = new SubmitAndSaveTask(this.project, dbAgencyExpose, this.agencyObjects, jFileChooser.getSelectedFile());
        if (this.isChangesAreSaved()) {
            for (Long l : this.removedSetupIds) {
                this.submitTask.addExposeToRemove(l);
            }
            for (DbAgencyExpose dbAgencyExpose2 : arrayList) {
                this.submitTask.addExposeToSave(dbAgencyExpose2);
            }
        }
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("create expos\u00e9"));
    }

    private DbAgencyExpose getExposes(List<DbAgencyExpose> list) {
        int n = this.setupBox.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        DbAgencyExpose dbAgencyExpose = null;
        for (int i = 0; i < this.setupBox.getItemCount(); ++i) {
            AbstractExposePanel abstractExposePanel;
            DbAgencyExpose dbAgencyExpose2 = this.setupBox.getItemAt(i);
            if (dbAgencyExpose2 == null || (abstractExposePanel = this.exposeForms.get(dbAgencyExpose2)) == null) continue;
            AbstractExpose abstractExpose = dbAgencyExpose2.createExposeBuilder();
            abstractExposePanel.save(abstractExpose);
            dbAgencyExpose2.setExposeBuilder(abstractExpose);
            dbAgencyExpose2.temporaryTemplateFile = abstractExpose.getTemporaryTemplateFile();
            dbAgencyExpose2.templateFileDisabled = !abstractExposePanel.isTemplateSelected();
            list.add(dbAgencyExpose2);
            if (i != n) continue;
            dbAgencyExpose = dbAgencyExpose2;
        }
        return dbAgencyExpose;
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_type_pdf.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("create an expos\u00e9"));
    }

    private boolean isChangesAreSaved() {
        return this.saveChangesBox.isSelected();
    }

    private void load(ImmoToolProject immoToolProject, DbAgencyExpose[] dbAgencyExposeArray, DbAgencyObject[] dbAgencyObjectArray) {
        int n;
        Object object;
        this.project = immoToolProject;
        this.removedSetupIds.clear();
        this.exposeForms.clear();
        this.agencyObjects = dbAgencyObjectArray;
        this.setupAddMenu.removeAll();
        TreeMap<String, AbstractExpose> treeMap = new TreeMap<String, AbstractExpose>();
        for (AbstractExpose dbAgencyExposeArray2 : AbstractExpose.getExposes().values()) {
            object = dbAgencyExposeArray2.getTitle().toLowerCase();
            int n2 = 0;
            while (treeMap.containsKey(object)) {
                object = dbAgencyExposeArray2.getTitle().toLowerCase() + "_" + ++n2;
            }
            treeMap.put((String)object, dbAgencyExposeArray2);
        }
        for (final AbstractExpose abstractExpose : treeMap.values()) {
            abstractExpose.initDefaults();
            object = new JMenuItem(abstractExpose.getTitle());
            this.setupAddMenu.add((JMenuItem)object);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyExposeDialog.this.doSetupAdd(abstractExpose);
                }
            });
        }
        TreeMap treeMap2 = new TreeMap();
        for (DbAgencyExpose dbAgencyExpose : dbAgencyExposeArray) {
            String string;
            String string2 = string = dbAgencyExpose.name.toLowerCase().trim();
            int n3 = 0;
            while (treeMap2.containsKey(string2)) {
                string2 = string + "_" + ++n3;
            }
            treeMap2.put(string2, dbAgencyExpose);
        }
        this.setupBox.setEnabled(false);
        this.setupBox.removeAllItems();
        this.setupBox.setSelectedIndex(-1);
        boolean bl = false;
        for (DbAgencyExpose dbAgencyExpose : treeMap2.values()) {
            this.setupBox.addItem(dbAgencyExpose);
            if (lastSelectedExposeId != dbAgencyExpose.id) continue;
            n = this.setupBox.getItemCount() - 1;
        }
        this.setupBox.setEnabled(true);
        this.setupBox.setSelectedIndex(n > 0 ? n : (this.setupBox.getItemCount() > 0 ? 0 : -1));
    }

    private static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }

    private static synchronized void setLastSelectedExposeId(long l) {
        lastSelectedExposeId = l;
    }

    public static AgencyExposeTask showDialog(ImmoToolProject immoToolProject, long l, Window window) throws SQLException {
        return l > 0L ? AgencyExposeDialog.showDialog(immoToolProject, new long[]{l}, window) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static AgencyExposeTask showDialog(ImmoToolProject immoToolProject, long[] lArray, Window window) throws SQLException {
        DbAgencyObject[] dbAgencyObjectArray;
        Object object;
        Connection connection;
        AgencyExposeDialog agencyExposeDialog;
        block8: {
            if (ArrayUtils.isEmpty((long[])lArray)) {
                return null;
            }
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencyExposesHandler dbAgencyExposesHandler = AgencyPlugin.getDbAgencyExtension().getExposeHandler();
            agencyExposeDialog = null;
            agencyExposeDialog = window instanceof Dialog ? new AgencyExposeDialog((Dialog)window) : (window instanceof Frame ? new AgencyExposeDialog((Frame)window) : new AgencyExposeDialog((Frame)null));
            connection = null;
            connection = immoToolProject.getDbConnection();
            object = dbAgencyExposesHandler.getExposes(connection);
            dbAgencyExposesHandler.loadExposeSettings(connection, (DbAgencyExpose[])object);
            Object[] objectArray = dbAgencyObjectsHandler.getObjects(connection, lArray);
            dbAgencyObjectArray = (DbAgencyObject[])ArrayUtils.addAll((Object[])new DbAgencyObject[0], (Object[])objectArray);
            if (!ArrayUtils.isEmpty((Object[])dbAgencyObjectArray)) break block8;
            AgencyExposeTask agencyExposeTask = null;
            JdbcUtils.closeQuietly((Connection)connection);
            SwingUtils.disposeRecursively((Component)((Object)agencyExposeDialog));
            return agencyExposeTask;
        }
        try {
            block9: {
                agencyExposeDialog.load(immoToolProject, (DbAgencyExpose[])object, dbAgencyObjectArray);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            }
            agencyExposeDialog.setLocationRelativeTo(window);
            agencyExposeDialog.setVisible(true);
            object = agencyExposeDialog.submitted ? agencyExposeDialog.submitTask : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(agencyExposeDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)agencyExposeDialog));
        return object;
    }

    public static AgencyExposeTask showDialog(ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject, Window window) throws SQLException {
        return dbAgencyObject != null ? AgencyExposeDialog.showDialog(immoToolProject, new DbAgencyObject[]{dbAgencyObject}, window) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyExposeTask showDialog(ImmoToolProject immoToolProject, DbAgencyObject[] dbAgencyObjectArray, Window window) throws SQLException {
        Object object;
        if (ArrayUtils.isEmpty((Object[])dbAgencyObjectArray)) {
            return null;
        }
        DbAgencyExposesHandler dbAgencyExposesHandler = AgencyPlugin.getDbAgencyExtension().getExposeHandler();
        AgencyExposeDialog agencyExposeDialog = null;
        try {
            agencyExposeDialog = window instanceof Dialog ? new AgencyExposeDialog((Dialog)window) : (window instanceof Frame ? new AgencyExposeDialog((Frame)window) : new AgencyExposeDialog((Frame)null));
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                object = dbAgencyExposesHandler.getExposes(connection);
                dbAgencyExposesHandler.loadExposeSettings(connection, (DbAgencyExpose[])object);
                agencyExposeDialog.load(immoToolProject, (DbAgencyExpose[])object, dbAgencyObjectArray);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            agencyExposeDialog.setLocationRelativeTo(window);
            agencyExposeDialog.setVisible(true);
            object = agencyExposeDialog.submitted ? agencyExposeDialog.submitTask : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(agencyExposeDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)agencyExposeDialog));
        return object;
    }

    private void showSetupForm(DbAgencyExpose dbAgencyExpose) {
        AbstractExposePanel abstractExposePanel = null;
        if (dbAgencyExpose != null) {
            if (this.exposeForms.containsKey(dbAgencyExpose)) {
                abstractExposePanel = this.exposeForms.get(dbAgencyExpose);
            } else {
                try {
                    AbstractExpose abstractExpose = dbAgencyExpose.createExposeBuilder();
                    abstractExposePanel = abstractExpose.createForm();
                    abstractExposePanel.load(abstractExpose);
                    this.exposeForms.put(dbAgencyExpose, abstractExposePanel);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load expos\u00e9 form!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        this.setupPanel.removeAll();
        if (abstractExposePanel != null) {
            this.setupPanel.add((Component)((Object)abstractExposePanel), "Center");
        }
        this.setupPanel.revalidate();
        this.setupPanel.repaint();
        this.pack();
    }

    private void updateButtons(boolean bl) {
        this.setupBox.setEnabled(bl && this.setupBox.getItemCount() > 0);
        this.setupAddAction.setEnabled(bl);
        this.setupRemoveAction.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
        this.submitAndSaveAction.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
        this.submitAndOpenAction.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.setupLabel.setText(StringUtils.capitalize((String)I18N.tr("template")) + ":");
        this.saveChangesBox.setText(I18N.tr("Save changes permanently."));
        this.setupTitleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("settings for the selected template")));
    }

    private class PdfSetupEditor
    extends JTextField
    implements ComboBoxEditor {
        private DbAgencyExpose currentSetup = null;
        private String currentName = null;

        private PdfSetupEditor() {
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    String string = PdfSetupEditor.this.getText().trim();
                    if (!string.equals(PdfSetupEditor.this.currentName)) {
                        PdfSetupEditor.this.currentSetup = (DbAgencyExpose)PdfSetupEditor.this.getItem();
                    }
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            if (object instanceof DbAgencyExpose) {
                this.currentSetup = (DbAgencyExpose)object;
                this.currentName = this.currentSetup.name;
                this.setText(this.currentName);
            } else {
                this.currentSetup = null;
                this.currentName = null;
                this.setText("");
            }
        }

        @Override
        public Object getItem() {
            if (this.currentSetup == null) {
                return null;
            }
            this.currentSetup.name = this.currentName = this.getText().trim();
            return this.currentSetup;
        }
    }

    private static class SubmitAndSaveTask
    extends AbstractSubmitTask {
        private SubmitAndSaveTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, DbAgencyObject[] dbAgencyObjectArray, File file) {
            super(immoToolProject, dbAgencyExpose, dbAgencyObjectArray, file);
        }

        private SubmitAndSaveTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, long[] lArray, File file) {
            super(immoToolProject, dbAgencyExpose, lArray, file);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't create expos\u00e9s!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(File[] fileArray) {
            super.succeeded((Object)fileArray);
            if (ArrayUtils.isEmpty((Object[])fileArray)) {
                return;
            }
            String string = "<b>" + I18N.trn("{0} expos\u00e9 was saved.", "{0} expos\u00e9s were saved.", (long)fileArray.length, (Object)fileArray.length) + "</b>";
            string = fileArray.length > 1 ? string + "<br>" + I18N.tr("into folder: {0}", (Object)StringUtils.abbreviateMiddle((String)this.outputFile.getAbsolutePath(), (String)"...", (int)75)) : string + "<br>" + I18N.tr("into file: {0}", (Object)StringUtils.abbreviateMiddle((String)this.outputFile.getAbsolutePath(), (String)"...", (int)75));
            ImmoToolUtils.showMessageInfoDialog((String)("<html>" + string + "</html>"), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private class SubmitAndSaveAction
    extends AbstractI18nAction {
        private SubmitAndSaveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_save.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExposeDialog.this.doSubmitAndSave();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save expos\u00e9")));
            this.setShortDescription(I18N.tr("Save expos\u00e9s for the selected properties to harddisk."));
        }
    }

    private static class SubmitAndOpenTask
    extends AbstractSubmitTask {
        private SubmitAndOpenTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, DbAgencyObject[] dbAgencyObjectArray, File file) {
            super(immoToolProject, dbAgencyExpose, dbAgencyObjectArray, file);
        }

        private SubmitAndOpenTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, long[] lArray, File file) {
            super(immoToolProject, dbAgencyExpose, lArray, file);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't create expos\u00e9s!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(File[] fileArray) {
            super.succeeded((Object)fileArray);
            if (ArrayUtils.isEmpty((Object[])fileArray)) {
                return;
            }
            for (File file : fileArray) {
                ImmoToolUtils.openPDF((File)file);
            }
        }
    }

    private static class AbstractSubmitTask
    extends AgencyExposeTask {
        private final List<DbAgencyExpose> exposesToSave = new ArrayList<DbAgencyExpose>();
        private final List<Long> exposesToRemove = new ArrayList<Long>();

        private AbstractSubmitTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, DbAgencyObject[] dbAgencyObjectArray, File file) {
            super(immoToolProject, dbAgencyExpose, dbAgencyObjectArray, file);
        }

        private AbstractSubmitTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, long[] lArray, File file) {
            super(immoToolProject, dbAgencyExpose, lArray, file);
        }

        private void addExposeToRemove(long l) {
            this.exposesToRemove.add(l);
        }

        private void addExposeToSave(DbAgencyExpose dbAgencyExpose) {
            this.exposesToSave.add(dbAgencyExpose);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected File[] doInBackground() throws Exception {
            DbAgencyExposesHandler dbAgencyExposesHandler = AgencyPlugin.getDbAgencyExtension().getExposeHandler();
            Connection connection = null;
            try {
                if (!this.exposesToRemove.isEmpty()) {
                    connection = this.project.getDbConnection();
                    for (Long serializable : this.exposesToRemove) {
                        dbAgencyExposesHandler.removeExpose(connection, serializable);
                    }
                }
                if (!this.exposesToSave.isEmpty()) {
                    if (connection == null) {
                        connection = this.project.getDbConnection();
                    }
                    for (DbAgencyExpose dbAgencyExpose : this.exposesToSave) {
                        dbAgencyExpose.saveToDatabase(connection, dbAgencyExposesHandler);
                    }
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            if (this.expose != null && this.expose.id > 0L) {
                AgencyExposeDialog.setLastSelectedExposeId(this.expose.id);
            }
            return super.doInBackground();
        }
    }

    private class SubmitAndOpenAction
    extends AbstractI18nAction {
        private SubmitAndOpenAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExposeDialog.this.doSubmitAndOpen();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open expos\u00e9")));
            this.setShortDescription(I18N.tr("Open the expos\u00e9s for the selected properties in your PDF reader."));
        }
    }

    private class SetupRemoveAction
    extends AbstractI18nAction {
        private SetupRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExposeDialog.this.doSetupRemove();
        }

        protected final void updateLocalization() {
            this.setName("");
            this.setShortDescription(I18N.tr("Remove the selected expos\u00e9 template."));
        }
    }

    private class SetupAddAction
    extends AbstractI18nAction {
        private SetupAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyExposeDialog.this.doSetupAdd(jButton, 0, jButton.getSize().height);
        }

        protected final void updateLocalization() {
            this.setName("");
            this.setShortDescription(I18N.tr("Add another expos\u00e9 template."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExposeDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window and cancel expos\u00e9 creation."));
        }
    }
}

