/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.extensions.FrameMenuAdapter;
import com.openindex.openestate.tool.gui.DefaultMenu;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyFrameMenuExtension
extends FrameMenuAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyFrameMenuExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyFrameMenuExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_SELECT = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ESTATE = 4;
    public static final int MENU_ADD_SEARCH = 5;
    public static final int MENU_ADD_CONTACT = 6;
    public static final int MENU_ADD_EXPORT = 7;
    public static final int MENU_ADD_END = 8;
    public static final int MENU_ESTATES = 9;
    public static final int MENU_CONTACTS = 10;
    public static final int MENU_EXPORTS = 11;
    public static final int MENU_ELSE = 12;
    public static final int MENU_ELSE_BEGIN = 13;
    public static final int MENU_ELSE_PROPERTY_LOAD = 14;
    public static final int MENU_ELSE_PROPERTY_SAVE = 15;
    public static final int MENU_ELSE_PROPERTY_ATTACHMENTS_UPDATE = 16;
    public static final int MENU_ELSE_EXPORT_CANCEL = 17;
    public static final int MENU_ELSE_EXPORT_LOAD = 18;
    public static final int MENU_ELSE_END = 19;
    public static final int MENU_END = 20;

    public JMenu createMainMenu() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = AgencyFrameMenuExtension.getAddons((ImmoToolProject)immoToolProject, ((Object)((Object)this)).getClass());
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(AgencyPlugin.getInstance().getTitle());
            }
        };
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)0, (Collection)collection);
        defaultMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.SidebarSelectAction())));
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)1, (Collection)collection);
        DefaultMenu defaultMenu2 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the agency addon."));
            }
        };
        defaultMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)3, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            defaultMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateFormAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)4, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            defaultMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.SearchDialogAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)5, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT)) {
            if (defaultMenu2.getItemCount() > 0) {
                defaultMenu2.addSeparator();
            }
            defaultMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.ContactFormAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)6, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)) {
            if (defaultMenu2.getItemCount() > 0) {
                defaultMenu2.addSeparator();
            }
            defaultMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportFormAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)7, (Collection)collection);
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)8, (Collection)collection);
        if (defaultMenu2.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu2);
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)2, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            defaultMenu.addSeparator();
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateTableAction(true))));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)9, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ContactTableAction(true))));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)10, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportTableAction(true))));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)11, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            defaultMenu.addSeparator();
        }
        DefaultMenu defaultMenu3 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
                this.setToolTipText(I18N.tr("Further actions in the agency addon."));
            }
        };
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)13, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_IMPORT)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateImportAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)14, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateSaveAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)15, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateUpdateAttachmentsAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)16, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
            defaultMenu3.addSeparator();
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportCancelAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)17, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportLoadAction())));
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)18, (Collection)collection);
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)19, (Collection)collection);
        if (defaultMenu3.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu3);
        }
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)12, (Collection)collection);
        AgencyFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)20, (Collection)collection);
        return defaultMenu;
    }
}

