/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum AgencyPermission implements ProjectPermission
{
    USE_PLUGIN(null, I18n.marktr((String)"use addon")),
    CONTACTS(USE_PLUGIN, I18n.marktr((String)"access to contact persons")),
    CONTACTS_EDIT(CONTACTS, I18n.marktr((String)"edit contact persons")),
    CONTACTS_REMOVE(CONTACTS, I18n.marktr((String)"remove contact persons")),
    PROPERTIES(USE_PLUGIN, I18n.marktr((String)"access to properties")),
    PROPERTIES_EDIT(PROPERTIES, I18n.marktr((String)"edit properties")),
    PROPERTIES_EDIT_STATUS(PROPERTIES_EDIT, I18n.marktr((String)"change status of properties")),
    PROPERTIES_EDIT_STATUS_PUBLISHING(PROPERTIES_EDIT_STATUS, I18n.marktr((String)"mark properties published")),
    PROPERTIES_EDIT_STATUS_UNPUBLISHING(PROPERTIES_EDIT_STATUS, I18n.marktr((String)"mark properties unpublished")),
    PROPERTIES_REMOVE(PROPERTIES, I18n.marktr((String)"remove properties")),
    PROPERTIES_IMPORT(PROPERTIES, I18n.marktr((String)"import properties")),
    EXPORTS(USE_PLUGIN, I18n.marktr((String)"access to export interfaces")),
    EXPORTS_EDIT(EXPORTS, I18n.marktr((String)"edit export interfaces")),
    EXPORTS_REMOVE(EXPORTS, I18n.marktr((String)"remove export interfaces")),
    EXPORTS_EXECUTE(EXPORTS, I18n.marktr((String)"execute exports")),
    BROKERINGS(USE_PLUGIN, I18n.marktr((String)"access to brokering mandates")),
    BROKERINGS_EDIT(BROKERINGS, I18n.marktr((String)"edit brokering mandates")),
    BROKERINGS_REMOVE(BROKERINGS, I18n.marktr((String)"remove brokering mandates")),
    INTERESTS(USE_PLUGIN, I18n.marktr((String)"access to search mandates")),
    INTERESTS_EDIT(INTERESTS, I18n.marktr((String)"edit search mandates")),
    INTERESTS_REMOVE(INTERESTS, I18n.marktr((String)"remove search mandates"));

    private static final Logger LOGGER;
    private static final I18n I18N;
    private final String i18nKey;
    private final ProjectPermission parent;

    private AgencyPermission(ProjectPermission projectPermission, String string2) {
        this.parent = projectPermission;
        this.i18nKey = string2;
    }

    public ProjectPermission[] getChildren() {
        ArrayList<AgencyPermission> arrayList = new ArrayList<AgencyPermission>();
        for (AgencyPermission agencyPermission : AgencyPermission.values()) {
            if (!this.equals(agencyPermission.parent)) continue;
            arrayList.add(agencyPermission);
        }
        return arrayList.toArray(new ProjectPermission[0]);
    }

    public String getKey() {
        return this.name();
    }

    public ProjectPermission getParent() {
        return this.parent;
    }

    public String getTranslation() {
        return ImmoToolUtils.getI18nString(AgencyPermission.class, (String)this.i18nKey);
    }

    public String getTranslation(Locale locale) {
        return ImmoToolUtils.getI18nString(AgencyPermission.class, (String)this.i18nKey, (Locale)locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(AgencyPermission.class);
        I18N = I18nFactory.getI18n(AgencyPermission.class);
    }
}

