/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.db.DbLanguage;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactTablePanel;
import com.openindex.openestate.tool.agency.AgencyContactViewTask;
import com.openindex.openestate.tool.agency.AgencyEstateExportCsvTask;
import com.openindex.openestate.tool.agency.AgencyEstateExportDialog;
import com.openindex.openestate.tool.agency.AgencyEstateExportXlsTask;
import com.openindex.openestate.tool.agency.AgencyEstateTablePanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyExportDialog;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyExportLogViewPanel;
import com.openindex.openestate.tool.agency.AgencyExportObjectsDialog;
import com.openindex.openestate.tool.agency.AgencyExportTablePanel;
import com.openindex.openestate.tool.agency.AgencyExportViewTask;
import com.openindex.openestate.tool.agency.AgencyFrameSidebarExtension;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.AgencySearchDialog;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbAdminHandler;
import com.openindex.openestate.tool.db.DbPlugin;
import com.openindex.openestate.tool.db.DbPluginHandler;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.LanguageExtension;
import com.openindex.openestate.tool.gui.AbstractFrame;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.java.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyPlugin.class);
    public static final String ID = "OpenEstate-Tool-Agency";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/agency/resources/";
    public static final String IMAGE_FORMAT = "JPG";
    public static final int IMAGE_PREVIEW_WIDTH = 300;
    public static final int IMAGE_PREVIEW_HEIGHT = 300;
    private static final String PARAM_IMAGE_MAX_HEIGHT = "image.max.height";
    private static final String PARAM_IMAGE_MAX_WIDTH = "image.max.width";
    private static final String PARAM_ATTRIBS_APPROX = "openestate.attribs.approx";
    public static final String APP_LAST_IMPORT_LOCATION = "agency.LastImportLocation";
    public static final String USER_FAVOURED_SEARCH_IDS = "favouredSearchIds";
    private static int imageMaxHeight = 1000;
    private static int imageMaxWidth = 1000;
    private static Locale[] locales = new Locale[0];
    private static File lastImageLocation = null;
    private static File lastExportLocation = null;
    private static DbAgencyExtension dbAgencyExtension = null;

    protected void doStart() {
    }

    protected void doStop() {
    }

    public static DbAgencyExtension getDbAgencyExtension() {
        return dbAgencyExtension;
    }

    public String getDescription() {
        return I18N.tr("Management of properties based on OpenEstate specifications.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(AgencyPlugin.getResourceImage("agent_estates.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static int getImageMaxHeight() {
        return imageMaxHeight;
    }

    public static int getImageMaxWidth() {
        return imageMaxWidth;
    }

    public static AgencyPlugin getInstance() {
        return (AgencyPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public static File getLastExportLocation() {
        return lastExportLocation;
    }

    public static File getLastImageLocation() {
        return lastImageLocation;
    }

    public static File getLastImportLocation() {
        String string = ImmoToolEnvironment.getSettings().getProperty(APP_LAST_IMPORT_LOCATION, "");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        File file = new File(string);
        return file.isDirectory() ? file : null;
    }

    public String getLicense() {
        return "Freeware";
    }

    public static Locale[] getLocales() {
        return locales != null ? (Locale[])ArrayUtils.clone((Object[])locales) : new Locale[]{};
    }

    public static Locale[] getLocalesWithLanguagePack() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (Locale locale : locales) {
            LanguageExtension languageExtension = ImmoToolEnvironment.getLanguageExtension((String)locale.getLanguage());
            Plugin plugin = ImmoToolEnvironment.getPluginManager().getPluginFor((Object)languageExtension);
            if (plugin == null) continue;
            arrayList.add(locale);
        }
        return arrayList.toArray(new Locale[0]);
    }

    public ProjectPermission[] getPermissions() {
        return AgencyPermission.values();
    }

    public String getPhpExportVersion() {
        return StringUtils.trimToNull((String)this.getProperty("PhpExportVersion"));
    }

    public String getPhpExport2Version() {
        return StringUtils.trimToNull((String)this.getProperty("PhpExport2Version"));
    }

    public String[] getRequiredProcedures() {
        return dbAgencyExtension != null ? dbAgencyExtension.getRequiredProcedures() : null;
    }

    public String[] getRequiredViews() {
        return dbAgencyExtension != null ? AgencyPlugin.getDbAgencyExtension().getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)AgencyPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)AgencyPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)AgencyPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("properties"));
    }

    public String getUninstallQuery(String string) throws IOException {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(string);
        if (dbAgencyExtension == null) {
            throw new IOException("Can't find a DbAgencyExtension for driver '" + string + "'!");
        }
        return dbAgencyExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(string);
        if (dbAgencyExtension == null) {
            LOGGER.warn("Can't find a DbAgencyExtension for driver '" + string + "'!");
            return null;
        }
        return dbAgencyExtension.getUpdateHandler();
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(string);
        if (dbAgencyExtension == null) {
            throw new SQLException("Can't find a DbAgencyExtension for driver '" + string + "'!");
        }
        dbAgencyExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
        if (bl) {
            for (AbstractExpose abstractExpose : AbstractExpose.getExposes().values()) {
                abstractExpose.initDefaults();
                DbAgencyExpose dbAgencyExpose = new DbAgencyExpose();
                dbAgencyExpose.name = abstractExpose.getTitle();
                dbAgencyExpose.setExposeBuilder(abstractExpose);
                dbAgencyExtension.getExposeHandler().saveExpose(connection, dbAgencyExpose);
            }
        }
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        return AgencyPlugin.isUserAllowedTo(AgencyPermission.USE_PLUGIN, immoToolProject);
    }

    public static boolean isApproximatedAttributes() {
        return OpenEstateUtils.isApproximatedAttributes();
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject);
    }

    public static boolean isUserAllowedTo(AgencyPermission agencyPermission) {
        return AgencyPlugin.isUserAllowedTo(agencyPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(AgencyPermission agencyPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null && dbUser.isAllowedTo(ID, (ProjectPermission)agencyPermission);
    }

    public static void loadSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            AgencyPlugin.loadSettings(immoToolProject, connection);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static void loadSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbPluginHandler dbPluginHandler = immoToolProject.getDbExtension().getPluginHandler();
        DbLanguagesHandler dbLanguagesHandler = dbAgencyExtension.getLanguagesHandler();
        DbPlugin dbPlugin = immoToolProject.getDbPlugin(ID);
        if (dbPlugin == null) {
            throw new IOException("Plugin 'OpenEstate-Tool-Agency' is not installed!");
        }
        dbPluginHandler.loadPluginSettings(connection, dbPlugin);
        imageMaxHeight = Integer.parseInt(dbPlugin.getSetting(PARAM_IMAGE_MAX_HEIGHT, "1000"));
        imageMaxWidth = Integer.parseInt(dbPlugin.getSetting(PARAM_IMAGE_MAX_WIDTH, "1000"));
        locales = dbLanguagesHandler.getLanguageLocales(connection, Boolean.valueOf(true));
        OpenEstateUtils.setApproximatedAttributes((boolean)Boolean.parseBoolean(dbPlugin.getSetting(PARAM_ATTRIBS_APPROX, "true")));
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        AgencyPlugin.getDbAgencyExtension().repair(connection, abstractDbDriver);
    }

    public static void saveSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            AgencyPlugin.saveSettings(connection, immoToolProject.getUser(), immoToolProject.getDbExtension());
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static void saveSettings(Connection connection, DbUser dbUser, DbExtension dbExtension) throws SQLException, IOException {
        AgencyPlugin.saveSettings(connection, dbUser, dbExtension, dbAgencyExtension);
    }

    /*
     * WARNING - void declaration
     */
    public static void saveSettings(Connection connection, DbUser dbUser, DbExtension dbExtension, DbAgencyExtension dbAgencyExtension) throws SQLException, IOException {
        DbAdminHandler dbAdminHandler = dbExtension.getAdminHandler();
        DbPluginHandler dbPluginHandler = dbExtension.getPluginHandler();
        DbLanguagesHandler dbLanguagesHandler = dbAgencyExtension != null ? dbAgencyExtension.getLanguagesHandler() : null;
        DbPlugin dbPlugin = dbPluginHandler.getPlugin(connection, ID);
        if (dbPlugin == null) {
            throw new IOException("Plugin 'OpenEstate-Tool-Agency' is not installed!");
        }
        dbPluginHandler.loadPluginSettings(connection, dbPlugin);
        if (dbAdminHandler.isAdmin(connection)) {
            dbPlugin.putSetting(PARAM_IMAGE_MAX_HEIGHT, String.valueOf(AgencyPlugin.getImageMaxHeight()));
            dbPlugin.putSetting(PARAM_IMAGE_MAX_WIDTH, String.valueOf(AgencyPlugin.getImageMaxWidth()));
            dbPlugin.putSetting(PARAM_ATTRIBS_APPROX, String.valueOf(AgencyPlugin.isApproximatedAttributes()));
            dbPluginHandler.savePlugin(connection, dbPlugin);
            if (dbLanguagesHandler != null) {
                void entry;
                HashMap<String, DbLanguage> hashMap = new HashMap<String, DbLanguage>();
                Object hashMap2 = dbLanguagesHandler.getLanguages(connection, (Boolean)null);
                int n = ((DbLanguage[])hashMap2).length;
                boolean bl = false;
                while (entry < n) {
                    DbLanguage dbLanguage = hashMap2[entry];
                    if (dbLanguage.locale != null) {
                        hashMap.put(dbLanguage.locale.toString().toLowerCase(), dbLanguage);
                    }
                    ++entry;
                }
                hashMap2 = new HashMap();
                for (Locale locale : locales) {
                    hashMap2.put(locale.toString().toLowerCase(), locale);
                }
                for (Map.Entry entry2 : hashMap2.entrySet()) {
                    DbLanguage dbLanguage = (DbLanguage)hashMap.get(entry2.getKey());
                    if (dbLanguage == null) {
                        dbLanguage = new DbLanguage();
                        dbLanguage.locale = (Locale)entry2.getValue();
                    }
                    dbLanguage.enabled = true;
                    dbLanguagesHandler.saveLanguage(connection, dbLanguage);
                }
                for (Map.Entry entry3 : hashMap.entrySet()) {
                    if (hashMap2.containsKey(entry3.getKey())) continue;
                    DbLanguage dbLanguage = (DbLanguage)entry3.getValue();
                    dbLanguage.enabled = false;
                    dbLanguagesHandler.saveLanguage(connection, dbLanguage);
                }
            }
        }
    }

    public static void setApproximatedAttributes(boolean bl) {
        OpenEstateUtils.setApproximatedAttributes((boolean)bl);
    }

    public static void setDbAgencyExtension(DbAgencyExtension dbAgencyExtension) {
        AgencyPlugin.dbAgencyExtension = dbAgencyExtension;
    }

    public static void setImageMaxHeight(int n) {
        imageMaxHeight = n;
    }

    public static void setImageMaxWidth(int n) {
        imageMaxWidth = n;
    }

    public static synchronized void setLastExportLocation(File file) {
        lastExportLocation = file;
    }

    public static synchronized void setLastImageLocation(File file) {
        lastImageLocation = file;
    }

    public static synchronized void setLastImportLocation(File file) {
        ImmoToolEnvironment.getSettings().setProperty(APP_LAST_IMPORT_LOCATION, file != null && file.isDirectory() ? file.getAbsolutePath() : "");
    }

    public static void setLocales(Locale[] localeArray) {
        locales = localeArray != null ? (Locale[])ArrayUtils.clone((Object[])localeArray) : new Locale[]{};
    }

    public static void unloadSettings() {
        imageMaxHeight = 1000;
        imageMaxWidth = 1000;
        locales = new Locale[0];
        OpenEstateUtils.setApproximatedAttributes((boolean)true);
    }

    public static class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = ImmoToolApp.getAppFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(AgencyFrameSidebarExtension.class);
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property view")));
            this.setShortDescription(I18N.tr("Show property view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<TreeModel, Void> {
        private final AgencyFrameSidebarExtension.Tree tree;

        public SidebarRefreshTask(AgencyFrameSidebarExtension.Tree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TreeModel doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                TreeModel treeModel = AgencyFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbAgencyExportsHandler, dbAgencySearchesHandler);
                return treeModel;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(TreeModel treeModel) {
            super.succeeded((Object)treeModel);
            if (treeModel == null) {
                return;
            }
            this.tree.setModel(treeModel);
            this.tree.expandAll();
        }
    }

    public static class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyFrameSidebarExtension.Tree tree = AgencyFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(tree));
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh property view in the sidebar."));
        }
    }

    private static final class SearchRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long searchId;

        public SearchRemoveTask(long l) {
            this.searchId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                dbAgencySearchesHandler.removeSearch(connection, this.searchId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove property search!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            this.setMessage("Property search #" + this.searchId + " was removed.");
            AgencyFrameSidebarExtension.Tree tree = AgencyFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeSearch(this.searchId);
            }
        }
    }

    public static class SearchRemoveAction
    extends AbstractI18nAction {
        private final long searchId;

        public SearchRemoveAction(long l) {
            this.searchId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.searchId < 1L) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove property search {0}?", (Object)("#" + this.searchId)), (Component)ImmoToolEnvironment.getFrame());
            if (bl) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SearchRemoveTask(this.searchId));
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove property search")));
            this.setShortDescription(I18N.tr("Remove the selected property search."));
        }
    }

    private static final class SearchDialogTask
    extends ImmoToolTask<DbAgencySearch, Void> {
        private final long searchId;

        public SearchDialogTask(long l) {
            this.searchId = l;
        }

        protected DbAgencySearch doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            return this.searchId < 1L ? AgencySearchDialog.showDialog(immoToolProject, DbAgencySearch.Type.SIDEBAR, true, false, (Window)ImmoToolEnvironment.getFrame()) : AgencySearchDialog.showDialog(this.searchId, immoToolProject, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load search form!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(DbAgencySearch dbAgencySearch) {
            super.succeeded((Object)dbAgencySearch);
            if (dbAgencySearch != null) {
                new SidebarRefreshAction().actionPerformed(null);
            }
        }
    }

    public static class SearchDialogAction
    extends AbstractI18nAction {
        private final long searchId;

        public SearchDialogAction() {
            this(0L);
        }

        public SearchDialogAction(long l) {
            this.searchId = l;
            if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            }
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new SearchDialogTask(this.searchId));
        }

        protected void updateLocalization() {
            if (this.searchId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add property search")));
                this.setShortDescription(I18N.tr("Add a new property search."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("edit property search")));
                this.setShortDescription(I18N.tr("Show details about the property search."));
            }
        }
    }

    private static final class ExportViewLogTask
    extends ImmoToolTask<AgencyExportLogViewPanel, Void> {
        private final long exportId;

        public ExportViewLogTask(long l) {
            this.exportId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AgencyExportLogViewPanel doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, this.exportId);
                if (dbAgencyExport == null) {
                    throw new Exception("Can't find export #" + this.exportId + "!");
                }
                DbAgencyExportLog dbAgencyExportLog = dbAgencyExportsHandler.getLatestExportLog(connection, this.exportId);
                if (dbAgencyExportLog == null) {
                    throw new Exception("Can't find latest protocol for export #" + this.exportId + "!");
                }
                dbAgencyExportsHandler.loadExportLogEntries(connection, dbAgencyExportLog);
                dbAgencyExportsHandler.loadExportLogMessages(connection, dbAgencyExportLog);
                AgencyExportLogViewPanel agencyExportLogViewPanel = new AgencyExportLogViewPanel();
                agencyExportLogViewPanel.setLog(dbAgencyExportLog, StringUtils.trimToNull((String)dbAgencyExport.name));
                AgencyExportLogViewPanel agencyExportLogViewPanel2 = agencyExportLogViewPanel;
                return agencyExportLogViewPanel2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load export protocol!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyExportLogViewPanel agencyExportLogViewPanel) {
            super.succeeded((Object)agencyExportLogViewPanel);
            if (agencyExportLogViewPanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyExportLogViewPanel, (boolean)true);
            }
        }
    }

    public static class ExportViewLogAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportViewLogAction(long l) {
            this.exportId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"history.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportViewLogTask(this.exportId));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show latest export protocol")));
            this.setShortDescription(I18N.tr("Show the latest protocol for the export interface."));
        }
    }

    private static final class ExportUnlockTask
    extends ImmoToolTask<Boolean, Void> {
        private final long exportId;

        public ExportUnlockTask(long l) {
            this.exportId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, this.exportId);
                if (dbAgencyExport == null) {
                    throw new Exception("Can't find export interface #" + this.exportId + "!");
                }
                if (!dbAgencyExport.isLocked()) {
                    Boolean bl = false;
                    return bl;
                }
                dbAgencyExport.lockTime = null;
                dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, false, false);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't unlock interface!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            Object[] objectArray;
            super.succeeded((Object)bl);
            if (Boolean.TRUE.equals(bl)) {
                this.setMessage("Interface #" + this.exportId + " was unlocked.");
            } else {
                this.setMessage("Interface #" + this.exportId + " is already unlocked.");
            }
            AgencyFrameSidebarExtension.Tree tree = AgencyFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeExport(this.exportId);
            }
            if (!ArrayUtils.isEmpty((Object[])(objectArray = ImmoToolAppUtils.getTabs(AgencyExportTablePanel.class)))) {
                for (Object object : objectArray) {
                    object.doRefresh();
                }
            }
        }
    }

    public static class ExportUnlockAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportUnlockAction(long l) {
            this.exportId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"lock.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.exportId < 1L) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to unlock property export {0}?", (Object)("#" + this.exportId)), (Component)ImmoToolEnvironment.getFrame());
            if (!bl) {
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportUnlockTask(this.exportId));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("unlock interface")));
            this.setShortDescription(I18N.tr("Unlock the selected export interface."));
        }
    }

    private static final class ExportSaveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] exportIds;
        private final File destinationFile;

        public ExportSaveTask(long[] lArray, File file) {
            this.exportIds = lArray;
            this.destinationFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                long[] lArray = this.exportIds;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long l = lArray[i];
                    DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, l);
                    if (dbAgencyExport == null) {
                        throw new Exception("Can't find export #" + l + "!");
                    }
                    dbAgencyExportsHandler.loadExportSettings(connection, dbAgencyExport);
                    File file = this.exportIds.length == 1 ? this.destinationFile : new File(this.destinationFile.getAbsolutePath() + File.separator + "export." + System.currentTimeMillis() + ".xml");
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        Properties properties = new Properties();
                        dbAgencyExport.save(properties);
                        properties.storeToXML(fileOutputStream, "export interface " + dbAgencyExport.name + " (#" + dbAgencyExport.id + ")");
                        fileOutputStream.flush();
                        continue;
                    }
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save export interfaces!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyPlugin.setLastExportLocation(this.exportIds.length == 1 ? this.destinationFile.getParentFile() : this.destinationFile);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            String string = this.destinationFile.getAbsolutePath();
            String string2 = "<html>" + I18N.tr("The selected interfaces were exported!") + "<br>" + I18N.tr("into file: {0}", (Object)StringUtils.abbreviateMiddle((String)string, (String)"...", (int)75)) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)ImmoToolEnvironment.getFrame());
        }
    }

    public static class ExportSaveAction
    extends AbstractI18nAction {
        private final long[] exportIds;

        public ExportSaveAction(long l) {
            this(new long[]{l});
        }

        public ExportSaveAction(long[] lArray) {
            this.exportIds = ArrayUtils.clone((long[])lArray);
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_saveas.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(I18N.tr("Export interfaces to harddisk."));
            if (this.exportIds.length > 1) {
                jFileChooser.setFileSelectionMode(1);
                if (lastExportLocation != null) {
                    jFileChooser.setSelectedFile(lastExportLocation);
                }
            } else {
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return I18N.tr("XML files") + " (*.xml)";
                    }
                });
                String string = "export." + System.currentTimeMillis() + ".xml";
                if (lastExportLocation != null) {
                    jFileChooser.setSelectedFile(new File(lastExportLocation.getAbsolutePath() + File.separator + string));
                } else {
                    jFileChooser.setSelectedFile(new File(string));
                }
            }
            if ((n = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame())) != 0) {
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportSaveTask(this.exportIds, jFileChooser.getSelectedFile()));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("export interface to disk")));
            this.setShortDescription(I18N.tr("Export the selected interfaces to harddisk."));
        }
    }

    private static final class ExportRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long exportId;

        public ExportRemoveTask(long l) {
            this.exportId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                Object object;
                connection = ImmoToolProject.getAppDbConnection();
                DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, this.exportId);
                if (dbAgencyExport == null) {
                    throw new Exception("Can't find export interface #" + this.exportId + "!");
                }
                if (dbAgencyExport.isLocked() && !ImmoToolUtils.showQuestionDialog((String)(object = "<html><b>" + I18N.tr("An export was started through this interface!") + "</b><br>" + I18N.tr("Maybe the last export did not finish successfully or another user started the export process.") + "<br>" + I18N.tr("Do you want to continue to remove the interface nevertheless?") + "</html>"), (Component)ImmoToolEnvironment.getFrame())) {
                    Boolean bl = false;
                    return bl;
                }
                dbAgencyExportsHandler.removeExport(connection, this.exportId);
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove interface!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            Object[] objectArray;
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            this.setMessage("Interface #" + this.exportId + " was removed.");
            AgencyFrameSidebarExtension.Tree tree = AgencyFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeExport(this.exportId);
            }
            if (!ArrayUtils.isEmpty((Object[])(objectArray = ImmoToolAppUtils.getTabs(AgencyExportTablePanel.class)))) {
                for (Object object : objectArray) {
                    object.doRefresh();
                }
            }
        }
    }

    public static class ExportRemoveAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportRemoveAction(long l) {
            this.exportId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.exportId < 1L) {
                return;
            }
            if (AgencyExportHandler.isJobRunning(this.exportId)) {
                String string = "<html>" + I18N.tr("You are currently exporting properties through this interface!") + "</html>";
                ImmoToolUtils.showMessageErrorDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove property export {0}?", (Object)("#" + this.exportId)), (Component)ImmoToolEnvironment.getFrame());
            if (!bl) {
                return;
            }
            if (AgencyExportHandler.hasExportJob(this.exportId)) {
                AgencyExportHandler.removeExportJob(this.exportId);
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportRemoveTask(this.exportId));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove interface")));
            this.setShortDescription(I18N.tr("Remove the selected export interface."));
        }
    }

    private static final class ExportTableTask
    extends ImmoToolTask<AgencyExportTablePanel, Void> {
        private final boolean asNewTab;

        public ExportTableTask(boolean bl) {
            this.asNewTab = bl;
        }

        protected AgencyExportTablePanel doInBackground() {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(AgencyExportTablePanel.class) : null;
            if (abstractMainTab instanceof AgencyExportTablePanel) {
                AgencyExportTablePanel agencyExportTablePanel = (AgencyExportTablePanel)abstractMainTab;
                ImmoToolAppUtils.selectTab((Component)((Object)agencyExportTablePanel));
                return null;
            }
            return AgencyExportTablePanel.createTab();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyExportTablePanel agencyExportTablePanel) {
            super.succeeded((Object)agencyExportTablePanel);
            if (agencyExportTablePanel != null) {
                agencyExportTablePanel.loadInBackground(ImmoToolProject.getAppDbDriver());
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyExportTablePanel);
            }
        }
    }

    public static class ExportTableAction
    extends AbstractI18nAction {
        private final boolean asNewTab;

        public ExportTableAction() {
            this(false);
        }

        public ExportTableAction(boolean bl) {
            this.asNewTab = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportTableTask(this.asNewTab));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show interfaces")));
            this.setShortDescription(I18N.tr("Show a table of export interfaces."));
        }
    }

    public static class ExportObjectsAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportObjectsAction() {
            this(0L);
        }

        public ExportObjectsAction(long l) {
            this.exportId = l;
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS) && AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                return;
            }
            AgencyExportObjectsDialog.showDialog(this.exportId, immoToolProject.getDbDriver(), AgencyPlugin.getDbAgencyExtension(), immoToolProject.getUser(), immoToolProject.getTempDirectory(), (Window)ImmoToolEnvironment.getFrame());
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("manage exportable properties")));
            this.setShortDescription(I18N.tr("Manage exportable properties for the export interfaces."));
        }
    }

    private static final class ExportLoadTask
    extends ImmoToolTask<DbAgencyExport[], Void> {
        private final File[] files;

        public ExportLoadTask(File[] fileArray) {
            this.files = fileArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyExport[] doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            ArrayList<DbAgencyExport> arrayList = new ArrayList<DbAgencyExport>();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                for (File file : this.files) {
                    DbAgencyExport dbAgencyExport;
                    this.setMessage(file.getAbsolutePath());
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        Properties properties = new Properties();
                        if (file.getName().toLowerCase().endsWith(".xml")) {
                            properties.loadFromXML(fileInputStream);
                        } else {
                            properties.load(fileInputStream);
                        }
                        dbAgencyExport = new DbAgencyExport();
                        dbAgencyExport.load(properties);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't read export interface!");
                        LOGGER.error("> from " + file.getAbsolutePath());
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)dbAgencyExport.name) || StringUtils.isBlank((CharSequence)dbAgencyExport.getFormatName()) || StringUtils.isBlank((CharSequence)dbAgencyExport.getTransportName())) {
                        LOGGER.error("Invalid or incomplete export interface!");
                        LOGGER.error("> from " + file.getAbsolutePath());
                        continue;
                    }
                    dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, true, false);
                    arrayList.add(dbAgencyExport);
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            return arrayList.toArray(new DbAgencyExport[0]);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't import interfaces!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            if (!ArrayUtils.isEmpty((Object[])this.files)) {
                AgencyPlugin.setLastExportLocation(this.files[0].getParentFile());
            }
        }

        protected void succeeded(DbAgencyExport[] dbAgencyExportArray) {
            super.succeeded((Object)dbAgencyExportArray);
            if (ArrayUtils.isEmpty((Object[])dbAgencyExportArray)) {
                return;
            }
            new SidebarRefreshAction().actionPerformed(null);
            Object[] objectArray = ImmoToolAppUtils.getTabs(AgencyExportTablePanel.class);
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    object.doRefresh();
                }
            }
        }
    }

    public static class ExportLoadAction
    extends AbstractI18nAction {
        public ExportLoadAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(I18N.tr("Please select an interface file."));
            if (lastExportLocation != null) {
                jFileChooser.setCurrentDirectory(lastExportLocation);
            }
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".ini") || file.getName().toLowerCase().endsWith(".properties");
                }

                @Override
                public String getDescription() {
                    return StringUtils.capitalize((String)I18N.tr("interface files")) + " (*.xml, *.ini, *.properties)";
                }
            });
            int n = jFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame());
            if (n != 0) {
                return;
            }
            Object[] objectArray = jFileChooser.getSelectedFiles();
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                ImmoToolUtils.executeTask((ImmoToolTask)new ExportLoadTask((File[])objectArray));
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import interface")));
            this.setShortDescription(I18N.tr("Import an export interface from an external file."));
        }
    }

    public static class ExportJobRestartAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportJobRestartAction(long l) {
            this.exportId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"restart.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportHandler.restartFailedTransport(this.exportId);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("restart transport")));
            this.setShortDescription(I18N.tr("Restart transport of the failed export process."));
        }
    }

    public static class ExportJobErrorAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportJobErrorAction(long l) {
            this.exportId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportHandler.Job job = AgencyExportHandler.getExportJob(this.exportId);
            if (job == null) {
                return;
            }
            Throwable throwable = job.getErrorException();
            if (throwable == null) {
                return;
            }
            AgencyExportHandler.JobState jobState = job.getState();
            if (AgencyExportHandler.JobState.PREPARATION_ERROR.equals((Object)jobState)) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Export failed during preparation."), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            } else if (AgencyExportHandler.JobState.TRANSPORT_ERROR.equals((Object)jobState)) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Export failed during transport."), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            } else if (AgencyExportHandler.JobState.FINISHING_ERROR.equals((Object)jobState)) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Export failed during finalization."), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show error details")));
            this.setShortDescription(I18N.tr("Show error details for the failed export process."));
        }
    }

    public static class ExportJobCancelAction
    extends AbstractI18nAction {
        private final long exportId;
        private final boolean immediately;

        public ExportJobCancelAction(long l, boolean bl) {
            this.exportId = l;
            this.immediately = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportHandler.cancelExportJob(this.exportId, this.immediately);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel export process")));
            this.setShortDescription(I18N.tr("Cancel the currently running export process."));
        }
    }

    public static class ExportFormAction
    extends AbstractI18nAction {
        private final long exportId;

        public ExportFormAction() {
            this(0L);
        }

        public ExportFormAction(long l) {
            this.exportId = l;
            if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyExportViewTask(ImmoToolProject.getAppDbDriver(), this.exportId));
        }

        protected void updateLocalization() {
            if (this.exportId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add export interface")));
                this.setShortDescription(I18N.tr("Add a new export interface."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("edit interface")));
                this.setShortDescription(I18N.tr("Edit settings of the export interface."));
            }
        }
    }

    private static final class ExportEnableTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] exportIds;
        private final boolean enabled;

        public ExportEnableTask(long[] lArray, boolean bl) {
            this.exportIds = lArray;
            this.enabled = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                dbAgencyExportsHandler.setExportsEnabled(connection, this.exportIds, this.enabled);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            String string = this.enabled ? "Can't enable interfaces!" : "Can't disable interfaces!";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            new SidebarRefreshAction().actionPerformed(null);
            Object[] objectArray = ImmoToolAppUtils.getTabs(AgencyExportTablePanel.class);
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    object.doRefresh();
                }
            }
        }
    }

    public static class ExportEnableAction
    extends AbstractI18nAction {
        private final long[] exportIds;
        private final boolean setEnabled;

        public ExportEnableAction(long l, boolean bl) {
            this(new long[]{l}, bl);
        }

        public ExportEnableAction(long[] lArray, boolean bl) {
            this.exportIds = ArrayUtils.clone((long[])lArray);
            this.setEnabled = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            for (long l : this.exportIds) {
                if (l <= 0L || !AgencyExportHandler.isJobRunning(l)) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string = "<html>" + I18N.tr("You are currently exporting properties through this interface!") + "</html>";
                ImmoToolUtils.showMessageErrorDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
                return;
            }
            ImmoToolUtils.executeTask((ImmoToolTask)new ExportEnableTask(this.exportIds, this.setEnabled));
        }

        protected void updateLocalization() {
            if (this.setEnabled) {
                this.setName(StringUtils.capitalize((String)I18N.tr("enable interface")));
                this.setShortDescription(I18N.tr("Enable the selected interfaces."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("disable interface")));
                this.setShortDescription(I18N.tr("Disable the selected interfaces."));
            }
        }
    }

    public static class ExportCancelAction
    extends AbstractI18nAction
    implements AgencyExportHandler.JobListener {
        private final long[] exportIds;

        public ExportCancelAction() {
            this(null);
        }

        public ExportCancelAction(long l) {
            this(new long[]{l});
        }

        public ExportCancelAction(long[] lArray) {
            this.exportIds = ArrayUtils.clone((long[])lArray);
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"switch.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE) && AgencyExportHandler.hasRunningJobs());
            this.updateLocalization();
            AgencyExportHandler.addJobListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.exportIds == null) {
                boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to cancel all currently running exports?"), (Component)ImmoToolEnvironment.getFrame());
                if (bl) {
                    AgencyExportHandler.cancelExportJobs(true);
                }
            } else {
                boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to cancel the selected exports?"), (Component)ImmoToolEnvironment.getFrame());
                if (!bl) {
                    return;
                }
                for (long l : this.exportIds) {
                    AgencyExportHandler.cancelExportJob(l, true);
                }
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            if (this.exportIds == null) {
                this.setName(StringUtils.capitalize((String)I18N.tr("cancel running exports")));
                this.setShortDescription(I18N.tr("Cancel all currently running exports."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("cancel running export")));
                this.setShortDescription(I18N.tr("Cancel a currently running export."));
            }
        }

        @Override
        public void jobAdded(AgencyExportHandler.Job job) {
        }

        @Override
        public void jobRemoved(long l) {
        }

        @Override
        public void jobStateChanged(AgencyExportHandler.Job job) {
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE) && AgencyExportHandler.hasRunningJobs());
        }

        @Override
        public void taskMessageChanged(long l, String string) {
        }

        @Override
        public void taskProgressChanged(long l, int n) {
        }
    }

    public static class ExportAction
    extends AbstractI18nAction {
        private final long[] exportIds;

        public ExportAction() {
            this(null);
        }

        public ExportAction(long l) {
            this(new long[]{l});
        }

        public ExportAction(long[] lArray) {
            this.exportIds = ArrayUtils.clone((long[])lArray);
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"launch.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                return;
            }
            Object[] objectArray = AgencyExportDialog.showDialog(this.exportIds, immoToolProject.getDbDriver(), AgencyPlugin.getDbAgencyExtension(), immoToolProject.getTempDirectory(), (Window)ImmoToolEnvironment.getFrame());
            if (objectArray == null || ArrayUtils.isEmpty((Object[])objectArray)) {
                return;
            }
            for (Object object : objectArray) {
                ((ExportContext)object).agent = immoToolProject.getAgent();
                ((ExportContext)object).agentLogoFile = immoToolProject.getAgentLogo();
                AgencyExportHandler.putExportJob((ExportContext)object);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            if (this.exportIds == null) {
                this.setName(StringUtils.capitalize((String)I18N.tr("start exports")));
                this.setShortDescription(I18N.tr("Start the export for all active interfaces."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("start export")));
                this.setShortDescription(I18N.tr("Start the export for the selected interface."));
            }
        }
    }

    private static final class EstateUpdateAttachmentsTask
    extends ImmoToolTask<Boolean, Void> {
        private final long objectId;

        public EstateUpdateAttachmentsTask(long l) {
            this.objectId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                AgencyPluginUtils.updateEstateFileHashes(connection, immoToolProject.getDbDriver(), this.objectId, this.createCallback());
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't update attachments!", (Throwable)throwable, (Window)this.getParentWindow());
        }
    }

    public static class EstateUpdateAttachmentsAction
    extends AbstractI18nAction {
        private final long objectId;

        public EstateUpdateAttachmentsAction() {
            this(0L);
        }

        public EstateUpdateAttachmentsAction(long l) {
            this.objectId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateUpdateAttachmentsTask(this.objectId), (Window)ImmoToolEnvironment.getFrame());
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("update property attachments")));
            this.setShortDescription(I18N.tr("Update attachments of properties."));
        }
    }

    private static final class EstateTableTask
    extends ImmoToolTask<AgencyEstateTablePanel, Void> {
        private final long searchId;
        private final boolean asNewTab;

        public EstateTableTask(long l, boolean bl) {
            this.searchId = l;
            this.asNewTab = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AgencyEstateTablePanel doInBackground() throws Exception {
            Object object;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbAgencySearch dbAgencySearch = null;
            if (this.searchId > 0L) {
                object = null;
                try {
                    object = immoToolProject.getDbConnection();
                    dbAgencySearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch((Connection)object, this.searchId);
                    if (dbAgencySearch == null) {
                        throw new Exception("Can't find search #" + this.searchId + "!");
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)object);
                }
            }
            AbstractMainTab abstractMainTab = object = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(AgencyEstateTablePanel.class) : null;
            if (object instanceof AgencyEstateTablePanel) {
                AgencyEstateTablePanel agencyEstateTablePanel = (AgencyEstateTablePanel)((Object)object);
                if (dbAgencySearch == null && agencyEstateTablePanel.getCurrentSearchId() > -1L || dbAgencySearch != null && agencyEstateTablePanel.getCurrentSearchId() != dbAgencySearch.id) {
                    agencyEstateTablePanel.setSearch(dbAgencySearch);
                    agencyEstateTablePanel.loadInBackground(immoToolProject.getDbDriver());
                }
                ImmoToolAppUtils.selectTab((Component)((Object)agencyEstateTablePanel));
                return null;
            }
            return AgencyEstateTablePanel.createTab(dbAgencySearch);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyEstateTablePanel agencyEstateTablePanel) {
            super.succeeded((Object)agencyEstateTablePanel);
            if (agencyEstateTablePanel != null) {
                agencyEstateTablePanel.doRefresh();
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyEstateTablePanel);
            }
        }
    }

    public static class EstateTableAction
    extends AbstractI18nAction {
        private final long searchId;
        private final boolean asNewTab;

        public EstateTableAction() {
            this(0L, false);
        }

        public EstateTableAction(long l) {
            this(l, false);
        }

        public EstateTableAction(boolean bl) {
            this(0L, bl);
        }

        public EstateTableAction(long l, boolean bl) {
            this.searchId = l;
            this.asNewTab = bl;
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EstateTableTask(this.searchId, this.asNewTab));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show properties")));
            this.setShortDescription(I18N.tr("Show a table of properties."));
        }
    }

    private static final class EstateSaveXlsTask
    extends AgencyEstateExportXlsTask {
        private final AgencyEstateExportDialog.ExportSettings settings;
        private final File outputFile;
        private final File outputZipFile;

        public EstateSaveXlsTask(AbstractDbDriver abstractDbDriver, File file, File file2, AgencyEstateExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, file, exportSettings);
            this.settings = exportSettings;
            this.outputFile = file;
            this.outputZipFile = file2;
        }

        @Override
        protected Long doInBackground() throws Exception {
            Long l = super.doInBackground();
            if (this.settings.zipped) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.outputZipFile));){
                    Object[] objectArray = this.outputFile.getParentFile().listFiles();
                    if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                        for (Object object : objectArray) {
                            ImmoToolUtils.loadFileIntoZipStream((File)object, (ZipOutputStream)zipOutputStream);
                        }
                    }
                    zipOutputStream.flush();
                }
            }
            return l;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save properties to CSV table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            if (this.settings.zipped) {
                FileUtils.deleteQuietly((File)this.outputFile.getParentFile());
            }
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            String string = l == null || l.intValue() < 1 ? I18N.tr("No properties were saved.") : I18N.trn("{0} property was saved.", "{0} properties were saved.", (long)l.intValue(), (Object)l.intValue());
            ImmoToolUtils.showMessageInfoDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EstateSaveCsvTask
    extends AgencyEstateExportCsvTask {
        private final AgencyEstateExportDialog.ExportSettings settings;
        private final File outputFile;
        private final File outputZipFile;

        public EstateSaveCsvTask(AbstractDbDriver abstractDbDriver, File file, File file2, AgencyEstateExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, file, exportSettings);
            this.settings = exportSettings;
            this.outputFile = file;
            this.outputZipFile = file2;
        }

        @Override
        protected Long doInBackground() throws Exception {
            Long l = super.doInBackground();
            if (this.settings.zipped) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.outputZipFile));){
                    Object[] objectArray = this.outputFile.getParentFile().listFiles();
                    if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                        for (Object object : objectArray) {
                            ImmoToolUtils.loadFileIntoZipStream((File)object, (ZipOutputStream)zipOutputStream);
                        }
                    }
                    zipOutputStream.flush();
                }
            }
            return l;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save properties to CSV table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            if (this.settings.zipped) {
                FileUtils.deleteQuietly((File)this.outputFile.getParentFile());
            }
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            String string = l == null || l.intValue() < 1 ? I18N.tr("No properties were saved.") : I18N.trn("{0} property was saved.", "{0} properties were saved.", (long)l.intValue(), (Object)l.intValue());
            ImmoToolUtils.showMessageInfoDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
        }
    }

    public static class EstateSaveAction
    extends AbstractI18nAction {
        public EstateSaveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                return;
            }
            try {
                File file;
                Object object;
                AgencyEstateExportDialog.ExportSettings exportSettings = AgencyEstateExportDialog.showDialog(true, (Window)ImmoToolEnvironment.getFrame());
                if (exportSettings == null) {
                    return;
                }
                if (exportSettings.format == null) {
                    throw new NullPointerException("Invalid export format!");
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(I18N.tr("Where do you want to save the exported properties?"));
                jFileChooser.setFileFilter(exportSettings.getFileFilter());
                jFileChooser.setSelectedFile(lastExportLocation != null ? new File(lastExportLocation.getAbsolutePath() + File.separator + exportSettings.getDefaultFileName()) : new File(exportSettings.getDefaultFileName()));
                int n = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame());
                if (n != 0) {
                    return;
                }
                File file2 = jFileChooser.getSelectedFile();
                if (exportSettings.zipped) {
                    object = new File(immoToolProject.getTempDirectory().getAbsolutePath() + File.separator + System.currentTimeMillis());
                    if (!((File)object).mkdir()) {
                        throw new Exception("Can't create temp directory!");
                    }
                    String string = file2.getName();
                    string = string.substring(0, string.lastIndexOf(".")) + "." + exportSettings.format.name().toLowerCase();
                    file = new File(((File)object).getAbsolutePath() + File.separator + string);
                } else {
                    file = file2;
                }
                AgencyPlugin.setLastExportLocation(file2.getParentFile());
                if (AgencyEstateExportDialog.Format.CSV.equals((Object)exportSettings.format)) {
                    object = new EstateSaveCsvTask(immoToolProject.getDbDriver(), file, exportSettings.zipped ? file2 : null, exportSettings);
                } else if (AgencyEstateExportDialog.Format.XLS.equals((Object)exportSettings.format)) {
                    object = new EstateSaveXlsTask(immoToolProject.getDbDriver(), file, exportSettings.zipped ? file2 : null, exportSettings);
                } else {
                    throw new IllegalArgumentException("Unsupported export format '" + (Object)((Object)exportSettings.format) + "'!");
                }
                ImmoToolUtils.executeTask((ImmoToolTask)object);
            }
            catch (Exception exception) {
                LOGGER.error("Can't save properties to local harddisk!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't save properties to local harddisk!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save properties")));
            this.setShortDescription(I18N.tr("Save properties to harddisk."));
        }
    }

    public static class EstateImportAction
    extends AbstractI18nAction {
        public EstateImportAction() {
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_IMPORT));
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractFrame abstractFrame = ImmoToolEnvironment.getFrame();
            ImmoToolTask immoToolTask = AgencyImportDialog.showDialog(ImmoToolProject.getAppInstance(), null, null, (Window)abstractFrame);
            if (immoToolTask != null) {
                ImmoToolTaskDialog.showDialog((ImmoToolTask)immoToolTask, (Window)abstractFrame);
            }
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import properties")));
            this.setShortDescription(I18N.tr("Import properties into the project."));
        }
    }

    public static class EstateFormAction
    extends AbstractI18nAction {
        private final long estateId;

        public EstateFormAction() {
            this(0L);
        }

        public EstateFormAction(long l) {
            this.estateId = l;
            if (l < 1L) {
                this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyEstateViewTask(ImmoToolProject.getAppDbDriver(), this.estateId));
        }

        protected void updateLocalization() {
            if (this.estateId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add property")));
                this.setShortDescription(I18N.tr("Add a new property."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
                this.setShortDescription(I18N.tr("Show details about the property."));
            }
        }
    }

    private static final class ContactTableTask
    extends ImmoToolTask<AgencyContactTablePanel, Void> {
        private final boolean asNewTab;

        public ContactTableTask(boolean bl) {
            this.asNewTab = bl;
        }

        protected AgencyContactTablePanel doInBackground() {
            AbstractMainTab abstractMainTab;
            AbstractMainTab abstractMainTab2 = abstractMainTab = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(AgencyContactTablePanel.class) : null;
            if (abstractMainTab instanceof AgencyContactTablePanel) {
                AgencyContactTablePanel agencyContactTablePanel = (AgencyContactTablePanel)abstractMainTab;
                ImmoToolAppUtils.selectTab((Component)((Object)agencyContactTablePanel));
                return null;
            }
            return AgencyContactTablePanel.createTab();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(AgencyContactTablePanel agencyContactTablePanel) {
            super.succeeded((Object)agencyContactTablePanel);
            if (agencyContactTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyContactTablePanel);
                agencyContactTablePanel.loadInBackground(ImmoToolProject.getAppDbDriver());
            }
        }
    }

    public static class ContactTableAction
    extends AbstractI18nAction {
        private final boolean asNewTab;

        public ContactTableAction() {
            this(false);
        }

        public ContactTableAction(boolean bl) {
            this.asNewTab = bl;
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_family.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactTableTask(this.asNewTab));
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show contact persons")));
            this.setShortDescription(I18N.tr("Show a table of all contact persons."));
        }
    }

    public static class ContactFormAction
    extends AbstractI18nAction {
        private final long contactId;
        private final boolean selectTab;

        public ContactFormAction() {
            this(0L, true);
        }

        public ContactFormAction(long l) {
            this(l, true);
        }

        public ContactFormAction(long l, boolean bl) {
            this.contactId = l;
            this.selectTab = bl;
            if (l < 1L) {
                this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_family.png", 16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyContactViewTask(ImmoToolProject.getAppDbDriver(), this.contactId, this.selectTab));
        }

        protected void updateLocalization() {
            if (this.contactId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add contact person")));
                this.setShortDescription(I18N.tr("Add a new contact person."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("view contact person")));
                this.setShortDescription(I18N.tr("Show details about the contact person."));
            }
        }
    }
}

