/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormat;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyExport
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyExport.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyExport.class);
    private static final String NAME = "name";
    private static final String LIMIT = "limit";
    private static final String ENABLED = "enabled";
    private static final String FORMAT = "format";
    private static final String TRANSPORT = "transport";
    private static final String TRANSFER = "transfer";
    private static final String NOTES = "notes";
    private static final String OLD_OPENIMMO_AT_FORMAT = "openimmo-at";
    private static final String OLD_IMMOWELT_DE_FORMAT = "immowelt_de";
    public long id = 0L;
    public long exposeId = 0L;
    public long searchId = 0L;
    public String name = null;
    public String notes = null;
    private String oldFormatName = null;
    private String formatName = null;
    private String transportName = null;
    public AbstractFormat.TransferMode transferMode = null;
    public boolean enabled = true;
    public int limit = 0;
    public Date lastExecution = null;
    public Date lockTime = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public AbstractFormat format = null;
    public AbstractTransport transport = null;
    public Map<Long, DbAgencyExportPublishing> publishings = null;

    @Deprecated
    public AbstractFormat buildFormat() {
        return this.getFormat();
    }

    @Deprecated
    public AbstractTransport buildTransport() {
        return this.getTransport();
    }

    public AbstractFormat getFormat() {
        return this.format;
    }

    public String getFormatName() {
        return this.formatName;
    }

    @Deprecated
    public String getFormatType() {
        return this.getFormatName();
    }

    public Map<String, String> getSettings() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.format != null) {
            for (Map.Entry entry : this.format.entrySet()) {
                string = StringUtils.trimToNull((String)((String)entry.getValue()));
                if (string == null) continue;
                hashMap.put("format." + (String)entry.getKey(), string);
            }
        }
        if (this.transport != null) {
            for (Map.Entry entry : this.transport.entrySet()) {
                string = StringUtils.trimToNull((String)((String)entry.getValue()));
                if (string == null) continue;
                hashMap.put("transport." + (String)entry.getKey(), string);
            }
        }
        return hashMap;
    }

    public AbstractTransport getTransport() {
        return this.transport;
    }

    public String getTransportName() {
        return this.transportName;
    }

    @Deprecated
    public String getTransportType() {
        return this.getTransportName();
    }

    public void initDefaults() {
        if (this.format instanceof OpenImmoXmlFormat) {
            if (OLD_IMMOWELT_DE_FORMAT.equals(this.oldFormatName)) {
                ((OpenImmoXmlFormat)this.format).setOpenImmoVersion(OpenImmoVersion.V1_2_6);
            } else if (OLD_OPENIMMO_AT_FORMAT.equals(this.oldFormatName)) {
                ((OpenImmoXmlFormat)this.format).setOpenImmoExtensionAt10Enabled(true);
            }
        }
    }

    @Deprecated
    public boolean isIncremental() {
        return this.isIncrementalTransfer();
    }

    public boolean isLocked() {
        if (this.lockTime == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -24);
        return this.lockTime.after(calendar.getTime());
    }

    public boolean isLockedByAnotherProcess() {
        return this.isLocked() && !AgencyExportHandler.isJobRunning(this.id);
    }

    public boolean isFullTransfer() {
        return this.transferMode == null || AbstractFormat.TransferMode.FULL.equals((Object)this.transferMode);
    }

    public boolean isIncrementalTransfer() {
        return AbstractFormat.TransferMode.INCREMENTAL.equals((Object)this.transferMode);
    }

    public void load(Properties properties) {
        this.name = StringUtils.trimToNull((String)properties.getProperty(NAME));
        this.notes = StringUtils.trimToNull((String)properties.getProperty(NOTES));
        this.limit = ImmoToolUtils.getPropertyAsInteger((String)LIMIT, (Integer)0, (Properties)properties);
        this.enabled = ImmoToolUtils.getPropertyAsBoolean((String)ENABLED, (Boolean)true, (Properties)properties);
        String string = StringUtils.trimToNull((String)properties.getProperty(TRANSFER));
        if (string == null) {
            LOGGER.warn("Transfer mode is empty for export interface '" + this.name + "'!");
            this.transferMode = AbstractFormat.TransferMode.FULL;
        } else {
            try {
                this.transferMode = AbstractFormat.TransferMode.valueOf(string);
            }
            catch (Exception exception) {
                LOGGER.warn("Transfer mode '" + string + "' is invalid for export interface " + this.name + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.transferMode = AbstractFormat.TransferMode.FULL;
            }
        }
        this.setFormat(StringUtils.trimToNull((String)properties.getProperty(FORMAT)));
        this.setTransport(StringUtils.trimToNull((String)properties.getProperty(TRANSPORT)));
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("format.") && !string2.startsWith("transport.")) continue;
            this.putSetting(string2, properties.getProperty(string2));
        }
    }

    public void putSetting(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        string2 = StringUtils.trimToNull((String)string2);
        if (string.startsWith("format.")) {
            String string3 = string.substring(FORMAT.length() + 1);
            if (this.format == null) {
                LOGGER.warn("No format specified, where setting '" + string3 + "' could be stored.");
            } else if (string2 == null) {
                this.format.remove(string3);
            } else {
                this.format.put(string3, string2);
            }
        } else if (string.startsWith("transport.")) {
            String string4 = string.substring(TRANSPORT.length() + 1);
            if (this.transport == null) {
                LOGGER.warn("No transport specified, where setting '" + string4 + "' could be stored.");
            } else if (string2 == null) {
                this.transport.remove(string4);
            } else {
                this.transport.put(string4, string2);
            }
        } else {
            LOGGER.warn("Unsupported export setting!");
            LOGGER.warn("> " + string + " = " + string2);
        }
    }

    public void save(Properties properties) {
        properties.setProperty(NAME, StringUtils.trimToEmpty((String)this.name));
        properties.setProperty(NOTES, StringUtils.trimToEmpty((String)this.notes));
        properties.setProperty(FORMAT, StringUtils.trimToEmpty((String)this.formatName));
        properties.setProperty(TRANSPORT, StringUtils.trimToEmpty((String)this.transportName));
        properties.setProperty(TRANSFER, this.transferMode != null ? this.transferMode.name() : AbstractFormat.TransferMode.FULL.name());
        properties.setProperty(LIMIT, this.limit > 0 ? String.valueOf(this.limit) : "0");
        properties.setProperty(ENABLED, Boolean.toString(this.enabled));
        for (Map.Entry<String, String> entry : this.getSettings().entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setFormat(String string) {
        AbstractFormat abstractFormat;
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.setFormat((AbstractFormat)null);
            return;
        }
        if (OLD_OPENIMMO_AT_FORMAT.equalsIgnoreCase(string)) {
            this.oldFormatName = OLD_OPENIMMO_AT_FORMAT;
            OpenImmoXmlFormat openImmoXmlFormat = new OpenImmoXmlFormat();
            openImmoXmlFormat.setOpenImmoExtensionAt10Enabled(true);
            abstractFormat = openImmoXmlFormat;
        } else if (OLD_IMMOWELT_DE_FORMAT.equalsIgnoreCase(string)) {
            this.oldFormatName = OLD_IMMOWELT_DE_FORMAT;
            OpenImmoXmlFormat openImmoXmlFormat = new OpenImmoXmlFormat();
            openImmoXmlFormat.setOpenImmoVersion(OpenImmoVersion.V1_2_6);
            abstractFormat = openImmoXmlFormat;
        } else {
            this.oldFormatName = null;
            abstractFormat = AbstractFormat.getFormat(string);
        }
        if (abstractFormat != null) {
            this.setFormat(abstractFormat, true);
        } else {
            LOGGER.warn("Unsupported export format '" + string + "'!");
            this.formatName = string;
            this.format = null;
        }
    }

    public void setFormat(AbstractFormat abstractFormat) {
        this.setFormat(abstractFormat, false);
    }

    private void setFormat(AbstractFormat abstractFormat, boolean bl) {
        if (abstractFormat == null) {
            this.format = null;
            this.formatName = null;
            this.oldFormatName = null;
        } else {
            this.format = abstractFormat;
            this.formatName = abstractFormat.getName();
            if (!bl) {
                this.oldFormatName = null;
            }
        }
    }

    public void setTransport(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.setTransport((AbstractTransport)null);
            return;
        }
        AbstractTransport abstractTransport = AbstractTransport.getTransport(string);
        if (abstractTransport != null) {
            this.setTransport(abstractTransport);
        } else {
            LOGGER.warn("Unsupported transport method '" + string + "' for export!");
            this.transportName = string;
            this.transport = null;
        }
    }

    public void setTransport(AbstractTransport abstractTransport) {
        if (abstractTransport == null) {
            this.transport = null;
            this.transportName = null;
        } else {
            this.transport = abstractTransport;
            this.transportName = abstractTransport.getName();
        }
    }
}

