/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposeFile;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyExposesHandler
extends DbAgencyExposesHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyExposesHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyExposesHandler.class);
    public static final String PROC_REMOVE_EXPOSES = "remove_immotool_agency_exposes";
    public static final String PROC_REMOVE_EXPOSES_FILES = "remove_immotool_agency_exposes_files";
    public static final String PROC_REMOVE_EXPOSES_SETTINGS = "remove_immotool_agency_exposes_settings";
    public static final String PROC_SAVE_EXPOSES = "save_immotool_agency_exposes";
    public static final String PROC_SAVE_EXPOSES_FILES = "save_immotool_agency_exposes_files";
    public static final String PROC_SAVE_EXPOSES_SETTINGS = "save_immotool_agency_exposes_settings";
    public static final String VIEW_EXPOSES = "view_immotool_agency_exposes";
    public static final String VIEW_EXPOSES_FILES = "view_immotool_agency_exposes_files";
    public static final String VIEW_EXPOSES_FILES_CONTENT = "view_immotool_agency_exposes_files_content";
    public static final String VIEW_EXPOSES_SETTINGS = "view_immotool_agency_exposes_settings";
    public static final String TABLE_EXPOSES = "immotool_agency_exposes";
    public static final String FIELD_EXPOSE_ID = "expose_id";
    public static final String FIELD_EXPOSE_NAME = "expose_name";
    public static final String FIELD_EXPOSE_TYPE = "expose_type";
    public static final String TABLE_EXPOSES_FILES = "immotool_agency_exposes_files";
    public static final String FIELD_FILE_ID = "file_id";
    public static final String FIELD_FILE_NAME = "file_name";
    public static final String FIELD_FILE_MIMETYPE = "file_mimetype";
    public static final String FIELD_FILE_CONTENT = "file_content";
    public static final String TABLE_EXPOSES_SETTINGS = "immotool_agency_exposes_settings";
    public static final String FIELD_SETTING_KEY = "setting_key";
    public static final String FIELD_SETTING_VALUE = "setting_value";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbAgencyExpose createExpose(ResultSet resultSet) throws SQLException {
        DbAgencyExpose dbAgencyExpose = new DbAgencyExpose();
        dbAgencyExpose.id = resultSet.getLong(FIELD_EXPOSE_ID);
        dbAgencyExpose.name = resultSet.getString(FIELD_EXPOSE_NAME);
        dbAgencyExpose.type = resultSet.getString(FIELD_EXPOSE_TYPE);
        dbAgencyExpose.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyExpose.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbAgencyExpose.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbAgencyExpose.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbAgencyExpose.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        return dbAgencyExpose;
    }

    private static DbAgencyExposeFile createExposeFile(ResultSet resultSet) throws SQLException {
        DbAgencyExposeFile dbAgencyExposeFile = new DbAgencyExposeFile();
        dbAgencyExposeFile.id = resultSet.getLong(FIELD_FILE_ID);
        dbAgencyExposeFile.exposeId = resultSet.getLong(FIELD_EXPOSE_ID);
        dbAgencyExposeFile.name = resultSet.getString(FIELD_FILE_NAME);
        dbAgencyExposeFile.mimeType = resultSet.getString(FIELD_FILE_MIMETYPE);
        dbAgencyExposeFile.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyExposeFile.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbAgencyExposeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadExposeFile(Connection connection, long l, OutputStream outputStream) throws SQLException, IOException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT file_content FROM view_immotool_agency_exposes_files_content WHERE file_id = ? LIMIT 1;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new IOException("Can't find requested file #" + l + "!");
            }
            Blob blob = resultSet.getBlob(FIELD_FILE_CONTENT);
            try (InputStream inputStream = blob.getBinaryStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.flush();
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExpose[] getExposes(Connection connection, long[] lArray) throws SQLException {
        DbAgencyExpose[] dbAgencyExposeArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbAgencyExpose[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes ORDER BY expose_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes WHERE expose_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_EXPOSE_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExpose> arrayList = new ArrayList<DbAgencyExpose>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExposesHandler.createExpose(resultSet));
            }
            dbAgencyExposeArray = arrayList.toArray(new DbAgencyExpose[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExposeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExposeFile getExposeFile(Connection connection, long l, String string) throws SQLException {
        DbAgencyExposeFile dbAgencyExposeFile;
        if (l < 1L || string == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_files WHERE expose_id = ? AND file_name = ? LIMIT 1;");
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, string);
            resultSet = preparedStatement.executeQuery();
            dbAgencyExposeFile = resultSet.next() ? HSqlDbAgencyExposesHandler.createExposeFile(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExposeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExposeFile[] getExposeFiles(Connection connection, long l) throws SQLException {
        DbAgencyExposeFile[] dbAgencyExposeFileArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_files ORDER BY expose_id ASC, file_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_files WHERE expose_id = ? ORDER BY file_name ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExposeFile> arrayList = new ArrayList<DbAgencyExposeFile>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExposesHandler.createExposeFile(resultSet));
            }
            dbAgencyExposeFileArray = arrayList.toArray(new DbAgencyExposeFile[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExposeFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbAgencyExposeFile[] getExposeFiles(Connection connection, long[] lArray) throws SQLException {
        DbAgencyExposeFile[] dbAgencyExposeFileArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbAgencyExposeFile[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_files ORDER BY expose_id ASC, file_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_files WHERE file_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_EXPOSE_ID + " ASC, " + FIELD_FILE_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExposeFile> arrayList = new ArrayList<DbAgencyExposeFile>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExposesHandler.createExposeFile(resultSet));
            }
            dbAgencyExposeFileArray = arrayList.toArray(new DbAgencyExposeFile[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExposeFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getExposeFileIds(Connection connection, long l) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT expose_id FROM view_immotool_agency_exposes_files ORDER BY expose_id ASC, file_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT expose_id FROM view_immotool_agency_exposes_files WHERE expose_id = ? ORDER BY file_name ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_EXPOSE_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getExposeIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT expose_id FROM view_immotool_agency_exposes ORDER BY expose_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_EXPOSE_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadExposeSettings(Connection connection, DbAgencyExpose[] dbAgencyExposeArray) throws SQLException {
        HashMap<Long, DbAgencyExpose> hashMap = new HashMap<Long, DbAgencyExpose>();
        for (DbAgencyExpose dbAgencyExpose : dbAgencyExposeArray) {
            if (dbAgencyExpose.id <= 0L || hashMap.containsKey(dbAgencyExpose.id)) continue;
            hashMap.put(dbAgencyExpose.id, dbAgencyExpose);
            if (dbAgencyExpose.settings != null) {
                dbAgencyExpose.settings.clear();
                continue;
            }
            dbAgencyExpose.settings = new HashMap<String, String>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exposes_settings WHERE expose_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_EXPOSE_ID + " ASC, " + FIELD_SETTING_KEY + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_EXPOSE_ID);
                String string = resultSet.getString(FIELD_SETTING_KEY);
                String string2 = resultSet.getString(FIELD_SETTING_VALUE);
                if (!hashMap.containsKey(l)) continue;
                DbAgencyExpose dbAgencyExpose = (DbAgencyExpose)hashMap.get(l);
                if (string2 == null) continue;
                dbAgencyExpose.settings.put(string, string2);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeExposes(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_exposes(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeExposeFiles(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_exposes_files(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveExpose(Connection connection, DbAgencyExpose dbAgencyExpose) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block10: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_exposes(:expose_id, :expose_name, :expose_type, :access_owner_id, :access_group_id, :access_permissions);");
                namedCallableStatement.setLong(FIELD_EXPOSE_ID, dbAgencyExpose.id);
                namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbAgencyExpose.ownerUserId);
                namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbAgencyExpose.ownerGroupId);
                namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbAgencyExpose.permission != null ? dbAgencyExpose.permission.getValue() : -1);
                namedCallableStatement.setString(FIELD_EXPOSE_NAME, StringUtils.abbreviate((String)dbAgencyExpose.name, (int)100));
                namedCallableStatement.setString(FIELD_EXPOSE_TYPE, StringUtils.abbreviate((String)dbAgencyExpose.type, (int)255));
                namedCallableStatement.execute();
                long l2 = l = dbAgencyExpose.id < 1L ? namedCallableStatement.getLong(FIELD_EXPOSE_ID) : dbAgencyExpose.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbAgencyExpose.settings != null) {
                    NamedCallableStatement namedCallableStatement2;
                    if (dbAgencyExpose.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exposes_settings(:expose_id, :setting_key);");
                        namedCallableStatement2.setLong(FIELD_EXPOSE_ID, dbAgencyExpose.id);
                        namedCallableStatement2.setString(FIELD_SETTING_KEY, null);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL save_immotool_agency_exposes_settings(:expose_id, :setting_key, :setting_value);");
                    for (String string : dbAgencyExpose.settings.keySet()) {
                        String string2 = dbAgencyExpose.settings.get(string);
                        if (string2 == null || string2.trim().length() == 0) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_EXPOSE_ID, l);
                        namedCallableStatement2.setString(FIELD_SETTING_KEY, StringUtils.abbreviate((String)string, (int)255));
                        namedCallableStatement2.setString(FIELD_SETTING_VALUE, string2);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbAgencyExpose.id >= 1L) break block10;
                dbAgencyExpose.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveExposeFile(Connection connection, DbAgencyExposeFile dbAgencyExposeFile) throws SQLException, IOException {
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block9: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            InputStream inputStream = null;
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_exposes_files(:file_id, :expose_id, :file_name, :file_mimetype, :file_content);");
                namedCallableStatement.setLong(FIELD_FILE_ID, dbAgencyExposeFile.id);
                namedCallableStatement.setLong(FIELD_EXPOSE_ID, dbAgencyExposeFile.exposeId);
                namedCallableStatement.setString(FIELD_FILE_NAME, StringUtils.abbreviate((String)dbAgencyExposeFile.name, (int)255));
                namedCallableStatement.setString(FIELD_FILE_MIMETYPE, StringUtils.abbreviate((String)dbAgencyExposeFile.mimeType, (int)255));
                if (dbAgencyExposeFile.tempContent != null && dbAgencyExposeFile.tempContent.isFile()) {
                    inputStream = new FileInputStream(dbAgencyExposeFile.tempContent);
                    namedCallableStatement.setBinaryStream(FIELD_FILE_CONTENT, inputStream, (int)dbAgencyExposeFile.tempContent.length());
                } else {
                    namedCallableStatement.setNull(FIELD_FILE_CONTENT, 2004);
                }
                namedCallableStatement.execute();
                long l2 = l = dbAgencyExposeFile.id < 1L ? namedCallableStatement.getLong(FIELD_FILE_ID) : dbAgencyExposeFile.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                connection.commit();
                if (dbAgencyExposeFile.id <= 0L) {
                    dbAgencyExposeFile.id = l;
                }
                if (inputStream == null) break block9;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
            inputStream.close();
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

