/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.ExportProcess;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExportContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportContext.class);
    private static final I18n I18N = I18nFactory.getI18n(ExportContext.class);
    public final DbAgencyExport export;
    public final File tempDir;
    public final Date stamp = new Date();
    public final List<ExportEntry> entries;
    public final Map<Long, String> ignoredEntries;
    public final List<DbAgencyExportLogMessage> messages;
    public final AbstractDbDriver dbDriver;
    public final DbAgencyExtension dbExtension;
    public AbstractFormat.TransferMode transferMode;
    public AgentImpl agent = null;
    public File agentLogoFile = null;
    private BufferedImage agentLogoImage = null;
    private boolean agentLogoLoaded = false;

    public ExportContext(DbAgencyExport dbAgencyExport, File file, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) throws IOException {
        this.export = dbAgencyExport;
        this.dbDriver = abstractDbDriver;
        this.dbExtension = dbAgencyExtension;
        this.transferMode = dbAgencyExport.transferMode;
        this.entries = new ArrayList<ExportEntry>();
        this.ignoredEntries = new HashMap<Long, String>();
        this.messages = new ArrayList<DbAgencyExportLogMessage>();
        this.tempDir = new File(file, "export-" + dbAgencyExport.id);
        if (this.tempDir.exists()) {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        if (!this.tempDir.isDirectory() && !this.tempDir.mkdirs()) {
            throw new IOException("Can't create temp directory!");
        }
    }

    public void addEntry(ExportEntry exportEntry, File file) throws IOException {
        this.entries.add(exportEntry);
        if (file != null) {
            File file2 = new File(this.tempDir, exportEntry.objectId + ".xml");
            FileUtils.copyFile((File)file, (File)file2);
        }
    }

    public void addErrorMessages(Map<String, List<String>> map, String string) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string2 = StringUtils.trimToNull((String)entry.getKey());
            ExportEntry exportEntry = null;
            if (string2 != null && (exportEntry = this.getEntry(string2)) == null) {
                LOGGER.warn("Can't find export entry for object key '" + string2 + "'!");
                continue;
            }
            List<String> list = entry.getValue();
            for (String string3 : list) {
                if ((string3 = StringUtils.trimToNull((String)string3)) == null) continue;
                if (exportEntry != null) {
                    this.addMessage(exportEntry.objectId, string3, string, DbAgencyExportLogMessage.Level.ERROR);
                    continue;
                }
                this.addMessage(string3, string, DbAgencyExportLogMessage.Level.ERROR);
            }
        }
    }

    public void addIgnoredEntry(long l, String string) {
        if (!StringUtils.isBlank((CharSequence)string)) {
            this.ignoredEntries.put(l, string);
        }
    }

    public void addMessage(String string, String string2, DbAgencyExportLogMessage.Level level) {
        this.addMessage(new DbAgencyExportLogMessage(0L, string, string2, level));
    }

    public void addMessage(long l, String string, String string2, DbAgencyExportLogMessage.Level level) {
        this.addMessage(new DbAgencyExportLogMessage(l, string, string2, level));
    }

    public void addMessage(DbAgencyExportLogMessage dbAgencyExportLogMessage) {
        if (dbAgencyExportLogMessage != null) {
            this.messages.add(dbAgencyExportLogMessage);
        }
    }

    public void clear() {
        try {
            this.flushAgentLogo();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't flush company logo!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            if (this.tempDir != null && this.tempDir.isDirectory()) {
                FileUtils.deleteQuietly((File)this.tempDir);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't cleanup the temporary export folder completely!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public ExportProcess createExportProcess() {
        return this.getFormat().createExportProcess();
    }

    public synchronized void flushAgentLogo() {
        if (this.agentLogoImage != null) {
            this.agentLogoImage.flush();
        }
        this.agentLogoImage = null;
        this.agentLogoLoaded = false;
    }

    public synchronized BufferedImage getAgentLogo() {
        if (this.agentLogoImage == null && this.agentLogoFile != null && this.agentLogoFile.isFile() && !this.agentLogoLoaded) {
            try {
                this.agentLogoImage = ImageUtils.read((File)this.agentLogoFile);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read agency logo as image!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                this.agentLogoLoaded = true;
            }
        }
        return this.agentLogoImage;
    }

    public ExportEntry getEntry(long l) {
        for (ExportEntry exportEntry : this.entries) {
            if (exportEntry.objectId <= 0L || exportEntry.objectId != l) continue;
            return exportEntry;
        }
        return null;
    }

    public ExportEntry getEntry(String string) {
        for (ExportEntry exportEntry : this.entries) {
            if (exportEntry.objectKey == null || !exportEntry.objectKey.equals(string)) continue;
            return exportEntry;
        }
        return null;
    }

    public EstateImpl getEstate(long l) throws IOException, DocumentException {
        File file = new File(this.tempDir, l + ".xml");
        if (!file.isFile() || file.length() < 1L) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Document document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
            EstateImpl estateImpl = new EstateImpl(document);
            return estateImpl;
        }
    }

    public AbstractFormat getFormat() {
        return this.export.getFormat();
    }

    public String getIgnoredEntryHash(long l) {
        return StringUtils.trimToNull((String)this.ignoredEntries.get(l));
    }

    public long[] getIgnoredEntryIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.ignoredEntries.keySet());
        return ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
    }

    public AbstractTransport getTransport() {
        return this.export.getTransport();
    }

    public File getWorkDir() {
        return new File(this.tempDir, "work");
    }

    public boolean isFullTranfer() {
        return !this.isIncrementalTransfer();
    }

    public boolean isIncrementalTransfer() {
        return AbstractFormat.TransferMode.INCREMENTAL.equals((Object)this.transferMode);
    }
}

