/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ImmonetDeFormatPanel;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormat;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.Sonstige;
import org.openestate.io.openimmo.xml.UserDefinedAnyfield;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmonetDeFormat
extends OpenImmoXmlFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmonetDeFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmonetDeFormat.class);
    private static final String NAME = "immonet_de";
    private static final String IMMONET_RECIPIENT = "immonet_de.recipient";
    private static final String ANYFIELD_RECIPIENT_IVD = "ivdrechte";

    @Override
    public Openimmo convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        String string2;
        Openimmo openimmo = super.convertXml(transferImpl, exportContext);
        if (openimmo == null) {
            return null;
        }
        if (!Recipient.ALL.equals((Object)this.getImmonetRecipient())) {
            int n = Recipient.IVD.equals((Object)this.getImmonetRecipient()) ? 1 : 0;
            for (Object object : openimmo.getAnbieter()) {
                for (String string2 : object.getImmobilie()) {
                    JAXBElement jAXBElement = new JAXBElement(new QName(ANYFIELD_RECIPIENT_IVD), Integer.class, (Object)n);
                    UserDefinedAnyfield userDefinedAnyfield = OpenImmoUtils.getFactory().createUserDefinedAnyfield();
                    userDefinedAnyfield.getContent().add(jAXBElement);
                    if (string2.getVerwaltungTechn() == null) {
                        string2.setVerwaltungTechn(OpenImmoUtils.getFactory().createVerwaltungTechn());
                    }
                    string2.getVerwaltungTechn().getUserDefinedAnyfield().add(userDefinedAnyfield);
                }
            }
        }
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                string2 = immobilie.getVerwaltungTechn() != null ? immobilie.getVerwaltungTechn().getObjektnrExtern() : null;
                if (StringUtils.isEmpty((CharSequence)string2)) continue;
                immobilie.getVerwaltungTechn().setObjektnrExtern(StringUtils.abbreviate((String)string2, (int)80));
            }
        }
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                if (immobilie.getObjektkategorie() == null || immobilie.getObjektkategorie().getObjektart() == null || immobilie.getObjektkategorie().getNutzungsart() == null || immobilie.getObjektkategorie().getObjektart().getParken().isEmpty() && (immobilie.getObjektkategorie().getObjektart().getSonstige().isEmpty() || !Sonstige.SonstigeTyp.PARKHAUS.equals((Object)(string2 = (Sonstige)immobilie.getObjektkategorie().getObjektart().getSonstige().get(0)).getSonstigeTyp()) && !Sonstige.SonstigeTyp.SONSTIGE.equals((Object)string2.getSonstigeTyp())) || Boolean.TRUE.equals((string2 = immobilie.getObjektkategorie().getNutzungsart()).getANLAGE()) || Boolean.TRUE.equals(string2.isGEWERBE()) || Boolean.TRUE.equals(string2.getWAZ()) || Boolean.TRUE.equals(string2.isWOHNEN())) continue;
                LOGGER.info("Force use of <nutzungsart WOHNEN=\"true\" /> because of compatibility issues with immonet.de!");
                if (immobilie.getVerwaltungTechn() != null) {
                    if (immobilie.getVerwaltungTechn().getObjektnrIntern() != null) {
                        LOGGER.info("> for <objektnr_intern>" + immobilie.getVerwaltungTechn().getObjektnrIntern() + "</objektnr_intern>");
                    }
                    if (immobilie.getVerwaltungTechn().getObjektnrExtern() != null) {
                        LOGGER.info("> for <objektnr_extern>" + immobilie.getVerwaltungTechn().getObjektnrExtern() + "</objektnr_extern>");
                    }
                }
                string2.setWOHNEN(true);
            }
        }
        return openimmo;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new ImmonetDeFormatPanel();
    }

    @Override
    public AbstractFormat.Compression getCompression() {
        return AbstractFormat.Compression.ZIP;
    }

    public Recipient getImmonetRecipient() {
        String string = StringUtils.trimToNull((String)((String)this.get(IMMONET_RECIPIENT)));
        return string != null ? Recipient.valueOf(string.toUpperCase()) : Recipient.ALL;
    }

    @Override
    public Locale[] getLanguages() {
        return new Locale[]{Locale.GERMAN};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Portal: Immonet.de";
    }

    @Override
    public AbstractXmlFormat.LineBreakMode getXmlLineBreak() {
        return AbstractXmlFormat.LineBreakMode.XHTML;
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
        this.setLanguages(new Locale[]{Locale.GERMAN});
        this.setOpenImmoPropertyPublicIdExported(true);
        this.setPropertyAddressHiddenIfUnpublished(false);
    }

    @Override
    public boolean isPropertyAddressHiddenIfUnpublished() {
        return false;
    }

    public void setImmonetRecipient(Recipient recipient) {
        if (recipient == null) {
            this.remove(IMMONET_RECIPIENT);
        } else {
            this.put(IMMONET_RECIPIENT, recipient.name());
        }
    }

    public static enum Recipient implements Translatable
    {
        ALL(I18n.marktr((String)"Publish at Immonet.de and all of their partners.")),
        IVD(I18n.marktr((String)"Publish only at IVD.net."));

        private final String i18nKey;

        private Recipient(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ImmonetDeFormat.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ImmonetDeFormat.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

