/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.is24.Is24CsvWriter;
import com.openindex.openestate.tool.agency.export.AbstractCsvFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.Is24CsvFormatPanel;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.is24_csv.Is24CsvPrinter;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24CsvFormat
extends AbstractCsvFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24CsvFormat.class);
    private static final String NAME = "is24_csv";
    public static final String GEODB = "is24";

    protected Is24CsvWriter buildWriter() {
        return this.buildWriter(null, null);
    }

    private Writer buildWriter(ExportContext exportContext) {
        return exportContext != null ? this.buildWriter(exportContext.dbDriver, exportContext.dbExtension) : this.buildWriter(null, null);
    }

    private Writer buildWriter(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        Writer writer = new Writer(this.getLanguage(), abstractDbDriver, dbAgencyExtension);
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        return writer;
    }

    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            Is24CsvWriter is24CsvWriter = this.buildWriter();
            String string = StringUtils.trimToEmpty((String)is24CsvWriter.writeToString(agencyImpl));
            String string2 = is24CsvWriter.getErrorMessages(estateImpl.getId());
            if (string2 != null) {
                throw new AbstractFormat.NotExportableException(string2);
            }
            return DigestUtils.sha1Hex((String)string);
        }
        catch (IOException iOException) {
            throw new AbstractFormat.HashCalculationException(iOException.getLocalizedMessage(), iOException);
        }
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new Is24CsvFormatPanel();
    }

    @Override
    protected String getCompressedFileName(AbstractFormat.Compression compression, ExportContext exportContext) {
        String string = super.getCompressedFileName(compression, exportContext);
        char c = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode) ? (char)'t' : 'v';
        int n = string.lastIndexOf(".");
        return string.substring(0, n) + "_st_Z7P_im" + c + string.substring(n);
    }

    @Override
    protected String getCsvFileName(ExportContext exportContext) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        return "transfer-" + simpleDateFormat.format(exportContext.stamp) + ".csv";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return new String[]{"application/pdf", "image/bmp", "image/gif", "image/jpeg", "image/png", "video/avi", "video/mpeg", "video/msvideo", "video/quicktime", "video/x-ms-wmv", "video/x-msvideo"};
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public String getTitle() {
        return "IS24-CSV";
    }

    @Override
    public String getVersion() {
        return "1.4.0.4";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setLanguages(new Locale[]{Locale.GERMAN});
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(GEODB);
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.removeCustomGeoAreas();
        if (geoAreaImpl != null) {
            estateImpl.putCustomGeoArea(GEODB, geoAreaImpl);
        }
        return true;
    }

    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException {
        File file2 = new File(file, this.getCsvFileName(exportContext));
        Writer writer = this.buildWriter(exportContext);
        writer.write(transferImpl, file2);
        exportContext.addErrorMessages(writer.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return file;
    }

    public static class Writer
    extends Is24CsvWriter {
        private final Map<Long, DbGeoArea> areas;
        private final AbstractDbDriver dbDriver;
        private final DbAgencyExtension dbExtension;
        private Connection dbConnection = null;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
            super(locale);
            this.dbDriver = abstractDbDriver;
            this.dbExtension = dbAgencyExtension;
            this.areas = new HashMap<Long, DbGeoArea>();
        }

        protected Is24CsvRecord createRecord(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws OpenEstateException {
            Is24CsvRecord is24CsvRecord = super.createRecord(estateImpl, agentImpl, agentContactImpl, list);
            if (this.dbDriver != null) {
                DbGeoArea dbGeoArea = null;
                try {
                    GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(Is24CsvFormat.GEODB);
                    dbGeoArea = geoAreaImpl != null ? this.lookupArea(geoAreaImpl) : null;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load areas from geodb 'is24'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                if (dbGeoArea != null) {
                    is24CsvRecord.setInternationaleRegion(dbGeoArea.name);
                }
            }
            return is24CsvRecord;
        }

        private Connection initConnection() throws SQLException {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbDriver.getConnection();
            }
            return this.dbConnection;
        }

        private DbGeoArea lookupArea(Long l) throws SQLException {
            if (this.areas.containsKey(l)) {
                return this.areas.get(l);
            }
            Connection connection = this.initConnection();
            DbGeoArea dbGeoArea = this.dbExtension.getGeoHandler().getGeoArea(connection, l.longValue());
            this.areas.put(dbGeoArea.id, dbGeoArea);
            return dbGeoArea;
        }

        private DbGeoArea lookupArea(GeoAreaImpl geoAreaImpl) throws SQLException {
            Long l = Long.valueOf(geoAreaImpl.getId());
            return this.lookupArea(l);
        }

        public void write(AgencyImpl agencyImpl, Is24CsvPrinter is24CsvPrinter) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                super.write(agencyImpl, is24CsvPrinter);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }

        public void write(TransferImpl transferImpl, Is24CsvPrinter is24CsvPrinter) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                super.write(transferImpl, is24CsvPrinter);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }
    }
}

