/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.kyero.KyeroWriter;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.KyeroXmlFormatPanel;
import com.openindex.openestate.tool.agency.export.MultiVersionSupport;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KyeroXmlFormat
extends AbstractXmlFormat<Root>
implements MultiVersionSupport {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(KyeroXmlFormat.class);
    private static final String NAME = "kyero";
    private static final String KYERO_BASE_URL = "kyero.baseUrl";
    private static final String KYERO_VERSION = "kyero.version";
    private transient String preparedObjectId = null;
    private transient int preparedObjectImgCount = 0;

    protected KyeroWriter buildWriter() {
        Writer writer = new Writer(this.getLanguage());
        writer.setXmlLineSeparator(System.lineSeparator());
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        URI uRI = this.getKyeroBaseUrl();
        writer.setBaseUrl(uRI != null ? uRI.toString() : "http://localhost");
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        Root root;
        Object object2;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object2 = this.buildWriter();
            object2.setXmlLineSeparator("<br/>");
            root = (Root)object2.writeToObject(agencyImpl);
            string = object2.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (root == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        root.setKyero(null);
        root.setAgent(null);
        for (Object object322 : root.getProperty()) {
            object322.setDate(null);
        }
        try {
            Object object322;
            object2 = new StringWriter();
            object322 = null;
            try {
                KyeroUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)root, (java.io.Writer)object2);
                String string2 = ((StringWriter)object2).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                String string3 = DigestUtils.sha1Hex((String)string2);
                return string3;
            }
            catch (Throwable throwable) {
                object322 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object322 != null) {
                        try {
                            ((StringWriter)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object322).addSuppressed(throwable);
                        }
                    } else {
                        ((StringWriter)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    protected boolean canPublishAttachment(String string, EstateAttachmentImpl estateAttachmentImpl) {
        boolean bl;
        boolean bl2 = bl = super.canPublishAttachment(string, estateAttachmentImpl) && estateAttachmentImpl.getMimeType().toLowerCase().startsWith("image/");
        if (!bl) {
            return false;
        }
        if (this.preparedObjectId == null || !this.preparedObjectId.equals(string)) {
            this.preparedObjectId = string;
            this.preparedObjectImgCount = 0;
        }
        if (this.preparedObjectImgCount > 50) {
            return false;
        }
        ++this.preparedObjectImgCount;
        return true;
    }

    @Override
    protected Root convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        KyeroWriter kyeroWriter = this.buildWriter();
        Root root = (Root)kyeroWriter.writeToObject(transferImpl);
        if (root == null) {
            return null;
        }
        if (PublishingMode.NEVER.equals((Object)this.getPropertyFilePublication())) {
            for (PropertyType propertyType : root.getProperty()) {
                propertyType.setImages(null);
            }
        }
        exportContext.addErrorMessages(kyeroWriter.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return root;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new KyeroXmlFormatPanel();
    }

    public URI getKyeroBaseUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(KYERO_BASE_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read url: " + string);
            return null;
        }
    }

    public KyeroVersion getKyeroVersion() {
        if (this.isLatestVersion()) {
            return KyeroUtils.VERSION;
        }
        String string = StringUtils.trimToNull((String)((String)this.get(KYERO_VERSION)));
        KyeroVersion kyeroVersion = null;
        try {
            if (string != null) {
                kyeroVersion = KyeroVersion.valueOf((String)string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't determine Kyero version from '" + string + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return kyeroVersion != null ? kyeroVersion : KyeroUtils.VERSION;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected String[] getPreferredMimeTypes() {
        return new String[]{"image/gif", "image/jpeg", "image/png"};
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return this.getPreferredMimeTypes();
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "Kyero-XML";
    }

    @Override
    public String getVersion() {
        KyeroVersion kyeroVersion = this.getKyeroVersion();
        if (kyeroVersion == null) {
            kyeroVersion = KyeroUtils.VERSION;
        }
        return kyeroVersion.toReadableVersion();
    }

    @Override
    public String[] getVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = KyeroVersion.values();
        ArrayUtils.reverse((Object[])objectArray);
        for (Object object : objectArray) {
            arrayList.add(object.toReadableVersion());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        return "kyero.xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
        this.setCompression(AbstractFormat.Compression.UNCOMPRESSED);
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }

    @Override
    public boolean isLatestVersion() {
        String string = StringUtils.trimToNull((String)((String)this.get(KYERO_VERSION)));
        return string == null || "latest".equalsIgnoreCase(string);
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        this.preparedObjectId = null;
        this.preparedObjectImgCount = 0;
        return super.prepareObjectForExport(l, estateImpl);
    }

    public void setKyeroBaseUrl(URI uRI) {
        if (uRI == null) {
            this.remove(KYERO_BASE_URL);
        } else {
            this.put(KYERO_BASE_URL, uRI.toString());
        }
    }

    public void setKyeroVersion(KyeroVersion kyeroVersion) {
        this.put(KYERO_VERSION, kyeroVersion != null ? kyeroVersion.name() : "latest");
    }

    @Override
    public void setLatestVersion() {
        this.setKyeroVersion(null);
    }

    @Override
    public void setVersion(String string) {
        this.setKyeroVersion(KyeroVersion.detectFromString((String)string));
    }

    @Override
    protected void writeXmlObject(Root root, java.io.Writer writer) throws IOException, JAXBException {
        try {
            KyeroDocument kyeroDocument = KyeroDocument.newDocument((Root)root);
            kyeroDocument.downgrade((XmlVersion)this.getKyeroVersion());
            kyeroDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends KyeroWriter {
        private URI companyWebsite = null;

        public Writer(Locale locale) {
            super(locale);
            AgencyPluginUtils.initJAXB(KyeroUtils.class);
        }

        protected PropertyType convertEstate(EstateImpl estateImpl, List<String> list) {
            PropertyType propertyType = super.convertEstate(estateImpl, list);
            if (this.companyWebsite != null) {
                List list2 = estateImpl.getLanguages();
                String string = this.companyWebsite.getHost();
                for (EstateLinkImpl estateLinkImpl : estateImpl.getLinks()) {
                    URI uRI = estateLinkImpl.getWebLink();
                    if (uRI == null || !uRI.getHost().equalsIgnoreCase(string)) continue;
                    propertyType.setUrl(KyeroUtils.FACTORY.createUrlType());
                    if (list2.contains("ca")) {
                        propertyType.getUrl().setCa(uRI);
                    }
                    if (list2.contains("da")) {
                        propertyType.getUrl().setDa(uRI);
                    }
                    if (list2.contains("de")) {
                        propertyType.getUrl().setDe(uRI);
                    }
                    if (list2.contains("en")) {
                        propertyType.getUrl().setEn(uRI);
                    }
                    if (list2.contains("es")) {
                        propertyType.getUrl().setEs(uRI);
                    }
                    if (list2.contains("fi")) {
                        propertyType.getUrl().setFi(uRI);
                    }
                    if (list2.contains("fr")) {
                        propertyType.getUrl().setFr(uRI);
                    }
                    if (list2.contains("it")) {
                        propertyType.getUrl().setIt(uRI);
                    }
                    if (list2.contains("nl")) {
                        propertyType.getUrl().setNl(uRI);
                    }
                    if (list2.contains("no")) {
                        propertyType.getUrl().setNo(uRI);
                    }
                    if (list2.contains("pt")) {
                        propertyType.getUrl().setPt(uRI);
                    }
                    if (list2.contains("ru")) {
                        propertyType.getUrl().setRu(uRI);
                    }
                    if (!list2.contains("sv")) break;
                    propertyType.getUrl().setSv(uRI);
                    break;
                }
            }
            return propertyType;
        }

        protected synchronized Root convertToXmlObject(AgencyImpl agencyImpl) {
            this.companyWebsite = agencyImpl != null ? agencyImpl.getAgent().getCompany().getCompanyWebsite() : null;
            return super.convertToXmlObject(agencyImpl);
        }

        protected synchronized Root convertToXmlObject(TransferImpl transferImpl) {
            TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
            this.companyWebsite = transferAgencyImpl != null ? transferAgencyImpl.getAgent().getCompany().getCompanyWebsite() : null;
            return super.convertToXmlObject(transferImpl);
        }
    }
}

