/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.OpenEstateXmlFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenEstateXmlFormatPanel
extends AbstractFormatPanel<OpenEstateXmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenEstateXmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(OpenEstateXmlFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel exportLineBreakLabel;
    private JComboBox<AbstractXmlFormat.LineBreakMode> exportLineBreakBox;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;

    public OpenEstateXmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.zipExportBox = new JCheckBox();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.exportLineBreakLabel = new JLabel();
        this.exportLineBreakBox = new JComboBox();
        this.exportLineBreakBox.setRenderer((ListCellRenderer<AbstractXmlFormat.LineBreakMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        for (AbstractXmlFormat.LineBreakMode lineBreakMode : AbstractXmlFormat.LineBreakMode.values()) {
            this.exportLineBreakBox.addItem(lineBreakMode);
        }
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.exportLineBreakLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.exportLineBreakBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.row(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (OpenEstateXmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, OpenEstateXmlFormat openEstateXmlFormat) {
        if (openEstateXmlFormat == null) {
            this.estateIdPrefixField.setText("");
            this.exportLineBreakBox.setSelectedItem((Object)AbstractXmlFormat.LineBreakMode.NATIVE);
            this.zipExportBox.setSelected(true);
        } else {
            this.estateIdPrefixField.setText(openEstateXmlFormat.getPropertyPrefix());
            AbstractFormat.Compression compression = openEstateXmlFormat.getCompression();
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)compression));
            AbstractXmlFormat.LineBreakMode lineBreakMode = openEstateXmlFormat.getXmlLineBreak();
            this.exportLineBreakBox.setSelectedItem((Object)(lineBreakMode != null ? lineBreakMode : AbstractXmlFormat.LineBreakMode.NATIVE));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, OpenEstateXmlFormat openEstateXmlFormat) {
        if (openEstateXmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        openEstateXmlFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        openEstateXmlFormat.setXmlLineBreak((AbstractXmlFormat.LineBreakMode)((Object)this.exportLineBreakBox.getSelectedItem()));
        openEstateXmlFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.exportLineBreakLabel.setText(StringUtils.capitalize((String)I18N.tr("line break")) + ":");
        this.exportLineBreakBox.setToolTipText(I18N.tr("Use this field to specify, how line breaks are written into the exported file."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
    }
}

