/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.SftpTransportPanel;
import com.openindex.openestate.tool.utils.SftpClient;
import com.openindex.openestate.tool.utils.SshUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SftpTransport
extends AbstractTransport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(SftpTransport.class);
    private static final String NAME = "sftp";
    private static final String SFTP_HOST = "sftp.host";
    private static final String SFTP_LOGIN_PASS = "sftp.login.pass";
    private static final String SFTP_LOGIN_USER = "sftp.login.user";
    private static final String SFTP_PATH = "sftp.path";
    private static final String SFTP_PORT = "sftp.port";

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new SftpTransportPanel();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getSftpHost() {
        return StringUtils.trimToNull((String)((String)this.get(SFTP_HOST)));
    }

    public String getSftpLoginPass() {
        return StringUtils.trimToNull((String)((String)this.get(SFTP_LOGIN_PASS)));
    }

    public String getSftpLoginUser() {
        return StringUtils.trimToNull((String)((String)this.get(SFTP_LOGIN_USER)));
    }

    public String getSftpPath() {
        return StringUtils.trimToNull((String)((String)this.get(SFTP_PATH)));
    }

    public int getSftpPort() {
        String string = StringUtils.trimToNull((String)((String)this.get(SFTP_PORT)));
        return string != null ? Integer.parseInt(string) : 22;
    }

    @Override
    public String getTitle() {
        return I18N.tr("Transport to a SFTP server.");
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setSftpPath("");
        this.setSftpPort(22);
    }

    @Override
    protected boolean isUpdatingMessage() {
        return true;
    }

    @Override
    protected boolean isUpdatingProgress() {
        return true;
    }

    public void setSftpHost(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(SFTP_HOST);
        } else {
            this.put(SFTP_HOST, string);
        }
    }

    public void setSftpLoginPass(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(SFTP_LOGIN_PASS);
        } else {
            this.put(SFTP_LOGIN_PASS, string);
        }
    }

    public void setSftpLoginUser(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(SFTP_LOGIN_USER);
        } else {
            this.put(SFTP_LOGIN_USER, string);
        }
    }

    public void setSftpPath(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(SFTP_PATH);
        } else {
            this.put(SFTP_PATH, string);
        }
    }

    public void setSftpPort(int n) {
        if (n < 1) {
            this.remove(SFTP_PORT);
        } else {
            this.put(SFTP_PORT, String.valueOf(n));
        }
    }

    private static final class TransferListener
    implements SftpProgressMonitor {
        private final NumberFormat floatFormat;
        private final ImmoToolTask.Callback callback;
        private long totalSize;
        private long copiedSize = 0L;
        private long startTime = -1L;
        private long permille = -1L;
        private String currentSpeed = null;

        public TransferListener(long l, ImmoToolTask.Callback callback) {
            this.totalSize = l;
            this.callback = callback;
            this.floatFormat = NumberFormat.getNumberInstance();
            this.floatFormat.setMaximumFractionDigits(1);
        }

        public boolean count(long l) {
            this.copiedSize += l;
            if (this.copiedSize > this.totalSize) {
                this.totalSize = this.copiedSize;
            }
            long l2 = Math.round((double)this.copiedSize / (double)this.totalSize * 1000.0);
            if (this.permille < 0L || this.permille != l2) {
                this.permille = l2;
                String string = ImmoToolUtils.getHumanReadableByteCount((long)this.copiedSize, (NumberFormat)this.floatFormat);
                String string2 = ImmoToolUtils.getHumanReadableByteCount((long)this.totalSize, (NumberFormat)this.floatFormat);
                if (this.currentSpeed == null || this.permille % 10L == 0L) {
                    long l3 = 0L;
                    if (this.startTime < 0L) {
                        this.startTime = System.currentTimeMillis() / 1000L;
                    } else {
                        l3 = System.currentTimeMillis() / 1000L - this.startTime;
                    }
                    if (l3 > 0L) {
                        long l4 = Math.round((double)this.copiedSize / (double)l3);
                        this.currentSpeed = ImmoToolUtils.getHumanReadableByteCount((long)l4, (NumberFormat)this.floatFormat) + "/s";
                    }
                }
                if (this.currentSpeed != null) {
                    string2 = string2 + " (" + this.currentSpeed + ")";
                }
                this.callback.setMessage(I18N.tr("{0} of {1}", (Object)string, (Object)string2));
                this.callback.setProgress((float)this.permille / 1000.0f);
            }
            try {
                this.callback.checkCancelled();
            }
            catch (CancellationException cancellationException) {
                throw new RuntimeException("Transfer was cancelled by user!", cancellationException);
            }
            return true;
        }

        public void init(int n, String string, String string2, long l) {
        }

        public void end() {
        }
    }

    public static final class TransferFailedException
    extends Exception {
        public TransferFailedException(String string) {
            super(string);
        }

        public TransferFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class Request
    extends AbstractTransportRequest<SftpTransport> {
        private final File exportFile;
        private final String stampFileName;
        private ExportContext currentContext = null;
        private SftpClient currentClient = null;
        private TransferListener currentTransferListener = null;

        public Request(SftpTransport sftpTransport, File file) {
            this(sftpTransport, file, null);
        }

        public Request(SftpTransport sftpTransport, File file, String string) {
            super(sftpTransport);
            if (file == null) {
                throw new IllegalArgumentException("No export file was specified!");
            }
            if (!file.isFile() && !file.isDirectory()) {
                throw new IllegalArgumentException("The export file is neither a file nor a directory (" + file.getAbsolutePath() + ")!");
            }
            this.exportFile = file;
            this.stampFileName = StringUtils.trimToNull((String)string);
        }

        protected SftpClient doConnect(ExportContext exportContext) throws IOException, SshUtils.AuthenticationFailedException, SshUtils.ConnectionFailedException {
            SftpTransport sftpTransport = (SftpTransport)this.getTransport();
            Session session = SshUtils.createSession((String)sftpTransport.getSftpHost(), (int)sftpTransport.getSftpPort(), (String)sftpTransport.getSftpLoginUser(), (String)sftpTransport.getSftpLoginPass());
            SftpClient sftpClient = new SftpClient(session);
            sftpClient.connect();
            return sftpClient;
        }

        protected void doDisconnect(SftpClient sftpClient) {
            sftpClient.disconnect();
        }

        protected final SftpClient doReconnect(String string) throws IOException, SshUtils.AuthenticationFailedException, SshUtils.ConnectionFailedException {
            if (this.currentClient != null) {
                this.doDisconnect(this.currentClient);
                this.currentClient = null;
            }
            this.currentClient = this.doConnect(this.currentContext);
            if (!StringUtils.isBlank((CharSequence)string)) {
                try {
                    this.currentClient.cd(string);
                }
                catch (IOException iOException) {
                    throw new IOException("Can't change directory!", iOException);
                }
            }
            return this.currentClient;
        }

        protected void doSend(File file, String string, int n, ImmoToolTask.Callback callback) throws TransferFailedException, CancellationException {
            block34: {
                SftpClient sftpClient = this.getCurrentClient();
                if (file.isFile()) {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        callback.checkCancelled();
                        sftpClient.put((InputStream)fileInputStream, file.getName(), (SftpProgressMonitor)this.currentTransferListener);
                        break block34;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Can't store file '" + file.getName() + "' into remote folder '" + string + "'!");
                        if (n < 3) {
                            callback.checkCancelled();
                            this.doDisconnect(sftpClient);
                            LOGGER.info("Trying to reconnect, attempt #" + ++n);
                            try {
                                LOGGER.info("> Waiting for 10 seconds...");
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                callback.checkCancelled();
                                this.doReconnect(string);
                                this.doSend(file, string, n, callback);
                                break block34;
                            }
                            catch (Exception exception) {
                                LOGGER.error("Reconnection #" + n + " failed: " + exception.getLocalizedMessage());
                                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                                throw new TransferFailedException("Can't store '" + file.getName() + "' into remote folder '" + string + "'!", iOException);
                            }
                        }
                        throw new TransferFailedException("Can't store '" + file.getName() + "' into remote folder '" + string + "'!", iOException);
                    }
                    catch (Exception exception) {
                        throw new TransferFailedException("Can't store '" + file.getName() + "' into remote folder '" + string + "'!", exception);
                    }
                }
                if (file.isDirectory()) {
                    callback.checkCancelled();
                    String string2 = string;
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    string2 = string2 + file.getName();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        callback.checkCancelled();
                        for (ChannelSftp.LsEntry lsEntry : sftpClient.ls()) {
                            arrayList.add(lsEntry.getFilename());
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Can't retrieve directory listing from SFTP server!");
                        LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
                    }
                    try {
                        callback.checkCancelled();
                        if (!arrayList.contains(file.getName())) {
                            sftpClient.mkdir(file.getName());
                        }
                    }
                    catch (IOException iOException) {
                        throw new TransferFailedException("Can't create directory: " + string2, iOException);
                    }
                    try {
                        callback.checkCancelled();
                        sftpClient.cd(file.getName());
                    }
                    catch (IOException iOException) {
                        throw new TransferFailedException("Can't change working directory: " + string2, iOException);
                    }
                    for (File file2 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                        callback.checkCancelled();
                        this.doSend(file2, string2, 0, callback);
                    }
                    try {
                        sftpClient.cdUp();
                    }
                    catch (IOException iOException) {
                        throw new TransferFailedException("Can't change to parent directory of " + string2, iOException);
                    }
                }
                LOGGER.warn("Invalid source file '" + file.getAbsolutePath() + "' for FTP transport!");
            }
        }

        protected void doTransportFinish(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            if (sftpClient == null) {
                throw new IllegalStateException("No SFTP channel was loaded!");
            }
        }

        protected void doTransportInit(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            block61: {
                StringBuilder stringBuilder;
                block63: {
                    Object[] iOException;
                    Object throwable2;
                    block62: {
                        boolean bl;
                        File file2;
                        if (sftpClient == null) {
                            throw new IllegalStateException("No SFTP channel was loaded!");
                        }
                        if (this.stampFileName == null) break block61;
                        File file3 = file != null && file.isFile() ? file.getAbsoluteFile().getParentFile() : (file2 = file != null && file.isDirectory() ? file : null);
                        if (file2 == null || !file2.isDirectory()) {
                            throw new IllegalArgumentException("An invalid export directory was specified!");
                        }
                        callback.checkCancelled();
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(System.currentTimeMillis()).append("\n");
                        Object[] objectArray2 = (File[])ObjectUtils.defaultIfNull((Object)file2.listFiles(), (Object)new File[0]);
                        if (ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                            for (Object objectArray3 : objectArray2) {
                                ImmoToolUtils.buildFileList((File)objectArray3, (String)"", (StringBuilder)stringBuilder);
                            }
                        }
                        ArrayList arrayList = new ArrayList();
                        try {
                            callback.checkCancelled();
                            for (ChannelSftp.LsEntry lsEntry : sftpClient.ls()) {
                                arrayList.add(lsEntry.getFilename());
                            }
                        }
                        catch (IOException iOException2) {
                            throw new IOException("Can't read existing files from SFTP server!", iOException2);
                        }
                        boolean bl2 = bl = !arrayList.contains(this.stampFileName);
                        if (!bl) break block62;
                        callback.checkCancelled();
                        if (ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                            for (Object throwable2 : objectArray2) {
                                if (!arrayList.contains(((File)throwable2).getName())) continue;
                                throw new IOException("The file '" + ((File)throwable2).getName() + "' already exists on the SFTP server!");
                            }
                        }
                        break block63;
                    }
                    File file4 = null;
                    Object object = null;
                    try {
                        callback.checkCancelled();
                        file4 = File.createTempFile("sftp.", ".stamp");
                        Object object2 = new FileOutputStream(file4);
                        throwable2 = null;
                        try {
                            sftpClient.get(this.stampFileName, (OutputStream)object2);
                            ((OutputStream)object2).flush();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (object2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)object2).close();
                                    }
                                    catch (Throwable iOException3) {
                                        ((Throwable)throwable2).addSuppressed(iOException3);
                                    }
                                } else {
                                    ((OutputStream)object2).close();
                                }
                            }
                        }
                        object2 = ImmoToolUtils.readFile((File)file4);
                        iOException = ((String)object2).split("\\n");
                    }
                    catch (IOException iOException4) {
                        try {
                            throw new IOException("Can't download '" + this.stampFileName + "' from FTP server!", iOException4);
                        }
                        catch (Throwable throwable4) {
                            FileUtils.deleteQuietly(file4);
                            throw throwable4;
                        }
                    }
                    FileUtils.deleteQuietly((File)file4);
                    if (iOException != null && !ArrayUtils.isEmpty((Object[])iOException)) {
                        for (int i = 1; i < iOException.length; ++i) {
                            callback.checkCancelled();
                            throwable2 = StringUtils.trimToNull((String)iOException[i]);
                            if (throwable2 == null) continue;
                            try {
                                if (((String)throwable2).endsWith("/")) {
                                    String string = ((String)throwable2).substring(0, ((String)throwable2).length() - 1);
                                    sftpClient.rmdir(string, true);
                                    continue;
                                }
                                sftpClient.rm((String)throwable2);
                                continue;
                            }
                            catch (IOException iOException5) {
                                LOGGER.warn("Can't delete '" + (String)throwable2 + "' from SFTP server!");
                                LOGGER.warn("> " + iOException5.getLocalizedMessage(), (Throwable)iOException5);
                            }
                        }
                    }
                }
                File file5 = File.createTempFile(this.stampFileName, "");
                try {
                    try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file5, "UTF-8");){
                        fileWriterWithEncoding.write(stringBuilder.toString());
                        fileWriterWithEncoding.flush();
                    }
                    var12_29 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(file5);){
                        sftpClient.put((InputStream)fileInputStream, this.stampFileName);
                    }
                    catch (Throwable throwable) {
                        var12_29 = throwable;
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw new IOException("Can't write '" + this.stampFileName + "' to SFTP server!", iOException);
                }
                finally {
                    FileUtils.deleteQuietly((File)file5);
                }
            }
        }

        @Override
        public AbstractTransportRequest[] getChildRequests() {
            return null;
        }

        protected final SftpClient getCurrentClient() {
            return this.currentClient;
        }

        public final String getStampFileName() {
            return this.stampFileName;
        }

        @Override
        public String getTitle() {
            return I18N.tr("Transferring files via {0}.", (Object)"SFTP");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ExportContext exportContext, ImmoToolTask.Callback callback) throws AbstractTransportRequest.TransferException {
            SftpTransport sftpTransport = (SftpTransport)this.getTransport();
            try {
                block21: {
                    this.currentContext = exportContext;
                    if (this.currentClient != null) {
                        this.doDisconnect(this.currentClient);
                    }
                    long l = this.exportFile.isDirectory() ? FileUtils.sizeOfDirectory((File)this.exportFile) : this.exportFile.length();
                    this.currentTransferListener = new TransferListener(l, callback);
                    try {
                        this.currentClient = this.doConnect(exportContext);
                    }
                    catch (SshUtils.AuthenticationFailedException authenticationFailedException) {
                        throw new AbstractTransportRequest.TransferException("Can't login at the SFTP server!", authenticationFailedException);
                    }
                    catch (SshUtils.ConnectionFailedException connectionFailedException) {
                        throw new AbstractTransportRequest.TransferException("Can't connect to the SFTP server!", connectionFailedException);
                    }
                    catch (IOException iOException) {
                        throw new AbstractTransportRequest.TransferException("Can't connect to SFTP server!", iOException);
                    }
                    String string = StringUtils.trimToNull((String)sftpTransport.getSftpPath());
                    try {
                        if (StringUtils.isBlank((CharSequence)string)) {
                            string = this.currentClient.getHome();
                        }
                        this.currentClient.cd(string);
                    }
                    catch (IOException iOException) {
                        throw new AbstractTransportRequest.TransferException("Can't change working directory to '" + string + "'!", iOException);
                    }
                    try {
                        this.doTransportInit(this.currentClient, this.exportFile, this.currentContext, callback);
                    }
                    catch (IOException iOException) {
                        throw new AbstractTransportRequest.TransferException("Can't initialize FTP transfer!", iOException);
                    }
                    try {
                        if (this.exportFile.isDirectory()) {
                            Object[] objectArray = this.exportFile.listFiles();
                            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                                for (Object object : objectArray) {
                                    callback.checkCancelled();
                                    this.doSend((File)object, StringUtils.trimToEmpty((String)string), 0, callback);
                                }
                            }
                            break block21;
                        }
                        if (this.exportFile.isFile()) {
                            callback.checkCancelled();
                            this.doSend(this.exportFile, StringUtils.trimToEmpty((String)string), 0, callback);
                            break block21;
                        }
                        throw new AbstractTransportRequest.TransferException("The export file is invalid!");
                    }
                    catch (TransferFailedException transferFailedException) {
                        throw new AbstractTransportRequest.TransferException(transferFailedException.getLocalizedMessage(), transferFailedException);
                    }
                }
                try {
                    this.doTransportFinish(this.currentClient, this.exportFile, this.currentContext, callback);
                }
                catch (IOException iOException) {
                    throw new AbstractTransportRequest.TransferException("Can't finalize SFTP transfer!", iOException);
                }
            }
            finally {
                this.doDisconnect(this.currentClient);
                this.currentClient = null;
                this.currentTransferListener = null;
                this.currentContext = null;
            }
        }
    }
}

