/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.PortNrField;
import com.openindex.openestate.tool.utils.SftpClient;
import com.openindex.openestate.tool.utils.SshUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SftpTransportPanel
extends AbstractTransportPanel<SftpTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpTransportPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(SftpTransportPanel.class);
    private ValidationHandler validationHandler;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private PortNrField portField;
    private JLabel userLabel;
    private JTextField userField;
    private JLabel passLabel;
    private JPasswordField passField;
    private JLabel pathLabel;
    private JTextField pathField;
    private JXTitledSeparator testTitle;
    private TestAction testAction;
    private JXBusyLabel testBusyLabel;
    private TestTask testTask = null;

    public SftpTransportPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new PortNrField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passLabel = new JLabel();
        this.passField = new JPasswordField();
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        this.testTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.testAction = new TestAction();
        this.testBusyLabel = new JXBusyLabel();
        this.testBusyLabel.setVisible(false);
        this.validationHandler.putRule((JComponent)this.hostField, ValidationHandler.HOSTNAME);
        this.validationHandler.putRule((JComponent)this.userField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.passField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow, 3dlu,right:pref, 3dlu, 30dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.hostLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.hostField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.userLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.userField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.passLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.passField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.pathLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.pathField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.testTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.testAction))).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.testBusyLabel).xyw(3, defaultFormBuilder.row(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (SftpTransport)null);
    }

    private void doTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided transport settings are incomplete!"), (Component)((Object)this));
            return;
        }
        this.testAction.setEnabled(false);
        this.testBusyLabel.setBusy(true);
        this.testBusyLabel.setText("<html><b>" + I18N.tr("Testing connection.") + "</b><br>" + I18N.tr("Please wait for a moment.") + "</html>");
        this.testBusyLabel.setVisible(true);
        this.testTask = new TestTask();
        ImmoToolUtils.executeTask((ImmoToolTask)this.testTask);
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, SftpTransport sftpTransport) {
        if (this.testTask != null && !this.testTask.isDone()) {
            this.testTask.cancel(true);
        }
        if (sftpTransport == null) {
            this.hostField.setText("");
            this.passField.setText("");
            this.pathField.setText("");
            this.portField.setPortNr(22);
            this.userField.setText("");
        } else {
            this.hostField.setText(sftpTransport.getSftpHost());
            this.passField.setText(sftpTransport.getSftpLoginPass());
            this.pathField.setText(sftpTransport.getSftpPath());
            this.portField.setValue((Object)sftpTransport.getSftpPort());
            this.userField.setText(sftpTransport.getSftpLoginUser());
        }
        this.testTask = null;
        this.testBusyLabel.setBusy(false);
        this.testBusyLabel.setVisible(false);
        this.testAction.setEnabled(true);
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, SftpTransport sftpTransport) {
        if (sftpTransport == null) {
            throw new NullPointerException("empty transport-class!");
        }
        if (this.testTask != null && !this.testTask.isDone()) {
            this.testTask.cancel(true);
        }
        sftpTransport.setSftpHost(this.hostField.getText().trim());
        sftpTransport.setSftpLoginUser(this.userField.getText().trim());
        sftpTransport.setSftpLoginPass(String.valueOf(this.passField.getPassword()).trim());
        sftpTransport.setSftpPath(this.pathField.getText().trim());
        sftpTransport.setSftpPort(this.portField.getPortNr());
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.hostLabel.setText(StringUtils.capitalize((String)I18N.tr("hostname")) + ":");
        this.hostField.setToolTipText(I18N.tr("Enter the hostname / IP address of the server."));
        this.portLabel.setText(StringUtils.capitalize((String)"port-nr") + ":");
        this.portField.setToolTipText(I18N.tr("Enter the port-nr of the server. The default port-nr is {0}.", (Object)"22"));
        this.userLabel.setText(StringUtils.capitalize((String)"user") + ":");
        this.userField.setToolTipText(I18N.tr("Enter the user name for authentication at the server."));
        this.passLabel.setText(StringUtils.capitalize((String)"password") + ":");
        this.passField.setToolTipText(I18N.tr("Enter the password for authentication at the server."));
        this.pathLabel.setText(StringUtils.capitalize((String)I18N.tr("server path")) + ":");
        this.pathField.setToolTipText(I18N.tr("Enter the path at the SFTP-server, where uploaded files will be saved to."));
        this.testTitle.setTitle(StringUtils.capitalize((String)I18N.tr("test connection")));
    }

    private class TestTask
    extends ImmoToolTask<Boolean, Void> {
        private TestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            SftpClient sftpClient = null;
            try {
                String string;
                try {
                    string = SftpTransportPanel.this.hostField.getText().trim();
                    int n = SftpTransportPanel.this.portField.getPortNr();
                    String string2 = SftpTransportPanel.this.userField.getText().trim();
                    String string3 = String.valueOf(SftpTransportPanel.this.passField.getPassword()).trim();
                    sftpClient = new SftpClient(string, n, string2, string3);
                    sftpClient.connect();
                }
                catch (SshUtils.AuthenticationFailedException authenticationFailedException) {
                    LOGGER.warn("Login denied!");
                    LOGGER.warn("> " + authenticationFailedException.getLocalizedMessage(), (Throwable)authenticationFailedException);
                    throw new Exception(I18N.tr("Login denied! Please check username and password!"), authenticationFailedException);
                }
                catch (SshUtils.ConnectionFailedException connectionFailedException) {
                    LOGGER.warn("Connection denied!");
                    LOGGER.warn("> " + connectionFailedException.getLocalizedMessage(), (Throwable)connectionFailedException);
                    throw new Exception(I18N.tr("Connection denied! Please check hostname and port-nr!"), connectionFailedException);
                }
                catch (Exception exception) {
                    LOGGER.warn("The connection test failed!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    throw new Exception("The connection test failed!", exception);
                }
                string = StringUtils.trimToNull((String)SftpTransportPanel.this.pathField.getText().trim());
                if (StringUtils.isBlank((CharSequence)string)) {
                    string = sftpClient.getHome();
                }
                try {
                    LOGGER.debug("lookup path: " + string);
                    for (String string2 : sftpClient.ls(string)) {
                        LOGGER.debug("found file: " + string2.getFilename());
                    }
                }
                catch (Exception exception) {
                    throw new Exception(I18N.tr("The provided path was not found on the server!"), exception);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                try {
                    if (sftpClient != null) {
                        sftpClient.disconnect();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error on SFTP-disconnection!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        protected void cancelled() {
            super.cancelled();
            SftpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test was cancelled!") + "</b></html>");
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            SftpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test failed!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
        }

        protected void finished() {
            super.finished();
            SftpTransportPanel.this.testTask = null;
            SftpTransportPanel.this.testBusyLabel.setBusy(false);
            SftpTransportPanel.this.testAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            SftpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test was successful!") + "</b></html>");
        }
    }

    private class TestAction
    extends AbstractI18nAction {
        public TestAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SftpTransportPanel.this.doTest();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Let the program try to connect to the configured server."));
        }
    }
}

