/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jcraft.jsch.ChannelSftp;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractPhpFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.agency.export.WebsitePhp1Builder;
import com.openindex.openestate.tool.agency.export.WebsitePhp1FormatPanel;
import com.openindex.openestate.tool.utils.FtpUtils;
import com.openindex.openestate.tool.utils.SftpClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsitePhp1Format
extends AbstractPhpFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitePhp1Format.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsitePhp1Format.class);
    private static final String NAME = "website_php";
    private static final String STAMP = "immotool.php.stamp";
    private static final String LOCK = "immotool.php.lock";
    private static final String PHP_FEED_ATOM = "website_php.feed.atom";
    private static final String PHP_FEED_RSS = "website_php.feed.rss";
    private static final String PHP_FEED_TROVIT = "website_php.feed.trovit";
    private static final String PHP_SAVE_SCRIPTS = "website_php.saveScripts";
    private static final String PHP_SHOW_CONTACT_FORM = "website_php.show.contactForm";
    private static final String PHP_SHOW_CONTACT_PERSON = "website_php.show.contactPerson";
    private static final String PHP_SHOW_TERMS = "website_php.show.terms";
    private static final String PHP_TITLE = "website_php.title";
    private static final String PHP_STYLESHEET = "website_php.stylesheet";

    @Override
    protected FtpTransport.Request createExportRequestForFtp(FtpTransport ftpTransport, File file) {
        return new FtpTransfer(ftpTransport, file);
    }

    @Override
    protected SftpTransport.Request createExportRequestForSftp(SftpTransport sftpTransport, File file) {
        return new SftpTransfer(sftpTransport, file);
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new WebsitePhp1FormatPanel();
    }

    @Override
    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) {
        String string = StringUtils.trimToNull((String)this.getPropertyPrefix());
        string = string != null ? string + "-" : "";
        return new File(new File(file, "data"), string + l);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getPhpStylesheet() {
        return StringUtils.trimToNull((String)((String)this.get(PHP_STYLESHEET)));
    }

    public String getPhpTitle() {
        return StringUtils.trimToNull((String)((String)this.get(PHP_TITLE)));
    }

    public static Locale[] getSupportedLocales() {
        return AgencyPlugin.getLocalesWithLanguagePack();
    }

    @Override
    protected int getThumbnailHeight() {
        return 75;
    }

    @Override
    protected int getThumbnailWidth() {
        return 100;
    }

    @Override
    public String getTitle() {
        return "Website: PHP-Export 1.x";
    }

    @Override
    public String getVersion() {
        return AgencyPlugin.getInstance().getPhpExportVersion();
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setPhpShowContactForm(true);
        this.setPhpShowContactPerson(true);
        this.setPhpShowTerms(true);
        this.setPhpFeedAtom(false);
        this.setPhpFeedRss(false);
        this.setPhpFeedTrovit(false);
    }

    public boolean isPhpFeedAtom() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_ATOM)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpFeedRss() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_RSS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpFeedTrovit() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_TROVIT)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    public boolean isPhpSaveScripts() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_SAVE_SCRIPTS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpShowContactForm() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_SHOW_CONTACT_FORM)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpShowContactPerson() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_SHOW_CONTACT_PERSON)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpShowTerms() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_SHOW_TERMS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public void setPhpFeedAtom(boolean bl) {
        this.put(PHP_FEED_ATOM, String.valueOf(bl));
    }

    public void setPhpFeedRss(boolean bl) {
        this.put(PHP_FEED_RSS, String.valueOf(bl));
    }

    public void setPhpFeedTrovit(boolean bl) {
        this.put(PHP_FEED_TROVIT, String.valueOf(bl));
    }

    @Override
    public void setPhpSaveScripts(boolean bl) {
        this.put(PHP_SAVE_SCRIPTS, String.valueOf(bl));
    }

    public void setPhpShowContactForm(boolean bl) {
        this.put(PHP_SHOW_CONTACT_FORM, String.valueOf(bl));
    }

    public void setPhpShowContactPerson(boolean bl) {
        this.put(PHP_SHOW_CONTACT_PERSON, String.valueOf(bl));
    }

    public void setPhpShowTerms(boolean bl) {
        this.put(PHP_SHOW_TERMS, String.valueOf(bl));
    }

    public void setPhpStylesheet(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(PHP_STYLESHEET);
        } else {
            this.put(PHP_STYLESHEET, string);
        }
    }

    public void setPhpTitle(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(PHP_TITLE);
        } else {
            this.put(PHP_TITLE, string);
        }
    }

    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException, SQLException {
        DbAgencyExpose dbAgencyExpose = this.createExpose(exportContext);
        new WebsitePhp1Builder(this).write(transferImpl, exportContext, dbAgencyExpose);
        return exportContext.getWorkDir();
    }

    private static class SftpTransfer
    extends SftpTransport.Request {
        private transient String remoteBasePath = null;

        private SftpTransfer(SftpTransport sftpTransport, File file) {
            super(sftpTransport, file);
        }

        @Override
        protected void doTransportFinish(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            super.doTransportFinish(sftpClient, file, exportContext, callback);
            String string = StringUtils.trimToEmpty((String)this.remoteBasePath);
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                callback.checkCancelled();
                String string2 = string + "sessions";
                sftpClient.chmod("777", string2);
                callback.checkCancelled();
                String string3 = string + "cache";
                sftpClient.chmod("777", string3);
                callback.checkCancelled();
                for (ChannelSftp.LsEntry lsEntry : sftpClient.ls(string3)) {
                    String string4 = lsEntry.getFilename();
                    if (lsEntry.getAttrs().isDir() || "index.html".equalsIgnoreCase(string4) || ".htaccess".equalsIgnoreCase(string4)) continue;
                    sftpClient.rm(string3 + "/" + string4);
                }
                callback.checkCancelled();
                String string5 = string + WebsitePhp1Format.LOCK;
                sftpClient.rm(string5);
            }
            catch (IOException iOException) {
                throw new IOException("Can't finish the export process!", iOException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doTransportInit(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            Object object42;
            boolean bl;
            Object object222;
            if (!file.isDirectory()) {
                return;
            }
            WebsitePhp1Format websitePhp1Format = (WebsitePhp1Format)exportContext.getFormat();
            boolean bl2 = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
            String string = StringUtils.trimToNull((String)exportContext.export.getFormat().getPropertyPrefix());
            String string2 = string != null ? string + "-" : "";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.currentTimeMillis()).append("\n");
            try {
                callback.checkCancelled();
                this.remoteBasePath = StringUtils.trimToEmpty((String)sftpClient.pwd());
            }
            catch (IOException iOException) {
                throw new IOException("Can't get current working directory from SFTP server!", iOException);
            }
            try {
                callback.checkCancelled();
                sftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), WebsitePhp1Format.LOCK);
            }
            catch (IOException iOException) {
                throw new IOException("Can't save lock file!", iOException);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                callback.checkCancelled();
                for (Object object222 : sftpClient.ls()) {
                    arrayList.add(object222.getFilename());
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't read existing files from SFTP server!", iOException);
            }
            boolean bl3 = bl = !arrayList.contains(WebsitePhp1Format.STAMP);
            if (bl) {
                void throwable3;
                File file2;
                void var15_33;
                String string3;
                int n;
                callback.checkCancelled();
                object222 = file.listFiles();
                if (object222 != null && ArrayUtils.isNotEmpty((Object[])object222)) {
                    void serializable3;
                    object42 = object222;
                    n = ((Object[])object42).length;
                    boolean bl4 = false;
                    while (serializable3 < n) {
                        string3 = object42[serializable3];
                        if (arrayList.contains(((File)((Object)string3)).getName())) {
                            throw new IOException("The file '" + ((File)((Object)string3)).getName() + "' already exists on the FTP server!");
                        }
                        ++serializable3;
                    }
                }
                callback.checkCancelled();
                object42 = new FileWriterWithEncoding[]{"data", "img"};
                n = ((String[])object42).length;
                boolean bl5 = false;
                while (var15_33 < n) {
                    string3 = object42[var15_33];
                    file2 = new File(file, string3);
                    ImmoToolUtils.buildFileList((File)file2, (String)"", (StringBuilder)stringBuilder);
                    ++var15_33;
                }
                object42 = new String[]{"templates" + File.separator + "default"};
                n = ((String[])object42).length;
                boolean string7 = false;
                while (throwable3 < n) {
                    string3 = object42[throwable3];
                    file2 = new File(file, string3);
                    ImmoToolUtils.buildFileList((File)file2, (String)"templates/", (StringBuilder)stringBuilder);
                    ++throwable3;
                }
            } else {
                Object object3;
                if (websitePhp1Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    try {
                        for (Object object42 : sftpClient.ls("templates")) {
                            object3 = object42.getFilename();
                            if (".htaccess".equals(object3) || "index.html".equals(object3) || object42.getAttrs().isDir()) continue;
                            sftpClient.rm("templates/" + (String)object3);
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't remove old template files!", iOException);
                    }
                }
                object222 = null;
                try {
                    callback.checkCancelled();
                    object222 = File.createTempFile("immotool.", ".stamp");
                    object3 = new FileOutputStream((File)object222);
                    Throwable throwable2 = null;
                    try {
                        sftpClient.get(WebsitePhp1Format.STAMP, (OutputStream)object3);
                        ((OutputStream)object3).flush();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable5 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object3 != null) {
                            if (throwable2 != null) {
                                try {
                                    ((FileOutputStream)object3).close();
                                }
                                catch (Throwable throwable) {
                                    throwable2.addSuppressed(throwable);
                                }
                            } else {
                                ((FileOutputStream)object3).close();
                            }
                        }
                    }
                    object3 = ImmoToolUtils.readFile((File)object222);
                    object42 = ((String)object3).split("\\n");
                }
                catch (IOException iOException) {
                    throw new IOException("Can't read 'immotool.php.stamp' from FTP server!", iOException);
                }
                finally {
                    FileUtils.deleteQuietly((File)object222);
                }
                if (!bl2) {
                    callback.checkCancelled();
                    try {
                        sftpClient.rmdir("data", true);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't remove old data files from FTP server!", iOException);
                    }
                    callback.checkCancelled();
                    for (String string4 : new String[]{"data"}) {
                        File file3 = new File(file, string4);
                        ImmoToolUtils.buildFileList((File)file3, (String)"", (StringBuilder)stringBuilder);
                    }
                } else {
                    Serializable serializable;
                    Object[] objectArray;
                    try {
                        for (ExportEntry exportEntry : exportContext.entries) {
                            if (!DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) continue;
                            objectArray = null;
                            if (exportContext.export.publishings.containsKey(exportEntry.objectId)) {
                                serializable = exportContext.export.publishings.get(exportEntry.objectId);
                                objectArray = StringUtils.trimToNull((String)serializable.objectKey);
                            }
                            if (objectArray == null) {
                                objectArray = string2 + exportEntry.objectId;
                            }
                            sftpClient.rmdir("data/" + objectArray, true);
                            callback.checkCancelled();
                        }
                        for (ExportEntry exportEntry : exportContext.entries) {
                            if (!DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) continue;
                            objectArray = null;
                            if (exportContext.export.publishings.containsKey(exportEntry.objectId)) {
                                serializable = exportContext.export.publishings.get(exportEntry.objectId);
                                objectArray = StringUtils.trimToNull((String)serializable.objectKey);
                            }
                            if (objectArray == null) {
                                objectArray = string2 + exportEntry.objectId;
                            }
                            sftpClient.rmdir("data/" + (String)objectArray, true);
                            callback.checkCancelled();
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't remove old data files from FTP server!", iOException);
                    }
                    callback.checkCancelled();
                    for (ExportEntry exportEntry : exportContext.entries) {
                        if (!DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) continue;
                        objectArray = string2 + exportEntry.objectId;
                        serializable = new File(new File(file, "data"), (String)objectArray);
                        ImmoToolUtils.buildFileList((File)serializable, (String)"data/", (StringBuilder)stringBuilder);
                    }
                    callback.checkCancelled();
                    for (int i = 1; i < ((FileWriterWithEncoding)object42).length; ++i) {
                        FileWriterWithEncoding fileWriterWithEncoding = object42[i];
                        if (fileWriterWithEncoding == null || !fileWriterWithEncoding.matches("data/[\\w\\-]*/.*")) continue;
                        stringBuilder.append((String)fileWriterWithEncoding).append("\n");
                    }
                    callback.checkCancelled();
                    object3 = new File(file, "data");
                    Object[] objectArray2 = ((File)object3).listFiles();
                    if (objectArray2 != null && ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                        for (Object object : objectArray2) {
                            if (!((File)object).isFile()) continue;
                            stringBuilder.append("data/").append(((File)object).getName()).append("\n");
                        }
                    }
                    stringBuilder.append("data/").append("\n");
                }
                callback.checkCancelled();
                for (String string5 : new String[]{"img"}) {
                    File file4 = new File(file, string5);
                    ImmoToolUtils.buildFileList((File)file4, (String)"", (StringBuilder)stringBuilder);
                }
                for (String string6 : new String[]{"templates" + File.separator + "default"}) {
                    File file5 = new File(file, string6);
                    ImmoToolUtils.buildFileList((File)file5, (String)"templates/", (StringBuilder)stringBuilder);
                }
                if (websitePhp1Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    for (int i = 1; i < ((Object)object42).length; ++i) {
                        String string7;
                        String string8 = string7 = object42[i] != null ? ((String)object42[i]).trim() : null;
                        if (string7 == null || StringUtils.isBlank((CharSequence)string7) || string7.startsWith("data/")) continue;
                        try {
                            if (string7.endsWith("/")) {
                                String string9 = string7.substring(0, string7.length() - 1);
                                sftpClient.rmdir(string9);
                                callback.checkCancelled();
                                continue;
                            }
                            try {
                                sftpClient.rm(string7);
                            }
                            catch (Exception exception) {
                                LOGGER.debug("File to remove was not found.");
                            }
                            callback.checkCancelled();
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't delete existing file from FTP-server!");
                            LOGGER.warn("> path: " + string7);
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
                if (arrayList.contains("private.php")) {
                    File file6 = new File(file, "private.php");
                    if (file6.isFile()) {
                        FileUtils.deleteQuietly((File)file6);
                    }
                    callback.checkCancelled();
                }
                if (arrayList.contains("myconfig.php")) {
                    File file7 = new File(file, "myconfig.php");
                    if (file7.isFile()) {
                        FileUtils.deleteQuietly((File)file7);
                    }
                    callback.checkCancelled();
                }
            }
            object222 = File.createTempFile(WebsitePhp1Format.STAMP, "");
            try {
                object42 = new FileWriterWithEncoding((File)object222, "UTF-8");
                Throwable throwable = null;
                try {
                    ((Writer)object42).write(stringBuilder.toString());
                    ((Writer)object42).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object42 != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)object42).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Writer)object42).close();
                        }
                    }
                }
                object42 = new FileInputStream((File)object222);
                throwable = null;
                try {
                    sftpClient.put((InputStream)object42, WebsitePhp1Format.STAMP);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (object42 != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object42).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)object42).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't write 'immotool.php.stamp' to SFTP server!", iOException);
            }
            finally {
                FileUtils.deleteQuietly((File)object222);
            }
        }
    }

    private static class FtpTransfer
    extends FtpTransport.Request {
        private transient String remoteBasePath = null;

        private FtpTransfer(FtpTransport ftpTransport, File file) {
            super(ftpTransport, file);
        }

        @Override
        protected void doTransportFinish(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            super.doTransportFinish(fTPClient, file, exportContext, callback);
            String string = StringUtils.trimToEmpty((String)this.remoteBasePath);
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                callback.checkCancelled();
                String string2 = string + "sessions";
                if (fTPClient.site("CHMOD 777 " + string2) != 200) {
                    LOGGER.warn("Can't CHMOD the sessions-directory!");
                }
                callback.checkCancelled();
                String string3 = string + "cache";
                if (fTPClient.site("CHMOD 777 " + string3) != 200) {
                    LOGGER.warn("Can't CHMOD the cache-directory!");
                }
                callback.checkCancelled();
                for (FTPFile fTPFile : fTPClient.listFiles(string3)) {
                    if (fTPFile.getType() != 0 || "index.html".equalsIgnoreCase(fTPFile.getName()) || ".htaccess".equalsIgnoreCase(fTPFile.getName()) || fTPClient.deleteFile(string3 + "/" + fTPFile.getName())) continue;
                    LOGGER.warn("Can't remove file: " + string3 + "/" + fTPFile.getName());
                }
                callback.checkCancelled();
                String string4 = string + WebsitePhp1Format.LOCK;
                if (!fTPClient.deleteFile(string4)) {
                    LOGGER.warn("Can't remove lock-file from: " + string4);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't finish the export process!", iOException);
            }
        }

        @Override
        protected void doTransportInit(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            Object object;
            boolean bl;
            List<Object> list;
            if (!file.isDirectory()) {
                return;
            }
            WebsitePhp1Format websitePhp1Format = (WebsitePhp1Format)exportContext.getFormat();
            boolean bl2 = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
            String string = StringUtils.trimToNull((String)exportContext.export.getFormat().getPropertyPrefix());
            String string2 = string != null ? string + "-" : "";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.currentTimeMillis()).append("\n");
            try {
                callback.checkCancelled();
                this.remoteBasePath = FtpUtils.getWorkingDirectory((FTPClient)fTPClient);
            }
            catch (IOException iOException) {
                throw new IOException("Can't get current working directory from FTP server!", iOException);
            }
            try {
                callback.checkCancelled();
                if (!FtpUtils.storeEmptyFile((FTPClient)fTPClient, (String)WebsitePhp1Format.LOCK)) {
                    LOGGER.warn("Can't save lock-file!");
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't save lock file!", iOException);
            }
            try {
                callback.checkCancelled();
                list = Arrays.asList((Object[])ObjectUtils.defaultIfNull((Object)fTPClient.listNames(), (Object)new String[0]));
                fTPClient.sendNoOp();
            }
            catch (IOException iOException) {
                throw new IOException("Can't read file names from FTP server!", iOException);
            }
            boolean bl3 = bl = !list.contains(WebsitePhp1Format.STAMP);
            if (bl) {
                File file2;
                callback.checkCancelled();
                for (File file3 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                    if (!list.contains(file3.getName())) continue;
                    throw new IOException("The file '" + file3.getName() + "' already exists on the FTP server!");
                }
                callback.checkCancelled();
                for (File file3 : new String[]{"data", "img"}) {
                    file2 = new File(file, (String)((Object)file3));
                    ImmoToolUtils.buildFileList((File)file2, (String)"", (StringBuilder)stringBuilder);
                }
                for (File string6 : new String[]{"templates" + File.separator + "default"}) {
                    file2 = new File(file, (String)((Object)string6));
                    ImmoToolUtils.buildFileList((File)file2, (String)"templates/", (StringBuilder)stringBuilder);
                }
            } else {
                String[] stringArray;
                Object object2;
                if (websitePhp1Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    try {
                        for (File file4 : fTPClient.listFiles("templates")) {
                            if (!file4.isFile() || file4.getName().equals("index.html")) continue;
                            fTPClient.deleteFile("templates/" + file4.getName());
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't remove old template files!", iOException);
                    }
                }
                object = null;
                try {
                    callback.checkCancelled();
                    object = File.createTempFile("immotool.", ".stamp");
                    FtpUtils.downloadToFile((FTPClient)fTPClient, (String)WebsitePhp1Format.STAMP, (File)object);
                    object2 = ImmoToolUtils.readFile((File)object);
                    stringArray = ((String)object2).split("\\n");
                }
                catch (Exception exception) {
                    throw new IOException("Can't read 'immotool.php.stamp' from FTP server!", exception);
                }
                finally {
                    FileUtils.deleteQuietly((File)object);
                }
                if (!bl2) {
                    callback.checkCancelled();
                    try {
                        FtpUtils.deleteRecursively((FTPClient)fTPClient, (String)"data");
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't remove old data files from FTP server!", exception);
                    }
                    callback.checkCancelled();
                    for (String string3 : new String[]{"data"}) {
                        File file5 = new File(file, string3);
                        ImmoToolUtils.buildFileList((File)file5, (String)"", (StringBuilder)stringBuilder);
                    }
                } else {
                    Serializable serializable;
                    Object[] objectArray;
                    try {
                        for (ExportEntry throwable : exportContext.entries) {
                            if (!DbAgencyExportAction.UPDATE.equals((Object)throwable.action) && !DbAgencyExportAction.DELETE.equals((Object)throwable.action)) continue;
                            objectArray = null;
                            if (exportContext.export.publishings.containsKey(throwable.objectId)) {
                                serializable = exportContext.export.publishings.get(throwable.objectId);
                                objectArray = StringUtils.trimToNull((String)serializable.objectKey);
                            }
                            if (objectArray == null) {
                                objectArray = string2 + throwable.objectId;
                            }
                            FtpUtils.deleteRecursively((FTPClient)fTPClient, (String)("data/" + objectArray));
                            callback.checkCancelled();
                        }
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't remove old data files from FTP server!", exception);
                    }
                    callback.checkCancelled();
                    for (ExportEntry exportEntry : exportContext.entries) {
                        if (!DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) continue;
                        objectArray = string2 + exportEntry.objectId;
                        serializable = new File(new File(file, "data"), (String)objectArray);
                        ImmoToolUtils.buildFileList((File)serializable, (String)"data/", (StringBuilder)stringBuilder);
                    }
                    callback.checkCancelled();
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string4 = stringArray[i];
                        if (string4 == null || !string4.matches("data/[\\w\\-]*/.*")) continue;
                        stringBuilder.append(string4).append("\n");
                    }
                    callback.checkCancelled();
                    object2 = new File(file, "data");
                    Object[] objectArray2 = ((File)object2).listFiles();
                    if (objectArray2 != null && ArrayUtils.isNotEmpty((Object[])objectArray2)) {
                        for (Object object3 : objectArray2) {
                            if (!((File)object3).isFile()) continue;
                            stringBuilder.append("data/").append(((File)object3).getName()).append("\n");
                        }
                    }
                    stringBuilder.append("data/").append("\n");
                }
                callback.checkCancelled();
                for (String string5 : new String[]{"img"}) {
                    File file6 = new File(file, string5);
                    ImmoToolUtils.buildFileList((File)file6, (String)"", (StringBuilder)stringBuilder);
                }
                for (String string6 : new String[]{"templates" + File.separator + "default"}) {
                    File file7 = new File(file, string6);
                    ImmoToolUtils.buildFileList((File)file7, (String)"templates/", (StringBuilder)stringBuilder);
                }
                if (websitePhp1Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string7 = StringUtils.trimToNull((String)stringArray[i]);
                        if (string7 == null || string7.startsWith("data/")) continue;
                        try {
                            if (string7.endsWith("/")) {
                                String string8 = string7.substring(0, string7.length() - 1);
                                if (!fTPClient.removeDirectory(string8)) {
                                    LOGGER.warn("Can't remove directory: " + string8);
                                }
                                callback.checkCancelled();
                                continue;
                            }
                            if (!fTPClient.deleteFile(string7)) {
                                LOGGER.warn("Can't remove file: " + string7);
                            }
                            callback.checkCancelled();
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't delete existing file from FTP-server!");
                            LOGGER.warn("> path: " + string7);
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
                if (list.contains("private.php")) {
                    File file7 = new File(file, "private.php");
                    if (file7.isFile()) {
                        FileUtils.deleteQuietly((File)file7);
                    }
                    callback.checkCancelled();
                }
                if (list.contains("myconfig.php")) {
                    File file8 = new File(file, "myconfig.php");
                    if (file8.isFile()) {
                        FileUtils.deleteQuietly((File)file8);
                    }
                    callback.checkCancelled();
                }
            }
            object = File.createTempFile(WebsitePhp1Format.STAMP, "");
            try {
                try (Object object5 = new FileWriterWithEncoding((File)object, "UTF-8");){
                    ((Writer)object5).write(stringBuilder.toString());
                    ((Writer)object5).flush();
                }
                object5 = new FileInputStream((File)object);
                var14_32 = null;
                try {
                    if (!fTPClient.setFileType(2)) {
                        LOGGER.warn("Can't change file-type!");
                    }
                    if (!fTPClient.storeFile(WebsitePhp1Format.STAMP, (InputStream)object5)) {
                        LOGGER.warn("Can't store file: " + ((File)object).getName());
                    }
                }
                catch (Throwable throwable) {
                    var14_32 = throwable;
                    throw throwable;
                }
                finally {
                    if (object5 != null) {
                        if (var14_32 != null) {
                            try {
                                ((InputStream)object5).close();
                            }
                            catch (Throwable throwable) {
                                var14_32.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object5).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't write 'immotool.php.stamp' to FTP server!", iOException);
            }
            finally {
                FileUtils.deleteQuietly((File)object);
            }
        }
    }
}

