/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.PdfVitrineExpose;
import com.openindex.openestate.tool.agency.gui.ExposeHorizontalAlignRenderer;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.ColorPickButton;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfVitrineExposePanel
extends AbstractExposePanel<PdfVitrineExpose> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfVitrineExposePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfVitrineExposePanel.class);
    private ValidationHandler validationHandler;
    private JTabbedPane tabbedPane;
    private GeneralTab generalTab;
    private ContentTab contentTab;
    private AbstractExposePanel.EncryptionTab encryptionTab;

    public PdfVitrineExposePanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.tabbedPane = new JTabbedPane();
        this.generalTab = (GeneralTab)ImmoToolUtils.addTab((AbstractTab)new GeneralTab(), (JTabbedPane)this.tabbedPane);
        this.contentTab = (ContentTab)ImmoToolUtils.addTab((AbstractTab)new ContentTab(), (JTabbedPane)this.tabbedPane);
        this.encryptionTab = (AbstractExposePanel.EncryptionTab)ImmoToolUtils.addTab((AbstractTab)new AbstractExposePanel.EncryptionTab(), (JTabbedPane)this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add(this.tabbedPane, "Center");
    }

    @Override
    public boolean isTemplateSelected() {
        return false;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(PdfVitrineExpose pdfVitrineExpose) {
        this.generalTab.load(pdfVitrineExpose);
        this.contentTab.load(pdfVitrineExpose);
        this.encryptionTab.load(pdfVitrineExpose);
        this.validationHandler.init();
    }

    @Override
    public void save(PdfVitrineExpose pdfVitrineExpose) {
        this.generalTab.save(pdfVitrineExpose);
        this.contentTab.save(pdfVitrineExpose);
        this.encryptionTab.save(pdfVitrineExpose);
    }

    private static class AttachmentTypeRenderer
    extends TranslatableRenderer<EstateAttachmentType> {
        private AttachmentTypeRenderer() {
        }

        public String getEmptyText() {
            return "[ " + I18N.tr("every type of image") + " ]";
        }
    }

    private class GeneralTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JLabel formatLabel;
        private JComboBox<AbstractExpose.Orientation> formatField;
        private JLabel resolutionLabel;
        private JComboBox<AbstractExposePanel.Resolution> resolutionField;
        private JLabel localeLabel;
        private LocaleComboBox localePrimaryField;
        private LocaleComboBox localeSecondaryField;
        private JXTitledSeparator imageTitle;
        private JLabel bigImageLabel;
        private JComboBox<EstateAttachmentType> bigImageField;
        private JLabel smallImage1Label;
        private JComboBox<EstateAttachmentType> smallImage1Field;
        private JLabel smallImage2Label;
        private JComboBox<EstateAttachmentType> smallImage2Field;

        private GeneralTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.imageTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.localeLabel = new JLabel();
            this.localePrimaryField = new LocaleComboBox(AbstractExpose.getSupportedLocales(), true);
            this.localeSecondaryField = new LocaleComboBox(AbstractExpose.getSupportedLocales(), true);
            this.resolutionLabel = new JLabel();
            this.resolutionField = new JComboBox();
            this.resolutionField.setRenderer((ListCellRenderer<AbstractExposePanel.Resolution>)new DefaultListCellRenderer((Renderer)new AbstractExposePanel.ResolutionRenderer()));
            this.resolutionField.addItem(null);
            for (AbstractExposePanel.Resolution enum_ : AbstractExposePanel.Resolution.values()) {
                this.resolutionField.addItem(enum_);
            }
            this.resolutionField.setSelectedItem(null);
            this.formatLabel = new JLabel();
            this.formatField = new JComboBox();
            this.formatField.setRenderer((ListCellRenderer<AbstractExpose.Orientation>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : AbstractExpose.Orientation.values()) {
                this.formatField.addItem((AbstractExpose.Orientation)enum_);
            }
            this.bigImageLabel = new JLabel();
            this.bigImageField = new JComboBox();
            this.bigImageField.setRenderer((ListCellRenderer<EstateAttachmentType>)new DefaultListCellRenderer((Renderer)new AttachmentTypeRenderer()));
            this.bigImageField.addItem(null);
            for (Enum enum_ : EstateAttachmentType.values()) {
                this.bigImageField.addItem((EstateAttachmentType)enum_);
            }
            this.smallImage1Label = new JLabel();
            this.smallImage1Field = new JComboBox();
            this.smallImage1Field.setRenderer((ListCellRenderer<EstateAttachmentType>)new DefaultListCellRenderer((Renderer)new AttachmentTypeRenderer()));
            this.smallImage1Field.addItem(null);
            for (Enum enum_ : EstateAttachmentType.values()) {
                this.smallImage1Field.addItem((EstateAttachmentType)enum_);
            }
            this.smallImage2Label = new JLabel();
            this.smallImage2Field = new JComboBox();
            this.smallImage2Field.setRenderer((ListCellRenderer<EstateAttachmentType>)new DefaultListCellRenderer((Renderer)new AttachmentTypeRenderer()));
            this.smallImage2Field.addItem(null);
            for (Enum enum_ : EstateAttachmentType.values()) {
                this.smallImage2Field.addItem((EstateAttachmentType)enum_);
            }
            PdfVitrineExposePanel.this.validationHandler.putRule((JComponent)this.localePrimaryField, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.localePrimaryField));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.localeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.localePrimaryField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.localeSecondaryField).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.formatLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.formatField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.resolutionLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.resolutionField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.row(), 5);
            defaultFormBuilder.add((Component)this.imageTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.bigImageLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.bigImageField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.smallImage1Label).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.smallImage1Field).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.smallImage2Label).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.smallImage2Field).xyw(3, defaultFormBuilder.row(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("general"));
        }

        public void load(PdfVitrineExpose pdfVitrineExpose) {
            block5: {
                Locale locale;
                block4: {
                    this.formatField.setSelectedItem((Object)(pdfVitrineExpose.getOrientation() != null ? pdfVitrineExpose.getOrientation() : AbstractExpose.Orientation.PORTRAIT));
                    this.bigImageField.setSelectedItem(pdfVitrineExpose.getBigImageType());
                    this.smallImage1Field.setSelectedItem(pdfVitrineExpose.getSmallImage1Type());
                    this.smallImage2Field.setSelectedItem(pdfVitrineExpose.getSmallImage2Type());
                    this.resolutionField.setSelectedItem(null);
                    int n = pdfVitrineExpose.getResolution();
                    for (Object object : AbstractExposePanel.Resolution.values()) {
                        if (object.getValue() != n) continue;
                        this.resolutionField.setSelectedItem(object);
                        break;
                    }
                    locale = pdfVitrineExpose.getLocale();
                    this.localePrimaryField.setSelectedIndex(0);
                    if (locale != null) break block4;
                    if (this.localePrimaryField.getItemCount() <= 1) break block5;
                    this.localePrimaryField.setSelectedIndex(1);
                    break block5;
                }
                for (int i = 1; i < this.localePrimaryField.getItemCount(); ++i) {
                    Locale locale2 = this.localePrimaryField.getLocaleAt(i);
                    if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
                    this.localePrimaryField.setSelectedIndex(i);
                    break;
                }
            }
            Locale locale = pdfVitrineExpose.getSecondaryLocale();
            this.localeSecondaryField.setSelectedIndex(0);
            if (locale != null) {
                for (int i = 1; i < this.localeSecondaryField.getItemCount(); ++i) {
                    Object object;
                    object = this.localeSecondaryField.getLocaleAt(i);
                    if (!((Locale)object).getLanguage().equals(locale.getLanguage())) continue;
                    this.localeSecondaryField.setSelectedIndex(i);
                    break;
                }
            }
        }

        public void save(PdfVitrineExpose pdfVitrineExpose) {
            pdfVitrineExpose.setOrientation((AbstractExpose.Orientation)((Object)this.formatField.getSelectedItem()));
            pdfVitrineExpose.setLocale(this.localePrimaryField.getSelectedLocale());
            pdfVitrineExpose.setSecondaryLocale(this.localeSecondaryField.getSelectedLocale());
            pdfVitrineExpose.setBigImageType((EstateAttachmentType)this.bigImageField.getSelectedItem());
            pdfVitrineExpose.setSmallImage1Type((EstateAttachmentType)this.smallImage1Field.getSelectedItem());
            pdfVitrineExpose.setSmallImage2Type((EstateAttachmentType)this.smallImage2Field.getSelectedItem());
            AbstractExposePanel.Resolution resolution = (AbstractExposePanel.Resolution)((Object)this.resolutionField.getSelectedItem());
            pdfVitrineExpose.setResolution(resolution != null ? resolution.getValue() : 0);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general options")));
            this.localeLabel.setText(StringUtils.capitalize((String)I18N.tr("languages")) + ":");
            this.localePrimaryField.setToolTipText(I18N.tr("Select the language for the generated document."));
            this.localeSecondaryField.setToolTipText(I18N.tr("Select the secondary language for the generated document."));
            this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
            this.formatField.setToolTipText(I18N.tr("Select a page format for the generated document."));
            this.resolutionLabel.setText(StringUtils.capitalize((String)I18N.tr("resolution")) + ":");
            this.resolutionField.setToolTipText(I18N.tr("Select a resolution for the exported images. A higher resolution leads to better quality and bigger file size."));
            this.imageTitle.setTitle(StringUtils.capitalize((String)I18N.tr("preferred image types")));
            this.bigImageLabel.setText(StringUtils.capitalize((String)I18N.tr("big image")) + ":");
            this.bigImageField.setToolTipText(I18N.tr("Select the preferred image type, that is written as big image into the document."));
            this.smallImage1Label.setText(StringUtils.capitalize((String)I18N.tr("small image")) + " 1:");
            this.smallImage1Field.setToolTipText(I18N.tr("Select the preferred image type, that is written as first small image into the document."));
            this.smallImage2Label.setText(StringUtils.capitalize((String)I18N.tr("small image")) + " 2:");
            this.smallImage2Field.setToolTipText(I18N.tr("Select the preferred image type, that is written as second small image into the document."));
        }
    }

    private static class ContentTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JLabel alignmentLabel;
        private JLabel colorsLabel;
        private ColorPickButton borderColorField;
        private ColorPickButton bodyHeadBgColorField;
        private ColorPickButton bodyHeadFgColorField;
        private ColorPickButton bodyTextFgColorField;
        private JComboBox<AbstractExpose.HorizontalAlign> bodyTextAlignmentField;

        private ContentTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.alignmentLabel = new JLabel();
            this.colorsLabel = new JLabel();
            this.borderColorField = new ColorPickButton();
            this.bodyHeadBgColorField = new ColorPickButton();
            this.bodyHeadFgColorField = new ColorPickButton();
            this.bodyTextFgColorField = new ColorPickButton();
            this.bodyTextAlignmentField = new JComboBox();
            this.bodyTextAlignmentField.setRenderer((ListCellRenderer<AbstractExpose.HorizontalAlign>)new DefaultListCellRenderer((Renderer)new ExposeHorizontalAlignRenderer()));
            for (AbstractExpose.HorizontalAlign horizontalAlign : AbstractExpose.HorizontalAlign.values()) {
                this.bodyTextAlignmentField.addItem(horizontalAlign);
            }
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.alignmentLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.bodyTextAlignmentField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.colorsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyTextFgColorField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.bodyHeadFgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyHeadBgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.borderColorField).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("content"));
        }

        public void load(PdfVitrineExpose pdfVitrineExpose) {
            this.bodyHeadBgColorField.setColor(pdfVitrineExpose.getBodyHeadBgColor());
            this.bodyHeadFgColorField.setColor(pdfVitrineExpose.getBodyHeadFgColor());
            this.bodyTextFgColorField.setColor(pdfVitrineExpose.getBodyTextFgColor());
            this.borderColorField.setColor(pdfVitrineExpose.getBorderColor());
            this.bodyTextAlignmentField.setSelectedItem((Object)pdfVitrineExpose.getBodyTextAlignment());
        }

        public void save(PdfVitrineExpose pdfVitrineExpose) {
            pdfVitrineExpose.setBodyHeadBgColor(this.bodyHeadBgColorField.getColor());
            pdfVitrineExpose.setBodyHeadFgColor(this.bodyHeadFgColorField.getColor());
            pdfVitrineExpose.setBodyTextFgColor(this.bodyTextFgColorField.getColor());
            pdfVitrineExpose.setBorderColor(this.borderColorField.getColor());
            pdfVitrineExpose.setBodyTextAlignment((AbstractExpose.HorizontalAlign)((Object)this.bodyTextAlignmentField.getSelectedItem()));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("content")));
            this.alignmentLabel.setText(StringUtils.capitalize((String)I18N.tr("orientation")) + ":");
            this.bodyTextAlignmentField.setToolTipText(I18N.tr("Set alignment of texts."));
            this.colorsLabel.setText(StringUtils.capitalize((String)I18N.tr("colors")) + ":");
            this.borderColorField.setText(I18N.tr("color for lines & borders"));
            this.borderColorField.setToolTipText(I18N.tr("This color is used for borders and lines."));
            this.bodyHeadBgColorField.setText(I18N.tr("background color of headlines"));
            this.bodyHeadBgColorField.setToolTipText(I18N.tr("This color is used as headline background."));
            this.bodyHeadFgColorField.setText(I18N.tr("foreground color of headlines"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for headline texts."));
            this.bodyTextFgColorField.setText(I18N.tr("foreground color of texts"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for texts."));
        }
    }
}

