/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenEstateImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenEstateImport.class);
    private static final I18n I18N = I18nFactory.getI18n(OpenEstateImport.class);
    private static final String NAME = "openestate_xml";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "OpenEstate-XML";
    }

    @Override
    public String[] getVersions() {
        return new String[]{"1.0"};
    }

    @Override
    public boolean isIncrementalTransferSupported() {
        return true;
    }

    @Override
    public boolean isSingleLanguageFormat() {
        return false;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        Throwable throwable;
        Object object;
        Document document = null;
        try {
            object = new FileInputStream(file);
            throwable = null;
            try {
                document = OpenEstateUtils.loadDocument((InputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        object = document.getRootElement().getName();
        try {
            if ("Transfer".equals(object)) {
                return new TransferImpl(document);
            }
            if ("Agency".equals(object)) {
                throwable = new AgencyImpl(document);
                TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
                transferAgencyImpl.setAgent(throwable.getAgent());
                transferAgencyImpl.getContacts().putAll(throwable.getContacts());
                transferAgencyImpl.getEstatesToSave().addAll(throwable.getEstates().values());
                TransferImpl transferImpl = new TransferImpl();
                transferImpl.getAgencies().add(transferAgencyImpl);
                return transferImpl;
            }
        }
        catch (DocumentException documentException) {
            throw new IOException("Can't process document!", documentException);
        }
        throw new IOException("The file does not contain a supported document.");
    }

    @Override
    public String validateFile(File file) throws IOException {
        FileInputStream fileInputStream;
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileInputStream != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)fileInputStream).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        FileInputStream fileInputStream2 = fileInputStream = document != null ? document.getRootElement().getName() : null;
        if ("Agency".equals(fileInputStream)) {
            return "1.0";
        }
        if ("Transfer".equals(fileInputStream)) {
            return "1.0";
        }
        throw new IOException("The file does not contain a supported document.");
    }
}

