/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.openimmo.OpenImmoReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.Aktion;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenImmoImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoImport.class);
    private static final I18n I18N = I18nFactory.getI18n(OpenImmoImport.class);
    private static final String NAME = "openimmo";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "OpenImmo";
    }

    @Override
    public String[] getVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = OpenImmoVersion.values();
        ArrayUtils.reverse((Object[])objectArray);
        for (Object object : objectArray) {
            arrayList.add(object.toReadableVersion());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isIncrementalTransferSupported() {
        return true;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        try {
            OpenImmoImportReader openImmoImportReader = new OpenImmoImportReader();
            openImmoImportReader.setOpenEstateLanguage(settings.getLanguage());
            openImmoImportReader.setVersion(OpenImmoVersion.detectFromString((String)StringUtils.trimToNull((String)string)));
            openImmoImportReader.setImportRemovedObjects(settings.isImportRemovedObjects());
            return openImmoImportReader.readTransfer(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't load parser!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Can't parse document!", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't process document!", jAXBException);
        }
    }

    @Override
    public String validateFile(File file) throws IOException {
        OpenImmoDocument openImmoDocument = null;
        try {
            openImmoDocument = OpenImmoUtils.createDocument((File)file);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        if (openImmoDocument == null || !openImmoDocument.isTransfer()) {
            throw new IOException("The file does not contain a supported document.");
        }
        OpenImmoVersion openImmoVersion = openImmoDocument.getDocumentVersion();
        return openImmoVersion != null ? openImmoVersion.toReadableVersion() : null;
    }

    public static class OpenImmoImportReader
    extends OpenImmoReader {
        private OpenImmoVersion version = null;
        private boolean importRemovedObjects = false;

        public OpenImmoImportReader() {
            OpenImmoImportReader.initJAXB();
        }

        protected EstateImpl convertImmobilie(Immobilie immobilie, Map<String, AgentContactImpl> map) {
            EstateImpl estateImpl = super.convertImmobilie(immobilie, map);
            if (estateImpl == null) {
                return null;
            }
            return estateImpl;
        }

        protected TransferImpl convertToTransfer(Openimmo openimmo) {
            if (this.isImportRemovedObjects()) {
                for (Anbieter anbieter : openimmo.getAnbieter()) {
                    for (Immobilie immobilie : anbieter.getImmobilie()) {
                        Aktion.AktionArt aktionArt = immobilie.getVerwaltungTechn() != null && immobilie.getVerwaltungTechn().getAktion() != null ? immobilie.getVerwaltungTechn().getAktion().getAktionart() : null;
                        if (!Aktion.AktionArt.DELETE.equals(aktionArt)) continue;
                        immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
                    }
                }
            }
            return super.convertToTransfer(openimmo);
        }

        protected OpenImmoTransferDocument createXmlDocument(Document document) {
            OpenImmoTransferDocument openImmoTransferDocument = super.createXmlDocument(document);
            if (openImmoTransferDocument != null && this.version != null) {
                LOGGER.debug("Set OpenImmo version " + this.version + " for import.");
                openImmoTransferDocument.setDocumentVersion(this.version);
            }
            return openImmoTransferDocument;
        }

        public OpenImmoVersion getVersion() {
            return this.version;
        }

        public static void initJAXB() {
            AgencyPluginUtils.initJAXB(OpenImmoUtils.class);
        }

        public boolean isImportRemovedObjects() {
            return this.importRemovedObjects;
        }

        public void setImportRemovedObjects(boolean bl) {
            this.importRemovedObjects = bl;
        }

        public void setVersion(OpenImmoVersion openImmoVersion) {
            this.version = openImmoVersion;
        }
    }
}

