/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.utils.GeoAreaPanel;
import com.openindex.openestate.tool.agency.utils.GeoData;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.CountryObjectRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.CountryObject;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class GeoAreaDialog
extends AbstractDialog
implements DisposableComponent {
    private static final long serialVersionUID = -40627752615625756L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoAreaDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(GeoAreaDialog.class);
    private AbstractDbDriver dbDriver;
    private DbGeoHandler dbGeoHandler;
    private JLabel countryLabel;
    private JComboBox<CountryObject> countryField;
    private JLabel regionLabel;
    private JTextField regionField;
    private JTabbedPane geoTabsPane;
    private Map<Long, GeoAreaPanel> geoTabs;
    private JXBusyLabel loadDialogLabel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction cancelAction;
    private AbstractI18nAction helpAction;
    private GeoData result = null;

    private GeoAreaDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(500, 400));
        this.setLocationRelativeTo(frame);
    }

    private GeoAreaDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(500, 400));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.submitAction.setEnabled(false);
        this.cancelAction = this.createDefaultCloseAction();
        this.helpAction = this.createDefaultHelpAction();
        this.helpAction.setEnabled(false);
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.cancelAction));
    }

    protected JComponent buildMainComponent() {
        this.loadDialogLabel = new JXBusyLabel();
        this.loadDialogLabel.setOpaque(false);
        this.loadDialogLabel.setBusy(false);
        this.loadDialogLabel.setVisible(false);
        this.geoTabsPane = new JTabbedPane();
        this.countryLabel = new JLabel();
        this.countryField = new JComboBox<CountryObject>(CountryObject.getObjects());
        this.countryField.setRenderer((ListCellRenderer<CountryObject>)new DefaultListCellRenderer((Renderer)new CountryObjectRenderer()));
        this.countryField.setSelectedIndex(-1);
        this.countryField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeoAreaDialog.this.updateCountry();
            }
        });
        this.regionLabel = new JLabel();
        this.regionField = new JTextField();
        this.regionField.setColumns(20);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.countryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.countryField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.regionLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.regionField).xy(3, defaultFormBuilder.row());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.geoTabsPane, "Center");
        jPanel.add((Component)this.loadDialogLabel, "South");
        return jPanel;
    }

    protected void doHelp() {
    }

    private void doSubmit() {
        String string = this.getSelectedCountry();
        if (string == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No country selected."), (Component)((Object)this));
            return;
        }
        this.result = new GeoData(string, StringUtils.trimToNull((String)this.regionField.getText()));
        for (GeoAreaPanel geoAreaPanel : this.geoTabs.values()) {
            DbGeo dbGeo = geoAreaPanel.getGeoDb();
            DbGeoArea dbGeoArea = geoAreaPanel.getGeoArea();
            if (dbGeo == null || dbGeoArea == null) continue;
            this.result.putArea(dbGeo.id, dbGeoArea);
        }
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("modify geo data"));
    }

    protected String getHeaderTitle() {
        return I18N.tr("Modify geo data of selected properties.");
    }

    private String getSelectedCountry() {
        CountryObject countryObject = (CountryObject)this.countryField.getSelectedItem();
        return countryObject != null ? countryObject.getCode() : null;
    }

    private String getSelectedCountryName() {
        CountryObject countryObject = (CountryObject)this.countryField.getSelectedItem();
        return countryObject != null ? countryObject.getName() : null;
    }

    private void load(AbstractDbDriver abstractDbDriver, DbGeoHandler dbGeoHandler) {
        this.result = null;
        this.geoTabs = new HashMap<Long, GeoAreaPanel>();
        this.dbDriver = abstractDbDriver;
        this.dbGeoHandler = dbGeoHandler;
        ImmoToolUtils.executeTask((ImmoToolTask)new LoadInBackgroundTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(DbGeo[] dbGeoArray) {
        this.geoTabs.clear();
        this.geoTabsPane.removeAll();
        if (ArrayUtils.isEmpty((Object[])dbGeoArray)) {
            this.geoTabsPane.addTab(I18N.tr("notice"), new JLabel(I18N.tr("No geo databases were configured.")));
            return;
        }
        DbGeoHandler dbGeoHandler = this.dbGeoHandler;
        Connection connection = null;
        try {
            connection = this.dbDriver.getConnection();
            for (DbGeo dbGeo : dbGeoArray) {
                GeoAreaPanel geoAreaPanel = new GeoAreaPanel(dbGeo, 50);
                geoAreaPanel.setBorder((Border)Paddings.DIALOG);
                geoAreaPanel.load(connection, dbGeoHandler);
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)geoAreaPanel));
                jScrollPane.setBorder(Paddings.EMPTY);
                this.geoTabs.put(dbGeo.id, geoAreaPanel);
                this.geoTabsPane.addTab(dbGeo.name, jScrollPane);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't load geo data!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoData showDialog(Window window, AbstractDbDriver abstractDbDriver, DbGeoHandler dbGeoHandler) {
        GeoData geoData;
        block3: {
            GeoAreaDialog geoAreaDialog = null;
            try {
                geoAreaDialog = window instanceof Dialog ? new GeoAreaDialog((Dialog)window) : (window instanceof Frame ? new GeoAreaDialog((Frame)window) : new GeoAreaDialog((Frame)null));
                geoAreaDialog.load(abstractDbDriver, dbGeoHandler);
                geoAreaDialog.setVisible(true);
                geoData = geoAreaDialog.result;
                if (geoAreaDialog == null) break block3;
            }
            catch (Throwable throwable) {
                if (geoAreaDialog != null) {
                    SwingUtils.disposeRecursively(geoAreaDialog);
                }
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)geoAreaDialog));
        }
        return geoData;
    }

    private void updateCountry() {
        String string = this.getSelectedCountry();
        String string2 = this.getSelectedCountryName();
        for (GeoAreaPanel geoAreaPanel : this.geoTabs.values()) {
            geoAreaPanel.setCountry(string, string2, true);
        }
        this.submitAction.setEnabled(string != null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.countryLabel.setText(StringUtils.capitalize((String)I18N.tr("country")) + ":");
        this.regionLabel.setText(StringUtils.capitalize((String)I18N.tr("region")) + ":");
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private static final long serialVersionUID = -3746038938883913204L;

        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GeoAreaDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Modify geo data of selected properties."));
        }
    }

    private class LoadInBackgroundTask
    extends ImmoToolTask<DbGeo[], Void> {
        private LoadInBackgroundTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbGeo[] doInBackground() throws Exception {
            DbGeo[] dbGeoArray;
            DbGeoHandler dbGeoHandler = GeoAreaDialog.this.dbGeoHandler;
            Connection connection = null;
            try {
                connection = GeoAreaDialog.this.dbDriver.getConnection();
                dbGeoArray = dbGeoHandler.getGeoDbs(connection);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return dbGeoArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            GeoAreaDialog.this.loadDialogLabel.setBusy(false);
            GeoAreaDialog.this.loadDialogLabel.setText(I18N.tr("An error occurred!"));
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load geo databases!", (Throwable)throwable, (Window)((Object)GeoAreaDialog.this));
        }

        protected void succeeded(DbGeo[] dbGeoArray) {
            super.succeeded((Object)dbGeoArray);
            GeoAreaDialog.this.load(dbGeoArray);
        }
    }
}

