/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.openimmo;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAddressImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AccessBeginDate;
import com.openindex.openestate.impl.attribs.administration.ApartmentNr;
import com.openindex.openestate.impl.attribs.administration.AuctionCompulsory;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.ChargeBeginDate;
import com.openindex.openestate.impl.attribs.administration.ChargeEndDate;
import com.openindex.openestate.impl.attribs.administration.CommercialIndustries;
import com.openindex.openestate.impl.attribs.administration.CommercialUse;
import com.openindex.openestate.impl.attribs.administration.CommunalCode;
import com.openindex.openestate.impl.attribs.administration.CommunalDistrict;
import com.openindex.openestate.impl.attribs.administration.CountryCourtFileReference;
import com.openindex.openestate.impl.attribs.administration.CountryCourtName;
import com.openindex.openestate.impl.attribs.administration.EffectiveDate;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LocationInBuilding;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Parcel;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.RegionalNotes;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.RoomsModifiable;
import com.openindex.openestate.impl.attribs.administration.Skyscraper;
import com.openindex.openestate.impl.attribs.administration.SubPlot;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ContaminatedSites;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaThermalHeatDemand;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaTotalEnergyEfficiencyFactor;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.CreationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.ExpirationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.AttachedGastronomy;
import com.openindex.openestate.impl.attribs.features.BalconyTerraceDirection;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.BreweryObligation;
import com.openindex.openestate.impl.attribs.features.BroadbandInternet;
import com.openindex.openestate.impl.attribs.features.BroadbandInternetSpeed;
import com.openindex.openestate.impl.attribs.features.BuildingStyle;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.ChimneyPort;
import com.openindex.openestate.impl.attribs.features.CommercialRooms;
import com.openindex.openestate.impl.attribs.features.CommercialServices;
import com.openindex.openestate.impl.attribs.features.Conservatory;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.RoofShape;
import com.openindex.openestate.impl.attribs.features.Sauna;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.attribs.features.ShuttersInterior;
import com.openindex.openestate.impl.attribs.features.SportsFacilities;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TelephoneAvailable;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.features.WellnessArea;
import com.openindex.openestate.impl.attribs.measures.AdministrationArea;
import com.openindex.openestate.impl.attribs.measures.AtticArea;
import com.openindex.openestate.impl.attribs.measures.BalconyArea;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.BasementArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBalconies;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountCommercialUnits;
import com.openindex.openestate.impl.attribs.measures.CountConferenceRooms;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountLivingAndBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountLoggia;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountResidentialUnits;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CountSeparateToilets;
import com.openindex.openestate.impl.attribs.measures.CountTerraces;
import com.openindex.openestate.impl.attribs.measures.CubatureVolume;
import com.openindex.openestate.impl.attribs.measures.CubicIndex;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowArea;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.GardenArea;
import com.openindex.openestate.impl.attribs.measures.GrossFloorArea;
import com.openindex.openestate.impl.attribs.measures.GuestTerrace;
import com.openindex.openestate.impl.attribs.measures.HeatableArea;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.OfficeAreaPart;
import com.openindex.openestate.impl.attribs.measures.OpenSpace;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.PlotForesideLength;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.RetailArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TerraceArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.UtilizationNumber;
import com.openindex.openestate.impl.attribs.prices.AdditionalRentalCharges;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeIncludingVat;
import com.openindex.openestate.impl.attribs.prices.AgentFeeRequired;
import com.openindex.openestate.impl.attribs.prices.BasicRent;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.DevelopmentCosts;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.MarketValue;
import com.openindex.openestate.impl.attribs.prices.NetReturn;
import com.openindex.openestate.impl.attribs.prices.PlusVat;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.prices.SharedCapital;
import com.openindex.openestate.impl.attribs.prices.TakeoverCosts;
import com.openindex.openestate.impl.attribs.prices.VatRate;
import com.openindex.openestate.impl.attribs.prices.VatValue;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBeach;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCityCentre;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToComprehensiveSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToDayNursery;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToElementarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToJuniorHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToLake;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextGastronomy;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextShopping;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToRecreationalArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSecondarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSkiingArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSportsFacilities;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToWanderingArea;
import com.openindex.openestate.impl.attribs.surroundings.SupplyPossible;
import com.openindex.openestate.impl.attribs.surroundings.View;
import com.openindex.openestate.impl.attribs.surroundings.Zone;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.Aktion;
import org.openestate.io.openimmo.xml.Alter;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Anhaenge;
import org.openestate.io.openimmo.xml.Anhang;
import org.openestate.io.openimmo.xml.Ausblick;
import org.openestate.io.openimmo.xml.AusrichtBalkonTerrasse;
import org.openestate.io.openimmo.xml.AusstattKategorie;
import org.openestate.io.openimmo.xml.Ausstattung;
import org.openestate.io.openimmo.xml.Bad;
import org.openestate.io.openimmo.xml.BebaubarNach;
import org.openestate.io.openimmo.xml.Befeuerung;
import org.openestate.io.openimmo.xml.Bewertung;
import org.openestate.io.openimmo.xml.Bieterverfahren;
import org.openestate.io.openimmo.xml.Boden;
import org.openestate.io.openimmo.xml.BueroPraxen;
import org.openestate.io.openimmo.xml.Distanzen;
import org.openestate.io.openimmo.xml.DistanzenSport;
import org.openestate.io.openimmo.xml.Einzelhandel;
import org.openestate.io.openimmo.xml.Energiepass;
import org.openestate.io.openimmo.xml.Erschliessung;
import org.openestate.io.openimmo.xml.Flaechen;
import org.openestate.io.openimmo.xml.Freitexte;
import org.openestate.io.openimmo.xml.FreizeitimmobilieGewerblich;
import org.openestate.io.openimmo.xml.Gastgewerbe;
import org.openestate.io.openimmo.xml.Geo;
import org.openestate.io.openimmo.xml.Geokoordinaten;
import org.openestate.io.openimmo.xml.Geschlecht;
import org.openestate.io.openimmo.xml.Grundstueck;
import org.openestate.io.openimmo.xml.HallenLagerProd;
import org.openestate.io.openimmo.xml.Haus;
import org.openestate.io.openimmo.xml.Heizungsart;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Infrastruktur;
import org.openestate.io.openimmo.xml.Kontaktperson;
import org.openestate.io.openimmo.xml.Kueche;
import org.openestate.io.openimmo.xml.LageGebiet;
import org.openestate.io.openimmo.xml.LageImBau;
import org.openestate.io.openimmo.xml.LandUndForstwirtschaft;
import org.openestate.io.openimmo.xml.MieteinnahmenIst;
import org.openestate.io.openimmo.xml.MieteinnahmenSoll;
import org.openestate.io.openimmo.xml.Moebliert;
import org.openestate.io.openimmo.xml.ObjectFactory;
import org.openestate.io.openimmo.xml.Objektkategorie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.Parken;
import org.openestate.io.openimmo.xml.PreisZeiteinheit;
import org.openestate.io.openimmo.xml.Preise;
import org.openestate.io.openimmo.xml.Serviceleistungen;
import org.openestate.io.openimmo.xml.Sicherheitstechnik;
import org.openestate.io.openimmo.xml.Sonstige;
import org.openestate.io.openimmo.xml.Stellplatz;
import org.openestate.io.openimmo.xml.Stellplatzart;
import org.openestate.io.openimmo.xml.Uebertragung;
import org.openestate.io.openimmo.xml.Unterkellert;
import org.openestate.io.openimmo.xml.Versteigerung;
import org.openestate.io.openimmo.xml.VerwaltungObjekt;
import org.openestate.io.openimmo.xml.VerwaltungTechn;
import org.openestate.io.openimmo.xml.WeitereAdresse;
import org.openestate.io.openimmo.xml.Wohnung;
import org.openestate.io.openimmo.xml.Zimmer;
import org.openestate.io.openimmo.xml.ZinshausRenditeobjekt;
import org.openestate.io.openimmo.xml.Zustand;
import org.openestate.io.openimmo.xml.ZustandAngaben;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenImmoWriter
extends AbstractXmlWriter<OpenImmoTransferDocument, Openimmo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoWriter.class);
    private final ObjectFactory FACTORY = OpenImmoUtils.getFactory();
    private boolean at10ExtensionEnabled = false;
    private boolean energyCertificateAppendedToDescription = false;
    private OpenImmoVersion version = OpenImmoUtils.VERSION;
    private DateFormat energyCertificateExpirationFormat = null;

    public OpenImmoWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public OpenImmoWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected Anbieter convertAgent(AgentImpl agentImpl) {
        Anbieter anbieter = this.createEmptyAnbieter();
        anbieter.setOpenimmoAnid("");
        anbieter.setAnbieternr(agentImpl.getId());
        anbieter.setImpressum(OpenEstateUtils.serializeString((String)agentImpl.getTerms(this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        anbieter.setFirma(OpenEstateUtils.serializeString((String)agentImpl.getCompany().getCompanyName(), (String)this.getXmlLineSeparator()));
        anbieter.setImpressumStrukt(this.FACTORY.createImpressumStrukt());
        anbieter.getImpressumStrukt().setBerufsaufsichtsbehoerde("");
        anbieter.getImpressumStrukt().setFirmenanschrift(agentImpl.getCompany().writeFullAddress(this.getXmlLineSeparator(), this.getOpenEstateLanguage()));
        anbieter.getImpressumStrukt().setFirmenname(OpenEstateUtils.serializeString((String)agentImpl.getCompany().getCompanyName(), (String)this.getXmlLineSeparator()));
        anbieter.getImpressumStrukt().setHandelsregister("");
        anbieter.getImpressumStrukt().setHandelsregisterNr("");
        anbieter.getImpressumStrukt().setSteuernummer("");
        anbieter.getImpressumStrukt().setTelefon("");
        anbieter.getImpressumStrukt().setUmsstId("");
        anbieter.getImpressumStrukt().setVertretungsberechtigter(OpenEstateUtils.serializeString((String)agentImpl.getCompany().writePersonFullName(), (String)this.getXmlLineSeparator()));
        anbieter.getImpressumStrukt().setWeiteres("");
        return anbieter;
    }

    protected Immobilie convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        try {
            Immobilie immobilie = this.createEmptyImmobilie();
            immobilie.setObjektkategorie(this.FACTORY.createObjektkategorie());
            this.writeImmobilieObjektkategorie(immobilie.getObjektkategorie(), estateImpl);
            immobilie.setGeo(this.FACTORY.createGeo());
            this.writeImmobilieGeo(immobilie.getGeo(), estateImpl);
            immobilie.setKontaktperson(this.FACTORY.createKontaktperson());
            if (agentContactImpl != null) {
                this.writeImmobilieKontaktperson(immobilie.getKontaktperson(), agentContactImpl, agentImpl);
            } else {
                this.writeImmobilieKontaktperson(immobilie.getKontaktperson(), (PersonAddressImpl)agentImpl.getCompany(), agentImpl);
                immobilie.getKontaktperson().setPersonennummer("0");
            }
            this.writeImmobilieWeitereAdressen(immobilie.getWeitereAdresse(), estateImpl);
            immobilie.setPreise(this.FACTORY.createPreise());
            this.writeImmobiliePreise(immobilie.getPreise(), estateImpl);
            if (OpenEstateAction.AUCTION.equals((Object)estateImpl.getAction())) {
                immobilie.setVersteigerung(this.FACTORY.createVersteigerung());
                this.writeImmobilieVersteigerung(immobilie.getVersteigerung(), estateImpl);
            }
            immobilie.setFlaechen(this.FACTORY.createFlaechen());
            this.writeImmobilieFlaechen(immobilie.getFlaechen(), estateImpl);
            immobilie.setAusstattung(this.FACTORY.createAusstattung());
            this.writeImmobilieAusstattung(immobilie.getAusstattung(), estateImpl);
            immobilie.setZustandAngaben(this.FACTORY.createZustandAngaben());
            this.writeImmobilieZustandAngaben(immobilie.getZustandAngaben(), estateImpl);
            immobilie.setInfrastruktur(this.FACTORY.createInfrastruktur());
            this.writeImmobilieInfrastruktur(immobilie.getInfrastruktur(), estateImpl);
            immobilie.setFreitexte(this.FACTORY.createFreitexte());
            this.writeImmobilieFreitexte(immobilie.getFreitexte(), estateImpl);
            immobilie.setAnhaenge(this.FACTORY.createAnhaenge());
            this.writeImmobilieAnhaenge(immobilie.getAnhaenge(), estateImpl);
            immobilie.setVerwaltungObjekt(this.FACTORY.createVerwaltungObjekt());
            this.writeImmobilieVerwaltungObjekt(immobilie.getVerwaltungObjekt(), estateImpl);
            immobilie.setVerwaltungTechn(this.FACTORY.createVerwaltungTechn());
            this.writeImmobilieVerwaltungTechn(immobilie.getVerwaltungTechn(), estateImpl);
            return immobilie;
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert estate!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected Openimmo convertToXmlObject(AgencyImpl agencyImpl) {
        Openimmo openimmo = this.createRoot();
        Anbieter anbieter = this.convertAgent(agencyImpl.getAgent());
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            String string = estateImpl.getContactId();
            AgentContactImpl agentContactImpl = string != null && agencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)agencyImpl.getContacts().get(string) : null;
            ArrayList<String> arrayList = new ArrayList<String>();
            Immobilie immobilie = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
            if (!arrayList.isEmpty()) {
                this.putErrors(estateImpl.getId(), arrayList);
                continue;
            }
            if (immobilie == null) continue;
            immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
            anbieter.getImmobilie().add(immobilie);
        }
        openimmo.getAnbieter().add(anbieter);
        return openimmo;
    }

    protected Openimmo convertToXmlObject(TransferImpl transferImpl) {
        Openimmo openimmo = this.createRoot();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            Immobilie immobilie;
            Object object;
            String string;
            Anbieter anbieter = this.convertAgent(transferAgencyImpl.getAgent());
            for (Object object2 : transferAgencyImpl.getEstatesToSave()) {
                string = object2.getContactId();
                object = transferAgencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)transferAgencyImpl.getContacts().get(string) : null;
                immobilie = new ArrayList();
                Immobilie immobilie2 = this.convertEstate((EstateImpl)object2, transferAgencyImpl.getAgent(), (AgentContactImpl)object, (List<String>)immobilie);
                if (!immobilie.isEmpty()) {
                    this.putErrors(object2.getId(), (List)immobilie);
                    continue;
                }
                if (immobilie2 == null) continue;
                immobilie2.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
                anbieter.getImmobilie().add(immobilie2);
            }
            for (Object object2 : transferAgencyImpl.getEstateIdsToRemove()) {
                string = this.createEmptyEstate();
                string.setId((String)object2);
                string.setCurrency(Currency.getInstance(Locale.GERMANY));
                string.getAddress().setPostalCode("13125");
                try {
                    string.setType(OpenEstateType.GENERAL_RESIDENCE, OpenEstateAction.RENT);
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getLocalizedMessage(), (Throwable)exception);
                }
                object = new ArrayList();
                immobilie = this.convertEstate((EstateImpl)string, transferAgencyImpl.getAgent(), null, (List<String>)object);
                if (!object.isEmpty()) {
                    this.putErrors(string.getId(), (List)object);
                    continue;
                }
                if (immobilie == null) continue;
                immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.DELETE);
                anbieter.getImmobilie().add(immobilie);
            }
            openimmo.getAnbieter().add(anbieter);
        }
        return openimmo;
    }

    protected Anhang createAnhang(EstateAttachmentImpl estateAttachmentImpl) {
        String string = estateAttachmentImpl.getMimeType();
        Anhang anhang = this.FACTORY.createAnhang();
        anhang.setAnhangtitel(StringUtils.trimToNull((String)estateAttachmentImpl.getTitle(this.getOpenEstateLanguage())));
        anhang.setFormat(string);
        anhang.setDaten(this.FACTORY.createDaten());
        if (estateAttachmentImpl.isUrl()) {
            anhang.setLocation(Anhang.Location.REMOTE);
            anhang.getDaten().setPfad(estateAttachmentImpl.getFileAsUrl().toString());
        } else if (estateAttachmentImpl.isName()) {
            anhang.setLocation(Anhang.Location.EXTERN);
            anhang.getDaten().setPfad(estateAttachmentImpl.getFileAsName());
        } else if (estateAttachmentImpl.isBase64()) {
            anhang.setLocation(Anhang.Location.INTERN);
            anhang.getDaten().setAnhanginhalt(estateAttachmentImpl.getFileAsBase64());
        } else {
            LOGGER.warn("invalid attachment!");
            return null;
        }
        if (EstateAttachmentType.IMAGE_OUTER_VIEW.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.AUSSENANSICHTEN);
        } else if (EstateAttachmentType.IMAGE.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.BILD);
        } else if (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.GRUNDRISS);
        } else if (EstateAttachmentType.IMAGE_INNER_VIEW.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.INNENANSICHTEN);
        } else if (EstateAttachmentType.IMAGE_MAP.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.KARTEN_LAGEPLAN);
        } else if (EstateAttachmentType.IMAGE_PANORAMA.equals((Object)estateAttachmentImpl.getType())) {
            anhang.setGruppe(Anhang.Gruppe.PANORAMA);
        } else if (string.startsWith("video/")) {
            anhang.setGruppe(Anhang.Gruppe.FILM);
        } else if (string.startsWith("image/")) {
            anhang.setGruppe(Anhang.Gruppe.BILD);
        } else if (estateAttachmentImpl.isUrl()) {
            anhang.setGruppe(Anhang.Gruppe.LINKS);
        } else {
            anhang.setGruppe(Anhang.Gruppe.DOKUMENTE);
        }
        return anhang;
    }

    protected Anhang createAnhang(EstateLinkImpl estateLinkImpl) {
        Anhang anhang = this.FACTORY.createAnhang();
        anhang.setAnhangtitel(StringUtils.trimToNull((String)estateLinkImpl.getTitle(this.getOpenEstateLanguage())));
        anhang.setFormat("text/url");
        anhang.setLocation(Anhang.Location.REMOTE);
        if (estateLinkImpl.isProviderLink()) {
            anhang.setGruppe(Anhang.Gruppe.FILMLINK);
        } else {
            anhang.setGruppe(Anhang.Gruppe.LINKS);
        }
        URI uRI = estateLinkImpl.getUrl();
        if (uRI == null) {
            LOGGER.warn("invalid link!");
            return null;
        }
        anhang.setDaten(this.FACTORY.createDaten());
        anhang.getDaten().setPfad(uRI.toString());
        return anhang;
    }

    private Distanzen createDistanz(Distanzen.DistanzZu distanzZu, BigDecimal bigDecimal) {
        if (distanzZu == null || bigDecimal == null) {
            return null;
        }
        Distanzen distanzen = this.FACTORY.createDistanzen();
        distanzen.setDistanzZu(distanzZu);
        distanzen.setValue(bigDecimal);
        return distanzen;
    }

    private DistanzenSport createDistanzSport(DistanzenSport.DistanzZuSport distanzZuSport, BigDecimal bigDecimal) {
        if (distanzZuSport == null || bigDecimal == null) {
            return null;
        }
        DistanzenSport distanzenSport = this.FACTORY.createDistanzenSport();
        distanzenSport.setDistanzZuSport(distanzZuSport);
        distanzenSport.setValue(bigDecimal);
        return distanzenSport;
    }

    protected Anbieter createEmptyAnbieter() {
        return this.FACTORY.createAnbieter();
    }

    protected Immobilie createEmptyImmobilie() {
        return this.FACTORY.createImmobilie();
    }

    protected Openimmo createRoot() {
        Openimmo openimmo = this.FACTORY.createOpenimmo();
        Uebertragung uebertragung = this.FACTORY.createUebertragung();
        uebertragung.setArt(Uebertragung.Art.OFFLINE);
        uebertragung.setModus(Uebertragung.Modus.NEW);
        uebertragung.setSendersoftware("OpenEstate.org");
        uebertragung.setSenderversion("1.0");
        uebertragung.setTechnEmail("http://openestate.org/");
        uebertragung.setUmfang(Uebertragung.Umfang.VOLL);
        uebertragung.setVersion(OpenImmoUtils.VERSION.toReadableVersion());
        if (this.isAt10ExtensionEnabled()) {
            uebertragung.setVersion(uebertragung.getVersion() + "/AT1.0");
        }
        openimmo.setUebertragung(uebertragung);
        return openimmo;
    }

    protected OpenImmoTransferDocument createXmlDocument(Openimmo openimmo) throws ParserConfigurationException, JAXBException {
        OpenImmoTransferDocument openImmoTransferDocument = OpenImmoTransferDocument.newDocument((Openimmo)openimmo);
        if (this.version != null && !this.version.isLatestVersion()) {
            openImmoTransferDocument.downgrade((XmlVersion)this.version);
        }
        return openImmoTransferDocument;
    }

    public final DateFormat getEnergyCertificateExpirationFormat() {
        return (DateFormat)ObjectUtils.defaultIfNull((Object)this.energyCertificateExpirationFormat, (Object)new SimpleDateFormat("MM-yyyy"));
    }

    private BueroPraxen.BueroTyp getObjektartBueroTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.AUSSTELLUNGSFLAECHE;
        }
        if (OpenEstateType.OFFICE_AREA.equals((Object)openEstateType) || OpenEstateType.OFFICE_FLOOR.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.BUEROFLAECHE;
        }
        if (OpenEstateType.OFFICE_BUILDING.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.BUEROHAUS;
        }
        if (OpenEstateType.OFFICE_CENTER.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.BUEROZENTRUM;
        }
        if (OpenEstateType.SURGERY.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.PRAXIS;
        }
        if (OpenEstateType.SURGERY_AREA.equals((Object)openEstateType) || OpenEstateType.SURGERY_FLOOR.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.PRAXISFLAECHE;
        }
        if (OpenEstateType.DOCTORS_OFFICE_HOUSE.equals((Object)openEstateType)) {
            return BueroPraxen.BueroTyp.PRAXISHAUS;
        }
        return null;
    }

    private FreizeitimmobilieGewerblich.FreizeitTyp getObjektartFreizeitTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.LEISURE_FACILITY.equals((Object)openEstateType)) {
            return FreizeitimmobilieGewerblich.FreizeitTyp.FREIZEITANLAGE;
        }
        if (OpenEstateType.SPORTS_FACILITY.equals((Object)openEstateType)) {
            return FreizeitimmobilieGewerblich.FreizeitTyp.SPORTANLAGEN;
        }
        if (OpenEstateType.THEME_PARK.equals((Object)openEstateType)) {
            return FreizeitimmobilieGewerblich.FreizeitTyp.VERGNUEGUNGSPARKS_UND_CENTER;
        }
        return null;
    }

    private Gastgewerbe.GastgewTyp getObjektartGastgewTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.RESTAURANT_BAR.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.BAR;
        }
        if (OpenEstateType.BISTRO_CAFE.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.CAFE;
        }
        if (OpenEstateType.DISCOTHEQUE.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.DISCOTHEK;
        }
        if (OpenEstateType.ONE_ROOM_PREMISE.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.EINRAUMLOKAL;
        }
        if (OpenEstateType.GASTRONOMY.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.GASTRONOMIE;
        }
        if (OpenEstateType.GASTRONOMY_WITH_HOUSING.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.GASTRONOMIE_UND_WOHNUNG;
        }
        if (OpenEstateType.HOTEL.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.HOTELS;
        }
        if (OpenEstateType.SMOKERS_PREMISE.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.RAUCHERLOKAL;
        }
        if (OpenEstateType.RESTAURANT.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.RESTAURANT;
        }
        if (OpenEstateType.GUESTHOUSE.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.PENSIONEN;
        }
        if (OpenEstateType.YOUTH_HOSTEL.equals((Object)openEstateType) || OpenEstateType.HOSTEL.equals((Object)openEstateType) || OpenEstateType.GUEST_ROOM.equals((Object)openEstateType)) {
            return Gastgewerbe.GastgewTyp.WEITERE_BEHERBERGUNGSBETRIEBE;
        }
        return null;
    }

    private Grundstueck.GrundstTyp getObjektartGrundstTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.LEISURE_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.FREIZEIT;
        }
        if (OpenEstateType.MIXED_USE_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.GEMISCHT;
        }
        if (OpenEstateType.COMMERCIAL_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.GEWERBE;
        }
        if (OpenEstateType.INDUSTRIAL_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.INDUSTRIE;
        }
        if (OpenEstateType.AGRICULTURAL_FORESTRY_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.LAND_FORSTWIRSCHAFT;
        }
        if (OpenEstateType.LAKEFRONT_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.SEELIEGENSCHAFT;
        }
        if (OpenEstateType.SPECIAL_USE_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.SONDERNUTZUNG;
        }
        if (OpenEstateType.RESIDENTIAL_GROUND.equals((Object)openEstateType)) {
            return Grundstueck.GrundstTyp.WOHNEN;
        }
        return null;
    }

    private HallenLagerProd.HallenTyp getObjektartHallenTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.OPEN_SPACE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.FREIFLAECHEN;
        }
        if (OpenEstateType.HALL_WAREHOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.HALLE;
        }
        if (OpenEstateType.HIGH_RACK_WAREHOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.HOCHREGALLAGER;
        }
        if (OpenEstateType.INDUSTRIAL_WAREHOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.INDUSTRIEHALLE;
        }
        if (OpenEstateType.COOLING_HOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.KUEHLHAUS;
        }
        if (OpenEstateType.WAREHOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.LAGER;
        }
        if (OpenEstateType.WAREHOUSE_WITH_OPEN_SPACE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.LAGER_MIT_FREIFLAECHE;
        }
        if (OpenEstateType.STORAGE_AREA.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.LAGERFLAECHEN;
        }
        if (OpenEstateType.PRODUCTION.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.PRODUKTION;
        }
        if (OpenEstateType.SERVICE_AREA.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.SERVICE;
        }
        if (OpenEstateType.FORWARDING_WAREHOUSE.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.SPEDITIONSLAGER;
        }
        if (OpenEstateType.WORKSHOP.equals((Object)openEstateType)) {
            return HallenLagerProd.HallenTyp.WERKSTATT;
        }
        return null;
    }

    private Einzelhandel.HandelTyp getObjektartHandelTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.AUSSTELLUNGSFLAECHE;
        }
        if (OpenEstateType.SHOPPING_CENTER.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.EINKAUFSZENTRUM;
        }
        if (OpenEstateType.SHOP.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.EINZELHANDELSLADEN;
        }
        if (OpenEstateType.DEPARTMENT_STORE.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.KAUFHAUS;
        }
        if (OpenEstateType.STORE.equals((Object)openEstateType) || OpenEstateType.PREMISE.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.LADENLOKAL;
        }
        if (OpenEstateType.CONSUMER_STORE.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.VERBRAUCHERMARKT;
        }
        if (OpenEstateType.SALES_AREA.equals((Object)openEstateType) || OpenEstateType.SELF_SERVICE_MARKET.equals((Object)openEstateType)) {
            return Einzelhandel.HandelTyp.VERKAUFSFLAECHE;
        }
        return null;
    }

    private Haus.Haustyp getObjektartHaustyp(OpenEstateType openEstateType) {
        if (OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING.equals((Object)openEstateType)) {
            return Haus.Haustyp.APARTMENTHAUS;
        }
        if (OpenEstateType.FARMHOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.BAUERNHAUS;
        }
        if (OpenEstateType.ALPINE_HUT.equals((Object)openEstateType)) {
            return Haus.Haustyp.BERGHUETTE;
        }
        if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
            return Haus.Haustyp.BUNGALOW;
        }
        if (OpenEstateType.CASTLE.equals((Object)openEstateType)) {
            return Haus.Haustyp.BURG;
        }
        if (OpenEstateType.CHALET.equals((Object)openEstateType)) {
            return Haus.Haustyp.CHALET;
        }
        if (OpenEstateType.SEMIDETACHED_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.DOPPELHAUSHAELFTE;
        }
        if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.EINFAMILIENHAUS;
        }
        if (OpenEstateType.COTTAGE.equals((Object)openEstateType)) {
            return Haus.Haustyp.FERIENHAUS;
        }
        if (OpenEstateType.FINCA.equals((Object)openEstateType)) {
            return Haus.Haustyp.FINCA;
        }
        if (OpenEstateType.MANSION.equals((Object)openEstateType)) {
            return Haus.Haustyp.HERRENHAUS;
        }
        if (OpenEstateType.COUNTRY_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.LANDHAUS;
        }
        if (OpenEstateType.LEISURE_HOME.equals((Object)openEstateType)) {
            return Haus.Haustyp.LAUBE_DATSCHE_GARTENHAUS;
        }
        if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.MEHRFAMILIENHAUS;
        }
        if (OpenEstateType.TERRACED_HOUSE_CORNERSIDE.equals((Object)openEstateType)) {
            return Haus.Haustyp.REIHENECK;
        }
        if (OpenEstateType.TERRACED_HOUSE_TAIL.equals((Object)openEstateType)) {
            return Haus.Haustyp.REIHENEND;
        }
        if (OpenEstateType.TERRACED_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.REIHENHAUS;
        }
        if (OpenEstateType.TERRACED_HOUSE_MIDDLE.equals((Object)openEstateType)) {
            return Haus.Haustyp.REIHENMITTEL;
        }
        if (OpenEstateType.REST_OF_A_FARM.equals((Object)openEstateType)) {
            return Haus.Haustyp.RESTHOF;
        }
        if (OpenEstateType.RUSTICO.equals((Object)openEstateType)) {
            return Haus.Haustyp.RUSTICO;
        }
        if (OpenEstateType.PALACE.equals((Object)openEstateType)) {
            return Haus.Haustyp.SCHLOSS;
        }
        if (OpenEstateType.TOWN_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.STADTHAUS;
        }
        if (OpenEstateType.BEACH_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.STRANDHAUS;
        }
        if (OpenEstateType.VILLA.equals((Object)openEstateType)) {
            return Haus.Haustyp.VILLA;
        }
        if (OpenEstateType.TWO_FAMILY_HOUSE.equals((Object)openEstateType)) {
            return Haus.Haustyp.ZWEIFAMILIENHAUS;
        }
        return Haus.Haustyp.KEINE_ANGABE;
    }

    private LandUndForstwirtschaft.LandTyp getObjektartLandTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.CULTIVATION.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.ACKERBAU;
        }
        if (OpenEstateType.OUTLYING_FARM.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.AUSSIEDLERHOF;
        }
        if (OpenEstateType.FARM.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.BAUERNHOF;
        }
        if (OpenEstateType.GARDENING.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.GARTENBAU;
        }
        if (OpenEstateType.FORESTRY_HUNTING.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.JAGD_UND_FORSTWIRTSCHAFT;
        }
        if (OpenEstateType.HUNTING_GROUND.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.JAGDREVIER;
        }
        if (OpenEstateType.RIDING_ESTATE.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.REITERHOEFE;
        }
        if (OpenEstateType.BARN.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.SCHEUNEN;
        }
        if (OpenEstateType.FISH_FARMING.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.TEICH_UND_FISCHWIRTSCHAFT;
        }
        if (OpenEstateType.ANIMAL_HUSBANDRY.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.VIEHWIRTSCHAFT;
        }
        if (OpenEstateType.VINICULTURE.equals((Object)openEstateType)) {
            return LandUndForstwirtschaft.LandTyp.WEINBAU;
        }
        return null;
    }

    private Parken.ParkenTyp getObjektartParkenTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.BERTH.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.BOOTSLIEGEPLATZ;
        }
        if (OpenEstateType.CARPORT.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.CARPORT;
        }
        if (OpenEstateType.DOUBLE_GARAGE.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.DOPPELGARAGE;
        }
        if (OpenEstateType.DUPLEX_GARAGE.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.DUPLEX;
        }
        if (OpenEstateType.GARAGE.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.EINZELGARAGE;
        }
        if (OpenEstateType.CAR_PARK.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.PARKHAUS;
        }
        if (OpenEstateType.PARKING_SPACE.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.STELLPLATZ;
        }
        if (OpenEstateType.UNDERGROUND_CAR_PARK.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.TIEFGARAGE;
        }
        if (OpenEstateType.UNDERGROUND_CAR_PARK_UNIT.equals((Object)openEstateType)) {
            return Parken.ParkenTyp.TIEFGARAGENSTELLPLATZ;
        }
        return null;
    }

    private Sonstige.SonstigeTyp getObjektartSonstigeTyp(OpenEstateType openEstateType) {
        if (OpenEstateType.HOSPITAL_CLINIC.equals((Object)openEstateType)) {
            return Sonstige.SonstigeTyp.KRANKENHAUS;
        }
        if (OpenEstateType.CAR_PARK.equals((Object)openEstateType)) {
            return Sonstige.SonstigeTyp.PARKHAUS;
        }
        if (OpenEstateType.PETROL_STATION.equals((Object)openEstateType)) {
            return Sonstige.SonstigeTyp.TANKSTELLE;
        }
        return null;
    }

    private Wohnung.Wohnungtyp getObjektartWohnungtyp(OpenEstateType openEstateType) {
        if (OpenEstateType.APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.APARTMENT;
        }
        if (OpenEstateType.ATTIC_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.DACHGESCHOSS;
        }
        if (OpenEstateType.GROUND_FLOOR_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.ERDGESCHOSS;
        }
        if (OpenEstateType.HIGHER_FLOOR_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.ETAGE;
        }
        if (OpenEstateType.LOFT.equals((Object)openEstateType) || OpenEstateType.STUDIO.equals((Object)openEstateType) || OpenEstateType.ATELIER.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.LOFT_STUDIO_ATELIER;
        }
        if (OpenEstateType.MAISONETTE.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.MAISONETTE;
        }
        if (OpenEstateType.PENTHOUSE_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.PENTHOUSE;
        }
        if (OpenEstateType.ATTIC_UNDER_CONSTRUCTION.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.ROHDACHBODEN;
        }
        if (OpenEstateType.SOUTERRAIN_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.SOUTERRAIN;
        }
        if (OpenEstateType.TERRACE_APARTMENT.equals((Object)openEstateType)) {
            return Wohnung.Wohnungtyp.TERRASSEN;
        }
        return Wohnung.Wohnungtyp.KEINE_ANGABE;
    }

    public OpenImmoVersion getVersion() {
        return this.version;
    }

    public boolean isAt10ExtensionEnabled() {
        return this.at10ExtensionEnabled;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setAt10ExtensionEnabled(boolean bl) {
        this.at10ExtensionEnabled = bl;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public void setEnergyCertificateExpirationFormat(DateFormat dateFormat) {
        this.energyCertificateExpirationFormat = dateFormat;
    }

    public void setVersion(OpenImmoVersion openImmoVersion) {
        this.version = openImmoVersion;
    }

    protected void writeImmobilieAnhaenge(Anhaenge anhaenge, EstateImpl estateImpl) {
        Anhang anhang;
        if (anhaenge == null) {
            return;
        }
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            anhang = this.createAnhang(estateAttachmentImpl);
            if (anhang == null) continue;
            anhaenge.getAnhang().add(anhang);
        }
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getLinks()) {
            anhang = this.createAnhang((EstateLinkImpl)estateAttachmentImpl);
            if (anhang == null) continue;
            anhaenge.getAnhang().add(anhang);
        }
    }

    protected void writeImmobilieAusstattung(Ausstattung ausstattung, EstateImpl estateImpl) {
        UndergroundLevel.Option option;
        List list;
        List list2;
        Object object;
        RoomsModifiable.Option option2;
        List list3;
        List list4;
        Furnished.Option option3;
        List list5;
        List list6;
        List list7;
        List list8;
        BigDecimal bigDecimal;
        String string;
        List list9;
        List list10;
        Equipment.Option option4;
        List list11;
        if (ausstattung == null) {
            return;
        }
        ausstattung.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        ausstattung.setBrauereibindung(BreweryObligation.get((EstateImpl)estateImpl));
        ausstattung.setGartennutzung(GardenUse.get((EstateImpl)estateImpl));
        ausstattung.setGastterrasse(GuestTerrace.get((EstateImpl)estateImpl));
        ausstattung.setHallenhoehe(WarehouseHeight.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        ausstattung.setHebebuehne(LiftingPlatform.get((EstateImpl)estateImpl));
        ausstattung.setKamin(ChimneyPort.get((EstateImpl)estateImpl));
        ausstattung.setKantineCafeteria(CanteenCafeteria.get((EstateImpl)estateImpl));
        ausstattung.setKlimatisiert(AirConditioned.get((EstateImpl)estateImpl));
        ausstattung.setKran(Crane.get((EstateImpl)estateImpl));
        ausstattung.setRampe(Ramp.get((EstateImpl)estateImpl));
        ausstattung.setRolladen(ShuttersInterior.get((EstateImpl)estateImpl));
        ausstattung.setSauna(Sauna.get((EstateImpl)estateImpl));
        ausstattung.setSporteinrichtungen(SportsFacilities.get((EstateImpl)estateImpl));
        ausstattung.setSwimmingpool(SwimmingPool.get((EstateImpl)estateImpl));
        ausstattung.setTelefonFerienimmobilie(TelephoneAvailable.get((EstateImpl)estateImpl));
        ausstattung.setWellnessbereich(WellnessArea.get((EstateImpl)estateImpl));
        ausstattung.setWintergarten(Conservatory.get((EstateImpl)estateImpl));
        BigDecimal bigDecimal2 = ElectricalConnectionValue.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal2 != null) {
            ausstattung.setStromanschlusswert(bigDecimal2.toPlainString());
        }
        if (Boolean.TRUE.equals(AttachedGastronomy.get((EstateImpl)estateImpl))) {
            ausstattung.setAngeschlGastronomie(this.FACTORY.createAngeschlGastronomie());
        }
        if ((list11 = BalconyTerraceDirection.getAsList((EstateImpl)estateImpl)) != null && !list11.isEmpty()) {
            option4 = this.FACTORY.createAusrichtBalkonTerrasse();
            if (list11.contains(BalconyTerraceDirection.Option.N) && list11.contains(BalconyTerraceDirection.Option.E)) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                }
                ausstattung.getAusrichtBalkonTerrasse().setNORDOST(Boolean.valueOf(true));
            }
            if (list11.contains(BalconyTerraceDirection.Option.N) && list11.contains(BalconyTerraceDirection.Option.W)) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                }
                ausstattung.getAusrichtBalkonTerrasse().setNORDWEST(Boolean.valueOf(true));
            }
            if (list11.contains(BalconyTerraceDirection.Option.S) && list11.contains(BalconyTerraceDirection.Option.E)) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                }
                ausstattung.getAusrichtBalkonTerrasse().setSUEDOST(Boolean.valueOf(true));
            }
            if (list11.contains(BalconyTerraceDirection.Option.S) && list11.contains(BalconyTerraceDirection.Option.W)) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                }
                ausstattung.getAusrichtBalkonTerrasse().setSUEDWEST(Boolean.valueOf(true));
            }
            if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                if (list11.contains(BalconyTerraceDirection.Option.N)) {
                    if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                        ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                    }
                    ausstattung.getAusrichtBalkonTerrasse().setNORD(Boolean.valueOf(true));
                }
                if (list11.contains(BalconyTerraceDirection.Option.E)) {
                    if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                        ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                    }
                    ausstattung.getAusrichtBalkonTerrasse().setOST(Boolean.valueOf(true));
                }
                if (list11.contains(BalconyTerraceDirection.Option.S)) {
                    if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                        ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                    }
                    ausstattung.getAusrichtBalkonTerrasse().setSUED(Boolean.valueOf(true));
                }
                if (list11.contains(BalconyTerraceDirection.Option.W)) {
                    if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                        ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)option4);
                    }
                    ausstattung.getAusrichtBalkonTerrasse().setWEST(Boolean.valueOf(true));
                }
            }
        }
        if (Equipment.Option.BASIC.equals((Object)(option4 = Equipment.get((EstateImpl)estateImpl))) || Equipment.Option.STANDARD.equals((Object)option4)) {
            ausstattung.setAusstattKategorie(AusstattKategorie.STANDARD);
        } else if (Equipment.Option.EXCLUSIVE.equals((Object)option4)) {
            ausstattung.setAusstattKategorie(AusstattKategorie.GEHOBEN);
        } else if (Equipment.Option.LUXURY.equals((Object)option4)) {
            ausstattung.setAusstattKategorie(AusstattKategorie.LUXUS);
        }
        List list12 = Bathroom.getAsList((EstateImpl)estateImpl);
        if (list12 != null && !list12.isEmpty()) {
            list10 = this.FACTORY.createBad();
            if (list12.contains(Bathroom.Option.BIDET)) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)list10);
                }
                ausstattung.getBad().setBIDET(Boolean.valueOf(true));
            }
            if (list12.contains(Bathroom.Option.SHOWER)) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)list10);
                }
                ausstattung.getBad().setDUSCHE(Boolean.valueOf(true));
            }
            if (list12.contains(Bathroom.Option.WINDOW)) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)list10);
                }
                ausstattung.getBad().setFENSTER(Boolean.valueOf(true));
            }
            if (list12.contains(Bathroom.Option.URINAL)) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)list10);
                }
                ausstattung.getBad().setPISSOIR(Boolean.valueOf(true));
            }
            if (list12.contains(Bathroom.Option.BATHTUB)) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)list10);
                }
                ausstattung.getBad().setWANNE(Boolean.valueOf(true));
            }
        }
        if ((list10 = TypeOfBeaconing.getAsList((EstateImpl)estateImpl)) != null && !list10.isEmpty()) {
            list9 = this.FACTORY.createBefeuerung();
            if (list10.contains(TypeOfBeaconing.Option.ALTERNATIVELY)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setALTERNATIV(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.BLOCK_POWER_PLANT)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setBLOCK(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.ELECTRICS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setELEKTRO(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.GEOTHERMICS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setERDWAERME(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setFERN(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.LIQUID_GAS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setFLUESSIGGAS(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.GAS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setGAS(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.WOOD) || list10.contains(TypeOfBeaconing.Option.WOODCHIPS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setHOLZ(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.COAL)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setKOHLE(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.AIR_TO_WATER_HEAT_PUMP)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setLUFTWP(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.OIL)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setOEL(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.PELLETS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setPELLET(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.SOLAR)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setSOLAR(Boolean.valueOf(true));
            }
            if (list10.contains(TypeOfBeaconing.Option.WATER_ELECTRICS)) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)list9);
                }
                ausstattung.getBefeuerung().setWASSERELEKTRO(Boolean.valueOf(true));
            }
        }
        if ((list9 = FlooringMaterial.getAsList((EstateImpl)estateImpl)) != null && !list9.isEmpty()) {
            string = this.FACTORY.createBoden();
            if (list9.contains(FlooringMaterial.Option.FLOOR_BOARDS) || list9.contains(FlooringMaterial.Option.FLOOR_BOARDS_POLISHED)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setDIELEN(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.ACCESS_FLOOR)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setDOPPELBODEN(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.SCREED) || list9.contains(FlooringMaterial.Option.CONCRETE)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setESTRICH(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.PARQUET_FINISHED)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setFERTIGPARKETT(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.TILES) || list9.contains(FlooringMaterial.Option.CERAMIC)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setFLIESEN(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.GRANITE)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setGRANIT(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.SYNTHETIC_MATERIAL) || list9.contains(FlooringMaterial.Option.PVC)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setKUNSTSTOFF(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.LAMINATE)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setLAMINAT(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.LINOLEUM)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setLINOLEUM(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.MARBLE)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setMARMOR(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.PARQUET)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setPARKETT(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.STONE) || list9.contains(FlooringMaterial.Option.SLATE)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setSTEIN(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.CARPET) || list9.contains(FlooringMaterial.Option.CARPET_ANTISTATIC) || list9.contains(FlooringMaterial.Option.NATURAL_FIBER)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setTEPPICH(Boolean.valueOf(true));
            }
            if (list9.contains(FlooringMaterial.Option.TERRACOTTA)) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)string);
                }
                ausstattung.getBoden().setTERRAKOTTA(Boolean.valueOf(true));
            }
        }
        if (!StringUtils.isBlank((CharSequence)(string = BroadbandInternet.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())))) {
            if (ausstattung.getBreitbandZugang() == null) {
                ausstattung.setBreitbandZugang(this.FACTORY.createBreitbandZugang());
            }
            ausstattung.getBreitbandZugang().setArt(string);
        }
        if ((bigDecimal = BroadbandInternetSpeed.getAsBigDecimal((EstateImpl)estateImpl)) != null) {
            if (ausstattung.getBreitbandZugang() == null) {
                ausstattung.setBreitbandZugang(this.FACTORY.createBreitbandZugang());
            }
            ausstattung.getBreitbandZugang().setSpeed(bigDecimal);
        }
        if (!(list8 = RoofShape.getAsList((EstateImpl)estateImpl)).isEmpty()) {
            ausstattung.setDachform(this.FACTORY.createDachform());
            if (list8.contains(RoofShape.Option.FLAT)) {
                ausstattung.getDachform().setFLACHDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.HALF_HIP)) {
                ausstattung.getDachform().setKRUEPPELWALMDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.MANSARD)) {
                ausstattung.getDachform().setMANSARDDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.MONOPITCH)) {
                ausstattung.getDachform().setPULTDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.PYRAMID)) {
                ausstattung.getDachform().setPYRAMIDENDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.GABLED)) {
                ausstattung.getDachform().setSATTELDACH(Boolean.valueOf(true));
            }
            if (list8.contains(RoofShape.Option.HIP)) {
                ausstattung.getDachform().setWALMDACH(Boolean.valueOf(true));
            }
        }
        if ((list7 = Applicability.getAsList((EstateImpl)estateImpl)) != null && !list7.isEmpty()) {
            if (list7.contains(Applicability.Option.WHEELCHAIR)) {
                ausstattung.setRollstuhlgerecht(Boolean.valueOf(true));
            }
            if (list7.contains(Applicability.Option.APARTMENT_SHARE)) {
                ausstattung.setWgGeeignet(Boolean.valueOf(true));
            }
            if (list7.contains(Applicability.Option.SENIORS)) {
                ausstattung.setSeniorengerecht(Boolean.valueOf(true));
            }
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.FEATURES_FREIGHT_ELEVATOR)) {
            if (ausstattung.getFahrstuhl() == null) {
                ausstattung.setFahrstuhl(this.FACTORY.createFahrstuhl());
            }
            ausstattung.getFahrstuhl().setLASTEN(FreightElevator.get((EstateImpl)estateImpl));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.FEATURES_LIFT)) {
            if (ausstattung.getFahrstuhl() == null) {
                ausstattung.setFahrstuhl(this.FACTORY.createFahrstuhl());
            }
            ausstattung.getFahrstuhl().setPERSONEN(Lift.get((EstateImpl)estateImpl));
        }
        if ((list6 = TypeOfHeating.getAsList((EstateImpl)estateImpl)) != null && !list6.isEmpty()) {
            list5 = this.FACTORY.createHeizungsart();
            if (list6.contains(TypeOfHeating.Option.SELF_CONTAINED_CENTRAL)) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)list5);
                }
                ausstattung.getHeizungsart().setETAGE(Boolean.valueOf(true));
            }
            if (list6.contains(TypeOfHeating.Option.UNDERFLOOR)) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)list5);
                }
                ausstattung.getHeizungsart().setFUSSBODEN(Boolean.valueOf(true));
            }
            if (list6.contains(TypeOfHeating.Option.OVEN)) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)list5);
                }
                ausstattung.getHeizungsart().setOFEN(Boolean.valueOf(true));
            }
            if (list6.contains(TypeOfHeating.Option.CENTRAL)) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)list5);
                }
                ausstattung.getHeizungsart().setZENTRAL(Boolean.valueOf(true));
            }
        }
        if (list10 != null && list10.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            if (ausstattung.getHeizungsart() == null) {
                ausstattung.setHeizungsart(this.FACTORY.createHeizungsart());
            }
            ausstattung.getHeizungsart().setFERN(Boolean.valueOf(true));
        }
        if ((list5 = Kitchen.getAsList((EstateImpl)estateImpl)) != null && !list5.isEmpty()) {
            option3 = this.FACTORY.createKueche();
            if (list5.contains(Kitchen.Option.FITTED_KITCHEN)) {
                if (ausstattung.getKueche() == null) {
                    ausstattung.setKueche((Kueche)option3);
                }
                ausstattung.getKueche().setEBK(Boolean.valueOf(true));
            }
            if (list5.contains(Kitchen.Option.OPEN_KITCHEN)) {
                if (ausstattung.getKueche() == null) {
                    ausstattung.setKueche((Kueche)option3);
                }
                ausstattung.getKueche().setOFFEN(Boolean.valueOf(true));
            }
            if (list5.contains(Kitchen.Option.KITCHENETTE)) {
                if (ausstattung.getKueche() == null) {
                    ausstattung.setKueche((Kueche)option3);
                }
                ausstattung.getKueche().setPANTRY(Boolean.valueOf(true));
            }
        }
        if ((option3 = Furnished.get((EstateImpl)estateImpl)) != null) {
            if (Furnished.Option.YES.equals((Object)option3)) {
                ausstattung.setMoebliert(this.FACTORY.createMoebliert());
                ausstattung.getMoebliert().setMoeb(Moebliert.Moeb.VOLL);
            } else if (Furnished.Option.PARTIAL.equals((Object)option3)) {
                ausstattung.setMoebliert(this.FACTORY.createMoebliert());
                ausstattung.getMoebliert().setMoeb(Moebliert.Moeb.TEIL);
            }
        }
        if ((list4 = ResidentialRooms.getAsList((EstateImpl)estateImpl)) != null && !list4.isEmpty()) {
            if (list4.contains(ResidentialRooms.Option.STORAGE_ROOM)) {
                ausstattung.setAbstellraum(Boolean.valueOf(true));
            }
            if (list4.contains(ResidentialRooms.Option.LIBRARY)) {
                ausstattung.setBibliothek(Boolean.valueOf(true));
            }
            if (list4.contains(ResidentialRooms.Option.ATTIC)) {
                ausstattung.setDachboden(Boolean.valueOf(true));
            }
            if (list4.contains(ResidentialRooms.Option.BICYCLE_ROOM)) {
                ausstattung.setFahrradraum(Boolean.valueOf(true));
            }
            if (list4.contains(ResidentialRooms.Option.GUEST_TOILET)) {
                ausstattung.setGaestewc(Boolean.valueOf(true));
            }
            if (list4.contains(ResidentialRooms.Option.WASHING_DRYING_ROOM)) {
                ausstattung.setWaschTrockenraum(Boolean.valueOf(true));
            }
        }
        if ((list3 = CommercialRooms.getAsList((EstateImpl)estateImpl)) != null && !list3.isEmpty()) {
            if (list3.contains(CommercialRooms.Option.STORAGE_ROOM)) {
                ausstattung.setAbstellraum(Boolean.valueOf(true));
            }
            if (list3.contains(CommercialRooms.Option.TEA_KITCHEN)) {
                ausstattung.setTeekueche(Boolean.valueOf(true));
            }
        }
        if ((option2 = RoomsModifiable.get((EstateImpl)estateImpl)) != null) {
            ausstattung.setRaeumeVeraenderbar(Boolean.valueOf(option2.equals((Object)RoomsModifiable.Option.YES) || option2.equals((Object)RoomsModifiable.Option.PARTIALLY)));
        }
        List list13 = ResidentialServices.getAsList((EstateImpl)estateImpl);
        List list14 = CommercialServices.getAsList((EstateImpl)estateImpl);
        if (!list13.isEmpty() || !list14.isEmpty()) {
            object = this.FACTORY.createServiceleistungen();
            if (list13.contains(ResidentialServices.Option.ASSISTED_LIVING)) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add(object);
                }
                ((Serviceleistungen)ausstattung.getServiceleistungen().get(0)).setBETREUTESWOHNEN(Boolean.valueOf(true));
            }
            if (list13.contains(ResidentialServices.Option.CATERING) || list14.contains(CommercialServices.Option.CATERING)) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add(object);
                }
                ((Serviceleistungen)ausstattung.getServiceleistungen().get(0)).setCATERING(Boolean.valueOf(true));
            }
            if (list13.contains(ResidentialServices.Option.PURCHASING)) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add(object);
                }
                ((Serviceleistungen)ausstattung.getServiceleistungen().get(0)).setEINKAUF(Boolean.valueOf(true));
            }
            if (list13.contains(ResidentialServices.Option.CLEANING) || list14.contains(CommercialServices.Option.CLEANING)) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add(object);
                }
                ((Serviceleistungen)ausstattung.getServiceleistungen().get(0)).setREINIGUNG(Boolean.valueOf(true));
            }
            if (list13.contains(ResidentialServices.Option.SECURITY_FIRM) || list14.contains(CommercialServices.Option.SECURITY_FIRM)) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add(object);
                }
                ((Serviceleistungen)ausstattung.getServiceleistungen().get(0)).setWACHDIENST(Boolean.valueOf(true));
            }
        }
        if ((object = SecurityTechnology.getAsList((EstateImpl)estateImpl)) != null && !object.isEmpty()) {
            list2 = this.FACTORY.createSicherheitstechnik();
            if (object.contains(SecurityTechnology.Option.ALARM_SYSTEM)) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)list2);
                }
                ausstattung.getSicherheitstechnik().setALARMANLAGE(Boolean.valueOf(true));
            }
            if (object.contains(SecurityTechnology.Option.CAMERA)) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)list2);
                }
                ausstattung.getSicherheitstechnik().setKAMERA(Boolean.valueOf(true));
            }
            if (object.contains(SecurityTechnology.Option.EMERGENCY_CALL) || object.contains(SecurityTechnology.Option.POLICE_CALL)) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)list2);
                }
                ausstattung.getSicherheitstechnik().setPOLIZEIRUF(Boolean.valueOf(true));
            }
        }
        if ((list2 = CarParkingType.getAsList((EstateImpl)estateImpl)) != null && !list2.isEmpty()) {
            list = this.FACTORY.createStellplatzart();
            if (list2.contains(CarParkingType.Option.CARPORT)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setCARPORT(Boolean.valueOf(true));
            }
            if (list2.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setDUPLEX(Boolean.valueOf(true));
            }
            if (list2.contains(CarParkingType.Option.OUTDOOR) || list2.contains(CarParkingType.Option.GENERAL)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setFREIPLATZ(Boolean.valueOf(true));
            }
            if (list2.contains(CarParkingType.Option.GARAGE)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setGARAGE(Boolean.valueOf(true));
            }
            if (list2.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setPARKHAUS(Boolean.valueOf(true));
            }
            if (list2.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add(list);
                }
                ((Stellplatzart)ausstattung.getStellplatzart().get(0)).setTIEFGARAGE(Boolean.valueOf(true));
            }
        }
        if ((list = Technics.getAsList((EstateImpl)estateImpl)) != null && !list.isEmpty()) {
            if (list.contains(Technics.Option.DV_CABLING)) {
                ausstattung.setDvVerkabelung(Boolean.valueOf(true));
            }
            if (list.contains(Technics.Option.DVBT_RECEPTION)) {
                ausstattung.setDvbt(Boolean.valueOf(true));
            }
            if (list.contains(Technics.Option.WIREWAYS)) {
                ausstattung.setKabelkanaele(Boolean.valueOf(true));
            }
            if (list.contains(Technics.Option.UMTS_RECEPTION)) {
                ausstattung.setUmtsEmpfang(Boolean.valueOf(true));
            }
            if (list.contains(Technics.Option.CABLE_SAT_TV)) {
                ausstattung.setKabelSatTv(Boolean.valueOf(true));
            } else if (list.contains(Technics.Option.CABLE_TV)) {
                ausstattung.setKabelSatTv(Boolean.valueOf(true));
            } else if (list.contains(Technics.Option.SAT_TV)) {
                ausstattung.setKabelSatTv(Boolean.valueOf(true));
            } else {
                ausstattung.setKabelSatTv(Boolean.valueOf(false));
            }
        }
        if ((option = UndergroundLevel.get((EstateImpl)estateImpl)) != null) {
            ausstattung.setUnterkellert(this.FACTORY.createUnterkellert());
            if (option.equals((Object)UndergroundLevel.Option.YES)) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.JA);
            } else if (option.equals((Object)UndergroundLevel.Option.PARTIALLY)) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.TEIL);
            } else if (option.equals((Object)UndergroundLevel.Option.NO)) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.NEIN);
            }
        }
    }

    protected void writeImmobilieBewertung(Bewertung bewertung, EstateImpl estateImpl) {
    }

    protected void writeImmobilieBieterverfahren(Bieterverfahren bieterverfahren, EstateImpl estateImpl) {
    }

    protected void writeImmobilieFlaechen(Flaechen flaechen, EstateImpl estateImpl) {
        Double d;
        Double d2;
        Double d3;
        BigDecimal bigDecimal;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(2);
        if (flaechen == null) {
            return;
        }
        flaechen.setAnzahlBadezimmer(CountBathrooms.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlBalkone(CountBalconies.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlBetten(CountBeds.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlGewerbeeinheiten(CountCommercialUnits.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlLogia(CountLoggia.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlSchlafzimmer(CountBedrooms.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlSepWc(CountSeparateToilets.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlStellplaetze(CountParkingSpaces.getAsBigInteger((EstateImpl)estateImpl));
        flaechen.setAnzahlTagungsraeume(CountConferenceRooms.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlTerrassen(CountTerraces.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlWohnSchlafzimmer(CountLivingAndBedrooms.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlWohneinheiten(CountResidentialUnits.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAnzahlZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setAusnuetzungsziffer(UtilizationNumber.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setBeheizbareFlaeche(HeatableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setBueroflaeche(OfficeArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setBueroteilflaeche(OfficeAreaPart.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setDachbodenflaeche(AtticArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setEinliegerwohnung(GrannyFlat.get((EstateImpl)estateImpl));
        flaechen.setFensterfront(FrontWindowLength.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        flaechen.setFensterfrontQm(FrontWindowArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setFreiflaeche(OpenSpace.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setGartenflaeche(GardenArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setGastroflaeche(SeatingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setGrundstuecksflaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setGrundstuecksfront(PlotForesideLength.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        flaechen.setKellerflaeche(BasementArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setKubatur(CubatureVolume.getAsBigDecimal((EstateImpl)estateImpl, (VolumeValue.Unit)VolumeValue.Unit.CUM));
        flaechen.setLadenflaeche(RetailArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setLagerflaeche(StorageArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setNutzflaeche(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setPlaetzeGastraum(CountGuestroomSeats.getAsBigDecimal((EstateImpl)estateImpl));
        flaechen.setSonstflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setTeilbarAb(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setVerkaufsflaeche(SalesArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setVermietbareFlaeche(RentableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setVerwaltungsflaeche(AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flaechen.setWohnflaeche(ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        if (estateImpl.hasAttribute(OpenEstateAttrib.MEASURES_BALCONY_AREA) || estateImpl.hasAttribute(OpenEstateAttrib.MEASURES_TERRACE_AREA)) {
            bigDecimal = BigDecimal.ZERO;
            bigDecimal = bigDecimal.add((BigDecimal)ObjectUtils.defaultIfNull((Object)BalconyArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), (Object)BigDecimal.ZERO));
            if ((bigDecimal = bigDecimal.add((BigDecimal)ObjectUtils.defaultIfNull((Object)TerraceArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), (Object)BigDecimal.ZERO))).compareTo(BigDecimal.ZERO) >= 1) {
                flaechen.setBalkonTerrasseFlaeche(bigDecimal);
            }
        }
        bigDecimal = flaechen.getGesamtflaeche();
        BigDecimal bigDecimal2 = flaechen.getNutzflaeche();
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            flaechen.setGesamtflaeche(CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        } else if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            flaechen.setNutzflaeche(CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        }
        Double d4 = GrossFloorArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (d4 != null) {
            flaechen.setBgf(numberFormat.format(d4));
        }
        if ((d3 = CubicIndex.getAsDouble((EstateImpl)estateImpl)) != null) {
            flaechen.setBmz(numberFormat.format(d3));
        }
        if ((d2 = FloorAreaIndex.getAsDouble((EstateImpl)estateImpl)) != null) {
            flaechen.setGfz(numberFormat.format(d2));
        }
        if ((d = BaseAreaIndex.getAsDouble((EstateImpl)estateImpl)) != null) {
            flaechen.setGrz(numberFormat.format(d));
        }
    }

    protected void writeImmobilieFreitexte(Freitexte freitexte, EstateImpl estateImpl) {
        if (freitexte == null) {
            return;
        }
        freitexte.setAusstattBeschr(OpenEstateUtils.serializeString((String)FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        freitexte.setDreizeiler(OpenEstateUtils.serializeString((String)ShortDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        freitexte.setLage(OpenEstateUtils.serializeString((String)LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        freitexte.setObjektbeschreibung(OpenEstateUtils.serializeString((String)DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        freitexte.setObjekttitel(OpenEstateUtils.serializeString((String)estateImpl.getTitle(this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        freitexte.setSonstigeAngaben(OpenEstateUtils.serializeString((String)AdditionalInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        if (this.isEnergyCertificateAppendedToDescription()) {
            String string = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)this.getXmlLineSeparator());
            String string2 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
            if (!StringUtils.isBlank((CharSequence)string)) {
                String string3 = StringUtils.trimToNull((String)freitexte.getObjektbeschreibung());
                string3 = string3 == null ? string : string + string2 + string3;
                freitexte.setObjektbeschreibung(StringUtils.trimToEmpty((String)string3));
            }
        }
    }

    protected void writeImmobilieGeo(Geo geo, EstateImpl estateImpl) {
        Object object;
        List list;
        Object object2;
        if (geo == null) {
            return;
        }
        geo.setAnzahlEtagen(CountFloors.getAsBigInteger((EstateImpl)estateImpl));
        geo.setBundesland(estateImpl.getAddress().getRegion());
        geo.setFlur(Parcel.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        geo.setFlurstueck(SubPlot.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        geo.setGemarkung(CommunalDistrict.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        geo.setGemeindecode(CommunalCode.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        geo.setHausnummer(estateImpl.getAddress().getStreetNr());
        if (!StringUtils.isBlank((CharSequence)estateImpl.getAddress().getCountry())) {
            object2 = OpenEstateUtils.convertToIso3Country((String)estateImpl.getAddress().getCountry());
            if (object2 != null && ((String)object2).length() == 3) {
                geo.setLand(this.FACTORY.createLand());
                geo.getLand().setIsoLand((String)object2);
            } else {
                LOGGER.warn("Can't convert country: " + estateImpl.getAddress().getCountry() + " => " + (String)object2);
            }
        }
        geo.setOrt(estateImpl.getAddress().getCity());
        geo.setPlz(estateImpl.getAddress().getPostalCode());
        geo.setStrasse(estateImpl.getAddress().getStreet());
        geo.setWohnungsnr(ApartmentNr.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        object2 = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (object2 instanceof BigInteger) {
            geo.setEtage((BigInteger)object2);
        } else if (object2 instanceof BigDecimal) {
            geo.setEtage(((BigDecimal)object2).toBigInteger());
        } else {
            geo.setEtage(object2 != null ? BigInteger.valueOf(((Number)object2).longValue()) : null);
        }
        String string = RegionalNotes.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        if (StringUtils.isBlank((CharSequence)string)) {
            string = estateImpl.getAddress().getDistrict();
        }
        if (!StringUtils.isBlank((CharSequence)string)) {
            geo.setRegionalerZusatz(string.trim());
        }
        if (estateImpl.getAddress().getLatitude() != null && estateImpl.getAddress().getLongitude() != null) {
            list = this.FACTORY.createGeokoordinaten();
            list.setBreitengrad(estateImpl.getAddress().getLatitude());
            list.setLaengengrad(estateImpl.getAddress().getLongitude());
            geo.setGeokoordinaten((Geokoordinaten)list);
        }
        list = Zone.getAsList((EstateImpl)estateImpl);
        List list2 = CommercialZone.getAsList((EstateImpl)estateImpl);
        if (!list.isEmpty() || !list2.isEmpty()) {
            object = this.FACTORY.createLageGebiet();
            if (list2.contains(CommercialZone.Option.LOCATION_A) || list2.contains(CommercialZone.Option.LOCATION_1A) || list2.contains(CommercialZone.Option.LOCATION_2A)) {
                object.setGebiete(LageGebiet.Gebiete.A_LAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list2.contains(CommercialZone.Option.LOCATION_B) || list2.contains(CommercialZone.Option.LOCATION_1B) || list2.contains(CommercialZone.Option.LOCATION_2B)) {
                object.setGebiete(LageGebiet.Gebiete.B_LAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list2.contains(CommercialZone.Option.SHOPPING_CENTER) || list2.contains(CommercialZone.Option.PREDESTRIAN_ZONE) || list.contains(Zone.Option.COMMERCIAL)) {
                object.setGebiete(LageGebiet.Gebiete.GEWERBE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.MIXED)) {
                object.setGebiete(LageGebiet.Gebiete.MISCH);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.INDUSTRIAL)) {
                object.setGebiete(LageGebiet.Gebiete.INDUSTRIE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.SUBSIDIARY_CENTER)) {
                object.setGebiete(LageGebiet.Gebiete.NEBENZENTRUM);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.DEVELOPMENT)) {
                object.setGebiete(LageGebiet.Gebiete.NEUBAU);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.CITY) || list.contains(Zone.Option.VILLAGE_CENTER) || list.contains(Zone.Option.VILLAGE_EDGE)) {
                object.setGebiete(LageGebiet.Gebiete.ORTSLAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.VILLAGE)) {
                object.setGebiete(LageGebiet.Gebiete.SIEDLUNG);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.SUBURBS)) {
                object.setGebiete(LageGebiet.Gebiete.STADTRAND);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.DISTRICT)) {
                object.setGebiete(LageGebiet.Gebiete.STADTTEIL);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.CITY_CENTER)) {
                object.setGebiete(LageGebiet.Gebiete.STADTZENTRUM);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains(Zone.Option.RESIDENTIAL)) {
                object.setGebiete(LageGebiet.Gebiete.WOHN);
                geo.setLageGebiet((LageGebiet)object);
            }
        }
        if ((object = LocationInBuilding.getAsList((EstateImpl)estateImpl)) != null && !object.isEmpty()) {
            LageImBau lageImBau = this.FACTORY.createLageImBau();
            if (object.contains(LocationInBuilding.Option.BACKYARD_BUILDING)) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setHINTEN(Boolean.valueOf(true));
            }
            if (object.contains(LocationInBuilding.Option.SIDE_WING_LEFT)) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setLINKS(Boolean.valueOf(true));
            }
            if (object.contains(LocationInBuilding.Option.SIDE_WING_RIGHT)) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setRECHTS(Boolean.valueOf(true));
            }
            if (object.contains(LocationInBuilding.Option.FRONT_BUILDING)) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setVORNE(Boolean.valueOf(true));
            }
        }
    }

    protected void writeImmobilieInfrastruktur(Infrastruktur infrastruktur, EstateImpl estateImpl) {
        BigDecimal bigDecimal;
        if (infrastruktur == null) {
            return;
        }
        List list = View.getAsList((EstateImpl)estateImpl);
        if (list != null && !list.isEmpty()) {
            bigDecimal = this.FACTORY.createAusblick();
            if (list.contains(View.Option.MOUNTAIN_VIEW)) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)bigDecimal);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.BERGE);
            }
            if (list.contains(View.Option.DISTANT_VIEW)) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)bigDecimal);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.FERNE);
            }
            if (list.contains(View.Option.LAKE_VIEW)) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)bigDecimal);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.SEE);
            }
            if (list.contains(View.Option.SEA_VIEW)) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)bigDecimal);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.MEER);
            }
        }
        if ((bigDecimal = DistanceToMotorway.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.AUTOBAHN, bigDecimal));
        }
        if ((bigDecimal = DistanceToBusStation.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.BUS, bigDecimal));
        }
        if ((bigDecimal = DistanceToNextShopping.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.EINKAUFSMOEGLICHKEITEN, bigDecimal));
        }
        if ((bigDecimal = DistanceToMainLineStation.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.FERNBAHNHOF, bigDecimal));
        }
        if ((bigDecimal = DistanceToAirport.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.FLUGHAFEN, bigDecimal));
        }
        if ((bigDecimal = DistanceToNextGastronomy.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GASTSTAETTEN, bigDecimal));
        }
        if ((bigDecimal = DistanceToComprehensiveSchool.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GESAMTSCHULE, bigDecimal));
        }
        if ((bigDecimal = DistanceToElementarySchool.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GRUNDSCHULE, bigDecimal));
        }
        if ((bigDecimal = DistanceToHighSchool.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GYMNASIUM, bigDecimal));
        }
        if ((bigDecimal = DistanceToJuniorHighSchool.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.HAUPTSCHULE, bigDecimal));
        }
        if ((bigDecimal = DistanceToDayNursery.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.KINDERGAERTEN, bigDecimal));
        }
        if ((bigDecimal = DistanceToSecondarySchool.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.REALSCHULE, bigDecimal));
        }
        if ((bigDecimal = DistanceToNextTrainStation.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.US_BAHN, bigDecimal));
        }
        if ((bigDecimal = DistanceToCityCentre.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.ZENTRUM, bigDecimal));
        }
        if ((bigDecimal = DistanceToSea.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.MEER, bigDecimal));
        }
        if ((bigDecimal = DistanceToRecreationalArea.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.NAHERHOLUNG, bigDecimal));
        }
        if ((bigDecimal = DistanceToLake.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SEE, bigDecimal));
        }
        if ((bigDecimal = DistanceToSkiingArea.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SKIGEBIET, bigDecimal));
        }
        if ((bigDecimal = DistanceToSportsFacilities.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SPORTANLAGEN, bigDecimal));
        }
        if ((bigDecimal = DistanceToBeach.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.STRAND, bigDecimal));
        }
        if ((bigDecimal = DistanceToWanderingArea.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.KM)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.WANDERGEBIETE, bigDecimal));
        }
        infrastruktur.setZulieferung(SupplyPossible.get((EstateImpl)estateImpl));
    }

    protected void writeImmobilieKontaktperson(Kontaktperson kontaktperson, AgentContactImpl agentContactImpl, AgentImpl agentImpl) {
        if (kontaktperson == null) {
            return;
        }
        this.writeImmobilieKontaktperson(kontaktperson, (PersonAddressImpl)agentContactImpl, agentImpl);
        kontaktperson.setPersonennummer(StringUtils.trimToNull((String)agentContactImpl.getId()));
        URI uRI = agentContactImpl.getContactWebsite();
        if (uRI != null) {
            kontaktperson.setUrl(uRI.toString());
        }
    }

    protected void writeImmobilieKontaktperson(Kontaktperson kontaktperson, PersonAddressImpl personAddressImpl, AgentImpl agentImpl) {
        URI uRI;
        String string;
        if (kontaktperson == null) {
            return;
        }
        kontaktperson.setHausnummer(StringUtils.trimToNull((String)personAddressImpl.getStreetNr()));
        kontaktperson.setName(StringUtils.trimToNull((String)personAddressImpl.getPersonLastName()));
        kontaktperson.setOrt(StringUtils.trimToNull((String)personAddressImpl.getCity()));
        kontaktperson.setPersonennummer(null);
        kontaktperson.setPlz(StringUtils.trimToNull((String)personAddressImpl.getPostalCode()));
        kontaktperson.setStrasse(StringUtils.trimToNull((String)personAddressImpl.getStreet()));
        kontaktperson.setTitel(StringUtils.trimToNull((String)personAddressImpl.getPersonTitle()));
        kontaktperson.setVorname(StringUtils.trimToNull((String)personAddressImpl.getPersonFirstName()));
        if (Gender.FEMALE.equals((Object)personAddressImpl.getPersonGender())) {
            kontaktperson.setAnrede("Frau");
        } else if (Gender.MALE.equals((Object)personAddressImpl.getPersonGender())) {
            kontaktperson.setAnrede("Herr");
        }
        if (!StringUtils.isBlank((CharSequence)personAddressImpl.getCountry()) && (string = OpenEstateUtils.convertToIso3Country((String)personAddressImpl.getCountry())) != null && string.length() == 3) {
            kontaktperson.setLand(this.FACTORY.createLand());
            kontaktperson.getLand().setIsoLand(string);
        }
        Object object = string = agentImpl != null ? agentImpl.getCompany() : null;
        if (string != null && (uRI = string.getCompanyWebsite()) != null) {
            kontaktperson.setUrl(uRI.toString());
        }
        kontaktperson.setEmailDirekt(StringUtils.trimToNull((String)personAddressImpl.getPersonMail()));
        kontaktperson.setTelDurchw(StringUtils.trimToNull((String)personAddressImpl.getPersonPhone()));
        kontaktperson.setTelFax(StringUtils.trimToNull((String)personAddressImpl.getPersonFax()));
        kontaktperson.setTelHandy(StringUtils.trimToNull((String)personAddressImpl.getPersonMobilePhone()));
        if (string != null) {
            kontaktperson.setEmailZentrale(StringUtils.trimToNull((String)string.getCompanyMail()));
            kontaktperson.setTelZentrale(StringUtils.trimToNull((String)string.getCompanyPhone()));
        }
        kontaktperson.setEmailFeedback(kontaktperson.getEmailDirekt());
        if (kontaktperson.getEmailFeedback() == null) {
            kontaktperson.setEmailFeedback(kontaktperson.getEmailZentrale());
        }
    }

    protected void writeImmobilieObjektkategorie(Objektkategorie objektkategorie, EstateImpl estateImpl) {
        if (objektkategorie == null || estateImpl.getAction() == null || estateImpl.getType() == null) {
            return;
        }
        OpenEstateAction openEstateAction = estateImpl.getAction();
        OpenEstateType openEstateType = estateImpl.getType();
        List<OpenEstateType> list = Arrays.asList(openEstateType.getParentPath());
        objektkategorie.setVermarktungsart(this.FACTORY.createVermarktungsart());
        objektkategorie.getVermarktungsart().setERBPACHT(Boolean.valueOf(OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)));
        objektkategorie.getVermarktungsart().setKAUF(OpenEstateAction.PURCHASE.equals((Object)openEstateAction) || OpenEstateAction.AUCTION.equals((Object)openEstateAction));
        objektkategorie.getVermarktungsart().setMIETEPACHT(OpenEstateAction.RENT.equals((Object)openEstateAction) || OpenEstateAction.LEASE.equals((Object)openEstateAction) || OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction));
        List list2 = Usage.getAsList((EstateImpl)estateImpl);
        objektkategorie.setNutzungsart(this.FACTORY.createNutzungsart());
        objektkategorie.getNutzungsart().setWAZ(Boolean.valueOf(OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)));
        objektkategorie.getNutzungsart().setGEWERBE(list2.contains(Usage.Option.COMMERCIAL));
        objektkategorie.getNutzungsart().setWOHNEN(list2.contains(Usage.Option.RESIDENTIAL));
        objektkategorie.getNutzungsart().setANLAGE(Boolean.valueOf(list2.contains(Usage.Option.INVESTMENT)));
        if (!(objektkategorie.getNutzungsart().getANLAGE().booleanValue() || objektkategorie.getNutzungsart().isGEWERBE() || objektkategorie.getNutzungsart().getWAZ().booleanValue() || objektkategorie.getNutzungsart().isWOHNEN())) {
            if (list.contains(OpenEstateType.GENERAL_RESIDENCE) || list.contains(OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL) || list.contains(OpenEstateType.RESIDENTIAL_GROUND)) {
                objektkategorie.getNutzungsart().setWOHNEN(true);
            }
            if (list.contains(OpenEstateType.GENERAL_COMMERCIAL) || list.contains(OpenEstateType.GENERAL_AGRICULTURE) || list.contains(OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL) || list.contains(OpenEstateType.COMMERCIAL_GROUND) || list.contains(OpenEstateType.INDUSTRIAL_GROUND)) {
                objektkategorie.getNutzungsart().setGEWERBE(true);
            }
        }
        objektkategorie.setObjektart(this.FACTORY.createObjektart());
        if (list.contains(OpenEstateType.ASSISTED_LIVING)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.BETREUTES_WOHNEN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && (list.contains(OpenEstateType.OFFICE_BUILDING) || list.contains(OpenEstateType.OFFICE_CENTER))) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.BUEROGEBAEUDE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && (list.contains(OpenEstateType.SHOPPING_CENTER) || list.contains(OpenEstateType.DEPARTMENT_STORE))) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.EINKAUFSCENTREN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && list.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.GESCHAEFTSHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && (list.contains(OpenEstateType.INDUSTRIAL_FACILITY) || list.contains(OpenEstateType.INDUSTRIAL_WAREHOUSE))) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.INDUSTRIEANLAGEN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && list.contains(OpenEstateType.MULTI_FAMILY_HOUSE)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.MEHRFAMILIENHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains(OpenEstateType.CARE_HOME)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.PFLEGEHEIM);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains(OpenEstateType.SANATORIUM)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.SANATORIUM);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains(OpenEstateType.SENIOR_HOUSING_COMPLEX)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.SENIORENHEIM);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && list.contains(OpenEstateType.SELF_SERVICE_MARKET)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.SB_MAERKTE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && list.contains(OpenEstateType.CONSUMER_STORE)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.VERBRAUCHERMAERKTE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains(OpenEstateType.HOUSING_COMPLEX)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.WOHNANLAGEN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().getANLAGE().booleanValue() && list.contains(OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING)) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = this.FACTORY.createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.WOHN_UND_GESCHAEFTSHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains(OpenEstateType.ROOM)) {
            Zimmer zimmer = this.FACTORY.createZimmer();
            zimmer.setZimmertyp(Zimmer.Zimmertyp.ZIMMER);
            objektkategorie.getObjektart().getZimmer().add(zimmer);
        } else if (list.contains(OpenEstateType.PETROL_STATION)) {
            Sonstige sonstige = this.FACTORY.createSonstige();
            for (int i = list.size(); i > 0; --i) {
                Sonstige.SonstigeTyp sonstigeTyp = this.getObjektartSonstigeTyp(list.get(i - 1));
                if (sonstigeTyp == null) continue;
                sonstige.setSonstigeTyp(sonstigeTyp);
                break;
            }
            objektkategorie.getObjektart().getSonstige().add(sonstige);
        } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            Parken parken = this.FACTORY.createParken();
            for (int i = list.size(); i > 0; --i) {
                Parken.ParkenTyp parkenTyp = this.getObjektartParkenTyp(list.get(i - 1));
                if (parkenTyp == null) continue;
                parken.setParkenTyp(parkenTyp);
                break;
            }
            objektkategorie.getObjektart().getParken().add(parken);
        } else if (list.contains(OpenEstateType.OFFICE_SURGERY) || list.contains(OpenEstateType.OFFICE_COMMERCIAL_PREMISE) || list.contains(OpenEstateType.EXHIBITION_AREA)) {
            BueroPraxen bueroPraxen = this.FACTORY.createBueroPraxen();
            for (int i = list.size(); i > 0; --i) {
                BueroPraxen.BueroTyp bueroTyp = this.getObjektartBueroTyp(list.get(i - 1));
                if (bueroTyp == null) continue;
                bueroPraxen.setBueroTyp(bueroTyp);
                break;
            }
            objektkategorie.getObjektart().getBueroPraxen().add(bueroPraxen);
        } else if (list.contains(OpenEstateType.RETAIL)) {
            Einzelhandel einzelhandel = this.FACTORY.createEinzelhandel();
            for (int i = list.size(); i > 0; --i) {
                Einzelhandel.HandelTyp handelTyp = this.getObjektartHandelTyp(list.get(i - 1));
                if (handelTyp == null) continue;
                einzelhandel.setHandelTyp(handelTyp);
                break;
            }
            objektkategorie.getObjektart().getEinzelhandel().add(einzelhandel);
        } else if ((list.contains(OpenEstateType.GENERAL_AGRICULTURE) || list.contains(OpenEstateType.RIDING_ESTATE)) && !list.contains(OpenEstateType.REST_OF_A_FARM)) {
            LandUndForstwirtschaft landUndForstwirtschaft = this.FACTORY.createLandUndForstwirtschaft();
            for (int i = list.size(); i > 0; --i) {
                LandUndForstwirtschaft.LandTyp landTyp = this.getObjektartLandTyp(list.get(i - 1));
                if (landTyp == null) continue;
                landUndForstwirtschaft.setLandTyp(landTyp);
                break;
            }
            if (landUndForstwirtschaft.getLandTyp() == null) {
                landUndForstwirtschaft.setLandTyp(LandUndForstwirtschaft.LandTyp.SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN);
            }
            objektkategorie.getObjektart().getLandUndForstwirtschaft().add(landUndForstwirtschaft);
        } else if (list.contains(OpenEstateType.LEISURE_SPORTS_FACILITY)) {
            FreizeitimmobilieGewerblich freizeitimmobilieGewerblich = this.FACTORY.createFreizeitimmobilieGewerblich();
            for (int i = list.size(); i > 0; --i) {
                FreizeitimmobilieGewerblich.FreizeitTyp freizeitTyp = this.getObjektartFreizeitTyp(list.get(i - 1));
                if (freizeitTyp == null) continue;
                freizeitimmobilieGewerblich.setFreizeitTyp(freizeitTyp);
                break;
            }
            objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().add(freizeitimmobilieGewerblich);
        } else if (list.contains(OpenEstateType.HOSPITALITY_INDUSTRY) || list.contains(OpenEstateType.GASTRONOMY)) {
            Gastgewerbe gastgewerbe = this.FACTORY.createGastgewerbe();
            for (int i = list.size(); i > 0; --i) {
                Gastgewerbe.GastgewTyp gastgewTyp = this.getObjektartGastgewTyp(list.get(i - 1));
                if (gastgewTyp == null) continue;
                gastgewerbe.setGastgewTyp(gastgewTyp);
                break;
            }
            objektkategorie.getObjektart().getGastgewerbe().add(gastgewerbe);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            Grundstueck grundstueck = this.FACTORY.createGrundstueck();
            for (int i = list.size(); i > 0; --i) {
                Grundstueck.GrundstTyp grundstTyp = this.getObjektartGrundstTyp(list.get(i - 1));
                if (grundstTyp == null) continue;
                grundstueck.setGrundstTyp(grundstTyp);
                break;
            }
            objektkategorie.getObjektart().getGrundstueck().add(grundstueck);
        } else if (list.contains(OpenEstateType.HALL_WAREHOUSE) || list.contains(OpenEstateType.PRODUCTION) || list.contains(OpenEstateType.SERVICE_AREA)) {
            HallenLagerProd hallenLagerProd = this.FACTORY.createHallenLagerProd();
            for (int i = list.size(); i > 0; --i) {
                HallenLagerProd.HallenTyp hallenTyp = this.getObjektartHallenTyp(list.get(i - 1));
                if (hallenTyp == null) continue;
                hallenLagerProd.setHallenTyp(hallenTyp);
                break;
            }
            objektkategorie.getObjektart().getHallenLagerProd().add(hallenLagerProd);
        } else if (list.contains(OpenEstateType.HOUSE) || list.contains(OpenEstateType.HOSPITAL_CLINIC) || list.contains(OpenEstateType.ASSISTED_LIVING) || list.contains(OpenEstateType.SENIOR_HOUSING_COMPLEX) || list.contains(OpenEstateType.REST_OF_A_FARM)) {
            Haus haus = this.FACTORY.createHaus();
            if (BuildingStyle.Option.PREFABRICATED_HOUSE.equals((Object)BuildingStyle.get((EstateImpl)estateImpl))) {
                haus.setHaustyp(Haus.Haustyp.FERTIGHAUS);
            } else {
                for (int i = list.size(); i > 0; --i) {
                    Haus.Haustyp haustyp = this.getObjektartHaustyp(list.get(i - 1));
                    if (haustyp == null) continue;
                    haus.setHaustyp(haustyp);
                    break;
                }
            }
            objektkategorie.getObjektart().getHaus().add(haus);
        } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE) || list.contains(OpenEstateType.HOUSING_COMPLEX)) {
            Wohnung wohnung = this.FACTORY.createWohnung();
            if (Boolean.TRUE.equals(HolidayProperty.get((EstateImpl)estateImpl))) {
                wohnung.setWohnungtyp(Wohnung.Wohnungtyp.FERIENWOHNUNG);
            } else {
                for (int i = list.size(); i > 0; --i) {
                    Wohnung.Wohnungtyp wohnungtyp = this.getObjektartWohnungtyp(list.get(i - 1));
                    if (wohnungtyp == null) continue;
                    wohnung.setWohnungtyp(wohnungtyp);
                    break;
                }
            }
            objektkategorie.getObjektart().getWohnung().add(wohnung);
        } else {
            LOGGER.debug("Can't resolve estate-type for " + openEstateType + ", fallback to <Sonstige>");
            Sonstige sonstige = this.FACTORY.createSonstige();
            sonstige.setSonstigeTyp(Sonstige.SonstigeTyp.SONSTIGE);
            objektkategorie.getObjektart().getSonstige().add(sonstige);
        }
        objektkategorie.getObjektart().getObjektartZusatz().add(openEstateType.name());
    }

    protected void writeImmobiliePreise(Preise preise, EstateImpl estateImpl) {
        Object object;
        BigDecimal bigDecimal;
        if (preise == null) {
            return;
        }
        preise.setAbstand(TakeoverCosts.getAsBigDecimal((EstateImpl)estateImpl));
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_AGENT_FEE)) {
            preise.setAussenCourtage(this.FACTORY.createAussenCourtage());
            preise.getAussenCourtage().setContent(AgentFee.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            preise.getAussenCourtage().setMitMwst(AgentFeeIncludingVat.get((EstateImpl)estateImpl));
        }
        preise.setCourtageHinweis(AgentFeeInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            preise.setErbpacht(Lease.getAsBigDecimal((EstateImpl)estateImpl));
        }
        preise.setErschliessungskosten(DevelopmentCosts.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setFreitextPreis(PriceDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        preise.setGeschaeftsguthaben(SharedCapital.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setHausgeld(CommonCharge.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setHeizkosten(HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setHeizkostenEnthalten(ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl));
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            bigDecimal = RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl);
            object = ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            if (bigDecimal != null && object != null) {
                preise.setKaltmiete(bigDecimal.subtract((BigDecimal)object));
            }
        } else {
            preise.setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            preise.setKaufpreis(this.FACTORY.createKaufpreis());
            preise.getKaufpreis().setAufAnfrage(Boolean.valueOf(estateImpl.isHiddenPrices()));
            preise.getKaufpreis().setValue(!estateImpl.isHiddenPrices() ? PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl) : BigDecimal.ZERO);
            preise.setKaufpreisProQm(PurchasePricePerArea.getAsBigDecimal((EstateImpl)estateImpl));
        }
        preise.setKaution(DepositAmount.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setKautionText(Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENTAL_INCOME_ACTUAL_PER_ANNUM)) {
            preise.setMieteinnahmenIst(this.FACTORY.createMieteinnahmenIst());
            preise.getMieteinnahmenIst().setPeriode(MieteinnahmenIst.Periode.JAHR);
            preise.getMieteinnahmenIst().setValue(RentalIncomeActualPerAnnum.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENTAL_INCOME_DEBIT_PER_ANNUM)) {
            preise.setMieteinnahmenSoll(this.FACTORY.createMieteinnahmenSoll());
            preise.getMieteinnahmenSoll().setPeriode(MieteinnahmenSoll.Periode.JAHR);
            preise.getMieteinnahmenSoll().setValue(RentalIncomeDebitPerAnnum.getAsBigDecimal((EstateImpl)estateImpl));
        }
        preise.setMietpreisProQm(RentExcludingServiceChargesPerArea.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setMietzuschlaege(AdditionalRentalCharges.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setMwstGesamt(VatValue.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setMwstSatz(VatRate.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setNettokaltmiete(BasicRent.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setNettorendite(NetReturn.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setPacht(Lease.getAsBigDecimal((EstateImpl)estateImpl));
        preise.setPauschalmiete(RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl));
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_FLAT_RATE_PER)) {
            bigDecimal = RentFlatRatePer.get((EstateImpl)estateImpl);
            if (RentFlatRatePer.Option.YEAR.equals((Object)bigDecimal)) {
                preise.setPreisZeiteinheit(this.FACTORY.createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.JAHR);
            } else if (RentFlatRatePer.Option.MONTH.equals((Object)bigDecimal)) {
                preise.setPreisZeiteinheit(this.FACTORY.createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.MONAT);
            } else if (RentFlatRatePer.Option.DAY.equals((Object)bigDecimal)) {
                preise.setPreisZeiteinheit(this.FACTORY.createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.TAG);
            } else if (RentFlatRatePer.Option.WEEK.equals((Object)bigDecimal)) {
                preise.setPreisZeiteinheit(this.FACTORY.createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.WOCHE);
            }
        }
        preise.setPreisZeitraumBis(ChargeEndDate.getAsCalendar((EstateImpl)estateImpl));
        preise.setPreisZeitraumVon(ChargeBeginDate.getAsCalendar((EstateImpl)estateImpl));
        preise.setProvisionspflichtig(AgentFeeRequired.get((EstateImpl)estateImpl));
        bigDecimal = null;
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_CAR_PARKING_SPACE_PRICE)) {
            bigDecimal = this.FACTORY.createStellplatz();
            bigDecimal.setStellplatzkaufpreis(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_CAR_PARKING_SPACE_RENT)) {
            if (bigDecimal == null) {
                bigDecimal = this.FACTORY.createStellplatz();
            }
            bigDecimal.setStellplatzmiete(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.MEASURES_COUNT_PARKING_SPACES)) {
            if (bigDecimal == null) {
                bigDecimal = this.FACTORY.createStellplatz();
            }
            bigDecimal.setAnzahl(CountParkingSpaces.getAsBigInteger((EstateImpl)estateImpl));
        }
        if (!estateImpl.hasAttribute(OpenEstateAttrib.MEASURES_CAR_PARKING_TYPE)) {
            if (bigDecimal != null) {
                preise.setStpFreiplatz((Stellplatz)bigDecimal);
            }
        } else {
            if (bigDecimal == null) {
                bigDecimal = this.FACTORY.createStellplatz();
            }
            if ((object = CarParkingType.getAsList((EstateImpl)estateImpl)).contains(CarParkingType.Option.OUTDOOR)) {
                preise.setStpFreiplatz((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.CARPORT)) {
                preise.setStpCarport((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.DOUBLE_GARAGE)) {
                preise.setStpGarage((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
                preise.setStpDuplex((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.GARAGE)) {
                preise.setStpGarage((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
                preise.setStpParkhaus((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.GENERAL)) {
                preise.setStpFreiplatz((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.COMMUNAL)) {
                preise.setStpFreiplatz((Stellplatz)bigDecimal);
            } else if (object.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
                preise.setStpTiefgarage((Stellplatz)bigDecimal);
            } else {
                preise.setStpFreiplatz((Stellplatz)bigDecimal);
            }
        }
        if (estateImpl.getCurrency() != null) {
            preise.setWaehrung(this.FACTORY.createWaehrung());
            preise.getWaehrung().setIsoWaehrung(estateImpl.getCurrency().getCurrencyCode());
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            preise.setWarmmiete(RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            preise.setWarmmiete(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        }
        preise.setXFache(PurchasePriceOnAnnualRentalIncome.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        preise.setZzgMehrwertsteuer(PlusVat.get((EstateImpl)estateImpl));
        if (this.isAt10ExtensionEnabled()) {
            object = this.FACTORY.createUserDefinedAnyfield();
            BigDecimal bigDecimal2 = VatValue.getAsBigDecimal((EstateImpl)estateImpl);
            if (bigDecimal2 != null) {
                object.getContent().add(new JAXBElement(new QName("mwst_gesamt"), BigDecimal.class, (Object)bigDecimal2));
                if (preise.getWarmmiete() != null && preise.getKaltmiete() != null && preise.getNebenkosten() != null && preise.getHeizkosten() != null) {
                    BigDecimal bigDecimal3 = preise.getWarmmiete().subtract(preise.getKaltmiete()).subtract(preise.getNebenkosten()).subtract(preise.getHeizkosten()).subtract(bigDecimal2);
                    object.getContent().add(new JAXBElement(new QName("sonstige_kosten"), BigDecimal.class, (Object)bigDecimal3));
                }
            }
            if (!object.getContent().isEmpty()) {
                preise.getUserDefinedAnyfield().add(object);
            }
        }
    }

    protected void writeImmobilieVersteigerung(Versteigerung versteigerung, EstateImpl estateImpl) {
        if (versteigerung == null) {
            return;
        }
        versteigerung.setAktenzeichen(CountryCourtFileReference.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        versteigerung.setAmtsgericht(CountryCourtName.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        versteigerung.setVerkehrswert(MarketValue.getAsBigDecimal((EstateImpl)estateImpl));
        versteigerung.setZvtermin(AuctionDate.getAsCalendar((EstateImpl)estateImpl));
        versteigerung.setZwangsversteigerung(AuctionCompulsory.get((EstateImpl)estateImpl));
    }

    protected void writeImmobilieVerwaltungObjekt(VerwaltungObjekt verwaltungObjekt, EstateImpl estateImpl) {
        Calendar calendar;
        NonSmoker.Option option;
        Pets.Option option2;
        CommercialUse.Option option3;
        if (verwaltungObjekt == null) {
            return;
        }
        verwaltungObjekt.setAbdatum(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        verwaltungObjekt.setAlsFerien(HolidayProperty.get((EstateImpl)estateImpl));
        verwaltungObjekt.setBisdatum(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        verwaltungObjekt.setBranchen(CommercialIndustries.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        verwaltungObjekt.setDenkmalgeschuetzt(MonumentalProtection.get((EstateImpl)estateImpl));
        verwaltungObjekt.setGruppennummer(StringUtils.trimToNull((String)estateImpl.getGroupId()));
        verwaltungObjekt.setHochhaus(Skyscraper.get((EstateImpl)estateImpl));
        verwaltungObjekt.setLaufzeit(EmphyteusisDuration.getAsBigDecimal((EstateImpl)estateImpl));
        verwaltungObjekt.setMaxPersonen(PeopleMaximumCount.getAsBigInteger((EstateImpl)estateImpl));
        verwaltungObjekt.setObjektadresseFreigeben(Boolean.valueOf(estateImpl.getAddress().isPublished()));
        verwaltungObjekt.setVermietet(Rented.get((EstateImpl)estateImpl));
        verwaltungObjekt.setVersteigerungstermin(AuctionDate.getAsCalendar((EstateImpl)estateImpl));
        verwaltungObjekt.setWbsSozialwohnung(WbsRequired.get((EstateImpl)estateImpl));
        verwaltungObjekt.setZugang(AccessBeginDate.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        GenderOfRequestedFlatmates.Option option4 = GenderOfRequestedFlatmates.get((EstateImpl)estateImpl);
        if (option4 != null) {
            verwaltungObjekt.setGeschlecht(this.FACTORY.createGeschlecht());
            if (GenderOfRequestedFlatmates.Option.INDIFFERENT.equals((Object)option4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.EGAL);
            } else if (GenderOfRequestedFlatmates.Option.FEMALE.equals((Object)option4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.NUR_FRAU);
            } else if (GenderOfRequestedFlatmates.Option.MALE.equals((Object)option4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.NUR_MANN);
            }
        }
        if ((option3 = CommercialUse.get((EstateImpl)estateImpl)) != null) {
            verwaltungObjekt.setGewerblicheNutzung(Boolean.valueOf(CommercialUse.Option.YES.equals((Object)option3) || CommercialUse.Option.PARTIALLY.equals((Object)option3)));
        }
        if (Pets.Option.YES.equals((Object)(option2 = Pets.get((EstateImpl)estateImpl)))) {
            verwaltungObjekt.setHaustiere(Boolean.valueOf(true));
        } else if (Pets.Option.NO.equals((Object)option2)) {
            verwaltungObjekt.setHaustiere(Boolean.valueOf(false));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.ADMINISTRATION_OCCUPATION_PERIOD_MAXIMUM)) {
            verwaltungObjekt.setMaxMietdauer(this.FACTORY.createMaxMietdauer());
            verwaltungObjekt.getMaxMietdauer().setContent(OccupationPeriodMaximum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.ADMINISTRATION_OCCUPATION_PERIOD_MINIMUM)) {
            verwaltungObjekt.setMinMietdauer(this.FACTORY.createMinMietdauer());
            verwaltungObjekt.getMinMietdauer().setContent(OccupationPeriodMinimum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        if (NonSmoker.Option.YES.equals((Object)(option = NonSmoker.get((EstateImpl)estateImpl)))) {
            verwaltungObjekt.setNichtraucher(Boolean.valueOf(true));
        } else if (NonSmoker.Option.NO.equals((Object)option)) {
            verwaltungObjekt.setNichtraucher(Boolean.valueOf(false));
        } else if (NonSmoker.Option.INDIFFERENT.equals((Object)option)) {
            verwaltungObjekt.setNichtraucher(Boolean.valueOf(false));
        }
        verwaltungObjekt.setVerfuegbarAb(AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (StringUtils.isBlank((CharSequence)verwaltungObjekt.getVerfuegbarAb()) && (calendar = AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl)) != null) {
            verwaltungObjekt.setVerfuegbarAb(DateFormat.getDateInstance(2, this.getOpenEstateLanguage()).format(calendar.getTime()));
        }
    }

    protected void writeImmobilieVerwaltungTechn(VerwaltungTechn verwaltungTechn, EstateImpl estateImpl) {
        Cloneable cloneable;
        if (verwaltungTechn == null) {
            return;
        }
        verwaltungTechn.setAktion(this.FACTORY.createAktion());
        verwaltungTechn.getAktion().setAktionart(Aktion.AktionArt.CHANGE);
        if (estateImpl.getPublishEnd() != null) {
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime(estateImpl.getPublishEnd());
            verwaltungTechn.setAktivBis((Calendar)cloneable);
        }
        if (estateImpl.getPublishBegin() != null) {
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime(estateImpl.getPublishBegin());
            verwaltungTechn.setAktivVon((Calendar)cloneable);
        }
        if ((cloneable = this.getOpenEstateLanguage()) != null) {
            String string = StringUtils.trimToEmpty((String)((Locale)cloneable).getLanguage());
            String string2 = StringUtils.trimToNull((String)((Locale)cloneable).getCountry());
            if (string2 == null) {
                verwaltungTechn.setSprache(string.toLowerCase());
            } else {
                verwaltungTechn.setSprache(string.toLowerCase() + "-" + string2.toUpperCase());
            }
        }
        verwaltungTechn.setObjektnrExtern(StringUtils.trimToNull((String)((String)StringUtils.defaultIfBlank((CharSequence)estateImpl.getPublicId(), (CharSequence)estateImpl.getId()))));
        verwaltungTechn.setObjektnrIntern(StringUtils.trimToNull((String)estateImpl.getId()));
        verwaltungTechn.setOpenimmoObid(StringUtils.trimToNull((String)estateImpl.getId()));
        verwaltungTechn.setStandVom(EffectiveDate.getAsCalendar((EstateImpl)estateImpl));
        if (verwaltungTechn.getStandVom() == null) {
            verwaltungTechn.setStandVom(Calendar.getInstance());
        }
    }

    protected void writeImmobilieWeitereAdressen(List<WeitereAdresse> list, EstateImpl estateImpl) {
    }

    protected void writeImmobilieZustandAngaben(ZustandAngaben zustandAngaben, EstateImpl estateImpl) {
        ConditionType.Option option;
        Object object;
        Object object2;
        Comparable<BigDecimal> comparable;
        Calendar calendar;
        Date date;
        Comparable<Boolean> comparable2;
        BigDecimal bigDecimal;
        BuildableAccordingTo.Option option2;
        if (zustandAngaben == null) {
            return;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(2);
        String string = estateImpl.getAddress().getCountry();
        boolean bl = "de".equalsIgnoreCase(string) || "deu".equalsIgnoreCase(string);
        zustandAngaben.setAltlasten(ContaminatedSites.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        zustandAngaben.setBaujahr(OpenEstateUtils.toString((Object)BuildYear.getAsInteger((EstateImpl)estateImpl), null));
        zustandAngaben.setLetztemodernisierung(OpenEstateUtils.toString((Object)RefurbishmentYear.getAsInteger((EstateImpl)estateImpl), null));
        Age.Option option3 = Age.get((EstateImpl)estateImpl);
        if (option3 != null) {
            zustandAngaben.setAlter(this.FACTORY.createAlter());
            if (Age.Option.OLD_BUILDING.equals((Object)option3)) {
                zustandAngaben.getAlter().setAlterAttr(Alter.AlterAttr.ALTBAU);
            } else if (Age.Option.NEW_BUILDING.equals((Object)option3)) {
                zustandAngaben.getAlter().setAlterAttr(Alter.AlterAttr.NEUBAU);
            }
        }
        if ((option2 = BuildableAccordingTo.get((EstateImpl)estateImpl)) != null) {
            zustandAngaben.setBebaubarNach(this.FACTORY.createBebaubarNach());
            if (BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.AUSSENGEBIET);
            } else if (BuildableAccordingTo.Option.GREENFIELD_DEVELOPMENT.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.BAUERWARTUNGSLAND);
            } else if (BuildableAccordingTo.Option.NO_SITE_PLAN.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.BAULAND_OHNE_B_PLAN);
            } else if (BuildableAccordingTo.Option.BINDING_SITE_PLAN.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.B_PLAN);
            } else if (BuildableAccordingTo.Option.NO_DEVELOPMENT_AREA.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.KEIN_BAULAND);
            } else if (BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT.equals((Object)option2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.NACHBARSCHAFT);
            }
        }
        Energiepass energiepass = null;
        Type.Option option4 = Type.get((EstateImpl)estateImpl);
        if (option4 != null) {
            if (Type.Option.DEMAND.equals((Object)option4)) {
                energiepass = this.FACTORY.createEnergiepass();
                energiepass.setEpart(Energiepass.Epart.BEDARF);
                bigDecimal = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    energiepass.setEndenergiebedarf(numberFormat.format(bigDecimal));
                }
            } else if (Type.Option.CONSUMPTION.equals((Object)option4)) {
                energiepass = this.FACTORY.createEnergiepass();
                energiepass.setEpart(Energiepass.Epart.VERBRAUCH);
                energiepass.setMitwarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
                bigDecimal = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    energiepass.setEnergieverbrauchkennwert(numberFormat.format(bigDecimal));
                }
            }
        } else {
            bigDecimal = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            comparable2 = Available.get((EstateImpl)estateImpl);
            if (Boolean.TRUE.equals(comparable2) && bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                energiepass = this.FACTORY.createEnergiepass();
                energiepass.setEpart(Energiepass.Epart.VERBRAUCH);
                energiepass.setEnergieverbrauchkennwert(numberFormat.format(bigDecimal));
            }
        }
        bigDecimal = null;
        comparable2 = null;
        BigDecimal bigDecimal2 = null;
        if (energiepass != null) {
            if (Energiepass.Epart.BEDARF.equals((Object)energiepass.getEpart())) {
                bigDecimal = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                comparable2 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                bigDecimal2 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            } else if (Energiepass.Epart.VERBRAUCH.equals((Object)energiepass.getEpart())) {
                bigDecimal = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                comparable2 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                bigDecimal2 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (comparable2 != null && ((BigDecimal)comparable2).compareTo(BigDecimal.ZERO) > 0) {
                energiepass.setWaermewert(numberFormat.format(comparable2));
            }
            if (bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
                energiepass.setStromwert(numberFormat.format(bigDecimal2));
            }
        }
        if ((date = ExpirationDate.get((EstateImpl)estateImpl)) != null) {
            if (energiepass == null) {
                energiepass = this.FACTORY.createEnergiepass();
            }
            energiepass.setGueltigBis(this.getEnergyCertificateExpirationFormat().format(date));
        }
        if ((calendar = CreationDate.getAsCalendar((EstateImpl)estateImpl)) != null) {
            if (energiepass == null) {
                energiepass = this.FACTORY.createEnergiepass();
            }
            energiepass.setAusstelldatum(calendar);
            if (bl) {
                comparable = Calendar.getInstance();
                ((Calendar)comparable).set(2014, 4, 1, 0, 0, 0);
                ((Calendar)comparable).set(14, 0);
                if (calendar.before(comparable)) {
                    energiepass.setJahrgang(Energiepass.Jahrgang.BIS_APRIL_2014);
                } else {
                    energiepass.setJahrgang(Energiepass.Jahrgang.AB_MAI_2014);
                }
            }
        }
        if ((comparable = AustriaThermalHeatDemand.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR)) != null && ((BigDecimal)comparable).compareTo(BigDecimal.ZERO) > 0) {
            if (energiepass == null) {
                energiepass = this.FACTORY.createEnergiepass();
            }
            energiepass.setHwbwert(numberFormat.format(comparable));
            object2 = ((BigDecimal)comparable).compareTo(BigDecimal.valueOf(10L)) < 1 ? "A++" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(15L)) < 1 ? "A+" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(25L)) < 1 ? "A" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(50L)) < 1 ? "B" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(100L)) < 1 ? "C" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(150L)) < 1 ? "D" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(200L)) < 1 ? "E" : (((BigDecimal)comparable).compareTo(BigDecimal.valueOf(250L)) < 1 ? "F" : "G")))))));
            energiepass.setHwbklasse((String)object2);
        }
        if ((object2 = AustriaTotalEnergyEfficiencyFactor.getAsBigDecimal((EstateImpl)estateImpl)) != null && ((BigDecimal)object2).compareTo(BigDecimal.ZERO) > 0) {
            if (energiepass == null) {
                energiepass = this.FACTORY.createEnergiepass();
            }
            energiepass.setFgeewert(numberFormat.format(object2));
            object = ((BigDecimal)object2).compareTo(new BigDecimal("0.55")) < 1 ? "A++" : (((BigDecimal)object2).compareTo(new BigDecimal("0.7")) < 1 ? "A+" : (((BigDecimal)object2).compareTo(new BigDecimal("0.85")) < 1 ? "A" : (((BigDecimal)object2).compareTo(BigDecimal.ONE) < 1 ? "B" : (((BigDecimal)object2).compareTo(new BigDecimal("1.75")) < 1 ? "C" : (((BigDecimal)object2).compareTo(new BigDecimal("2.5")) < 1 ? "D" : (((BigDecimal)object2).compareTo(new BigDecimal("3.25")) < 1 ? "E" : (((BigDecimal)object2).compareTo(new BigDecimal("4")) < 1 ? "F" : "G")))))));
            energiepass.setFgeeklasse((String)object);
        }
        if (energiepass == null && bl && Boolean.TRUE.equals(MonumentalProtection.get((EstateImpl)estateImpl))) {
            energiepass = this.FACTORY.createEnergiepass();
            energiepass.setJahrgang(Energiepass.Jahrgang.NICHT_NOETIG);
        }
        if (energiepass != null) {
            if (!bl) {
                energiepass.setJahrgang(Energiepass.Jahrgang.OHNE);
            } else if (energiepass.getJahrgang() == null) {
                energiepass.setJahrgang(Energiepass.Jahrgang.OHNE);
            }
            object = BuildYear.getAsInteger((EstateImpl)estateImpl);
            if (object != null && (Integer)object > 0) {
                energiepass.setBaujahr(((Integer)object).toString());
            }
            if (!bl || Energiepass.Jahrgang.AB_MAI_2014.equals((Object)energiepass.getJahrgang())) {
                option = EfficiencyCategory.get((EstateImpl)estateImpl);
                if (option == null && estateImpl.getAddress() != null && bigDecimal != null) {
                    option = OpenEstateUtils.getEnergyEfficiencyCategory((Number)bigDecimal, (String)estateImpl.getAddress().getCountry());
                }
                if (option != null) {
                    energiepass.setWertklasse(option.getTranslation(Locale.ENGLISH));
                }
            }
            zustandAngaben.getEnergiepass().add(energiepass);
        }
        if ((object = Development.get((EstateImpl)estateImpl)) != null) {
            zustandAngaben.setErschliessung(this.FACTORY.createErschliessung());
            if (Development.Option.ACCORDING_LOCAL_PRACTICE.equals(object)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.ORTSUEBLICHERSCHLOSSEN);
            } else if (Development.Option.PARTIALLY.equals(object)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.TEILERSCHLOSSEN);
            } else if (Development.Option.UNDEVELOPED.equals(object)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.UNERSCHLOSSEN);
            } else if (Development.Option.COMPLETELY.equals(object)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.VOLLERSCHLOSSEN);
            }
        }
        if ((option = ConditionType.get((EstateImpl)estateImpl)) != null) {
            zustandAngaben.setZustand(this.FACTORY.createZustand());
            if (ConditionType.Option.CONDEMNED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ABRISSOBJEKT);
            } else if (ConditionType.Option.EXCELLENT.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if (ConditionType.Option.DILAPIDATED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.BAUFAELLIG);
            } else if (ConditionType.Option.GUTTED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ENTKERNT);
            } else if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ERSTBEZUG);
            } else if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ERSTBEZUG);
            } else if (ConditionType.Option.WELL_TENDED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if (ConditionType.Option.GOOD.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if (ConditionType.Option.MODERNIZED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.MODERNISIERT);
            } else if (ConditionType.Option.AS_APPOINTED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.NACH_VEREINBARUNG);
            } else if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.NEUWERTIG);
            } else if (ConditionType.Option.PROJECTED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.PROJEKTIERT);
            } else if (ConditionType.Option.PARTIALLY_RENOVATED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERT);
            } else if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERT);
            } else if (ConditionType.Option.PARTIAL_REFURBISHMENT_REQUIRED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.SANIERUNGSBEDUERFTIG);
            } else if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED);
            } else if (ConditionType.Option.COMPLETE_REFURBISHMENT_REQUIRED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.SANIERUNGSBEDUERFTIG);
            } else if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED);
            } else if (ConditionType.Option.SHELL_CONSTRUCTION.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ROHBAU);
            } else if (ConditionType.Option.PARTIALLY_REFURBISHED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_SANIERT);
            } else if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.VOLL_SANIERT);
            }
        }
    }
}

