/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.idx.types;

import org.apache.commons.lang3.StringUtils;
import org.openestate.io.idx.types.ObjectCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObjectType {
    AGRI_GENERAL(ObjectCategory.AGRI, 1),
    AGRI_ALPINE(ObjectCategory.AGRI, 2),
    AGRI_FARM(ObjectCategory.AGRI, 3),
    APPT_GENERAL(ObjectCategory.APPT, 1),
    APPT_DUPLEX(ObjectCategory.APPT, 2),
    APPT_ATTIC_FLAT(ObjectCategory.APPT, 3),
    APPT_ROOF_FLAT(ObjectCategory.APPT, 4),
    APPT_STUDIO(ObjectCategory.APPT, 5),
    APPT_SINGLE_ROOM(ObjectCategory.APPT, 6),
    APPT_FURNISHED_FLAT(ObjectCategory.APPT, 7),
    APPT_TERRACE_FLAT(ObjectCategory.APPT, 8),
    APPT_BACHERLOR_FLAT(ObjectCategory.APPT, 9),
    APPT_LOFT(ObjectCategory.APPT, 10),
    APPT_ATTIC(ObjectCategory.APPT, 11),
    GARDEN_GENERAL(ObjectCategory.GARDEN, 1),
    GASTRO_HOTEL(ObjectCategory.GASTRO, 1),
    GASTRO_RESTAURANT(ObjectCategory.GASTRO, 2),
    GASTRO_CAFE(ObjectCategory.GASTRO, 3),
    GASTRO_BAR(ObjectCategory.GASTRO, 4),
    GASTRO_CLUB_DISCO(ObjectCategory.GASTRO, 5),
    GASTRO_CASINO(ObjectCategory.GASTRO, 6),
    GASTRO_CINEMA_THEATRE(ObjectCategory.GASTRO, 7),
    GASTRO_SQUASH_BADMINTON(ObjectCategory.GASTRO, 8),
    GASTRO_INDOOR_TENNIS(ObjectCategory.GASTRO, 9),
    GASTRO_OUTDOOR_TENNIS(ObjectCategory.GASTRO, 10),
    GASTRO_SPORTS_HALL(ObjectCategory.GASTRO, 11),
    GASTRO_CAMPING(ObjectCategory.GASTRO, 12),
    GASTRO_OUTDOOR_SWIMMING(ObjectCategory.GASTRO, 13),
    GASTRO_INDOOR_SWIMMING(ObjectCategory.GASTRO, 14),
    GASTRO_GOLF(ObjectCategory.GASTRO, 15),
    GASTRO_MOTEL(ObjectCategory.GASTRO, 16),
    GASTRO_PUB(ObjectCategory.GASTRO, 17),
    HOUSE_SINGLE_FAMILY(ObjectCategory.HOUSE, 1),
    HOUSE_ROW(ObjectCategory.HOUSE, 2),
    HOUSE_DUPLEX(ObjectCategory.HOUSE, 3),
    HOUSE_TERRACE(ObjectCategory.HOUSE, 4),
    HOUSE_VILLA(ObjectCategory.HOUSE, 5),
    HOUSE_FARM(ObjectCategory.HOUSE, 6),
    HOUSE_MULTI_FAMILY(ObjectCategory.HOUSE, 7),
    HOUSE_CAVE_HOUSE(ObjectCategory.HOUSE, 9),
    HOUSE_CASTLE(ObjectCategory.HOUSE, 10),
    HOUSE_GRANNY_FLAT(ObjectCategory.HOUSE, 11),
    HOUSE_CHALET(ObjectCategory.HOUSE, 12),
    HOUSE_RUSTICO(ObjectCategory.HOUSE, 13),
    INDUS_OFFICE(ObjectCategory.INDUS, 1),
    INDUS_SHOP(ObjectCategory.INDUS, 2),
    INDUS_ADVERTISING(ObjectCategory.INDUS, 3),
    INDUS_COMMERCIAL(ObjectCategory.INDUS, 4),
    INDUS_STORAGE(ObjectCategory.INDUS, 5),
    INDUS_SURGERY(ObjectCategory.INDUS, 6),
    INDUS_KIOSK(ObjectCategory.INDUS, 7),
    INDUS_GARDENING(ObjectCategory.INDUS, 8),
    INDUS_FUEL_STATION(ObjectCategory.INDUS, 9),
    INDUS_GARAGE(ObjectCategory.INDUS, 10),
    INDUS_CHEESE_FACTORY(ObjectCategory.INDUS, 11),
    INDUS_BUTCHER(ObjectCategory.INDUS, 12),
    INDUS_BAKERY(ObjectCategory.INDUS, 13),
    INDUS_HAIRDRESSER(ObjectCategory.INDUS, 14),
    INDUS_SHOPPING_CENTRE(ObjectCategory.INDUS, 15),
    INDUS_FACTORY(ObjectCategory.INDUS, 16),
    INDUS_INDUSTRY(ObjectCategory.INDUS, 17),
    INDUS_ARCADE(ObjectCategory.INDUS, 18),
    INDUS_ATELIER(ObjectCategory.INDUS, 19),
    INDUS_LIVING_COMMERCIAL(ObjectCategory.INDUS, 20),
    INDUS_LIBRARY(ObjectCategory.INDUS, 21),
    INDUS_HOSPITAL(ObjectCategory.INDUS, 22),
    INDUS_LABORATORY(ObjectCategory.INDUS, 23),
    INDUS_MINI_GOLF(ObjectCategory.INDUS, 24),
    INDUS_NURSING(ObjectCategory.INDUS, 25),
    INDUS_RIDING_HALL(ObjectCategory.INDUS, 26),
    INDUS_SANATORIUM(ObjectCategory.INDUS, 27),
    INDUS_WORKSHOP(ObjectCategory.INDUS, 28),
    INDUS_PARTY_ROOM(ObjectCategory.INDUS, 29),
    INDUS_SAUNA(ObjectCategory.INDUS, 30),
    INDUS_SOLARIUM(ObjectCategory.INDUS, 31),
    INDUS_CARPENTRY(ObjectCategory.INDUS, 32),
    INDUS_OLD_AGE_HOME(ObjectCategory.INDUS, 33),
    INDUS_DEPARTMENT_STORE(ObjectCategory.INDUS, 34),
    INDUS_HOME(ObjectCategory.INDUS, 35),
    INDUS_DISPLAY_WINDOW(ObjectCategory.INDUS, 36),
    INDUS_PARKING_GARAGE(ObjectCategory.INDUS, 37),
    INDUS_PARKING_SURFACE(ObjectCategory.INDUS, 38),
    PARK_OPEN_SLOT(ObjectCategory.PARK, 1),
    PARK_COVERED_SLOT(ObjectCategory.PARK, 2),
    PARK_SINGLE_GARAGE(ObjectCategory.PARK, 3),
    PARK_DOUBLE_GARAGE(ObjectCategory.PARK, 4),
    PARK_UNDERGROUND_SLOT(ObjectCategory.PARK, 5),
    PARK_BOAT_DRY_DOCK(ObjectCategory.PARK, 7),
    PARK_BOAT_LANDING_STAGE(ObjectCategory.PARK, 8),
    PARK_BIKE_INDOOR(ObjectCategory.PARK, 9),
    PARK_BIKE_OUTDOOR(ObjectCategory.PARK, 10),
    PARK_HORSE_BOX(ObjectCategory.PARK, 11),
    PARK_BOAT_MOORING(ObjectCategory.PARK, 12),
    PROP_BUILDING(ObjectCategory.PROP, 1),
    PROP_AGRICULTURAL(ObjectCategory.PROP, 2),
    PROP_COMMERCIAL(ObjectCategory.PROP, 3),
    PROP_INDUSTRIAL(ObjectCategory.PROP, 4),
    SECONDARY_HOBBY_ROOM(ObjectCategory.SECONDARY, 0),
    SECONDARY_CELLAR_PART(ObjectCategory.SECONDARY, 1),
    SECONDARY_ATTIC_COMPARTMENT(ObjectCategory.SECONDARY, 2);

    private static final Logger LOGGER;
    private final ObjectCategory category;
    private final int value;

    private ObjectType(ObjectCategory objectCategory, int n2) {
        this.category = objectCategory;
        this.value = n2;
    }

    public ObjectCategory getCategory() {
        return this.category;
    }

    public static ObjectType parse(ObjectCategory objectCategory, String string) {
        if (objectCategory == null) {
            return null;
        }
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string);
            for (ObjectType objectType : ObjectType.values()) {
                if (!objectCategory.equals((Object)objectType.category) || n != objectType.value) continue;
                return objectType;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String print() {
        return String.valueOf(this.value);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ObjectType.class);
    }
}

