/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.kyero;

import com.openindex.openestate.impl.OpenEstateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KyeroType {
    APARTMENT("apartment", OpenEstateType.RESIDENCE, true),
    APARTMENT_DUPLEX("duplex", OpenEstateType.SEMIDETACHED_HOUSE, true),
    APARTMENT_PENTHOUSE("penthouse", OpenEstateType.PENTHOUSE_APARTMENT, true),
    APARTMENT_STUDIO("studio", OpenEstateType.STUDIO, true),
    APARTMENT_TRIPLEX("triplex", OpenEstateType.RESIDENCE, false),
    VILLA("villa", OpenEstateType.VILLA, true),
    VILLE("ville", OpenEstateType.VILLA, false),
    VILLA_BUNGALOW("bungalow", OpenEstateType.BUNGALOW, true),
    TOWN_HOUSE("town house", OpenEstateType.HOUSE, true),
    TOWN_HOUSE_TERRACED("terraced house", OpenEstateType.TERRACED_HOUSE, true),
    TOWN_HOUSE_VILLAGE("village house", OpenEstateType.TOWN_HOUSE, false),
    COUNTRY_HOUSE("country house", OpenEstateType.COUNTRY_HOUSE, true),
    COUNTRY_HOUSE_FARM("farm", OpenEstateType.FARM, true),
    COUNTRY_HOUSE_FARM_HOUSE("farmhouse", OpenEstateType.FARMHOUSE, true),
    COUNTRY_HOUSE_CORTIJO("cortijo", OpenEstateType.COUNTRY_HOUSE, false),
    COUNTRY_HOUSE_FINCA("finca", OpenEstateType.SUMMER_HOUSE, true),
    LAND("land", OpenEstateType.GENERAL_PIECE_OF_LAND, true),
    LAND_RUIN("ruin", OpenEstateType.GENERAL_PIECE_OF_LAND, false),
    CAVE_HOUSE("cave house", OpenEstateType.GENERAL_RESIDENCE, false),
    GARAGE("garage", OpenEstateType.GARAGE, true),
    GARAGE_PARKING_SPACE("parking space", OpenEstateType.PARKING_SPACE, true),
    COMERCIAL("comercial", OpenEstateType.GENERAL_COMMERCIAL, false),
    COMMERCIAL("commercial", OpenEstateType.GENERAL_COMMERCIAL, false),
    COMMERCIAL_PROPERTY("commercial property", OpenEstateType.GENERAL_COMMERCIAL, true),
    SEMI("semi", OpenEstateType.SEMIDETACHED_HOUSE, false),
    ATTACHED("attached", OpenEstateType.HOUSE, false),
    DETACHED("detached", OpenEstateType.HOUSE, false),
    QUAD("quad", OpenEstateType.HOUSE, false),
    WOODEN_HOME("wooden home", OpenEstateType.GENERAL_RESIDENCE, false),
    WOODEN_HOME_MOBILE("mobile home", OpenEstateType.GENERAL_RESIDENCE, false),
    WOODEN_HOME_CHALET("wooden chalet", OpenEstateType.GENERAL_RESIDENCE, false);

    private static final Logger LOGGER;
    private final String xmlValue;
    private final OpenEstateType type;
    private final boolean writable;

    private KyeroType(String string2, OpenEstateType openEstateType, boolean bl) {
        this.xmlValue = string2;
        this.type = openEstateType;
        this.writable = bl;
    }

    public OpenEstateType getType() {
        return this.type;
    }

    public String getXmlValue() {
        return this.xmlValue;
    }

    public boolean isWritable() {
        return this.writable;
    }

    static {
        LOGGER = LoggerFactory.getLogger(KyeroType.class);
    }
}

