/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyCalendarHandlerImpl;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyEstateCalendarEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyCalendarHandler
extends DbAgencyCalendarHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyCalendarHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyCalendarHandler.class);
    public static final String VIEW_AGENCY_OBJECTS_CALENDAR_ENTRIES = "view_immotool_agency_objects_calendar_entries";
    public static final String PROC_REMOVE_AGENCY_OBJECTS_CALENDAR_ENTRIES = "remove_immotool_agency_objects_calendar_entries";
    public static final String PROC_SAVE_AGENCY_OBJECTS_CALENDAR_ENTRIES = "save_immotool_agency_objects_calendar_entries";
    private static final String FIELD_AGENCY_OBJECT_ID = "agency_object_id";
    private static final String FIELD_CALENDAR_ENTRY_ID = "calendar_entry_id";
    private static final String FIELD_RELATION_TYPE = "relation_type";
    private static final String FIELD_RELATION_NOTES = "relation_notes";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    private static DbAgencyEstateCalendarEntry createEstateCalendarEntry(ResultSet resultSet) throws SQLException {
        DbAgencyEstateCalendarEntry dbAgencyEstateCalendarEntry = new DbAgencyEstateCalendarEntry();
        dbAgencyEstateCalendarEntry.agencyEstateId = resultSet.getLong(FIELD_AGENCY_OBJECT_ID);
        dbAgencyEstateCalendarEntry.calendarEntryId = resultSet.getLong(FIELD_CALENDAR_ENTRY_ID);
        dbAgencyEstateCalendarEntry.relationType = resultSet.getString(FIELD_RELATION_TYPE);
        dbAgencyEstateCalendarEntry.relationNotes = resultSet.getString(FIELD_RELATION_NOTES);
        dbAgencyEstateCalendarEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyEstateCalendarEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbAgencyEstateCalendarEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyEstateCalendarEntry[] getEstateCalendarEntries(Connection connection, long[] lArray, long[] lArray2) throws SQLException {
        DbAgencyEstateCalendarEntry[] dbAgencyEstateCalendarEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            if (lArray2 != null) {
                arrayList.add("calendar_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_objects_calendar_entries " + string + " ORDER BY " + FIELD_CREATED_AT + " ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (lArray2 != null) {
                for (long l : lArray2) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(HSqlDbAgencyCalendarHandler.createEstateCalendarEntry(resultSet));
            }
            dbAgencyEstateCalendarEntryArray = object.toArray(new DbAgencyEstateCalendarEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyEstateCalendarEntryArray;
    }

    @Override
    public void removeEstateCalendarEntries(Connection connection, DbAgencyEstateCalendarEntry[] dbAgencyEstateCalendarEntryArray) throws SQLException {
        if (dbAgencyEstateCalendarEntryArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_agency_objects_calendar_entries(:agency_object_id, :calendar_entry_id);");
            for (DbAgencyEstateCalendarEntry dbAgencyEstateCalendarEntry : dbAgencyEstateCalendarEntryArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyEstateCalendarEntry.agencyEstateId);
                namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbAgencyEstateCalendarEntry.calendarEntryId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEstateCalendarEntry(Connection connection, DbAgencyEstateCalendarEntry dbAgencyEstateCalendarEntry) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_objects_calendar_entries(:agency_object_id, :calendar_entry_id, :relation_type, :relation_notes);");
            namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyEstateCalendarEntry.agencyEstateId);
            namedCallableStatement.setLong(FIELD_CALENDAR_ENTRY_ID, dbAgencyEstateCalendarEntry.calendarEntryId);
            namedCallableStatement.setString(FIELD_RELATION_TYPE, StringUtils.abbreviate((String)dbAgencyEstateCalendarEntry.relationType, (int)100));
            namedCallableStatement.setString(FIELD_RELATION_NOTES, dbAgencyEstateCalendarEntry.relationNotes != null && dbAgencyEstateCalendarEntry.relationNotes.trim().length() > 0 ? dbAgencyEstateCalendarEntry.relationNotes.trim() : null);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

