/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyBrokeringTable<R extends Row>
extends ContactsEntryTable<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyBrokeringTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyBrokeringTable.class);

    public AgencyBrokeringTable(String string) {
        super(string);
    }

    public AgencyBrokeringTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public DbAgencyObject getAgencyObjectAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getAgencyObject() : null;
    }

    public Long getAgencyObjectIdAt(int n) {
        DbAgencyObject dbAgencyObject = this.getAgencyObjectAt(n);
        return dbAgencyObject != null ? dbAgencyObject.id : 0L;
    }

    public DbAgencyBrokering getBrokeringAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getBrokering() : null;
    }

    public Long getBrokeringIdAt(int n) {
        DbAgencyBrokering dbAgencyBrokering = this.getBrokeringAt(n);
        return dbAgencyBrokering != null ? dbAgencyBrokering.id : 0L;
    }

    public int getRowForBrokeringId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getBrokeringIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected List<AbstractTable.Column> listColumns() {
        List list = super.listColumns();
        list.addAll(Arrays.asList(Column.values()));
        return list;
    }

    public static class Row
    extends ContactsEntryTable.Row {
        private final DbAgencyBrokering brokering;
        private final DbAgencyObject agencyObject;

        public Row(DbAgencyBrokering dbAgencyBrokering, DbAgencyObject dbAgencyObject, DbContactsEntry dbContactsEntry, String string) {
            super(dbContactsEntry, string);
            this.brokering = dbAgencyBrokering;
            this.agencyObject = dbAgencyObject;
        }

        public DbAgencyObject getAgencyObject() {
            return this.agencyObject;
        }

        public DbAgencyBrokering getBrokering() {
            return this.brokering;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForBrokering((Column)column);
            }
            return super.getValue(column);
        }

        public Object getValueForBrokering(Column column) {
            if (this.brokering == null || this.agencyObject == null) {
                return null;
            }
            switch (column) {
                case BROKERING_ID: {
                    return this.brokering.id;
                }
                case BROKERING_OBJECT_ID: {
                    return this.agencyObject.id;
                }
                case BROKERING_OBJECT_NR: {
                    return StringUtils.trimToNull((String)this.agencyObject.item.getPublicId());
                }
                case BROKERING_OBJECT_STATUS: {
                    return this.agencyObject.status;
                }
                case BROKERING_OBJECT_TITLE: {
                    Locale locale = Locale.getDefault();
                    return StringUtils.defaultIfBlank((CharSequence)this.agencyObject.item.getTitle(locale), (CharSequence)this.agencyObject.item.getFallbackTitle(locale));
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        BROKERING_ID,
        BROKERING_OBJECT_ID,
        BROKERING_OBJECT_NR,
        BROKERING_OBJECT_TITLE,
        BROKERING_OBJECT_STATUS;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case BROKERING_OBJECT_STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case BROKERING_ID: 
                case BROKERING_OBJECT_ID: {
                    return Long.class;
                }
                case BROKERING_OBJECT_NR: 
                case BROKERING_OBJECT_TITLE: {
                    return String.class;
                }
                case BROKERING_OBJECT_STATUS: {
                    return DbAgencyObject.Status.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case BROKERING_ID: {
                    return StringUtils.capitalize((String)I18N.tr("brokering")) + "-" + StringUtils.capitalize((String)I18N.tr("ID"));
                }
                case BROKERING_OBJECT_ID: {
                    return StringUtils.capitalize((String)I18N.tr("property")) + "-" + StringUtils.capitalize((String)I18N.tr("ID"));
                }
                case BROKERING_OBJECT_NR: {
                    return StringUtils.capitalize((String)I18N.tr("property")) + "-" + StringUtils.capitalize((String)I18N.tr("nr"));
                }
                case BROKERING_OBJECT_STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("property")) + "-" + StringUtils.capitalize((String)I18N.tr("status"));
                }
                case BROKERING_OBJECT_TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("property")) + "-" + StringUtils.capitalize((String)I18N.tr("title"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case BROKERING_ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

