/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyBrokeringViewTask
extends ImmoToolTask<AgencyBrokeringViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyBrokeringViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyBrokeringViewTask.class);
    private long brokeringId;
    private boolean selectCreatedTab;
    private AbstractDbDriver dbDriver;
    private AgencyBrokeringViewPanel viewTab;

    public AgencyBrokeringViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public AgencyBrokeringViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading brokering mandate {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.brokeringId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public AgencyBrokeringViewTask(AbstractDbDriver abstractDbDriver, long l, AgencyBrokeringViewPanel agencyBrokeringViewPanel) {
        super(I18N.tr("Loading brokering mandate {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.brokeringId = l;
        this.selectCreatedTab = true;
        this.viewTab = agencyBrokeringViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AgencyBrokeringViewPanel doInBackground() throws Exception {
        Object object;
        DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
        if (this.viewTab == null) {
            for (AbstractMainTab abstractMainTab : ImmoToolAppUtils.getTabs(AgencyBrokeringViewPanel.class)) {
                AgencyBrokeringViewPanel agencyBrokeringViewPanel = (AgencyBrokeringViewPanel)abstractMainTab;
                if (this.brokeringId == 0L && agencyBrokeringViewPanel.getCurrentBrokeringId() < 1L) {
                    if (this.selectCreatedTab) {
                        ImmoToolAppUtils.selectTab((Component)((Object)agencyBrokeringViewPanel));
                    }
                    return null;
                }
                if (this.brokeringId <= 0L || agencyBrokeringViewPanel.getCurrentBrokeringId() != this.brokeringId) continue;
                if (this.selectCreatedTab) {
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyBrokeringViewPanel));
                }
                return null;
            }
        }
        if (this.brokeringId < 1L) {
            object = this.viewTab != null ? this.viewTab : AgencyBrokeringViewPanel.createTab();
        } else {
            Connection connection = null;
            try {
                connection = this.dbDriver.getConnection();
                DbAgencyBrokering dbAgencyBrokering = dbAgencyBrokeringsHandler.getBrokering(connection, this.brokeringId);
                if (dbAgencyBrokering == null) {
                    throw new Exception("Can't find brokering #" + this.brokeringId + "!");
                }
                if (this.viewTab == null) {
                    object = AgencyBrokeringViewPanel.createTab(dbAgencyBrokering);
                } else {
                    object = this.viewTab;
                    ((AgencyBrokeringViewPanel)((Object)object)).setBrokering(dbAgencyBrokering);
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)("Can't load brokering #" + this.brokeringId + "!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(AgencyBrokeringViewPanel agencyBrokeringViewPanel) {
        super.succeeded((Object)agencyBrokeringViewPanel);
        if (agencyBrokeringViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyBrokeringViewPanel, (boolean)this.selectCreatedTab);
            }
            agencyBrokeringViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

