/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import net.java.balloontip.BalloonTip;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewBrokeringPanel
extends AgencyEstateViewPanel.AbstractTab
implements DisposableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewBrokeringPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewBrokeringPanel.class);
    private DbAgencyObject currentEstate = null;
    private DbAgencyBrokering currentBrokering = null;
    private DbContactsEntry currentBrokeringContactsEntry = null;
    private ValidationHandler validationHandler;
    private ModificationHandler modifications;
    private JXTitledSeparator formTitle;
    private JLabel contactEntryLabel;
    private ContactsEntryField contactEntryField;
    private JPanel contactEntryPanel;
    private JComboBox<Action> contactActionField;
    private JComboBox<DbContactsGroup> contactGroupField;
    private ContactsEntryExtendedAddressPanel contactEntryForm;
    private DbContactsGroup unreadableGroup = null;
    private DbContactsEntry unreadableAddress = null;
    private BalloonTip unreadableAddressBalloonTip;
    private JLabel unreadableAddressBalloonLabel;

    public AgencyEstateViewBrokeringPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.contactEntryLabel = new JLabel();
        this.contactEntryField = new ContactsEntryField();
        this.contactEntryField.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

            public void valueChanged() {
                if (!AgencyEstateViewBrokeringPanel.this.contactEntryField.isEnabled()) {
                    return;
                }
                DbContactsEntry dbContactsEntry = AgencyEstateViewBrokeringPanel.this.contactEntryField.getContactsEntry();
                if (dbContactsEntry != null) {
                    if (AgencyEstateViewBrokeringPanel.this.unreadableAddress != null && ((AgencyEstateViewBrokeringPanel)AgencyEstateViewBrokeringPanel.this).unreadableAddress.id == dbContactsEntry.id) {
                        AgencyEstateViewBrokeringPanel.this.contactEntryForm.load(AgencyEstateViewBrokeringPanel.this.unreadableAddress);
                        if (!AgencyEstateViewBrokeringPanel.this.unreadableAddressBalloonTip.isVisible()) {
                            AgencyEstateViewBrokeringPanel.this.unreadableAddressBalloonTip.setVisible(true);
                        }
                    } else {
                        if (AgencyEstateViewBrokeringPanel.this.unreadableAddressBalloonTip.isVisible()) {
                            AgencyEstateViewBrokeringPanel.this.unreadableAddressBalloonTip.setVisible(false);
                        }
                        AgencyEstateViewBrokeringPanel.this.contactEntryForm.load(dbContactsEntry);
                    }
                }
            }
        });
        this.contactEntryPanel = new JPanel(new BorderLayout());
        this.contactEntryPanel.add((Component)this.contactEntryField, "Center");
        this.contactGroupField = new JComboBox();
        this.contactGroupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select group") + " ]";
            }
        }));
        this.contactGroupField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewBrokeringPanel.this.contactGroupField.isEnabled()) {
                    return;
                }
                AgencyEstateViewBrokeringPanel.this.updateContact();
            }
        });
        this.contactActionField = new JComboBox();
        this.contactActionField.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
        this.contactActionField.setRenderer((ListCellRenderer<Action>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        for (Action action : Action.values()) {
            this.contactActionField.addItem(action);
        }
        if (!ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT)) {
            this.contactActionField.removeItem((Object)Action.NEW_CONTACT);
        }
        this.contactActionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewBrokeringPanel.this.contactActionField.isEnabled()) {
                    return;
                }
                AgencyEstateViewBrokeringPanel.this.updateContact();
            }
        });
        this.contactEntryForm = new ContactsEntryExtendedAddressPanel(60);
        this.unreadableAddressBalloonLabel = new JLabel();
        this.unreadableAddressBalloonLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
        this.unreadableAddressBalloonTip = new BalloonTip((JComponent)this.contactEntryField, (JComponent)this.unreadableAddressBalloonLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.LEFT_BELOW, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
        this.unreadableAddressBalloonTip.setVisible(false);
        this.validationHandler.putRule(this.contactGroupField, ValidationHandler.NOT_NULL);
        this.validationHandler.putRule((JComponent)this.contactEntryField, ValidationHandler.NOT_NULL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[60dlu,pref], 3dlu, pref, 3dlu, pref, 3dlu, 40dlu:grow");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.contactEntryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.contactActionField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add(this.contactGroupField).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactEntryPanel).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.contactEntryForm).xyw(1, defaultFormBuilder.nextRow(), 7);
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add(jScrollPane, "Center");
        this.updateLocalization();
        this.contactEntryForm.setEnabled(false);
        this.updateContact();
    }

    public void dispose() {
        if (this.unreadableAddressBalloonTip != null) {
            this.unreadableAddressBalloonTip.closeBalloon();
        }
    }

    public void doLoadInBackground(Connection connection) throws Exception {
        DbContactsGroup[] dbContactsGroupArray;
        this.contactGroupField.setModel(new DefaultComboBoxModel());
        this.contactEntryField.setContactsGroupId(0L);
        this.contactEntryField.setContactsEntry(null);
        this.contactEntryField.setEnabled(false);
        DbAgencyBrokering dbAgencyBrokering = null;
        DbContactsEntry dbContactsEntry = null;
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        defaultComboBoxModel.addElement(null);
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
        if (this.currentEstate != null && this.currentEstate.id > 0L && (dbAgencyBrokering = dbAgencyBrokeringsHandler.getBrokeringForObject(connection, this.currentEstate.id)) != null) {
            dbContactsEntry = dbContactsHandler.getEntry(connection, dbAgencyBrokering.contactsEntryId);
            dbContactsHandler.loadEntrySettings(connection, dbContactsEntry);
            if (dbContactsEntry == null) {
                this.unreadableGroup = new DbContactsGroup();
                this.unreadableGroup.id = 0L;
                this.unreadableGroup.name = I18N.tr("unknown");
                this.unreadableAddress = new DbContactsEntry();
                this.unreadableAddress.id = dbAgencyBrokering.contactsEntryId;
                this.unreadableAddress.address = new CompanyAddressImpl();
                this.unreadableAddress.address.setPersonLastName(I18N.tr("unknown"));
                dbContactsEntry = this.unreadableAddress;
            }
        }
        for (DbContactsGroup dbContactsGroup : dbContactsGroupArray = dbContactsHandler.getGroups(connection)) {
            defaultComboBoxModel.addElement(dbContactsGroup);
        }
        if (this.unreadableGroup != null) {
            defaultComboBoxModel.addElement(this.unreadableGroup);
        }
        this.currentBrokering = dbAgencyBrokering;
        this.currentBrokeringContactsEntry = dbContactsEntry;
        if (this.currentBrokering != null) {
            this.contactActionField.setSelectedItem((Object)Action.USE_CONTACT);
        } else {
            this.contactActionField.setSelectedItem((Object)Action.NO_CONTACT);
        }
        this.contactEntryField.setEnabled(false);
        this.contactEntryField.setContactsEntry(this.currentBrokeringContactsEntry);
        this.contactGroupField.setEnabled(false);
        this.contactGroupField.setModel(defaultComboBoxModel);
        if (dbContactsEntry == null) {
            this.contactGroupField.setSelectedItem(null);
        } else if (this.unreadableGroup != null) {
            this.contactGroupField.setSelectedItem(this.unreadableGroup);
        } else {
            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                dbAgencyBrokeringsHandler = (DbContactsGroup)defaultComboBoxModel.getElementAt(i);
                if (dbAgencyBrokeringsHandler == null || ((DbContactsGroup)dbAgencyBrokeringsHandler).id != this.currentBrokeringContactsEntry.groupId) continue;
                this.contactGroupField.setSelectedIndex(i);
                break;
            }
        }
        this.updateContact();
        this.modifications.clear();
        this.modifications.putValue(this.contactActionField);
    }

    public DbContactsEntry getContactsEntry() {
        DbContactsEntry dbContactsEntry = null;
        Action action = (Action)((Object)this.contactActionField.getSelectedItem());
        if (Action.NEW_CONTACT.equals((Object)action)) {
            dbContactsEntry = new DbContactsEntry();
            this.contactEntryForm.saveAddress((AddressImpl)dbContactsEntry.address);
        } else if (Action.USE_CONTACT.equals((Object)action) && (dbContactsEntry = this.contactEntryField.getContactsEntry()) != null) {
            this.contactEntryForm.saveAddress((AddressImpl)dbContactsEntry.address);
        }
        return dbContactsEntry;
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("brokering mandate"));
    }

    public boolean isAgentContactSelected() {
        Action action = (Action)((Object)this.contactActionField.getSelectedItem());
        return Action.NEW_CONTACT.equals((Object)action) || Action.USE_CONTACT.equals((Object)action);
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isTabModified() {
        if (this.modifications.isModified()) {
            return true;
        }
        Action action = (Action)((Object)this.contactActionField.getSelectedItem());
        return Action.USE_CONTACT.equals((Object)action) && this.contactEntryForm.isModifiedInput();
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        this.contactEntryForm.validateInputs();
        Action action = (Action)((Object)this.contactActionField.getSelectedItem());
        return this.validationHandler.isValid() && this.contactEntryForm.isValidInput() && action != null;
    }

    public void load(DbAgencyObject dbAgencyObject) {
        if (this.unreadableAddressBalloonTip.isVisible()) {
            this.unreadableAddressBalloonTip.setVisible(false);
        }
        this.currentEstate = dbAgencyObject;
        this.currentBrokering = null;
        this.currentBrokeringContactsEntry = null;
        this.unreadableGroup = null;
        this.unreadableAddress = null;
    }

    public void save(DbAgencyObject dbAgencyObject) {
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT)) {
            return;
        }
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException {
        DbContactsEntry dbContactsEntry;
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT)) {
            return;
        }
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
        Action action = (Action)((Object)this.contactActionField.getSelectedItem());
        if (Action.NO_CONTACT.equals((Object)action)) {
            if (this.currentBrokering != null && this.currentBrokering.id > 0L) {
                dbAgencyBrokeringsHandler.removeBrokering(connection, this.currentBrokering.id);
            }
        } else if (Action.NEW_CONTACT.equals((Object)action) && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT)) {
            DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactGroupField.getSelectedItem();
            if (this.unreadableGroup == null || this.unreadableGroup != dbContactsGroup) {
                DbContactsEntry dbContactsEntry2 = new DbContactsEntry();
                dbContactsEntry2.groupId = dbContactsGroup.id;
                this.contactEntryForm.save(dbContactsEntry2);
                dbContactsHandler.saveEntry(connection, dbContactsEntry2);
                if (this.currentBrokering == null) {
                    this.currentBrokering = new DbAgencyBrokering();
                    this.currentBrokering.begin = new Date();
                }
                this.currentBrokering.agencyObjectId = dbAgencyObject.id;
                this.currentBrokering.contactsEntryId = dbContactsEntry2.id;
                dbAgencyBrokeringsHandler.saveBrokering(connection, this.currentBrokering);
            }
        } else if (Action.USE_CONTACT.equals((Object)action) && (dbContactsEntry = this.contactEntryField.getContactsEntry()) != null && (this.unreadableAddress == null || this.unreadableAddress.id != dbContactsEntry.id)) {
            if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT)) {
                this.contactEntryForm.save(dbContactsEntry);
                dbContactsHandler.saveEntry(connection, dbContactsEntry);
            }
            if (this.currentBrokering == null || this.currentBrokering.contactsEntryId != dbContactsEntry.id) {
                if (this.currentBrokering == null) {
                    this.currentBrokering = new DbAgencyBrokering();
                    this.currentBrokering.begin = new Date();
                }
                this.currentBrokering.agencyObjectId = dbAgencyObject.id;
                this.currentBrokering.contactsEntryId = dbContactsEntry.id;
                dbAgencyBrokeringsHandler.saveBrokering(connection, this.currentBrokering);
            }
        }
    }

    private void updateContact() {
        Object object;
        DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactGroupField.getSelectedItem();
        if (this.unreadableAddressBalloonTip.isVisible()) {
            this.unreadableAddressBalloonTip.setVisible(false);
        }
        boolean bl = true;
        if (dbContactsGroup != null && this.unreadableGroup != null && dbContactsGroup == this.unreadableGroup) {
            bl = false;
        } else if (dbContactsGroup != null && dbContactsGroup.permission != null) {
            object = ImmoToolProject.getAppInstance().getUser();
            bl = bl && dbContactsGroup.permission.canWrite(object, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
        }
        this.contactEntryField.setContactsGroupId(dbContactsGroup != null ? dbContactsGroup.id : 0L);
        object = (Action)((Object)this.contactActionField.getSelectedItem());
        if (Action.NO_CONTACT.equals(object)) {
            this.contactEntryField.setEnabled(false);
            this.contactGroupField.setEnabled(false);
            this.contactEntryForm.setEnabled(false);
            this.contactEntryForm.load(new DbContactsEntry());
        } else if (Action.NEW_CONTACT.equals(object)) {
            this.contactEntryField.setEnabled(false);
            this.contactGroupField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
            this.contactEntryForm.setEnabled(bl && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.contactEntryForm.load(new DbContactsEntry());
        } else if (Action.USE_CONTACT.equals(object)) {
            this.contactEntryField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
            this.contactGroupField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
            this.contactEntryForm.setEnabled(bl && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.contactEntryForm.load(this.contactEntryField.getContactsEntry());
        }
        this.contactEntryForm.initInputs();
        this.validationHandler.init();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("brokering mandate for the property")));
        this.contactEntryLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.unreadableAddressBalloonLabel.setText(I18N.tr("The assigned address is not readable by your user account."));
    }

    private static enum Action implements Translatable
    {
        NO_CONTACT(I18n.marktr((String)"no address")),
        NEW_CONTACT(I18n.marktr((String)"enter new address")),
        USE_CONTACT(I18n.marktr((String)"select address"));

        private final String i18nKey;

        private Action(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AgencyEstateViewBrokeringPanel.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyEstateViewBrokeringPanel.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

