/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySearchCriteriaPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestOfferPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.gui.InterestOfferStatusRenderer;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.contacts.ContactsEntryAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.ContactsEntryViewDetailsPanel;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultEditorPane;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyInterestViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyInterestViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyInterestViewPanel.class);
    private static final String OFFER_TABLE_ID = "AgencyInterestViewPanel.OffersTable";
    private static final String SEARCH_TABLE_ID = "AgencyInterestViewPanel.OffersSearchTable";
    private DbAgencyInterest currentInterest = null;
    private DbAgencySearch currentSearch = null;
    private long nextInterestId = 0L;
    private long prevInterestId = 0L;
    private boolean mayEditInterest = false;
    private boolean mayRemoveInterest = false;
    private InterestTab interestTab;
    private DetailsTab detailsTab;
    private SearchTab searchTab;
    private OffersTab offersTab;
    private NotesTab notesTab;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private AgencyInterestViewPanel() {
    }

    protected JComponent buildFooterComponent() {
        return this.createInfoPanel();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        this.interestTab = (InterestTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new InterestTab(), (JTabbedPane)jTabbedPane);
        this.detailsTab = (DetailsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new DetailsTab(this.interestTab.addressPanel), (JTabbedPane)jTabbedPane);
        this.searchTab = (SearchTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new SearchTab(), (JTabbedPane)jTabbedPane);
        this.offersTab = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES) ? (OffersTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new OffersTab(), (JTabbedPane)jTabbedPane) : null;
        this.notesTab = (NotesTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesTab(), (JTabbedPane)jTabbedPane);
    }

    public static AgencyInterestViewPanel createTab() {
        return AgencyInterestViewPanel.createTab(new DbAgencyInterest());
    }

    public static AgencyInterestViewPanel createTab(DbAgencyInterest dbAgencyInterest) {
        AgencyInterestViewPanel agencyInterestViewPanel = new AgencyInterestViewPanel();
        agencyInterestViewPanel.setInterest(dbAgencyInterest);
        return agencyInterestViewPanel;
    }

    protected void doCopy() {
        if (!this.mayEditInterest) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doHelp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        Object object;
        Object object2;
        block21: {
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            this.nextInterestId = 0L;
            this.prevInterestId = 0L;
            if (this.currentInterest != null && this.currentInterest.id > 0L) {
                try {
                    object2 = dbAgencyInterestsHandler.getInterestIds(connection);
                    int n = ArrayUtils.indexOf((long[])object2, (long)this.currentInterest.id);
                    if (n > 0) {
                        this.prevInterestId = object2[n - 1];
                    }
                    if (n + 1 < ((long[])object2).length) {
                        this.nextInterestId = object2[n + 1];
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load previous & next dataset!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.mayEditInterest = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT);
            this.mayRemoveInterest = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_REMOVE);
            this.currentSearch = null;
            object2 = null;
            try {
                if (this.currentInterest != null && this.currentInterest.agencySearchId > 0L) {
                    this.currentSearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, this.currentInterest.agencySearchId);
                    if (this.currentSearch == null) {
                        LOGGER.warn("Can't find search #" + this.currentInterest.agencySearchId + "!");
                    } else {
                        dbAgencySearchesHandler.loadAttribConditions(connection, (DbSearch)this.currentSearch);
                        dbAgencySearchesHandler.loadParameters(connection, (DbSearch)this.currentSearch);
                        dbAgencySearchesHandler.loadValueConditions(connection, (DbSearch)this.currentSearch);
                    }
                }
                if (this.currentInterest != null && this.currentInterest.contactsEntryId > 0L) {
                    DbContactsGroup dbContactsGroup;
                    object2 = dbContactsHandler.getEntry(connection, this.currentInterest.contactsEntryId);
                    if (object2 == null) {
                        LOGGER.warn("Can't find address #" + this.currentInterest.contactsEntryId + "!");
                    } else {
                        dbContactsHandler.loadEntrySettings(connection, (DbContactsEntry)object2);
                    }
                    DbContactsGroup dbContactsGroup2 = dbContactsGroup = object2 != null ? dbContactsHandler.getGroup(connection, object2.groupId) : null;
                    if (dbContactsGroup != null && dbContactsGroup.permission != null) {
                        DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
                        this.mayEditInterest = this.mayEditInterest && dbContactsGroup.permission.canRead(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
                        boolean bl = this.mayRemoveInterest = this.mayRemoveInterest && dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
                    }
                }
                if (this.currentSearch != null) break block21;
            }
            catch (Throwable throwable) {
                Object object3;
                if (this.currentSearch == null) {
                    this.currentSearch = new DbAgencySearch();
                }
                if (this.currentSearch.item == null) {
                    this.currentSearch.item = new SearchImpl();
                }
                if (object2 != null) {
                    object3 = object2;
                } else {
                    DbContactsEntry dbContactsEntry;
                    object3 = dbContactsEntry;
                    dbContactsEntry = new DbContactsEntry();
                }
                Object object4 = object3;
                SwingUtilities.invokeAndWait(new Runnable((DbContactsEntry)object4){
                    final /* synthetic */ DbContactsEntry val$currentContactsEntry;
                    {
                        this.val$currentContactsEntry = dbContactsEntry;
                    }

                    @Override
                    public void run() {
                        for (AbstractMainViewTab abstractMainViewTab : AgencyInterestViewPanel.this.getTabs()) {
                            int n = AgencyInterestViewPanel.this.indexOf(abstractMainViewTab);
                            if (n < 0) continue;
                            AgencyInterestViewPanel.this.getTabbedPane().setEnabledAt(n, false);
                            try {
                                AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                                abstractTab.load(AgencyInterestViewPanel.this.currentInterest, this.val$currentContactsEntry, AgencyInterestViewPanel.this.currentSearch);
                                AgencyInterestViewPanel.this.getTabbedPane().setEnabledAt(n, abstractTab.isTabEnabled() && abstractTab.isTabUsable());
                            }
                            catch (Exception exception) {
                                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                        }
                    }
                });
                throw throwable;
            }
            this.currentSearch = new DbAgencySearch();
        }
        if (this.currentSearch.item == null) {
            this.currentSearch.item = new SearchImpl();
        }
        if (object2 != null) {
            object = object2;
        } else {
            DbContactsEntry dbContactsEntry;
            object = dbContactsEntry;
            dbContactsEntry = new DbContactsEntry();
        }
        Object object5 = object;
        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    private void doOffersAdd(DbAgencyInterestOffer.Status status) {
        DbAgencyInterestOffer dbAgencyInterestOffer;
        if (this.offersTab == null) {
            return;
        }
        if (this.offersTab.foundEstatesTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.offersTab.foundEstatesTable.getSelectedRow();
        int n2 = this.offersTab.foundEstatesTable.convertRowIndexToModel(n);
        Long l = this.offersTab.foundEstatesTable.getEstateIdAt(n2);
        DbAgencyInterestOffer dbAgencyInterestOffer2 = dbAgencyInterestOffer = this.offersTab.removedOffers.containsKey(l) ? (DbAgencyInterestOffer)this.offersTab.removedOffers.get(l) : null;
        if (dbAgencyInterestOffer == null) {
            dbAgencyInterestOffer = new DbAgencyInterestOffer();
            dbAgencyInterestOffer.agencyObjectId = l;
            dbAgencyInterestOffer.interestId = this.currentInterest.id;
            dbAgencyInterestOffer.notes = null;
            dbAgencyInterestOffer.time = new Date();
        }
        dbAgencyInterestOffer.status = status != null ? status : DbAgencyInterestOffer.Status.OPEN;
        AgencyInterestViewPanel.moveAgencyObjectTableSelection(this.offersTab.foundEstatesTable, this.offersTab.offeredEstatesTable, dbAgencyInterestOffer);
        this.offersTab.updateLocalization();
        if (this.offersTab.matchingObjectIds.contains(l)) {
            this.setMatchingObjectsCount(this.offersTab.matchingObjectsCount - 1);
        }
    }

    private void doOffersRemove() {
        if (this.offersTab == null) {
            return;
        }
        if (this.offersTab.offeredEstatesTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.offersTab.offeredEstatesTable.getSelectedRow();
        int n2 = this.offersTab.offeredEstatesTable.convertRowIndexToModel(n);
        DbAgencyInterestOffer dbAgencyInterestOffer = new DbAgencyInterestOffer();
        dbAgencyInterestOffer.interestId = this.currentInterest.id;
        dbAgencyInterestOffer.agencyObjectId = this.offersTab.offeredEstatesTable.getEstateIdAt(n2);
        dbAgencyInterestOffer.notes = this.offersTab.offeredEstatesTable.getNotesAt(n2);
        dbAgencyInterestOffer.status = this.offersTab.offeredEstatesTable.getStatusAt(n2);
        dbAgencyInterestOffer.time = this.offersTab.offeredEstatesTable.getTimeAt(n2);
        this.offersTab.removedOffers.put(dbAgencyInterestOffer.agencyObjectId, dbAgencyInterestOffer);
        AgencyInterestViewPanel.moveAgencyObjectTableSelection(this.offersTab.offeredEstatesTable, this.offersTab.foundEstatesTable, dbAgencyInterestOffer);
        this.offersTab.updateLocalization();
        this.offersTab.offerForm.unselectRelation();
        if (this.offersTab.matchingObjectIds.contains(dbAgencyInterestOffer.agencyObjectId)) {
            this.setMatchingObjectsCount(this.offersTab.matchingObjectsCount + 1);
        }
    }

    private void doOffersSearch() {
        if (this.offersTab == null) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new OffersSearchTask());
    }

    private void doOffersSearchShowActions(Component component, int n, int n2) {
        if (this.offersTab == null) {
            return;
        }
        if (this.offersTab.foundEstatesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new OffersSearchViewObjectAction()));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu();
        jMenu.setText(I18N.tr("add offer"));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        for (DbAgencyInterestOffer.Status status : DbAgencyInterestOffer.Status.values()) {
            jMenu.add((Action)((Object)new OffersAddAction(status)));
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.show(component, n, n2);
    }

    private void doOffersSearchViewObject() {
        if (this.offersTab == null) {
            return;
        }
        int n = this.offersTab.foundEstatesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.offersTab.foundEstatesTable.getEstateIdAt(this.offersTab.foundEstatesTable.convertRowIndexToModel(n));
        new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
    }

    private void doOffersShowActions(Component component, int n, int n2) {
        if (this.offersTab == null) {
            return;
        }
        if (this.offersTab.offeredEstatesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new OffersRemoveAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new OffersViewObjectAction()));
        jPopupMenu.show(component, n, n2);
    }

    private void doOffersViewObject() {
        if (this.offersTab == null) {
            return;
        }
        int n = this.offersTab.offeredEstatesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.offersTab.offeredEstatesTable.getEstateIdAt(this.offersTab.offeredEstatesTable.convertRowIndexToModel(n));
        new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
    }

    public void doRefresh() {
        if (this.currentInterest != null && this.currentInterest.id > 0L) {
            this.setInterest(this.currentInterest);
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentInterest == null || this.currentInterest.id < 1L) {
            return;
        }
        if (!this.mayRemoveInterest) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove search mandate {0}?", (Object)("#" + this.currentInterest.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(this.currentInterest.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentInterest != null && this.currentInterest.id > 0L && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentInterest != null && this.currentInterest.id > 0L && this.mayRemoveInterest));
        jPopupMenu.addSeparator();
        if (this.currentInterest != null && this.currentInterest.contactsEntryId > 0L) {
            jPopupMenu.add((Action)new ContactsPlugin.EntryFormAction(this.currentInterest.contactsEntryId));
        }
        jPopupMenu.add((Action)this.notesTab.addressNotesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditInterest) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextInterestId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyInterestViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.nextInterestId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevInterestId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyInterestViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.prevInterestId, this));
        }
    }

    public long getCurrentAgencySearchId() {
        return this.currentInterest != null ? this.currentInterest.agencySearchId : 0L;
    }

    public long getCurrentContactsEntryId() {
        return this.currentInterest != null ? this.currentInterest.contactsEntryId : 0L;
    }

    public long getCurrentInterestId() {
        return this.currentInterest != null ? this.currentInterest.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)32);
    }

    protected String getHeaderTitle() {
        long l = this.getCurrentInterestId();
        return l < 1L ? StringUtils.capitalize((String)I18N.tr("new search mandate")) : StringUtils.capitalize((String)I18N.tr("search mandate")) + " #" + l;
    }

    public String getTabTitle() {
        long l = this.getCurrentInterestId();
        return l < 1L ? StringUtils.capitalize((String)I18N.tr("new search mandate")) : StringUtils.capitalize((String)I18N.tr("search mandate")) + " #" + l;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    private static void moveAgencyObjectTableSelection(AgencyEstateTable<? extends AgencyEstateTable.Row> agencyEstateTable, AgencyEstateTable<? extends AgencyEstateTable.Row> agencyEstateTable2, DbAgencyInterestOffer dbAgencyInterestOffer) {
        if (agencyEstateTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        agencyEstateTable.setEnabled(false);
        for (int n : agencyEstateTable.getSelectedRows()) {
            int n2 = agencyEstateTable.convertRowIndexToModel(n);
            AgencyEstateTable.Row row = (AgencyEstateTable.Row)agencyEstateTable.getRow(n2);
            if (agencyEstateTable2 instanceof OffersTable) {
                ((OffersTable)agencyEstateTable2).addRow((AbstractTable.Row)new OffersTableRow(row.getObject(), dbAgencyInterestOffer));
            } else {
                ((OffersSearchTable)agencyEstateTable2).addRow((AbstractTable.Row)new AgencyEstateTable.Row(row.getObject()));
            }
            arrayList.add(n2);
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Integer n = (Integer)object.next();
            agencyEstateTable.removeRow(n.intValue());
        }
        agencyEstateTable.setEnabled(true);
        agencyEstateTable.clearSelection();
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditInterest);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextInterestId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevInterestId > 0L);
    }

    public void setInterest(DbAgencyInterest dbAgencyInterest) {
        this.currentInterest = dbAgencyInterest != null ? dbAgencyInterest : new DbAgencyInterest();
        this.currentSearch = null;
        this.nextInterestId = 0L;
        this.prevInterestId = 0L;
        this.setInfoMessage(null);
        this.mayEditInterest = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT);
        this.mayRemoveInterest = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_REMOVE);
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
        }
        this.updateLocalization();
    }

    private void setMatchingObjectsCount(int n) {
        if (this.offersTab == null) {
            this.setInfoMessage(null);
            return;
        }
        this.offersTab.matchingObjectsCount = n;
        if (n < 1) {
            this.setInfoMessage(null);
        } else {
            String string = I18N.trn("{0} matching property was found, that is not assigned to the search mandate.", "{0} matching properties were found, that are not assigned to the search mandate.", (long)n, (Object)n);
            DefaultEditorPane defaultEditorPane = new DefaultEditorPane();
            defaultEditorPane.setOpaque(false);
            defaultEditorPane.setEditable(false);
            defaultEditorPane.setContentType("text/html");
            defaultEditorPane.setText("<html><a href=\"#\" style=\"font-family:sans-serif;\">" + string + "</a></html>");
            defaultEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        AgencyInterestViewPanel.this.getTabbedPane().setSelectedComponent((Component)((Object)AgencyInterestViewPanel.this.offersTab));
                    }
                }
            });
            this.setInfoMessage((Component)defaultEditorPane);
        }
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbAgencyInterest, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyInterest doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            boolean bl = AgencyInterestViewPanel.this.interestTab.addContactsEntryField.isSelected();
            this.warnings.clear();
            Connection connection = null;
            try {
                DbAgencySearch dbAgencySearch;
                DbContactsEntry dbContactsEntry;
                connection = immoToolProject.getDbConnection();
                DbAgencyInterest dbAgencyInterest = AgencyInterestViewPanel.this.currentInterest == null || ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.id < 1L || this.saveAsCopy ? new DbAgencyInterest() : dbAgencyInterestsHandler.getInterest(connection, ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.id);
                DbContactsEntry dbContactsEntry2 = dbContactsEntry = !bl ? AgencyInterestViewPanel.this.interestTab.contactsEntryField.getContactsEntry() : new DbContactsEntry();
                if (dbContactsEntry.address == null) {
                    dbContactsEntry.address = new CompanyAddressImpl();
                }
                if (dbContactsEntry.values == null) {
                    dbContactsEntry.values = new HashMap();
                }
                DbAgencySearch dbAgencySearch2 = dbAgencySearch = dbAgencyInterest.agencySearchId > 0L ? (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, dbAgencyInterest.agencySearchId) : new DbAgencySearch();
                if (dbAgencySearch == null) {
                    throw new Exception("Unknown search!");
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbAgencyInterest, dbContactsEntry, dbAgencySearch);
                }
                dbContactsHandler.saveEntry(connection, dbContactsEntry);
                dbAgencyInterest.contactsEntryId = dbContactsEntry.id;
                dbAgencySearchesHandler.saveSearch(connection, (DbSearch)dbAgencySearch);
                dbAgencyInterest.agencySearchId = dbAgencySearch.id;
                dbAgencyInterestsHandler.saveInterest(connection, dbAgencyInterest);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, dbAgencyInterest, dbContactsEntry, dbAgencySearch);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                DbAgencyInterest dbAgencyInterest2 = dbAgencyInterest;
                return dbAgencyInterest2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save search mandate!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyInterestViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbAgencyInterest dbAgencyInterest) {
            super.succeeded((Object)dbAgencyInterest);
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            if (dbAgencyInterest != null) {
                AgencyInterestViewPanel.this.setInterest(dbAgencyInterest);
                AgencyInterestViewPanel.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long interestId;

        private RemoveTask(long l) {
            this.interestId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencyInterestsHandler.removeInterest(connection, this.interestId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete search mandate!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyInterestViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)AgencyInterestViewPanel.this), (boolean)true);
        }
    }

    private class OffersViewObjectAction
    extends AbstractI18nAction {
        private OffersViewObjectAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestViewPanel.this.doOffersViewObject();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class OffersShowActionsAction
    extends AbstractI18nAction {
        private OffersShowActionsAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyInterestViewPanel.this.doOffersShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected offers."));
        }
    }

    private class OffersSearchViewObjectAction
    extends AbstractI18nAction {
        private OffersSearchViewObjectAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestViewPanel.this.doOffersSearchViewObject();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class OffersSearchShowActionsAction
    extends AbstractI18nAction {
        private OffersSearchShowActionsAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyInterestViewPanel.this.doOffersSearchShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the matching properties."));
        }
    }

    private class OffersSearchTask
    extends ImmoToolTask<Boolean, Void> {
        private OffersSearchTask() {
        }

        protected Boolean doInBackground() throws Exception {
            AgencyInterestViewPanel.this.searchTab.initSearch(AgencyInterestViewPanel.this.currentSearch);
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                AgencyInterestViewPanel.this.offersTab.doLoadInBackground(connection, false);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't look for matching properties!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private class OffersSearchAction
    extends AbstractI18nAction {
        private OffersSearchAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestViewPanel.this.doOffersSearch();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.trc("search (verb)", "search")));
            this.setShortDescription(I18N.tr("Search for matching properties."));
        }
    }

    private class OffersRemoveAction
    extends AbstractI18nAction {
        private OffersRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestViewPanel.this.doOffersRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove offer")));
            this.setShortDescription(I18N.tr("Remove the selected offers."));
        }
    }

    private class OffersAddAction
    extends AbstractI18nAction {
        private final DbAgencyInterestOffer.Status status;

        private OffersAddAction(DbAgencyInterestOffer.Status status) {
            this.status = status;
            this.setName(this.status.getTranslation());
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestViewPanel.this.doOffersAdd(this.status);
        }
    }

    private class SearchTab
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator titleLabel;
        private JLabel searchNameLabel;
        private JTextField searchNameField;
        private AgencySearchCriteriaPanel criteriaPanel;

        private SearchTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.searchNameLabel = new JLabel();
            this.searchNameField = new JTextField();
            this.searchNameField.setName("searchNameField");
            this.validationHandler.putRule((JComponent)this.searchNameField, ValidationHandler.NOT_BLANK);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.titleLabel).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.searchNameLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.searchNameField).xy(3, defaultFormBuilder.row());
            this.criteriaPanel = new AgencySearchCriteriaPanel();
            this.criteriaPanel.addTemplateListener(new AgencySearchCriteriaPanel.TemplateListener(){
                private String lastName = StringUtils.capitalize((String)AgencyInterestViewPanel.access$2500().tr("new search"));

                public void templateSelected(DbSearch dbSearch) {
                    String string;
                    if (dbSearch == null || dbSearch.item == null) {
                        return;
                    }
                    String string2 = SearchTab.this.searchNameField.getText().trim();
                    if (string2.equalsIgnoreCase(this.lastName.trim()) && !StringUtils.isBlank((CharSequence)(string = dbSearch.item.getName()))) {
                        this.lastName = string;
                        SearchTab.this.searchNameField.setText(string.trim());
                        SearchTab.this.searchNameField.setCaretPosition(0);
                    }
                }
            });
            this.setLayout(new BorderLayout(10, 10));
            this.add(defaultFormBuilder.getPanel(), "North");
            this.add((Component)this.criteriaPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            this.criteriaPanel.loadTemplates(connection, dbAgencySearchesHandler);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.trc("search (noun)", "search"));
        }

        private void initSearch(DbAgencySearch dbAgencySearch) {
            if (dbAgencySearch.item == null) {
                dbAgencySearch.item = new SearchImpl();
            }
            dbAgencySearch.item.setName(this.searchNameField.getText().trim());
            this.criteriaPanel.save(dbAgencySearch);
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            if (dbAgencyInterest.id < 1L || dbAgencySearch.id < 1L) {
                this.searchNameField.setText(StringUtils.capitalize((String)I18N.tr("new search")));
            } else {
                String string = dbAgencySearch.item.getName();
                this.searchNameField.setText(!StringUtils.isBlank((CharSequence)string) ? string : StringUtils.capitalize((String)I18N.tr("new search")));
            }
            this.criteriaPanel.removeCriterias();
            try {
                this.criteriaPanel.setEnabled(false);
                if (dbAgencySearch != null && dbAgencySearch.id > 0L) {
                    this.criteriaPanel.setCurrentSearch(dbAgencySearch);
                } else {
                    this.criteriaPanel.setDefaultSearch();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't load search criterias!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't load search criterias!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
            }
            finally {
                this.criteriaPanel.setEnabled(true);
            }
            this.validationHandler.init();
            this.revalidate();
            this.repaint();
        }

        @Override
        public void save(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) throws Exception {
            this.initSearch(dbAgencySearch);
            dbAgencySearch.type = DbAgencySearch.Type.INTEREST;
            dbAgencySearch.item.setEnabled(DbAgencyInterest.Status.PLANNED.equals((Object)dbAgencyInterest.status) || DbAgencyInterest.Status.PROCESSING.equals((Object)dbAgencyInterest.status));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("search request of the principal")));
            this.searchNameLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        }
    }

    private static class OffersTableRow
    extends AgencyEstateTable.Row {
        private final DbAgencyInterestOffer offer;

        private OffersTableRow(DbAgencyObject dbAgencyObject, DbAgencyInterestOffer dbAgencyInterestOffer) {
            super(dbAgencyObject);
            this.offer = dbAgencyInterestOffer;
        }

        public DbAgencyInterestOffer getOffer() {
            return this.offer;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof OffersTableColumn) {
                return this.getValueForOffer((OffersTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForOffer(OffersTableColumn offersTableColumn) {
            switch (offersTableColumn) {
                case OFFER_TIME: {
                    return this.offer.time;
                }
                case OFFER_STATUS: {
                    return this.offer.status;
                }
                case OFFER_NOTES: {
                    return StringUtils.trimToNull((String)this.offer.notes);
                }
            }
            return null;
        }
    }

    private static enum OffersTableColumn implements AbstractTable.Column
    {
        OFFER_TIME,
        OFFER_STATUS,
        OFFER_NOTES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case OFFER_TIME: {
                    return null;
                }
                case OFFER_STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new InterestOfferStatusRenderer());
                }
                case OFFER_NOTES: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case OFFER_TIME: {
                    return Date.class;
                }
                case OFFER_STATUS: {
                    return DbAgencyInterestOffer.Status.class;
                }
                case OFFER_NOTES: {
                    return String.class;
                }
            }
            return null;
        }

        public String getColumnName() {
            switch (this) {
                case OFFER_TIME: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case OFFER_STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("offer")) + "-" + StringUtils.capitalize((String)I18N.tr("status"));
                }
                case OFFER_NOTES: {
                    return StringUtils.capitalize((String)I18N.tr("notes"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case OFFER_TIME: {
                    return false;
                }
                case OFFER_STATUS: {
                    return true;
                }
                case OFFER_NOTES: {
                    return false;
                }
            }
            return false;
        }
    }

    private final class OffersTable
    extends AgencyEstateTable<OffersTableRow> {
        private OffersTable() {
            super(AgencyInterestViewPanel.OFFER_TABLE_ID);
        }

        protected void doRemove() {
        }

        protected void doSelect() {
            AgencyInterestViewPanel.this.offersTab.offeredEstatesShowActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                AgencyInterestViewPanel.this.offersTab.offerForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                DbAgencyInterestOffer dbAgencyInterestOffer = new DbAgencyInterestOffer();
                dbAgencyInterestOffer.interestId = ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.id;
                dbAgencyInterestOffer.agencyObjectId = this.getEstateIdAt(n);
                dbAgencyInterestOffer.notes = this.getNotesAt(n);
                dbAgencyInterestOffer.status = this.getStatusAt(n);
                dbAgencyInterestOffer.time = this.getTimeAt(n);
                AgencyInterestViewPanel.this.offersTab.offerForm.selectRelation(dbAgencyInterestOffer);
            }
        }

        protected void doShowActions(int n, int n2) {
            AgencyInterestViewPanel.this.doOffersShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyInterestViewPanel.this.doOffersViewObject();
        }

        public String getNotesAt(int n) {
            OffersTableRow offersTableRow = (OffersTableRow)this.getRow(n);
            return offersTableRow != null ? offersTableRow.getOffer().notes : null;
        }

        public DbAgencyInterestOffer.Status getStatusAt(int n) {
            OffersTableRow offersTableRow = (OffersTableRow)this.getRow(n);
            return offersTableRow != null ? offersTableRow.getOffer().status : null;
        }

        public Date getTimeAt(int n) {
            OffersTableRow offersTableRow = (OffersTableRow)this.getRow(n);
            return offersTableRow != null ? offersTableRow.getOffer().time : null;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(OffersTableColumn.values()));
            return list;
        }
    }

    private final class OffersSearchTable
    extends AgencyEstateTable<AgencyEstateTable.Row> {
        private OffersSearchTable() {
            super(AgencyInterestViewPanel.SEARCH_TABLE_ID);
        }

        protected void doRemove() {
        }

        protected void doSelect() {
            AgencyInterestViewPanel.this.offersTab.foundEstatesShowActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyInterestViewPanel.this.doOffersSearchShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyInterestViewPanel.this.doOffersSearchViewObject();
        }
    }

    private final class OffersTabForm
    extends AgencyInterestOfferPanel {
        private OffersTabForm() {
        }

        @Override
        public void close() {
            if (AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.getSelectedRowCount() > 0) {
                AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean submit(DbAgencyInterestOffer dbAgencyInterestOffer) {
            if (dbAgencyInterestOffer == null) {
                return false;
            }
            if (AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.getSelectedRowCount() < 1) {
                return false;
            }
            int n = AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.convertRowIndexToModel(AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.getSelectedRow());
            try {
                AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.setEnabled(false);
                OffersTableRow offersTableRow = (OffersTableRow)AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.getRow(n);
                ((OffersTableRow)offersTableRow).offer.time = dbAgencyInterestOffer.time;
                ((OffersTableRow)offersTableRow).offer.notes = dbAgencyInterestOffer.notes;
                ((OffersTableRow)offersTableRow).offer.status = dbAgencyInterestOffer.status != null ? dbAgencyInterestOffer.status : DbAgencyInterestOffer.Status.OPEN;
                AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.getModel().fireTableRowsUpdated(n, n);
            }
            finally {
                AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.setEnabled(true);
                AgencyInterestViewPanel.this.offersTab.offeredEstatesTable.clearSelection();
            }
            return true;
        }
    }

    private class OffersTab
    extends AbstractTab {
        private int matchingObjectsCount = 0;
        private List<Long> matchingObjectIds = new ArrayList<Long>();
        private Map<Long, DbAgencyInterestOffer> removedOffers;
        private JSplitPane offersSplitPanel;
        private JXTitledSeparator foundEstatesTitle;
        private JCheckBox foundEstatesAllBox;
        private JComboBox<DbAgencyObject.Status> foundEstatesStatusBox;
        private OffersSearchTable foundEstatesTable;
        private AbstractI18nAction foundEstatesShowActionsAction;
        private AbstractI18nAction foundEstatesSearchAction;
        private JXTitledSeparator offeredEstatesTitle;
        private OffersTable offeredEstatesTable;
        private AbstractI18nAction offeredEstatesShowActionsAction;
        private OffersTabForm offerForm;

        private OffersTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.removedOffers = new HashMap<Long, DbAgencyInterestOffer>();
            this.offersSplitPanel = new JSplitPane(0);
            this.offersSplitPanel.setBorder(Paddings.EMPTY);
            this.offersSplitPanel.setTopComponent(this.buildSearchTable());
            this.offersSplitPanel.setBottomComponent(this.buildOffersTable());
            this.offersSplitPanel.setDividerLocation(200);
            this.setLayout(new BorderLayout());
            this.setBorder(Paddings.EMPTY);
            this.add(this.offersSplitPanel, "Center");
        }

        private JPanel buildOffersTable() {
            this.offeredEstatesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.offeredEstatesShowActionsAction = new OffersShowActionsAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.offeredEstatesTitle, (JComponent[])new JComponent[]{new JButton((Action)this.offeredEstatesShowActionsAction)});
            this.offeredEstatesTable = new OffersTable();
            this.offerForm = new OffersTabForm();
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.setBorder((Border)Paddings.DIALOG);
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)this.offeredEstatesTable.createScrollPane(), "Center");
            jPanel2.add((Component)((Object)this.offerForm), "South");
            return jPanel2;
        }

        private JPanel buildSearchTable() {
            this.foundEstatesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.foundEstatesSearchAction = new OffersSearchAction();
            this.foundEstatesShowActionsAction = new OffersSearchShowActionsAction();
            this.foundEstatesAllBox = new JCheckBox();
            this.foundEstatesStatusBox = new JComboBox();
            this.foundEstatesStatusBox.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("property status") + " ]";
                }
            }));
            this.foundEstatesStatusBox.addItem(null);
            for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
                this.foundEstatesStatusBox.addItem(status);
            }
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.foundEstatesTitle, (JComponent[])new JComponent[]{this.foundEstatesAllBox, this.foundEstatesStatusBox, new JButton((Action)this.foundEstatesSearchAction), new JButton((Action)this.foundEstatesShowActionsAction)});
            this.foundEstatesTable = new OffersSearchTable();
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.setBorder((Border)Paddings.DIALOG);
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)this.foundEstatesTable.createScrollPane(), "Center");
            return jPanel2;
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.doLoadInBackground(connection, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection, boolean bl) throws Exception {
            boolean bl2 = this.foundEstatesAllBox.isSelected();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (!bl) {
                for (int i = 0; i < this.offeredEstatesTable.getRowCount(); ++i) {
                    arrayList.add(this.offeredEstatesTable.getEstateIdAt(i));
                }
            }
            this.offeredEstatesTable.setEnabled(false);
            if (bl) {
                this.offeredEstatesTable.clearSelection();
                this.offeredEstatesTable.clearRows();
            }
            this.foundEstatesTable.setEnabled(false);
            this.foundEstatesTable.clearSelection();
            this.foundEstatesTable.clearRows();
            this.matchingObjectIds.clear();
            this.setButtonsEnabled(false);
            ArrayList<DbAgencyObject> arrayList2 = new ArrayList<DbAgencyObject>();
            try {
                Object object;
                DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
                DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
                DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
                DbAgencyObject.Status status = (DbAgencyObject.Status)this.foundEstatesStatusBox.getSelectedItem();
                ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentSearch.status.clear();
                if (status != null) {
                    ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentSearch.status.add(status);
                }
                Map map = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
                HashMap<Long, DbObject> hashMap = new HashMap<Long, DbObject>();
                if (bl && AgencyInterestViewPanel.this.currentInterest != null && ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.id > 0L) {
                    dbAgencyInterestsHandler.loadInterestOffers(connection, AgencyInterestViewPanel.this.currentInterest);
                    if (!((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.offers.isEmpty()) {
                        DbObject[] dbObjectArray;
                        object = ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.offers.keySet();
                        long[] objectArray = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
                        DbObject[] dbObjectArray2 = dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, objectArray);
                        int n = dbObjectArray2.length;
                        for (int i = 0; i < n; ++i) {
                            DbObject dbObject = dbObjectArray2[i];
                            hashMap.put(dbObject.id, dbObject);
                        }
                    }
                }
                object = bl2 ? dbAgencyObjectsHandler.getObjects(connection, status, null) : dbAgencyObjectsHandler.getObjects(connection, (DbSearch)AgencyInterestViewPanel.this.currentSearch);
                for (DbObject dbObject : object) {
                    if (hashMap.containsKey(dbObject.id)) continue;
                    hashMap.put(dbObject.id, dbObject);
                }
                DbObject[] dbObjectArray = hashMap.values().toArray(new DbObject[0]);
                dbAgencyObjectsHandler.loadObjectAttribs(connection, dbObjectArray, map);
                dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, map);
                for (DbObject dbObject : dbObjectArray) {
                    arrayList2.add((DbAgencyObject)dbObject);
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(arrayList2, bl, arrayList, bl2){
                    final /* synthetic */ List val$objectList;
                    final /* synthetic */ boolean val$reloadAssignments;
                    final /* synthetic */ List val$assignedObjectIds;
                    final /* synthetic */ boolean val$showAllObjects;
                    {
                        this.val$objectList = list;
                        this.val$reloadAssignments = bl;
                        this.val$assignedObjectIds = list2;
                        this.val$showAllObjects = bl2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int n = 0;
                        try {
                            for (DbAgencyObject dbAgencyObject : this.val$objectList) {
                                boolean bl;
                                boolean bl2 = bl = this.val$reloadAssignments && AgencyInterestViewPanel.this.currentInterest != null && ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.offers.containsKey(dbAgencyObject.id);
                                if (!this.val$reloadAssignments && this.val$assignedObjectIds.contains(dbAgencyObject.id)) continue;
                                if (bl && this.val$reloadAssignments) {
                                    DbAgencyInterestOffer dbAgencyInterestOffer = ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.offers.get(dbAgencyObject.id);
                                    OffersTab.this.offeredEstatesTable.addRow((AbstractTable.Row)new OffersTableRow(dbAgencyObject, dbAgencyInterestOffer));
                                    OffersTab.this.matchingObjectIds.add(dbAgencyObject.id);
                                    continue;
                                }
                                if (bl) continue;
                                if (!this.val$showAllObjects) {
                                    ++n;
                                    OffersTab.this.matchingObjectIds.add(dbAgencyObject.id);
                                } else if (AgencyInterestViewPanel.this.currentSearch.isMatching(dbAgencyObject)) {
                                    ++n;
                                    OffersTab.this.matchingObjectIds.add(dbAgencyObject.id);
                                }
                                OffersTab.this.foundEstatesTable.addRow((AbstractTable.Row)new AgencyEstateTable.Row(dbAgencyObject));
                            }
                        }
                        finally {
                            OffersTab.this.offeredEstatesTable.setEnabled(true);
                            OffersTab.this.foundEstatesTable.setEnabled(true);
                            Object object = (DbAgencyInterest.Status)((Object)AgencyInterestViewPanel.this.interestTab.statusField.getSelectedItem());
                            if (n < 1 && (object == null || DbAgencyInterest.Status.CANCELLED.equals(object) || DbAgencyInterest.Status.FINISHED.equals(object))) {
                                AgencyInterestViewPanel.this.setMatchingObjectsCount(0);
                                OffersTab.this.matchingObjectIds.clear();
                            } else {
                                AgencyInterestViewPanel.this.setMatchingObjectsCount(n);
                            }
                            OffersTab.this.setButtonsEnabled(true);
                            OffersTab.this.updateLocalization();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("offers"));
        }

        public boolean isLoadedInBackground() {
            return AgencyInterestViewPanel.this.currentInterest != null && ((AgencyInterestViewPanel)AgencyInterestViewPanel.this).currentInterest.id > 0L;
        }

        @Override
        public void load(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            AgencyInterestViewPanel.this.setMatchingObjectsCount(0);
            this.removedOffers.clear();
            this.matchingObjectIds.clear();
            this.foundEstatesAllBox.setSelected(false);
            this.foundEstatesStatusBox.setSelectedItem(DbAgencyObject.Status.PUBLISHED);
            this.offerForm.unselectRelation();
        }

        @Override
        public void save(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
        }

        @Override
        public void saveFinished(Connection connection, DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) throws SQLException {
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            dbAgencyInterestsHandler.loadInterestOffers(connection, dbAgencyInterest);
            if (dbAgencyInterest.offers == null) {
                dbAgencyInterest.offers = new HashMap<Long, DbAgencyInterestOffer>();
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.offeredEstatesTable.getRowCount(); ++i) {
                Long l = this.offeredEstatesTable.getEstateIdAt(i);
                DbAgencyInterestOffer dbAgencyInterestOffer = dbAgencyInterest.offers.containsKey(l) ? dbAgencyInterest.offers.get(l) : new DbAgencyInterestOffer();
                dbAgencyInterestOffer.interestId = dbAgencyInterest.id;
                dbAgencyInterestOffer.agencyObjectId = l;
                dbAgencyInterestOffer.time = this.offeredEstatesTable.getTimeAt(i);
                dbAgencyInterestOffer.status = this.offeredEstatesTable.getStatusAt(i);
                dbAgencyInterestOffer.notes = this.offeredEstatesTable.getNotesAt(i);
                dbAgencyInterestsHandler.saveInterestOffer(connection, dbAgencyInterestOffer);
                arrayList.add(l);
                dbAgencyInterest.offers.put(l, dbAgencyInterestOffer);
            }
            for (Long l : dbAgencyInterest.offers.keySet().toArray(new Long[0])) {
                if (arrayList.contains(l)) continue;
                dbAgencyInterestsHandler.removeInterestOffer(connection, dbAgencyInterest.id, l);
                dbAgencyInterest.offers.remove(l);
            }
        }

        private void setButtonsEnabled(boolean bl) {
            this.offeredEstatesShowActionsAction.setEnabled(bl && this.offeredEstatesTable.getSelectedRowCount() > 0);
            this.foundEstatesShowActionsAction.setEnabled(bl && this.foundEstatesTable.getSelectedRowCount() > 0);
            this.foundEstatesAllBox.setEnabled(bl);
            this.foundEstatesStatusBox.setEnabled(bl);
            this.foundEstatesSearchAction.setEnabled(bl);
        }

        protected void updateLocalization() {
            int n;
            super.updateLocalization();
            String string = StringUtils.capitalize((String)I18N.tr("offered properties"));
            int n2 = n = this.offeredEstatesTable != null ? this.offeredEstatesTable.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.offeredEstatesTitle.setTitle(string);
            string = StringUtils.capitalize((String)I18N.tr("matching properties"));
            int n3 = n = this.foundEstatesTable != null ? this.foundEstatesTable.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.foundEstatesTitle.setTitle(string);
            this.foundEstatesAllBox.setText(I18N.tr("all properties"));
        }
    }

    private final class NotesTab
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JSplitPane splitPane;
        private JXTitledSeparator interestNotesTitle;
        private DefaultTextArea interestNotesField;
        private JXTitledSeparator addressNotesTitle;
        private DefaultTextArea addressNotesField;

        private NotesTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.interestNotesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.interestNotesField = new DefaultTextArea();
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)this.interestNotesTitle, "North");
            jPanel.add((Component)this.interestNotesField.createScrollPane(), "Center");
            this.addressNotesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.addressNotesField = new DefaultTextArea();
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.setBorder((Border)Paddings.DIALOG);
            jPanel2.add((Component)this.addressNotesTitle, "North");
            jPanel2.add((Component)this.addressNotesField.createScrollPane(), "Center");
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBorder(Paddings.EMPTY);
            this.splitPane.setTopComponent(jPanel);
            this.splitPane.setBottomComponent(jPanel2);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(this.splitPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        public void load(DbContactsEntry dbContactsEntry) {
            this.addressNotesField.setText(dbContactsEntry != null ? StringUtils.trimToEmpty((String)dbContactsEntry.notes) : "");
            this.addressNotesField.setCaretPosition(0);
            this.modificationHandler.putValue((JComponent)this.addressNotesField);
        }

        @Override
        public void load(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            this.modificationHandler.clear();
            this.load(dbContactsEntry);
            this.interestNotesField.setText(dbAgencyInterest != null ? StringUtils.trimToEmpty((String)dbAgencyInterest.notes) : "");
            this.interestNotesField.setCaretPosition(0);
            this.modificationHandler.putValue((JComponent)this.interestNotesField);
            this.splitPane.setDividerLocation(0.5);
        }

        @Override
        public void save(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            dbAgencyInterest.notes = StringUtils.trimToNull((String)this.interestNotesField.getText());
            if (this.addressNotesField.isEnabled()) {
                dbContactsEntry.notes = StringUtils.trimToNull((String)this.addressNotesField.getText());
            }
        }

        public void setAddressEnabled(boolean bl) {
            this.addressNotesField.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.interestNotesTitle.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the search mandate")));
            this.addressNotesTitle.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the assigned address")));
        }
    }

    private class InterestTab
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator titleLabel;
        private DbContactsEntry newContactsEntry = null;
        private ContactsEntryExtendedAddressPanel addressPanel;
        private JLabel beginLabel;
        private DefaultDatePicker beginField;
        private JLabel endLabel;
        private DefaultDatePicker endField;
        private JLabel statusLabel;
        private JComboBox<DbAgencyInterest.Status> statusField;
        private JLabel contactsLabel;
        private JComboBox<DbContactsGroup> contactsGroupField;
        private ContactsEntryField contactsEntryField;
        private JCheckBox addContactsEntryField;
        private long loadedContactsEntryId = 0L;
        private long loadedContactsGroupId = 0L;

        private InterestTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.beginLabel = new JLabel();
            this.beginField = new DefaultDatePicker();
            this.endLabel = new JLabel();
            this.endField = new DefaultDatePicker();
            this.statusLabel = new JLabel();
            this.statusField = new JComboBox();
            this.statusField.setRenderer((ListCellRenderer<DbAgencyInterest.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.statusField.addItem(null);
            for (DbAgencyInterest.Status status : DbAgencyInterest.Status.values()) {
                this.statusField.addItem(status);
            }
            this.contactsLabel = new JLabel();
            this.contactsGroupField = new JComboBox();
            this.contactsGroupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select address group") + " ]";
                }
            }));
            this.contactsGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!InterestTab.this.contactsGroupField.isEnabled()) {
                        return;
                    }
                    DbContactsGroup dbContactsGroup = (DbContactsGroup)InterestTab.this.contactsGroupField.getSelectedItem();
                    DbContactsEntry dbContactsEntry = InterestTab.this.contactsEntryField.getContactsEntry();
                    InterestTab.this.contactsEntryField.setContactsGroupId(dbContactsGroup != null ? dbContactsGroup.id : 0L);
                    if (dbContactsEntry == null || dbContactsGroup == null || dbContactsEntry.groupId != dbContactsGroup.id) {
                        InterestTab.this.contactsEntryField.setContactsEntry(null);
                    }
                    InterestTab.this.updateAddressForm();
                }
            });
            this.contactsEntryField = new ContactsEntryField();
            this.contactsEntryField.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

                public void valueChanged() {
                    if (!InterestTab.this.contactsEntryField.isEnabled()) {
                        return;
                    }
                    InterestTab.this.updateAddressForm();
                }
            });
            this.addContactsEntryField = new JCheckBox();
            this.addContactsEntryField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.addContactsEntryField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!InterestTab.this.addContactsEntryField.isEnabled()) {
                        return;
                    }
                    InterestTab.this.contactsEntryField.setEnabled(!InterestTab.this.addContactsEntryField.isSelected());
                    if (!InterestTab.this.addContactsEntryField.isSelected() && InterestTab.this.newContactsEntry != null) {
                        InterestTab.this.addressPanel.save(InterestTab.this.newContactsEntry);
                    }
                    InterestTab.this.updateAddressForm();
                }
            });
            this.validationHandler.putRule((JComponent)this.beginField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.statusField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.contactsGroupField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule((JComponent)this.contactsEntryField, ValidationHandler.NOT_NULL);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[60dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:[60dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.titleLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
            defaultFormBuilder.add((Component)this.contactsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.contactsGroupField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.statusField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.contactsEntryField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.beginLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.beginField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.addContactsEntryField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.endLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.endField).xy(7, defaultFormBuilder.row());
            this.addressPanel = new ContactsEntryExtendedAddressPanel(60){

                public void load(DbContactsEntry dbContactsEntry) {
                    super.load(dbContactsEntry);
                    try {
                        AgencyInterestViewPanel.this.detailsTab.load(dbContactsEntry);
                        AgencyInterestViewPanel.this.notesTab.load(dbContactsEntry);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load address details!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }

                public void setEnabled(boolean bl) {
                    super.setEnabled(bl);
                    AgencyInterestViewPanel.this.detailsTab.setAddressEnabled(bl);
                    AgencyInterestViewPanel.this.notesTab.setAddressEnabled(bl);
                }
            };
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
            jPanel.add((Component)this.addressPanel, "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) throws Exception {
            this.contactsGroupField.setEnabled(false);
            this.contactsGroupField.setModel(new DefaultComboBoxModel());
            ArrayList<DbContactsGroup> arrayList = new ArrayList<DbContactsGroup>();
            try {
                DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
                DbContactsGroup[] dbContactsGroupArray = dbContactsHandler.getGroups(connection);
                arrayList.addAll(Arrays.asList(dbContactsGroupArray));
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(arrayList){
                    final /* synthetic */ List val$groupList;
                    {
                        this.val$groupList = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
                                defaultComboBoxModel.addElement(null);
                                for (DbContactsGroup dbContactsGroup : this.val$groupList) {
                                    defaultComboBoxModel.addElement(dbContactsGroup);
                                }
                                InterestTab.this.contactsGroupField.setModel(defaultComboBoxModel);
                                InterestTab.this.contactsGroupField.setSelectedItem(null);
                                if (InterestTab.this.loadedContactsGroupId <= 0L) break block5;
                                for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                                    DbContactsGroup dbContactsGroup;
                                    dbContactsGroup = (DbContactsGroup)defaultComboBoxModel.getElementAt(i);
                                    if (dbContactsGroup == null || dbContactsGroup.id != InterestTab.this.loadedContactsGroupId) continue;
                                    InterestTab.this.contactsGroupField.setSelectedItem(dbContactsGroup);
                                    break;
                                }
                            }
                            finally {
                                InterestTab.this.contactsGroupField.setEnabled(true);
                                InterestTab.this.validationHandler.init();
                                InterestTab.this.updateAddressForm();
                            }
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("mandate"));
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabValid() {
            this.validationHandler.validate();
            this.addressPanel.validateInputs();
            return this.validationHandler.isValid() && this.addressPanel.isValidInput();
        }

        @Override
        public void load(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            this.loadedContactsEntryId = dbContactsEntry != null ? dbContactsEntry.id : 0L;
            this.loadedContactsGroupId = dbContactsEntry != null ? dbContactsEntry.groupId : 0L;
            this.newContactsEntry = null;
            this.beginField.setDate(dbAgencyInterest.id > 0L ? dbAgencyInterest.begin : new Date());
            this.endField.setDate(dbAgencyInterest.end);
            this.statusField.setSelectedItem((Object)(dbAgencyInterest.id > 0L ? dbAgencyInterest.status : DbAgencyInterest.Status.PLANNED));
            this.contactsGroupField.setEnabled(false);
            this.contactsGroupField.setModel(new DefaultComboBoxModel());
            this.addContactsEntryField.setSelected(dbAgencyInterest.id == 0L && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.contactsEntryField.setEnabled(false);
            this.contactsEntryField.setContactsEntry(dbContactsEntry != null && dbContactsEntry.id > 0L ? dbContactsEntry : null);
            this.contactsEntryField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && !this.addContactsEntryField.isSelected());
            this.addressPanel.setEnabled(false);
        }

        @Override
        public void save(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            dbAgencyInterest.begin = this.beginField.getDate();
            dbAgencyInterest.end = this.endField.getDate();
            dbAgencyInterest.status = (DbAgencyInterest.Status)((Object)this.statusField.getSelectedItem());
            if (this.contactsGroupField.isEnabled()) {
                dbContactsEntry.groupId = ((DbContactsGroup)this.contactsGroupField.getSelectedItem()).id;
            }
            if (this.addressPanel.isEnabled()) {
                this.addressPanel.save(dbContactsEntry);
            }
        }

        private void updateAddressForm() {
            boolean bl;
            boolean bl2 = this.addContactsEntryField.isEnabled() && this.addContactsEntryField.isSelected();
            DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactsGroupField.getSelectedItem();
            DbContactsEntry dbContactsEntry = this.contactsEntryField.getContactsEntry();
            if (bl2) {
                if (this.newContactsEntry == null) {
                    this.newContactsEntry = new DbContactsEntry();
                }
                dbContactsEntry = this.newContactsEntry;
            }
            boolean bl3 = bl = dbContactsGroup != null && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT);
            if (!bl2) {
                boolean bl4 = bl = bl && dbContactsEntry != null && dbContactsEntry.id > 0L;
            }
            if (dbContactsGroup != null && dbContactsGroup.permission != null) {
                DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
                bl = bl && dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
            }
            this.addressPanel.load(dbContactsEntry != null ? dbContactsEntry : new DbContactsEntry());
            this.addressPanel.setEnabled(bl);
            this.addressPanel.initInputs();
            this.validationHandler.init();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("details about the search mandate")));
            this.beginLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
            this.endLabel.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
            this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
            this.contactsLabel.setText(StringUtils.capitalize((String)I18N.tr("principal")) + ":");
            this.addContactsEntryField.setText(I18N.tr("Create a new address."));
        }
    }

    private static class DetailsTab
    extends AbstractTab {
        private ContactsEntryViewDetailsPanel form;

        private DetailsTab(ContactsEntryExtendedAddressPanel contactsEntryExtendedAddressPanel) {
            this.build(contactsEntryExtendedAddressPanel);
        }

        private void build(ContactsEntryExtendedAddressPanel contactsEntryExtendedAddressPanel) {
            this.form = new ContactsEntryViewDetailsPanel((ContactsEntryAddressPanel)contactsEntryExtendedAddressPanel);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add((Component)this.form, "Center");
        }

        public String getTabTitle() {
            return this.form.getTabTitle();
        }

        public void load(DbContactsEntry dbContactsEntry) {
            this.form.load(dbContactsEntry);
        }

        @Override
        public void load(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            this.load(dbContactsEntry);
        }

        @Override
        public void save(DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) {
            if (this.form.isEnabled()) {
                this.form.save(dbContactsEntry);
            }
        }

        public void setAddressEnabled(boolean bl) {
            this.form.setEnabled(bl);
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<AgencyInterestViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public AgencyInterestViewPanel getViewPanel() {
            return this.viewPanel != null ? (AgencyInterestViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbAgencyInterest var1, DbContactsEntry var2, DbAgencySearch var3) throws Exception;

        public abstract void save(DbAgencyInterest var1, DbContactsEntry var2, DbAgencySearch var3) throws Exception;

        public void saveFinished(Connection connection, DbAgencyInterest dbAgencyInterest, DbContactsEntry dbContactsEntry, DbAgencySearch dbAgencySearch) throws SQLException, IOException {
        }

        public void setViewPanel(AgencyInterestViewPanel agencyInterestViewPanel) {
            this.viewPanel = agencyInterestViewPanel != null ? new WeakReference<AgencyInterestViewPanel>(agencyInterestViewPanel) : null;
        }
    }
}

