/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero.converters;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Kyero_3
extends XmlConverter<KyeroDocument, KyeroVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Kyero_3.class);

    public KyeroVersion getVersion() {
        return KyeroVersion.V3;
    }

    public void downgradeToPreviousVersion(KyeroDocument kyeroDocument) {
        kyeroDocument.setDocumentVersion(KyeroVersion.V2_1);
        try {
            this.downgradeNewBuildElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't downgrade <new_build> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.downgradeTypeElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't downgrade <type> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.downgradeUrlElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't downgrade <url> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.removeLocationElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove <location> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.removeEnergyRatingElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove <energy_rating> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.removeNotesElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove <notes> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.removeUnsupportedLanguageElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove unsupported translation elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void upgradeFromPreviousVersion(KyeroDocument kyeroDocument) {
        kyeroDocument.setDocumentVersion(KyeroVersion.V3);
        try {
            this.removeCustomElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't remove <custom> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.upgradeNewBuildElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't upgrade <new_build> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.upgradeTypeElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't upgrade <type> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.upgradeCurrencyElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't upgrade <currency> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            this.upgradeUrlElements(kyeroDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't upgrade <url> elements!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected void downgradeNewBuildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:new_build", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            String string = StringUtils.trimToNull((String)element.getTextContent());
            if ("1".equals(string)) {
                Element element3 = (Element)XmlUtils.newXPath((String)"io:price_freq", (Document)document).selectSingleNode((Object)element2);
                if (element3 == null) {
                    element3 = document.createElementNS("", "price_freq");
                    element3.setTextContent("new_build");
                    element2.appendChild(element3);
                } else if ("sale".equalsIgnoreCase(element3.getTextContent())) {
                    element3.setTextContent("new_build");
                }
            }
            element2.removeChild(element);
        }
    }

    protected void downgradeTypeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:type", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getTextContent());
            element.setTextContent(null);
            Element element2 = document.createElementNS("", "en");
            element2.setTextContent(string);
            element.appendChild(element2);
        }
    }

    protected void downgradeUrlElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:url", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = null;
            String string2 = null;
            List list2 = XmlUtils.newXPath((String)"*", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                Element element2 = (Element)e2;
                if ("en".equalsIgnoreCase(element2.getLocalName())) {
                    string = StringUtils.trimToNull((String)element2.getTextContent());
                } else if (string2 == null) {
                    string2 = StringUtils.trimToNull((String)element2.getTextContent());
                }
                element.removeChild(element2);
            }
            element.setTextContent(string != null ? string : string2);
        }
    }

    protected void removeCustomElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:custom  | /io:root/io:agent/io:custom", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeEnergyRatingElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:energy_rating", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeLocationElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:location", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeNotesElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:notes", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeUnsupportedLanguageElements(Document document) throws JaxenException {
        Object[] objectArray = new String[]{"ar", "bg", "ca", "cs", "da", "el", "et", "fa", "fi", "he", "hi", "hu", "id", "it", "ja", "ko", "lt", "lv", "no", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:desc | /io:root/io:property/io:images/io:image/io:title", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            List list2 = XmlUtils.newXPath((String)"*", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                Element element2 = (Element)e2;
                String string = element2.getLocalName().toLowerCase();
                if (!ArrayUtils.contains((Object[])objectArray, (Object)string)) continue;
                element.removeChild(element2);
            }
        }
    }

    protected void upgradeCurrencyElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:currency", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            String string = StringUtils.trimToNull((String)element.getTextContent());
            if ("EUR".equalsIgnoreCase(string)) {
                element.setTextContent("EUR");
                continue;
            }
            if ("GBP".equalsIgnoreCase(string)) {
                element.setTextContent("GBP");
                continue;
            }
            if ("USD".equalsIgnoreCase(string)) {
                element.setTextContent("USD");
                continue;
            }
            element2.removeChild(element);
        }
    }

    protected void upgradeNewBuildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:price_freq", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            if (!"new_build".equalsIgnoreCase(element.getTextContent())) continue;
            element.setTextContent("sale");
            Element element3 = document.createElementNS("", "new_build");
            element3.setTextContent("1");
            element2.appendChild(element3);
        }
    }

    protected void upgradeTypeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:type", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = null;
            String string2 = null;
            List list2 = XmlUtils.newXPath((String)"*", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                Element element2 = (Element)e2;
                if ("en".equalsIgnoreCase(element2.getLocalName())) {
                    string = StringUtils.trimToNull((String)element2.getTextContent());
                } else if (string2 == null) {
                    string2 = StringUtils.trimToNull((String)element2.getTextContent());
                }
                element.removeChild(element2);
            }
            element.setTextContent(string != null ? string : string2);
        }
    }

    protected void upgradeUrlElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:root/io:property/io:url", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element;
            Element element2 = (Element)e;
            String string = StringUtils.trimToNull((String)element2.getTextContent());
            element2.setTextContent(null);
            if (string == null) {
                element = (Element)element2.getParentNode();
                element.removeChild(element2);
                continue;
            }
            element = document.createElementNS("", "en");
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }
}

