/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.utils.Response;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.Message;
import org.openestate.is24.restapi.xml.common.Messages;
import org.openestate.is24.restapi.xml.common.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFailedException
extends Exception {
    private static final long serialVersionUID = -5913145712963169005L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestFailedException.class);
    public final int statusCode;
    public final String statusMessage;
    public final String requestRefNumber;
    public final Messages responseMessages;

    public RequestFailedException(Response response, String string) {
        super(string);
        this.statusCode = response.statusCode;
        this.statusMessage = StringUtils.trimToNull((String)response.statusMessage);
        this.requestRefNumber = StringUtils.trimToNull((String)response.requestRefNumber);
        Messages messages = null;
        String string2 = StringUtils.trimToNull((String)response.body);
        if (string2 != null && string2.startsWith("<?xml")) {
            try {
                messages = (Messages)XmlUtils.unmarshal(string2);
            }
            catch (Exception exception) {
                LOGGER.error("WARNING: Can't read error messages from response body!");
                LOGGER.error(StringUtils.repeat((String)"-", (int)40));
                LOGGER.error(string2);
                LOGGER.error(StringUtils.repeat((String)"-", (int)40));
                LOGGER.error(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (messages == null) {
            ObjectFactory objectFactory = new ObjectFactory();
            Message message = objectFactory.createMessage();
            message.setMessage(string2 != null ? string2 : this.statusMessage);
            message.setMessageCode(null);
            messages = objectFactory.createMessages();
            messages.getMessage().add(message);
        }
        this.responseMessages = messages;
    }

    public RequestFailedException(Response response, String string, Throwable throwable) {
        super(string, throwable);
        this.statusCode = response.statusCode;
        this.statusMessage = StringUtils.trimToNull((String)response.statusMessage);
        this.requestRefNumber = StringUtils.trimToNull((String)response.requestRefNumber);
        Messages messages = null;
        try {
            messages = !StringUtils.isBlank((CharSequence)response.body) ? (Messages)XmlUtils.unmarshal(response.body) : null;
        }
        catch (Exception exception) {
            LOGGER.error("Can't parse response messages!", (Throwable)exception);
        }
        this.responseMessages = messages;
    }

    public String getRequestRefNumber() {
        return this.requestRefNumber;
    }

    public Messages getResponseMessages() {
        return this.responseMessages;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

