/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.NumberUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoFeedbackDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OpenImmoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoUtils.class);
    private static JAXBContext JAXB = null;
    public static final OpenImmoVersion VERSION = OpenImmoVersion.V1_2_7B;
    public static final String NAMESPACE = "";
    public static final String OLD_NAMESPACE = "http://www.openimmo.de";
    public static final String PACKAGE = "org.openestate.io.openimmo.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private OpenImmoUtils() {
    }

    public static OpenImmoDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return OpenImmoUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static OpenImmoDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return OpenImmoUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static OpenImmoDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return OpenImmoUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static OpenImmoDocument createDocument(Document document) {
        if (OpenImmoTransferDocument.isReadable(document)) {
            return new OpenImmoTransferDocument(document);
        }
        if (OpenImmoFeedbackDocument.isReadable(document)) {
            return new OpenImmoFeedbackDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return OpenImmoUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = OpenImmoUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = OpenImmoUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static Element createUserDefinedSimplefield(Document document, String string, String string2) {
        Element element = XmlUtils.getRootElement((Document)document);
        Element element2 = document.createElementNS(element.getNamespaceURI(), "user_defined_simplefield");
        element2.setAttribute("feldname", string);
        element2.setTextContent(string2);
        return element2;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            OpenImmoUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static Calendar parseDate(String string) {
        return XmlUtils.parseDate((String)string);
    }

    public static Calendar parseDateTime(String string) {
        return XmlUtils.parseDateTime((String)string);
    }

    public static BigDecimal parseDecimal(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDecimal((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return BigDecimal.valueOf(NumberUtils.parseNumber((String)string, (Locale[])new Locale[]{Locale.GERMANY}).doubleValue());
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalArgumentException("Can't parse decimal value '" + string + "'!");
            }
        }
    }

    public static BigInteger parseInteger(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseInteger((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse integer value '" + string + "'! " + numberFormatException.getLocalizedMessage());
        }
    }

    public static BigDecimal parsePositiveDecimal(String string) {
        return OpenImmoUtils.parseDecimal(string);
    }

    public static BigInteger parsePositiveInteger(String string) {
        return OpenImmoUtils.parseInteger(string);
    }

    public static String printDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date value!");
        }
        return OpenImmoUtils.getDateFormat().format(calendar.getTime());
    }

    public static String printDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date-time value!");
        }
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print double value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print integer value!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printPositiveDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Can't print positive decimal value!");
        }
        return OpenImmoUtils.printDecimal(bigDecimal.setScale(2, 4));
    }

    public static String printPositiveInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 1) {
            throw new IllegalArgumentException("Can't print positive integer value!");
        }
        return OpenImmoUtils.printInteger(bigInteger);
    }
}

