/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_xml;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.core.XmlDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.IS24ImmobilienTransfer;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Is24XmlDocument
extends XmlDocument<ImmobilienTransferTyp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlDocument.class);

    public Is24XmlDocument(Document document) {
        super(document);
        if (!Is24XmlDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "IS24ImmobilienTransfer".equals(element.getLocalName());
    }

    public static Is24XmlDocument newDocument() throws ParserConfigurationException, JAXBException {
        return Is24XmlDocument.newDocument(Is24XmlUtils.getFactory().createImmobilienTransferTyp());
    }

    public static Is24XmlDocument newDocument(ImmobilienTransferTyp immobilienTransferTyp) throws ParserConfigurationException, JAXBException {
        return Is24XmlDocument.newDocument(Is24XmlUtils.getFactory().createIS24ImmobilienTransfer(immobilienTransferTyp));
    }

    public static Is24XmlDocument newDocument(IS24ImmobilienTransfer iS24ImmobilienTransfer) throws ParserConfigurationException, JAXBException {
        Document document = XmlUtils.newDocument();
        Is24XmlUtils.createMarshaller("UTF-8", true).marshal((Object)iS24ImmobilienTransfer, (Node)document);
        return new Is24XmlDocument(document);
    }

    public ImmobilienTransferTyp toObject() throws JAXBException {
        return (ImmobilienTransferTyp)((IS24ImmobilienTransfer)((Object)Is24XmlUtils.createUnmarshaller().unmarshal((Node)this.getDocument()))).getValue();
    }
}

