/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.calendar;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyCalendarExtension;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyCalendarHandler;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyEstateCalendarEntry;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.utils.Relation;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyCalendarUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyCalendarUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyCalendarUpgradeExtension.class);

    public void upgradeFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, ImmoToolTask.Callback callback) throws SQLException, IOException {
        this.setMessage("Upgrade agency-calendar relations...", callback);
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        File file2 = new File(file.getAbsolutePath() + File.separator + "estate_calendars");
        DbAgencyCalendarHandler dbAgencyCalendarHandler = null;
        Object[] objectArray = ImmoToolEnvironment.getDbRelationExtensions((AbstractDbDriver)abstractDbDriver, null).iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray2 = (Object[])objectArray.next();
            if (!(objectArray2 instanceof DbAgencyCalendarExtension)) continue;
            dbAgencyCalendarHandler = ((DbAgencyCalendarExtension)objectArray2).getHandler();
            break;
        }
        if (dbAgencyCalendarHandler == null) {
            LOGGER.warn("Can't find relation-handler!");
            LOGGER.warn("> " + DbAgencyCalendarExtension.class.getName());
            this.setMessage("WARNING: Can't find relation-handler!", callback);
            this.setMessage("> " + DbAgencyCalendarExtension.class.getName(), callback);
            return;
        }
        if (file2.isDirectory() && ArrayUtils.isNotEmpty((Object[])(objectArray = file2.listFiles((FileFilter)suffixFileFilter)))) {
            for (Object object : objectArray) {
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream((File)object), "UTF-8");){
                    Relation relation = new Relation();
                    relation.read((Reader)inputStreamReader);
                    DbAgencyEstateCalendarEntry dbAgencyEstateCalendarEntry = new DbAgencyEstateCalendarEntry();
                    dbAgencyEstateCalendarEntry.relationNotes = relation.getNotes();
                    if (dbAgencyEstateCalendarEntry.relationNotes != null && dbAgencyEstateCalendarEntry.relationNotes.trim().length() < 1) {
                        dbAgencyEstateCalendarEntry.relationNotes = null;
                    }
                    dbAgencyEstateCalendarEntry.agencyEstateId = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Agency.estates", relation.getFirstObject("com.openindex.openestate.tool.agency.AgencyEstate").getId());
                    dbAgencyEstateCalendarEntry.calendarEntryId = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Calendar.entries", relation.getFirstObject("com.openindex.openestate.tool.calendar.CalendarEntry").getId());
                    if (dbAgencyEstateCalendarEntry.calendarEntryId < 1L || dbAgencyEstateCalendarEntry.agencyEstateId < 1L) {
                        LOGGER.warn("Relation is incomplete!");
                        this.setMessage("WARNING: Relation is incomplete!", callback);
                        continue;
                    }
                    this.setMessage("> estate #" + dbAgencyEstateCalendarEntry.agencyEstateId + " / calendar-entry #" + dbAgencyEstateCalendarEntry.calendarEntryId, callback);
                    dbAgencyCalendarHandler.saveEstateCalendarEntry(connection, dbAgencyEstateCalendarEntry);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read relation!");
                    LOGGER.warn("> from " + ((File)object).getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read relation!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
    }
}

