/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyFrameSidebarExtension;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonAdapter;
import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactsFrameSidebarExtension
extends FrameSidebarAddonAdapter<AgencyFrameSidebarExtension.TreeNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactsFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactsFrameSidebarExtension.class);

    public AgencyContactsFrameSidebarExtension() {
        super(AgencyFrameSidebarExtension.class);
    }

    public Component[] getMenuComponents(AgencyFrameSidebarExtension.TreeNode treeNode, int n) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        if (n == 6 && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN)) {
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT)) {
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.InterestFormAction())));
            }
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT)) {
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.BrokeringFormAction())));
            }
        }
        if (n == 9 && treeNode instanceof AddonTreeNode && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN)) {
            AddonTreeNode addonTreeNode = (AddonTreeNode)treeNode;
            if (addonTreeNode.isBrokeringsNode() && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
                arrayList.add((JMenuItem)ImmoToolUtils.createMenuSeparator((String)addonTreeNode.getNodeText()));
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.BrokeringTableAction(true))));
            }
            if (addonTreeNode.isInterestsNode() && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
                arrayList.add((JMenuItem)ImmoToolUtils.createMenuSeparator((String)addonTreeNode.getNodeText()));
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.InterestTableAction(true))));
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Component[0]);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"};
    }

    public void initTree(Connection connection, AgencyFrameSidebarExtension.TreeNode treeNode) {
        int n = -1;
        AgencyFrameSidebarExtension.TreeNode treeNode2 = null;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            AgencyFrameSidebarExtension.TreeNode treeNode3 = (AgencyFrameSidebarExtension.TreeNode)treeNode.getChildAt(i);
            if (!treeNode3.isContactsNode()) continue;
            treeNode2 = treeNode3;
            n = i;
            break;
        }
        if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN)) {
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
                AddonTreeNode addonTreeNode = new AddonTreeNode(1);
                if (n > -1) {
                    treeNode2.add((MutableTreeNode)((Object)addonTreeNode));
                } else {
                    treeNode.add((MutableTreeNode)((Object)addonTreeNode));
                }
            }
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
                AddonTreeNode addonTreeNode = new AddonTreeNode(2);
                if (treeNode2 != null) {
                    treeNode2.add((MutableTreeNode)((Object)addonTreeNode));
                } else {
                    treeNode.add((MutableTreeNode)((Object)addonTreeNode));
                }
            }
        }
    }

    private static class AddonTreeNode
    extends AgencyFrameSidebarExtension.TreeNode {
        private static final int TYPE_CONTACTS_INTERESTS = 1;
        private static final int TYPE_CONTACTS_BROKERINGS = 2;
        private final int contactsType;

        public AddonTreeNode(int n) {
            super(0);
            this.contactsType = n;
        }

        public void doShow(boolean bl) {
            switch (this.contactsType) {
                case 2: {
                    new AgencyContactsUtils.BrokeringTableAction(bl).actionPerformed(null);
                    break;
                }
                case 1: {
                    new AgencyContactsUtils.InterestTableAction(bl).actionPerformed(null);
                    break;
                }
                default: {
                    super.doShow(bl);
                }
            }
        }

        public Icon getNodeIcon() {
            switch (this.contactsType) {
                case 2: {
                    return ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16);
                }
                case 1: {
                    return ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16);
                }
            }
            return super.getNodeIcon();
        }

        public String getNodeText() {
            switch (this.contactsType) {
                case 2: {
                    return StringUtils.capitalize((String)I18N.tr("brokering mandates"));
                }
                case 1: {
                    return StringUtils.capitalize((String)I18N.tr("search mandates"));
                }
            }
            return super.getNodeText();
        }

        public String getNodeTooltip() {
            switch (this.contactsType) {
                case 2: {
                    return null;
                }
                case 1: {
                    return null;
                }
            }
            return super.getNodeTooltip();
        }

        public boolean isBrokeringsNode() {
            return this.contactsType == 2;
        }

        public boolean isInterestsNode() {
            return this.contactsType == 1;
        }
    }
}

