/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsExtension;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyEstateContactEntry;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.utils.Relation;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactsUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactsUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactsUpgradeExtension.class);

    public void upgradeFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, ImmoToolTask.Callback callback) throws SQLException, IOException {
        this.setMessage("Upgrade agency-contacts relations...", callback);
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        File file2 = new File(file.getParentFile().getAbsolutePath() + File.separator + "OpenEstate-Tool-Contacts" + File.separator + "entry_estates");
        DbAgencyContactsHandler dbAgencyContactsHandler = null;
        DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = null;
        for (Object[] objectArray : ImmoToolEnvironment.getDbRelationExtensions((AbstractDbDriver)abstractDbDriver, null)) {
            if (!(objectArray instanceof DbAgencyContactsExtension)) continue;
            dbAgencyContactsHandler = ((DbAgencyContactsExtension)objectArray).getContactsHandler();
            dbAgencyBrokeringsHandler = ((DbAgencyContactsExtension)objectArray).getBrokeringsHandler();
            break;
        }
        if (dbAgencyContactsHandler == null) {
            LOGGER.warn("Can't find relation-handler!");
            LOGGER.warn("> " + DbAgencyContactsExtension.class.getName());
            this.setMessage("WARNING: Can't find relation-handler!", callback);
            this.setMessage("> " + DbAgencyContactsExtension.class.getName(), callback);
            return;
        }
        if (dbAgencyBrokeringsHandler == null) {
            LOGGER.warn("Can't find relation-handler!");
            LOGGER.warn("> " + DbAgencyBrokeringsHandler.class.getName());
            this.setMessage("WARNING: Can't find relation-handler!", callback);
            this.setMessage("> " + DbAgencyBrokeringsHandler.class.getName(), callback);
            return;
        }
        if (file2.isDirectory()) {
            Object[] objectArray;
            ArrayList arrayList = new ArrayList();
            objectArray = file2.listFiles((FileFilter)suffixFileFilter);
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream((File)object), "UTF-8");){
                        Serializable serializable;
                        Relation relation = new Relation();
                        relation.read((Reader)inputStreamReader);
                        long l = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Agency.estates", relation.getFirstObject("com.openindex.openestate.tool.agency.AgencyEstate").getId());
                        long l2 = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Contacts.entries", relation.getFirstObject("com.openindex.openestate.tool.contacts.ContactsEntry").getId());
                        if (l2 < 1L || l < 1L) {
                            LOGGER.warn("Relation is incomplete (property #" + l + ", contact #" + l2 + ")!");
                            this.setMessage("WARNING: Relation is incomplete (property #" + l + ", contact #" + l2 + ")!", callback);
                            continue;
                        }
                        String string = StringUtils.trimToNull((String)((String)relation.getParams().get("estate.contact.type")));
                        if (!arrayList.contains(l) && ("owner".equalsIgnoreCase(string) || "Eigent\u00fcmer".equalsIgnoreCase(string))) {
                            serializable = new DbAgencyBrokering();
                            ((DbAgencyBrokering)serializable).agencyObjectId = l;
                            ((DbAgencyBrokering)serializable).contactsEntryId = l2;
                            ((DbAgencyBrokering)serializable).begin = null;
                            ((DbAgencyBrokering)serializable).end = null;
                            ((DbAgencyBrokering)serializable).exclusive = false;
                            ((DbAgencyBrokering)serializable).notes = StringUtils.trimToNull((String)relation.getNotes());
                            this.setMessage("> estate #" + ((DbAgencyBrokering)serializable).agencyObjectId + " / contact-entry #" + ((DbAgencyBrokering)serializable).contactsEntryId + " (brokering)", callback);
                            dbAgencyBrokeringsHandler.saveBrokering(connection, (DbAgencyBrokering)serializable);
                            arrayList.add(l);
                            continue;
                        }
                        serializable = new DbAgencyEstateContactEntry();
                        serializable.agencyEstateId = l;
                        serializable.contactEntryId = l2;
                        serializable.relationType = StringUtils.trimToNull((String)string);
                        serializable.relationNotes = StringUtils.trimToNull((String)relation.getNotes());
                        if (serializable.relationNotes != null && serializable.relationNotes.trim().length() < 1) {
                            serializable.relationNotes = null;
                        }
                        this.setMessage("> estate #" + serializable.agencyEstateId + " / contact-entry #" + serializable.contactEntryId + " (custom)", callback);
                        dbAgencyContactsHandler.saveEstateContactEntry(connection, (DbAgencyEstateContactEntry)serializable);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Can't read relation!");
                        LOGGER.warn("> from " + ((File)object).getAbsolutePath());
                        LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                        this.setMessage("WARNING: Can't read relation!", callback);
                        this.setMessage("> " + throwable.getLocalizedMessage(), callback);
                    }
                }
            }
        }
    }
}

