/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.DbContactsHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyContactTable;
import com.openindex.openestate.tool.agency.AgencyContactViewTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyContactTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactTablePanel.class);
    private static final String TABLE_ID = "AgencyContactTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_NAME = 1;
    private static final int FILTER_ADDRESS = 2;
    private static final int FILTER_EMAIL = 3;
    private static final int COUNT_FILTERS = 4;
    private List<String> filterValues;
    private JLabel personIdLabel;
    private JFormattedTextField personIdField;
    private JLabel personNameLabel;
    private JTextField personNameField;
    private JLabel personAddressLabel;
    private JTextField personAddressField;
    private JLabel personMailLabel;
    private JTextField personMailField;
    private JLabel personFilterLabel;
    private JComboBox<FilterType> personFilterBox;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private AgencyContactTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new ContactAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(AgencyPlugin.getResourceIcon("agent_family.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.filterValues.add(null);
        }
        this.personIdLabel = new JLabel();
        this.personIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.personIdField.setName("personIdField");
        this.personIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!AgencyContactTablePanel.this.personIdField.isEnabled()) {
                    return;
                }
                try {
                    AgencyContactTablePanel.this.personIdField.commitEdit();
                }
                catch (Exception exception) {
                    AgencyContactTablePanel.this.personIdField.setValue(null);
                }
                String string2 = string = AgencyContactTablePanel.this.personIdField.isEditValid() ? AgencyContactTablePanel.this.personIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && AgencyContactTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase((String)AgencyContactTablePanel.this.filterValues.get(0))) {
                    return;
                }
                AgencyContactTablePanel.this.filterValues.set(0, string);
                AgencyContactTablePanel.this.updateFilters(true);
            }
        });
        this.personNameLabel = new JLabel();
        this.personNameField = new JTextField();
        this.personNameField.setName("personNameField");
        this.personNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyContactTablePanel.this.personNameField.isEnabled()) {
                    return;
                }
                String string = AgencyContactTablePanel.this.personNameField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyContactTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)AgencyContactTablePanel.this.filterValues.get(1))) {
                    return;
                }
                AgencyContactTablePanel.this.filterValues.set(1, string);
                AgencyContactTablePanel.this.updateFilters(true);
            }
        });
        this.personAddressLabel = new JLabel();
        this.personAddressField = new JTextField();
        this.personAddressField.setName("personAddressField");
        this.personAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyContactTablePanel.this.personAddressField.isEnabled()) {
                    return;
                }
                String string = AgencyContactTablePanel.this.personAddressField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyContactTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)AgencyContactTablePanel.this.filterValues.get(2))) {
                    return;
                }
                AgencyContactTablePanel.this.filterValues.set(2, string);
                AgencyContactTablePanel.this.updateFilters(true);
            }
        });
        this.personMailLabel = new JLabel();
        this.personMailField = new JTextField();
        this.personMailField.setName("personMailField");
        this.personMailField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyContactTablePanel.this.personMailField.isEnabled()) {
                    return;
                }
                String string = AgencyContactTablePanel.this.personMailField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyContactTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)AgencyContactTablePanel.this.filterValues.get(3))) {
                    return;
                }
                AgencyContactTablePanel.this.filterValues.set(3, string);
                AgencyContactTablePanel.this.updateFilters(true);
            }
        });
        this.personFilterLabel = new JLabel();
        this.personFilterBox = new JComboBox();
        this.personFilterBox.setName("personFilterBox");
        this.personFilterBox.setRenderer((ListCellRenderer<FilterType>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<FilterType>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("no filtering") + " ]";
            }
        }));
        this.personFilterBox.addItem(null);
        this.personFilterBox.addItem(FilterType.CONTACTS_WITH_ESTATE);
        this.personFilterBox.addItem(FilterType.CONTACTS_WITHOUT_ESTATE);
        this.personFilterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyContactTablePanel.this.personFilterBox.isEnabled()) {
                    return;
                }
                AgencyContactTablePanel.this.doRefresh();
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 20dlu:grow");
        defaultFormBuilder.add((Component)this.personIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.personIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personNameLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personNameField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personFilterLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add(this.personFilterBox).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personAddressLabel).xy(5, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.personAddressField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personMailLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personMailField).xy(11, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static AgencyContactTablePanel createTab() {
        return new AgencyContactTablePanel();
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyContactTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyContactTable.Row row) {
                AgentContactImpl agentContactImpl;
                String string = StringUtils.trimToNull((String)AgencyContactTablePanel.this.personAddressField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 7.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(agentContactImpl = row.getContact().item).getPostalCode())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.getCity())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.getDistrict())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.getRegion())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.writeStreet())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyContactTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyContactTable.Row row) {
                String string = StringUtils.trimToNull((String)AgencyContactTablePanel.this.personMailField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 8.createPattern((String)this.value);
                }
                AgentContactImpl agentContactImpl = row.getContact().item;
                return this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.getPersonMail())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyContactTable.Row>(){

            public boolean include(AgencyContactTable.Row row) {
                Number number = AgencyContactTablePanel.this.personIdField.isEditValid() ? (Number)((Number)AgencyContactTablePanel.this.personIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getContact().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyContactTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyContactTable.Row row) {
                AgentContactImpl agentContactImpl;
                String string = StringUtils.trimToNull((String)AgencyContactTablePanel.this.personNameField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 10.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(agentContactImpl = row.getContact().item).getPersonLastName())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)agentContactImpl.getPersonFirstName())).find();
            }
        });
        return this.table;
    }

    private void doContactRemove() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_REMOVE)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getContactIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove the selected contact persons?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new ContactRemoveTask(ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]))));
    }

    private void doContactView() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            long l = this.table.getContactIdAt(n4);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyContactViewTask(ImmoToolProject.getAppDbDriver(), l, n == 1));
            if (++n2 >= 10) break;
        }
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.contacts", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearRows();
        this.table.clearSelection();
        this.updateFilters(false);
        ArrayList<DbContact> arrayList = new ArrayList<DbContact>();
        try {
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            FilterType filterType = (FilterType)((Object)this.personFilterBox.getSelectedItem());
            Boolean bl = null;
            if (FilterType.CONTACTS_WITHOUT_ESTATE.equals((Object)filterType)) {
                bl = false;
            } else if (FilterType.CONTACTS_WITH_ESTATE.equals((Object)filterType)) {
                bl = true;
            }
            DbContact[] dbContactArray = dbAgencyContactsHandler.getContacts(connection, bl);
            arrayList.addAll(Arrays.asList(dbContactArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$contactsList;
                {
                    this.val$contactsList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbContact dbContact : this.val$contactsList) {
                            if (!(dbContact instanceof DbAgencyContact)) {
                                LOGGER.warn("Unsupported contact #" + dbContact.id + "!");
                                continue;
                            }
                            AgencyContactTablePanel.this.table.addRow(new AgencyContactTable.Row((DbAgencyContact)dbContact));
                        }
                    }
                    finally {
                        AgencyContactTablePanel.this.table.setEnabled(true);
                        AgencyContactTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ContactViewAction())));
        jPopupMenu.add(new JMenuItem((Action)((Object)new ContactRemoveAction())));
        jPopupMenu.show(component, n, n2);
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_family.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of contact persons"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("contact persons"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of contact persons.");
    }

    protected String getTableTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.personIdField.setEnabled(bl);
        this.personNameField.setEnabled(bl);
        this.personAddressField.setEnabled(bl);
        this.personMailField.setEnabled(bl);
        this.personFilterBox.setEnabled(bl);
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.personIdLabel.setText(StringUtils.capitalize((String)I18N.tr("ID")) + ":");
        this.personNameLabel.setText(StringUtils.capitalize((String)I18N.tr("name")) + ":");
        this.personAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.personMailLabel.setText(StringUtils.capitalize((String)I18N.tr("e-mail")) + ":");
        this.personFilterLabel.setText(StringUtils.capitalize((String)I18N.tr("filter")) + ":");
    }

    private class Table
    extends AgencyContactTable<AgencyContactTable.Row> {
        public Table() {
            super(AgencyContactTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyContactTablePanel.this.doContactRemove();
        }

        protected void doSelect() {
            AgencyContactTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyContactTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyContactTablePanel.this.doContactView();
        }
    }

    private static enum FilterType implements Translatable
    {
        CONTACTS_WITH_ESTATE(I18n.marktr((String)"with assigned properties")),
        CONTACTS_WITHOUT_ESTATE(I18n.marktr((String)"without assigned properties"));

        private final String i18nKey;

        private FilterType(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyContactTablePanel.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    private class ContactViewAction
    extends AbstractI18nAction {
        private ContactViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactTablePanel.this.doContactView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("view contact person")));
            this.setShortDescription(I18N.tr("Show details about the selected contact persons."));
        }
    }

    private class ContactRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] contactIds;

        private ContactRemoveTask(long[] lArray) {
            this.contactIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            Connection connection = null;
            try {
                Object object;
                connection = ImmoToolProject.getAppDbConnection();
                long[] lArray = dbAgencyObjectsHandler.getObjectIds(connection, this.contactIds);
                if (lArray.length > 0) {
                    object = I18N.trn("{0} property is assigned to the selected contact persons!", "{0} properties are assigned to the selected contact persons!", (long)lArray.length, (Object)lArray.length);
                    AgencyContactDialog.Filter filter = new AgencyContactDialog.Filter(){

                        @Override
                        public boolean canLoadIntoSelection(DbAgencyContact dbAgencyContact) {
                            return !ArrayUtils.contains((long[])ContactRemoveTask.this.contactIds, (long)dbAgencyContact.id);
                        }
                    };
                    Long l = AgencyContactDialog.showDialog(connection, (DbContactsHandler)dbAgencyContactsHandler, filter, (String)(object = (String)object + " " + I18N.tr("Please select another contact person, who will maintain the unassigned properties.")), (Window)ImmoToolEnvironment.getFrame());
                    if (l == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    dbAgencyObjectsHandler.setObjectContactId(connection, lArray, l);
                }
                dbAgencyContactsHandler.removeContacts(connection, this.contactIds);
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete contact persons!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyContactTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            for (long l : this.contactIds) {
                int n = AgencyContactTablePanel.this.table.getRowForContactId(l);
                if (n <= -1) continue;
                AgencyContactTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class ContactRemoveAction
    extends AbstractI18nAction {
        private ContactRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactTablePanel.this.doContactRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected contact persons."));
        }
    }

    private static class ContactAddAction
    extends AbstractI18nAction {
        private ContactAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AgencyPlugin.ContactFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new contact person."));
        }
    }
}

