/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLog;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.utils.GeoData;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateGeoDataTask
extends ImmoToolTask<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateGeoDataTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateGeoDataTask.class);
    private final long[] estateIds;
    private final DbAgencyObject[] estates;
    private final AbstractDbDriver dbDriver;
    private final Connection dbConnection;
    private final DbUser dbUser;
    private final DbAgencyObjectsHandler dbObjectsHandler;
    private final DbAgencyObjectLogsHandler dbLogHandler;
    private GeoData geoData;

    public AgencyEstateGeoDataTask(long[] lArray, GeoData geoData, AbstractDbDriver abstractDbDriver, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = abstractDbDriver;
        this.dbConnection = null;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.geoData = geoData;
        this.estates = null;
        this.estateIds = ArrayUtils.clone((long[])lArray);
    }

    public AgencyEstateGeoDataTask(long[] lArray, GeoData geoData, Connection connection, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = null;
        this.dbConnection = connection;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.geoData = geoData;
        this.estates = null;
        this.estateIds = ArrayUtils.clone((long[])lArray);
    }

    public AgencyEstateGeoDataTask(DbAgencyObject[] dbAgencyObjectArray, GeoData geoData, AbstractDbDriver abstractDbDriver, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = abstractDbDriver;
        this.dbConnection = null;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.geoData = geoData;
        this.estates = (DbAgencyObject[])ArrayUtils.clone((Object[])dbAgencyObjectArray);
        this.estateIds = null;
    }

    public AgencyEstateGeoDataTask(DbAgencyObject[] dbAgencyObjectArray, GeoData geoData, Connection connection, DbUser dbUser, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
        this.dbDriver = null;
        this.dbConnection = connection;
        this.dbUser = dbUser;
        this.dbObjectsHandler = dbAgencyObjectsHandler;
        this.dbLogHandler = dbAgencyObjectLogsHandler;
        this.geoData = geoData;
        this.estates = (DbAgencyObject[])ArrayUtils.clone((Object[])dbAgencyObjectArray);
        this.estateIds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        Connection connection = this.dbConnection;
        try {
            if (connection == null) {
                connection = this.dbDriver.getConnection();
            }
            for (DbAgencyObject dbAgencyObject : this.loadEstates(connection)) {
                if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
                    LOGGER.warn("User is not allowed to edit property #" + dbAgencyObject.id + "!");
                    continue;
                }
                this.setMessage("Update object #" + dbAgencyObject.id);
                dbAgencyObject.item.getAddress().setCountry(this.geoData.getCountryCode());
                dbAgencyObject.item.getAddress().setRegion(this.geoData.getRegion());
                dbAgencyObject.geoDbAreas = new HashMap();
                dbAgencyObject.geoDbAreas.putAll(this.geoData.getAreaMap());
                this.dbObjectsHandler.saveObject(connection, dbAgencyObject, null, false, false);
                DbAgencyObjectLog dbAgencyObjectLog = DbAgencyObjectLog.create(dbAgencyObject.id, "EDIT", this.dbUser);
                this.dbLogHandler.saveLog(connection, dbAgencyObjectLog);
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            if (this.dbConnection == null) {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private DbAgencyObject[] loadEstates(Connection connection) throws SQLException {
        if (this.estates != null) {
            return this.estates;
        }
        if (this.estateIds == null || this.estateIds.length < 1) {
            return new DbAgencyObject[0];
        }
        ArrayList<DbAgencyObject> arrayList = new ArrayList<DbAgencyObject>();
        for (DbObject dbObject : this.dbObjectsHandler.getObjects(connection, this.estateIds)) {
            arrayList.add((DbAgencyObject)dbObject);
        }
        return arrayList.toArray(new DbAgencyObject[0]);
    }

    protected void setGeoData(GeoData geoData) {
        this.geoData = geoData;
    }
}

